<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.SeriesScheme StructType
 * @subpackage Structs
 */
class Ticketing_SeriesScheme extends Ticketing_Base
{
    /**
     * The AclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AclSchemeId;
    /**
     * The AllowedBookingRequestTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AllowedBookingRequestTypes
     */
    public $AllowedBookingRequestTypes;
    /**
     * The CanUserSelectEvents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanUserSelectEvents;
    /**
     * The ContinuationSubscriptionPrintingPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContinuationSubscriptionPrintingPolicy;
    /**
     * The CrossOrgUnitsAclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CrossOrgUnitsAclSchemeId;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The HallId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallId;
    /**
     * The HallVersionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallVersionId;
    /**
     * The InheritAllowedBookingRequestsOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $InheritAllowedBookingRequestsOptions;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsAllocatedSeatsAssignedByDefault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAllocatedSeatsAssignedByDefault;
    /**
     * The IsAssignAllEventsOnSale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAssignAllEventsOnSale;
    /**
     * The IsPrepaiedWaitingListAllowed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPrepaiedWaitingListAllowed;
    /**
     * The IsPricingPerSeries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPricingPerSeries;
    /**
     * The IsPTTAForForSeriesEnabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPTTAForForSeriesEnabled;
    /**
     * The IsSeriesAllocated
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSeriesAllocated;
    /**
     * The IsSinglePerClient
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSinglePerClient;
    /**
     * The IsTransferBonusBalanceOnRenewal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsTransferBonusBalanceOnRenewal;
    /**
     * The IsTransferTicketBalanceOnRenewal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsTransferTicketBalanceOnRenewal;
    /**
     * The IsWaitingListAllowed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsWaitingListAllowed;
    /**
     * The LedgerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LedgerId;
    /**
     * The Media
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Subscription_Media
     */
    public $Media;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The PeriodType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - type: tns:SubscriptionPeriodCalculation
     * @var string
     */
    public $PeriodType;
    /**
     * The ProjectIdentifierId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProjectIdentifierId;
    /**
     * The QuantityOfEvents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $QuantityOfEvents;
    /**
     * The Seasonality
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Seasonality;
    /**
     * The SendToApp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SendToApp;
    /**
     * The SubscriptionPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SubscriptionPeriod;
    /**
     * The SubscriptionPrintingPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriptionPrintingPolicy;
    /**
     * The TicketDateEnforcementPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketDateEnforcementPolicy;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for Ticketing.SeriesScheme
     * @uses Ticketing_SeriesScheme::setAclSchemeId()
     * @uses Ticketing_SeriesScheme::setAllowedBookingRequestTypes()
     * @uses Ticketing_SeriesScheme::setCanUserSelectEvents()
     * @uses Ticketing_SeriesScheme::setContinuationSubscriptionPrintingPolicy()
     * @uses Ticketing_SeriesScheme::setCrossOrgUnitsAclSchemeId()
     * @uses Ticketing_SeriesScheme::setDescription()
     * @uses Ticketing_SeriesScheme::setHallId()
     * @uses Ticketing_SeriesScheme::setHallVersionId()
     * @uses Ticketing_SeriesScheme::setInheritAllowedBookingRequestsOptions()
     * @uses Ticketing_SeriesScheme::setIsActive()
     * @uses Ticketing_SeriesScheme::setIsAllocatedSeatsAssignedByDefault()
     * @uses Ticketing_SeriesScheme::setIsAssignAllEventsOnSale()
     * @uses Ticketing_SeriesScheme::setIsPrepaiedWaitingListAllowed()
     * @uses Ticketing_SeriesScheme::setIsPricingPerSeries()
     * @uses Ticketing_SeriesScheme::setIsPTTAForForSeriesEnabled()
     * @uses Ticketing_SeriesScheme::setIsSeriesAllocated()
     * @uses Ticketing_SeriesScheme::setIsSinglePerClient()
     * @uses Ticketing_SeriesScheme::setIsTransferBonusBalanceOnRenewal()
     * @uses Ticketing_SeriesScheme::setIsTransferTicketBalanceOnRenewal()
     * @uses Ticketing_SeriesScheme::setIsWaitingListAllowed()
     * @uses Ticketing_SeriesScheme::setLedgerId()
     * @uses Ticketing_SeriesScheme::setMedia()
     * @uses Ticketing_SeriesScheme::setName()
     * @uses Ticketing_SeriesScheme::setOrganizationUnitId()
     * @uses Ticketing_SeriesScheme::setPeriodType()
     * @uses Ticketing_SeriesScheme::setProjectIdentifierId()
     * @uses Ticketing_SeriesScheme::setQuantityOfEvents()
     * @uses Ticketing_SeriesScheme::setSeasonality()
     * @uses Ticketing_SeriesScheme::setSendToApp()
     * @uses Ticketing_SeriesScheme::setSubscriptionPeriod()
     * @uses Ticketing_SeriesScheme::setSubscriptionPrintingPolicy()
     * @uses Ticketing_SeriesScheme::setTicketDateEnforcementPolicy()
     * @uses Ticketing_SeriesScheme::setVisibleBySubordinates()
     * @param int $aclSchemeId
     * @param \patest\StructType\AllowedBookingRequestTypes $allowedBookingRequestTypes
     * @param bool $canUserSelectEvents
     * @param string $continuationSubscriptionPrintingPolicy
     * @param int $crossOrgUnitsAclSchemeId
     * @param \patest\StructType\GlobalString $description
     * @param string $hallId
     * @param string $hallVersionId
     * @param bool $inheritAllowedBookingRequestsOptions
     * @param bool $isActive
     * @param bool $isAllocatedSeatsAssignedByDefault
     * @param bool $isAssignAllEventsOnSale
     * @param bool $isPrepaiedWaitingListAllowed
     * @param bool $isPricingPerSeries
     * @param bool $isPTTAForForSeriesEnabled
     * @param bool $isSeriesAllocated
     * @param bool $isSinglePerClient
     * @param bool $isTransferBonusBalanceOnRenewal
     * @param bool $isTransferTicketBalanceOnRenewal
     * @param bool $isWaitingListAllowed
     * @param string $ledgerId
     * @param \patest\StructType\Subscription_Media $media
     * @param \patest\StructType\GlobalString $name
     * @param string $organizationUnitId
     * @param string $periodType
     * @param string $projectIdentifierId
     * @param int $quantityOfEvents
     * @param string $seasonality
     * @param bool $sendToApp
     * @param int $subscriptionPeriod
     * @param string $subscriptionPrintingPolicy
     * @param string $ticketDateEnforcementPolicy
     * @param bool $visibleBySubordinates
     */
    public function __construct($aclSchemeId = null, \patest\StructType\AllowedBookingRequestTypes $allowedBookingRequestTypes = null, $canUserSelectEvents = null, $continuationSubscriptionPrintingPolicy = null, $crossOrgUnitsAclSchemeId = null, \patest\StructType\GlobalString $description = null, $hallId = null, $hallVersionId = null, $inheritAllowedBookingRequestsOptions = null, $isActive = null, $isAllocatedSeatsAssignedByDefault = null, $isAssignAllEventsOnSale = null, $isPrepaiedWaitingListAllowed = null, $isPricingPerSeries = null, $isPTTAForForSeriesEnabled = null, $isSeriesAllocated = null, $isSinglePerClient = null, $isTransferBonusBalanceOnRenewal = null, $isTransferTicketBalanceOnRenewal = null, $isWaitingListAllowed = null, $ledgerId = null, \patest\StructType\Subscription_Media $media = null, \patest\StructType\GlobalString $name = null, $organizationUnitId = null, $periodType = null, $projectIdentifierId = null, $quantityOfEvents = null, $seasonality = null, $sendToApp = null, $subscriptionPeriod = null, $subscriptionPrintingPolicy = null, $ticketDateEnforcementPolicy = null, $visibleBySubordinates = null)
    {
        $this
            ->setAclSchemeId($aclSchemeId)
            ->setAllowedBookingRequestTypes($allowedBookingRequestTypes)
            ->setCanUserSelectEvents($canUserSelectEvents)
            ->setContinuationSubscriptionPrintingPolicy($continuationSubscriptionPrintingPolicy)
            ->setCrossOrgUnitsAclSchemeId($crossOrgUnitsAclSchemeId)
            ->setDescription($description)
            ->setHallId($hallId)
            ->setHallVersionId($hallVersionId)
            ->setInheritAllowedBookingRequestsOptions($inheritAllowedBookingRequestsOptions)
            ->setIsActive($isActive)
            ->setIsAllocatedSeatsAssignedByDefault($isAllocatedSeatsAssignedByDefault)
            ->setIsAssignAllEventsOnSale($isAssignAllEventsOnSale)
            ->setIsPrepaiedWaitingListAllowed($isPrepaiedWaitingListAllowed)
            ->setIsPricingPerSeries($isPricingPerSeries)
            ->setIsPTTAForForSeriesEnabled($isPTTAForForSeriesEnabled)
            ->setIsSeriesAllocated($isSeriesAllocated)
            ->setIsSinglePerClient($isSinglePerClient)
            ->setIsTransferBonusBalanceOnRenewal($isTransferBonusBalanceOnRenewal)
            ->setIsTransferTicketBalanceOnRenewal($isTransferTicketBalanceOnRenewal)
            ->setIsWaitingListAllowed($isWaitingListAllowed)
            ->setLedgerId($ledgerId)
            ->setMedia($media)
            ->setName($name)
            ->setOrganizationUnitId($organizationUnitId)
            ->setPeriodType($periodType)
            ->setProjectIdentifierId($projectIdentifierId)
            ->setQuantityOfEvents($quantityOfEvents)
            ->setSeasonality($seasonality)
            ->setSendToApp($sendToApp)
            ->setSubscriptionPeriod($subscriptionPeriod)
            ->setSubscriptionPrintingPolicy($subscriptionPrintingPolicy)
            ->setTicketDateEnforcementPolicy($ticketDateEnforcementPolicy)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get AclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAclSchemeId()
    {
        return isset($this->AclSchemeId) ? $this->AclSchemeId : null;
    }
    /**
     * Set AclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aclSchemeId
     * @return \patest\StructType\Ticketing_SeriesScheme
     */
    public function setAclSchemeId($aclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($aclSchemeId) && !(is_int($aclSchemeId) || ctype_digit($aclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aclSchemeId, true), gettype($aclSchemeId)), __LINE__);
        }
        if (is_null($aclSchemeId) || (is_array($aclSchemeId) && empty($aclSchemeId))) {
            unset($this->AclSchemeId);
        } else {
            $this->AclSchemeId = $aclSchemeId;
        }
        return $this;
    }
    /**
     * Get AllowedBookingRequestTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AllowedBookingRequestTypes|null
     */
    public function getAllowedBookingRequestTypes()
    {
        return isset($this->AllowedBookingRequestTypes) ? $this->AllowedBookingRequestTypes : null;
    }
    /**
     * Set AllowedBookingRequestTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AllowedBookingRequestTypes $allowedBookingRequestTypes
     * @return \patest\StructType\Ticketing_SeriesScheme
     */
    public function setAllowedBookingRequestTypes(\patest\StructType\AllowedBookingRequestTypes $allowedBookingRequestTypes = null)
    {
        if (is_null($allowedBookingRequestTypes) || (is_array($allowedBookingRequestTypes) && empty($allowedBookingRequestTypes))) {
            unset($this->AllowedBookingRequestTypes);
        } else {
            $this->AllowedBookingRequestTypes = $allowedBookingRequestTypes;
        }
        return $this;
    }
    /**
     * Get CanUserSelectEvents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanUserSelectEvents()
    {
        return isset($this->CanUserSelectEvents) ? $this->CanUserSelectEvents : null;
    }
    /**
     * Set CanUserSelectEvents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canUserSelectEvents
     * @return \patest\StructType\Ticketing_SeriesScheme
     */
    public function setCanUserSelectEvents($canUserSelectEvents = null)
    {
        // validation for constraint: boolean
        if (!is_null($canUserSelectEvents) && !is_bool($canUserSelectEvents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canUserSelectEvents, true), gettype($canUserSelectEvents)), __LINE__);
        }
        if (is_null($canUserSelectEvents) || (is_array($canUserSelectEvents) && empty($canUserSelectEvents))) {
            unset($this->CanUserSelectEvents);
        } else {
            $this->CanUserSelectEvents = $canUserSelectEvents;
        }
        return $this;
    }
    /**
     * Get ContinuationSubscriptionPrintingPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContinuationSubscriptionPrintingPolicy()
    {
        return isset($this->ContinuationSubscriptionPrintingPolicy) ? $this->ContinuationSubscriptionPrintingPolicy : null;
    }
    /**
     * Set ContinuationSubscriptionPrintingPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SubscriptionPrintingPolicy::valueIsValid()
     * @uses \patest\EnumType\SubscriptionPrintingPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $continuationSubscriptionPrintingPolicy
     * @return \patest\StructType\Ticketing_SeriesScheme
     */
    public function setContinuationSubscriptionPrintingPolicy($continuationSubscriptionPrintingPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SubscriptionPrintingPolicy::valueIsValid($continuationSubscriptionPrintingPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SubscriptionPrintingPolicy', is_array($continuationSubscriptionPrintingPolicy) ? implode(', ', $continuationSubscriptionPrintingPolicy) : var_export($continuationSubscriptionPrintingPolicy, true), implode(', ', \patest\EnumType\SubscriptionPrintingPolicy::getValidValues())), __LINE__);
        }
        if (is_null($continuationSubscriptionPrintingPolicy) || (is_array($continuationSubscriptionPrintingPolicy) && empty($continuationSubscriptionPrintingPolicy))) {
            unset($this->ContinuationSubscriptionPrintingPolicy);
        } else {
            $this->ContinuationSubscriptionPrintingPolicy = $continuationSubscriptionPrintingPolicy;
        }
        return $this;
    }
    /**
     * Get CrossOrgUnitsAclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCrossOrgUnitsAclSchemeId()
    {
        return isset($this->CrossOrgUnitsAclSchemeId) ? $this->CrossOrgUnitsAclSchemeId : null;
    }
    /**
     * Set CrossOrgUnitsAclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $crossOrgUnitsAclSchemeId
     * @return \patest\StructType\Ticketing_SeriesScheme
     */
    public function setCrossOrgUnitsAclSchemeId($crossOrgUnitsAclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($crossOrgUnitsAclSchemeId) && !(is_int($crossOrgUnitsAclSchemeId) || ctype_digit($crossOrgUnitsAclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($crossOrgUnitsAclSchemeId, true), gettype($crossOrgUnitsAclSchemeId)), __LINE__);
        }
        if (is_null($crossOrgUnitsAclSchemeId) || (is_array($crossOrgUnitsAclSchemeId) && empty($crossOrgUnitsAclSchemeId))) {
            unset($this->CrossOrgUnitsAclSchemeId);
        } else {
            $this->CrossOrgUnitsAclSchemeId = $crossOrgUnitsAclSchemeId;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\Ticketing_SeriesScheme
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get HallId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallId()
    {
        return isset($this->HallId) ? $this->HallId : null;
    }
    /**
     * Set HallId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallId
     * @return \patest\StructType\Ticketing_SeriesScheme
     */
    public function setHallId($hallId = null)
    {
        // validation for constraint: string
        if (!is_null($hallId) && !is_string($hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallId, true), gettype($hallId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallId, true)), __LINE__);
        }
        if (is_null($hallId) || (is_array($hallId) && empty($hallId))) {
            unset($this->HallId);
        } else {
            $this->HallId = $hallId;
        }
        return $this;
    }
    /**
     * Get HallVersionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallVersionId()
    {
        return isset($this->HallVersionId) ? $this->HallVersionId : null;
    }
    /**
     * Set HallVersionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallVersionId
     * @return \patest\StructType\Ticketing_SeriesScheme
     */
    public function setHallVersionId($hallVersionId = null)
    {
        // validation for constraint: string
        if (!is_null($hallVersionId) && !is_string($hallVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallVersionId, true), gettype($hallVersionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallVersionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallVersionId, true)), __LINE__);
        }
        if (is_null($hallVersionId) || (is_array($hallVersionId) && empty($hallVersionId))) {
            unset($this->HallVersionId);
        } else {
            $this->HallVersionId = $hallVersionId;
        }
        return $this;
    }
    /**
     * Get InheritAllowedBookingRequestsOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getInheritAllowedBookingRequestsOptions()
    {
        return isset($this->InheritAllowedBookingRequestsOptions) ? $this->InheritAllowedBookingRequestsOptions : null;
    }
    /**
     * Set InheritAllowedBookingRequestsOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $inheritAllowedBookingRequestsOptions
     * @return \patest\StructType\Ticketing_SeriesScheme
     */
    public function setInheritAllowedBookingRequestsOptions($inheritAllowedBookingRequestsOptions = null)
    {
        // validation for constraint: boolean
        if (!is_null($inheritAllowedBookingRequestsOptions) && !is_bool($inheritAllowedBookingRequestsOptions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inheritAllowedBookingRequestsOptions, true), gettype($inheritAllowedBookingRequestsOptions)), __LINE__);
        }
        if (is_null($inheritAllowedBookingRequestsOptions) || (is_array($inheritAllowedBookingRequestsOptions) && empty($inheritAllowedBookingRequestsOptions))) {
            unset($this->InheritAllowedBookingRequestsOptions);
        } else {
            $this->InheritAllowedBookingRequestsOptions = $inheritAllowedBookingRequestsOptions;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Ticketing_SeriesScheme
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsAllocatedSeatsAssignedByDefault value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAllocatedSeatsAssignedByDefault()
    {
        return isset($this->IsAllocatedSeatsAssignedByDefault) ? $this->IsAllocatedSeatsAssignedByDefault : null;
    }
    /**
     * Set IsAllocatedSeatsAssignedByDefault value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAllocatedSeatsAssignedByDefault
     * @return \patest\StructType\Ticketing_SeriesScheme
     */
    public function setIsAllocatedSeatsAssignedByDefault($isAllocatedSeatsAssignedByDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAllocatedSeatsAssignedByDefault) && !is_bool($isAllocatedSeatsAssignedByDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAllocatedSeatsAssignedByDefault, true), gettype($isAllocatedSeatsAssignedByDefault)), __LINE__);
        }
        if (is_null($isAllocatedSeatsAssignedByDefault) || (is_array($isAllocatedSeatsAssignedByDefault) && empty($isAllocatedSeatsAssignedByDefault))) {
            unset($this->IsAllocatedSeatsAssignedByDefault);
        } else {
            $this->IsAllocatedSeatsAssignedByDefault = $isAllocatedSeatsAssignedByDefault;
        }
        return $this;
    }
    /**
     * Get IsAssignAllEventsOnSale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAssignAllEventsOnSale()
    {
        return isset($this->IsAssignAllEventsOnSale) ? $this->IsAssignAllEventsOnSale : null;
    }
    /**
     * Set IsAssignAllEventsOnSale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAssignAllEventsOnSale
     * @return \patest\StructType\Ticketing_SeriesScheme
     */
    public function setIsAssignAllEventsOnSale($isAssignAllEventsOnSale = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAssignAllEventsOnSale) && !is_bool($isAssignAllEventsOnSale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAssignAllEventsOnSale, true), gettype($isAssignAllEventsOnSale)), __LINE__);
        }
        if (is_null($isAssignAllEventsOnSale) || (is_array($isAssignAllEventsOnSale) && empty($isAssignAllEventsOnSale))) {
            unset($this->IsAssignAllEventsOnSale);
        } else {
            $this->IsAssignAllEventsOnSale = $isAssignAllEventsOnSale;
        }
        return $this;
    }
    /**
     * Get IsPrepaiedWaitingListAllowed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPrepaiedWaitingListAllowed()
    {
        return isset($this->IsPrepaiedWaitingListAllowed) ? $this->IsPrepaiedWaitingListAllowed : null;
    }
    /**
     * Set IsPrepaiedWaitingListAllowed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPrepaiedWaitingListAllowed
     * @return \patest\StructType\Ticketing_SeriesScheme
     */
    public function setIsPrepaiedWaitingListAllowed($isPrepaiedWaitingListAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrepaiedWaitingListAllowed) && !is_bool($isPrepaiedWaitingListAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrepaiedWaitingListAllowed, true), gettype($isPrepaiedWaitingListAllowed)), __LINE__);
        }
        if (is_null($isPrepaiedWaitingListAllowed) || (is_array($isPrepaiedWaitingListAllowed) && empty($isPrepaiedWaitingListAllowed))) {
            unset($this->IsPrepaiedWaitingListAllowed);
        } else {
            $this->IsPrepaiedWaitingListAllowed = $isPrepaiedWaitingListAllowed;
        }
        return $this;
    }
    /**
     * Get IsPricingPerSeries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPricingPerSeries()
    {
        return isset($this->IsPricingPerSeries) ? $this->IsPricingPerSeries : null;
    }
    /**
     * Set IsPricingPerSeries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPricingPerSeries
     * @return \patest\StructType\Ticketing_SeriesScheme
     */
    public function setIsPricingPerSeries($isPricingPerSeries = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPricingPerSeries) && !is_bool($isPricingPerSeries)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPricingPerSeries, true), gettype($isPricingPerSeries)), __LINE__);
        }
        if (is_null($isPricingPerSeries) || (is_array($isPricingPerSeries) && empty($isPricingPerSeries))) {
            unset($this->IsPricingPerSeries);
        } else {
            $this->IsPricingPerSeries = $isPricingPerSeries;
        }
        return $this;
    }
    /**
     * Get IsPTTAForForSeriesEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPTTAForForSeriesEnabled()
    {
        return isset($this->IsPTTAForForSeriesEnabled) ? $this->IsPTTAForForSeriesEnabled : null;
    }
    /**
     * Set IsPTTAForForSeriesEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPTTAForForSeriesEnabled
     * @return \patest\StructType\Ticketing_SeriesScheme
     */
    public function setIsPTTAForForSeriesEnabled($isPTTAForForSeriesEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPTTAForForSeriesEnabled) && !is_bool($isPTTAForForSeriesEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPTTAForForSeriesEnabled, true), gettype($isPTTAForForSeriesEnabled)), __LINE__);
        }
        if (is_null($isPTTAForForSeriesEnabled) || (is_array($isPTTAForForSeriesEnabled) && empty($isPTTAForForSeriesEnabled))) {
            unset($this->IsPTTAForForSeriesEnabled);
        } else {
            $this->IsPTTAForForSeriesEnabled = $isPTTAForForSeriesEnabled;
        }
        return $this;
    }
    /**
     * Get IsSeriesAllocated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSeriesAllocated()
    {
        return isset($this->IsSeriesAllocated) ? $this->IsSeriesAllocated : null;
    }
    /**
     * Set IsSeriesAllocated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSeriesAllocated
     * @return \patest\StructType\Ticketing_SeriesScheme
     */
    public function setIsSeriesAllocated($isSeriesAllocated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSeriesAllocated) && !is_bool($isSeriesAllocated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSeriesAllocated, true), gettype($isSeriesAllocated)), __LINE__);
        }
        if (is_null($isSeriesAllocated) || (is_array($isSeriesAllocated) && empty($isSeriesAllocated))) {
            unset($this->IsSeriesAllocated);
        } else {
            $this->IsSeriesAllocated = $isSeriesAllocated;
        }
        return $this;
    }
    /**
     * Get IsSinglePerClient value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSinglePerClient()
    {
        return isset($this->IsSinglePerClient) ? $this->IsSinglePerClient : null;
    }
    /**
     * Set IsSinglePerClient value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSinglePerClient
     * @return \patest\StructType\Ticketing_SeriesScheme
     */
    public function setIsSinglePerClient($isSinglePerClient = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSinglePerClient) && !is_bool($isSinglePerClient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSinglePerClient, true), gettype($isSinglePerClient)), __LINE__);
        }
        if (is_null($isSinglePerClient) || (is_array($isSinglePerClient) && empty($isSinglePerClient))) {
            unset($this->IsSinglePerClient);
        } else {
            $this->IsSinglePerClient = $isSinglePerClient;
        }
        return $this;
    }
    /**
     * Get IsTransferBonusBalanceOnRenewal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsTransferBonusBalanceOnRenewal()
    {
        return isset($this->IsTransferBonusBalanceOnRenewal) ? $this->IsTransferBonusBalanceOnRenewal : null;
    }
    /**
     * Set IsTransferBonusBalanceOnRenewal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isTransferBonusBalanceOnRenewal
     * @return \patest\StructType\Ticketing_SeriesScheme
     */
    public function setIsTransferBonusBalanceOnRenewal($isTransferBonusBalanceOnRenewal = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTransferBonusBalanceOnRenewal) && !is_bool($isTransferBonusBalanceOnRenewal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTransferBonusBalanceOnRenewal, true), gettype($isTransferBonusBalanceOnRenewal)), __LINE__);
        }
        if (is_null($isTransferBonusBalanceOnRenewal) || (is_array($isTransferBonusBalanceOnRenewal) && empty($isTransferBonusBalanceOnRenewal))) {
            unset($this->IsTransferBonusBalanceOnRenewal);
        } else {
            $this->IsTransferBonusBalanceOnRenewal = $isTransferBonusBalanceOnRenewal;
        }
        return $this;
    }
    /**
     * Get IsTransferTicketBalanceOnRenewal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsTransferTicketBalanceOnRenewal()
    {
        return isset($this->IsTransferTicketBalanceOnRenewal) ? $this->IsTransferTicketBalanceOnRenewal : null;
    }
    /**
     * Set IsTransferTicketBalanceOnRenewal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isTransferTicketBalanceOnRenewal
     * @return \patest\StructType\Ticketing_SeriesScheme
     */
    public function setIsTransferTicketBalanceOnRenewal($isTransferTicketBalanceOnRenewal = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTransferTicketBalanceOnRenewal) && !is_bool($isTransferTicketBalanceOnRenewal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTransferTicketBalanceOnRenewal, true), gettype($isTransferTicketBalanceOnRenewal)), __LINE__);
        }
        if (is_null($isTransferTicketBalanceOnRenewal) || (is_array($isTransferTicketBalanceOnRenewal) && empty($isTransferTicketBalanceOnRenewal))) {
            unset($this->IsTransferTicketBalanceOnRenewal);
        } else {
            $this->IsTransferTicketBalanceOnRenewal = $isTransferTicketBalanceOnRenewal;
        }
        return $this;
    }
    /**
     * Get IsWaitingListAllowed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsWaitingListAllowed()
    {
        return isset($this->IsWaitingListAllowed) ? $this->IsWaitingListAllowed : null;
    }
    /**
     * Set IsWaitingListAllowed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isWaitingListAllowed
     * @return \patest\StructType\Ticketing_SeriesScheme
     */
    public function setIsWaitingListAllowed($isWaitingListAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isWaitingListAllowed) && !is_bool($isWaitingListAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isWaitingListAllowed, true), gettype($isWaitingListAllowed)), __LINE__);
        }
        if (is_null($isWaitingListAllowed) || (is_array($isWaitingListAllowed) && empty($isWaitingListAllowed))) {
            unset($this->IsWaitingListAllowed);
        } else {
            $this->IsWaitingListAllowed = $isWaitingListAllowed;
        }
        return $this;
    }
    /**
     * Get LedgerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLedgerId()
    {
        return isset($this->LedgerId) ? $this->LedgerId : null;
    }
    /**
     * Set LedgerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ledgerId
     * @return \patest\StructType\Ticketing_SeriesScheme
     */
    public function setLedgerId($ledgerId = null)
    {
        // validation for constraint: string
        if (!is_null($ledgerId) && !is_string($ledgerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ledgerId, true), gettype($ledgerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ledgerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ledgerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ledgerId, true)), __LINE__);
        }
        if (is_null($ledgerId) || (is_array($ledgerId) && empty($ledgerId))) {
            unset($this->LedgerId);
        } else {
            $this->LedgerId = $ledgerId;
        }
        return $this;
    }
    /**
     * Get Media value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Subscription_Media|null
     */
    public function getMedia()
    {
        return isset($this->Media) ? $this->Media : null;
    }
    /**
     * Set Media value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Subscription_Media $media
     * @return \patest\StructType\Ticketing_SeriesScheme
     */
    public function setMedia(\patest\StructType\Subscription_Media $media = null)
    {
        if (is_null($media) || (is_array($media) && empty($media))) {
            unset($this->Media);
        } else {
            $this->Media = $media;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Ticketing_SeriesScheme
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Ticketing_SeriesScheme
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get PeriodType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPeriodType()
    {
        return isset($this->PeriodType) ? $this->PeriodType : null;
    }
    /**
     * Set PeriodType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $periodType
     * @return \patest\StructType\Ticketing_SeriesScheme
     */
    public function setPeriodType($periodType = null)
    {
        // validation for constraint: string
        if (!is_null($periodType) && !is_string($periodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($periodType, true), gettype($periodType)), __LINE__);
        }
        if (is_null($periodType) || (is_array($periodType) && empty($periodType))) {
            unset($this->PeriodType);
        } else {
            $this->PeriodType = $periodType;
        }
        return $this;
    }
    /**
     * Get ProjectIdentifierId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProjectIdentifierId()
    {
        return isset($this->ProjectIdentifierId) ? $this->ProjectIdentifierId : null;
    }
    /**
     * Set ProjectIdentifierId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $projectIdentifierId
     * @return \patest\StructType\Ticketing_SeriesScheme
     */
    public function setProjectIdentifierId($projectIdentifierId = null)
    {
        // validation for constraint: string
        if (!is_null($projectIdentifierId) && !is_string($projectIdentifierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($projectIdentifierId, true), gettype($projectIdentifierId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($projectIdentifierId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $projectIdentifierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($projectIdentifierId, true)), __LINE__);
        }
        if (is_null($projectIdentifierId) || (is_array($projectIdentifierId) && empty($projectIdentifierId))) {
            unset($this->ProjectIdentifierId);
        } else {
            $this->ProjectIdentifierId = $projectIdentifierId;
        }
        return $this;
    }
    /**
     * Get QuantityOfEvents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQuantityOfEvents()
    {
        return isset($this->QuantityOfEvents) ? $this->QuantityOfEvents : null;
    }
    /**
     * Set QuantityOfEvents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $quantityOfEvents
     * @return \patest\StructType\Ticketing_SeriesScheme
     */
    public function setQuantityOfEvents($quantityOfEvents = null)
    {
        // validation for constraint: int
        if (!is_null($quantityOfEvents) && !(is_int($quantityOfEvents) || ctype_digit($quantityOfEvents))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantityOfEvents, true), gettype($quantityOfEvents)), __LINE__);
        }
        if (is_null($quantityOfEvents) || (is_array($quantityOfEvents) && empty($quantityOfEvents))) {
            unset($this->QuantityOfEvents);
        } else {
            $this->QuantityOfEvents = $quantityOfEvents;
        }
        return $this;
    }
    /**
     * Get Seasonality value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeasonality()
    {
        return isset($this->Seasonality) ? $this->Seasonality : null;
    }
    /**
     * Set Seasonality value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SeriesSeasonality::valueIsValid()
     * @uses \patest\EnumType\SeriesSeasonality::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $seasonality
     * @return \patest\StructType\Ticketing_SeriesScheme
     */
    public function setSeasonality($seasonality = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SeriesSeasonality::valueIsValid($seasonality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SeriesSeasonality', is_array($seasonality) ? implode(', ', $seasonality) : var_export($seasonality, true), implode(', ', \patest\EnumType\SeriesSeasonality::getValidValues())), __LINE__);
        }
        if (is_null($seasonality) || (is_array($seasonality) && empty($seasonality))) {
            unset($this->Seasonality);
        } else {
            $this->Seasonality = $seasonality;
        }
        return $this;
    }
    /**
     * Get SendToApp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSendToApp()
    {
        return isset($this->SendToApp) ? $this->SendToApp : null;
    }
    /**
     * Set SendToApp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $sendToApp
     * @return \patest\StructType\Ticketing_SeriesScheme
     */
    public function setSendToApp($sendToApp = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendToApp) && !is_bool($sendToApp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendToApp, true), gettype($sendToApp)), __LINE__);
        }
        if (is_null($sendToApp) || (is_array($sendToApp) && empty($sendToApp))) {
            unset($this->SendToApp);
        } else {
            $this->SendToApp = $sendToApp;
        }
        return $this;
    }
    /**
     * Get SubscriptionPeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSubscriptionPeriod()
    {
        return isset($this->SubscriptionPeriod) ? $this->SubscriptionPeriod : null;
    }
    /**
     * Set SubscriptionPeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $subscriptionPeriod
     * @return \patest\StructType\Ticketing_SeriesScheme
     */
    public function setSubscriptionPeriod($subscriptionPeriod = null)
    {
        // validation for constraint: int
        if (!is_null($subscriptionPeriod) && !(is_int($subscriptionPeriod) || ctype_digit($subscriptionPeriod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($subscriptionPeriod, true), gettype($subscriptionPeriod)), __LINE__);
        }
        if (is_null($subscriptionPeriod) || (is_array($subscriptionPeriod) && empty($subscriptionPeriod))) {
            unset($this->SubscriptionPeriod);
        } else {
            $this->SubscriptionPeriod = $subscriptionPeriod;
        }
        return $this;
    }
    /**
     * Get SubscriptionPrintingPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionPrintingPolicy()
    {
        return isset($this->SubscriptionPrintingPolicy) ? $this->SubscriptionPrintingPolicy : null;
    }
    /**
     * Set SubscriptionPrintingPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SubscriptionPrintingPolicy::valueIsValid()
     * @uses \patest\EnumType\SubscriptionPrintingPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subscriptionPrintingPolicy
     * @return \patest\StructType\Ticketing_SeriesScheme
     */
    public function setSubscriptionPrintingPolicy($subscriptionPrintingPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SubscriptionPrintingPolicy::valueIsValid($subscriptionPrintingPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SubscriptionPrintingPolicy', is_array($subscriptionPrintingPolicy) ? implode(', ', $subscriptionPrintingPolicy) : var_export($subscriptionPrintingPolicy, true), implode(', ', \patest\EnumType\SubscriptionPrintingPolicy::getValidValues())), __LINE__);
        }
        if (is_null($subscriptionPrintingPolicy) || (is_array($subscriptionPrintingPolicy) && empty($subscriptionPrintingPolicy))) {
            unset($this->SubscriptionPrintingPolicy);
        } else {
            $this->SubscriptionPrintingPolicy = $subscriptionPrintingPolicy;
        }
        return $this;
    }
    /**
     * Get TicketDateEnforcementPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketDateEnforcementPolicy()
    {
        return isset($this->TicketDateEnforcementPolicy) ? $this->TicketDateEnforcementPolicy : null;
    }
    /**
     * Set TicketDateEnforcementPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketDateEnforcementPolicy::valueIsValid()
     * @uses \patest\EnumType\TicketDateEnforcementPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ticketDateEnforcementPolicy
     * @return \patest\StructType\Ticketing_SeriesScheme
     */
    public function setTicketDateEnforcementPolicy($ticketDateEnforcementPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketDateEnforcementPolicy::valueIsValid($ticketDateEnforcementPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketDateEnforcementPolicy', is_array($ticketDateEnforcementPolicy) ? implode(', ', $ticketDateEnforcementPolicy) : var_export($ticketDateEnforcementPolicy, true), implode(', ', \patest\EnumType\TicketDateEnforcementPolicy::getValidValues())), __LINE__);
        }
        if (is_null($ticketDateEnforcementPolicy) || (is_array($ticketDateEnforcementPolicy) && empty($ticketDateEnforcementPolicy))) {
            unset($this->TicketDateEnforcementPolicy);
        } else {
            $this->TicketDateEnforcementPolicy = $ticketDateEnforcementPolicy;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Ticketing_SeriesScheme
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
