<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.SeriesOrSeriesGroup StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Ticketing.SeriesOrSeriesGroup
 * @subpackage Structs
 */
class Ticketing_SeriesOrSeriesGroup extends Ticketing_Base
{
    /**
     * The AclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AclSchemeId;
    /**
     * The CanUserSelectEvents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanUserSelectEvents;
    /**
     * The CrossOrgUnitsAclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CrossOrgUnitsAclSchemeId;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The EffectiveEndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EffectiveEndDate;
    /**
     * The EffectiveStartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EffectiveStartDate;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The HallId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallId;
    /**
     * The HallVersionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallVersionId;
    /**
     * The HospitalityInRegularSaleApplicationChannels
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HospitalityInRegularSaleApplicationChannels;
    /**
     * The HospitalityMedia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Subscription_Media
     */
    public $HospitalityMedia;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsAvailableForDisplay
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAvailableForDisplay;
    /**
     * The IsAvailableForSale
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAvailableForSale;
    /**
     * The IsHospitalityAvailable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsHospitalityAvailable;
    /**
     * The IsPrepaiedWaitingListAllowed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPrepaiedWaitingListAllowed;
    /**
     * The IsSeriesAllocated
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSeriesAllocated;
    /**
     * The IsSeriesGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSeriesGroup;
    /**
     * The IsWaitingListAllowed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsWaitingListAllowed;
    /**
     * The LedgerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LedgerId;
    /**
     * The MasterHospitalitySeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MasterHospitalitySeriesId;
    /**
     * The MasterSeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MasterSeriesId;
    /**
     * The Media
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Subscription_Media
     */
    public $Media;
    /**
     * The MinPrice
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $MinPrice;
    /**
     * The MinQuantityOfEvents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MinQuantityOfEvents;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The NumberOfBonusEvents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfBonusEvents;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The PeriodDescription
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PeriodDescription;
    /**
     * The PeriodType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - type: tns:SubscriptionPeriodCalculation
     * @var string
     */
    public $PeriodType;
    /**
     * The ProjectIdentifierId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProjectIdentifierId;
    /**
     * The QuantityOfEvents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $QuantityOfEvents;
    /**
     * The RelatedSeriesOrGroupId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelatedSeriesOrGroupId;
    /**
     * The SchemeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SchemeId;
    /**
     * The Seasonality
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Seasonality;
    /**
     * The SeasonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeasonId;
    /**
     * The SellOnlyAsPartOfPrompt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SellOnlyAsPartOfPrompt;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The SubscriptionPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SubscriptionPeriod;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for Ticketing.SeriesOrSeriesGroup
     * @uses Ticketing_SeriesOrSeriesGroup::setAclSchemeId()
     * @uses Ticketing_SeriesOrSeriesGroup::setCanUserSelectEvents()
     * @uses Ticketing_SeriesOrSeriesGroup::setCrossOrgUnitsAclSchemeId()
     * @uses Ticketing_SeriesOrSeriesGroup::setDescription()
     * @uses Ticketing_SeriesOrSeriesGroup::setEffectiveEndDate()
     * @uses Ticketing_SeriesOrSeriesGroup::setEffectiveStartDate()
     * @uses Ticketing_SeriesOrSeriesGroup::setEndDate()
     * @uses Ticketing_SeriesOrSeriesGroup::setHallId()
     * @uses Ticketing_SeriesOrSeriesGroup::setHallVersionId()
     * @uses Ticketing_SeriesOrSeriesGroup::setHospitalityInRegularSaleApplicationChannels()
     * @uses Ticketing_SeriesOrSeriesGroup::setHospitalityMedia()
     * @uses Ticketing_SeriesOrSeriesGroup::setIsActive()
     * @uses Ticketing_SeriesOrSeriesGroup::setIsAvailableForDisplay()
     * @uses Ticketing_SeriesOrSeriesGroup::setIsAvailableForSale()
     * @uses Ticketing_SeriesOrSeriesGroup::setIsHospitalityAvailable()
     * @uses Ticketing_SeriesOrSeriesGroup::setIsPrepaiedWaitingListAllowed()
     * @uses Ticketing_SeriesOrSeriesGroup::setIsSeriesAllocated()
     * @uses Ticketing_SeriesOrSeriesGroup::setIsSeriesGroup()
     * @uses Ticketing_SeriesOrSeriesGroup::setIsWaitingListAllowed()
     * @uses Ticketing_SeriesOrSeriesGroup::setLedgerId()
     * @uses Ticketing_SeriesOrSeriesGroup::setMasterHospitalitySeriesId()
     * @uses Ticketing_SeriesOrSeriesGroup::setMasterSeriesId()
     * @uses Ticketing_SeriesOrSeriesGroup::setMedia()
     * @uses Ticketing_SeriesOrSeriesGroup::setMinPrice()
     * @uses Ticketing_SeriesOrSeriesGroup::setMinQuantityOfEvents()
     * @uses Ticketing_SeriesOrSeriesGroup::setName()
     * @uses Ticketing_SeriesOrSeriesGroup::setNumberOfBonusEvents()
     * @uses Ticketing_SeriesOrSeriesGroup::setOrganizationUnitId()
     * @uses Ticketing_SeriesOrSeriesGroup::setPeriodDescription()
     * @uses Ticketing_SeriesOrSeriesGroup::setPeriodType()
     * @uses Ticketing_SeriesOrSeriesGroup::setProjectIdentifierId()
     * @uses Ticketing_SeriesOrSeriesGroup::setQuantityOfEvents()
     * @uses Ticketing_SeriesOrSeriesGroup::setRelatedSeriesOrGroupId()
     * @uses Ticketing_SeriesOrSeriesGroup::setSchemeId()
     * @uses Ticketing_SeriesOrSeriesGroup::setSeasonality()
     * @uses Ticketing_SeriesOrSeriesGroup::setSeasonId()
     * @uses Ticketing_SeriesOrSeriesGroup::setSellOnlyAsPartOfPrompt()
     * @uses Ticketing_SeriesOrSeriesGroup::setStartDate()
     * @uses Ticketing_SeriesOrSeriesGroup::setSubscriptionPeriod()
     * @uses Ticketing_SeriesOrSeriesGroup::setVisibleBySubordinates()
     * @param int $aclSchemeId
     * @param bool $canUserSelectEvents
     * @param int $crossOrgUnitsAclSchemeId
     * @param \patest\StructType\GlobalString $description
     * @param string $effectiveEndDate
     * @param string $effectiveStartDate
     * @param string $endDate
     * @param string $hallId
     * @param string $hallVersionId
     * @param string $hospitalityInRegularSaleApplicationChannels
     * @param \patest\StructType\Subscription_Media $hospitalityMedia
     * @param bool $isActive
     * @param bool $isAvailableForDisplay
     * @param bool $isAvailableForSale
     * @param bool $isHospitalityAvailable
     * @param bool $isPrepaiedWaitingListAllowed
     * @param bool $isSeriesAllocated
     * @param bool $isSeriesGroup
     * @param bool $isWaitingListAllowed
     * @param string $ledgerId
     * @param string $masterHospitalitySeriesId
     * @param string $masterSeriesId
     * @param \patest\StructType\Subscription_Media $media
     * @param \patest\StructType\Money $minPrice
     * @param int $minQuantityOfEvents
     * @param \patest\StructType\GlobalString $name
     * @param int $numberOfBonusEvents
     * @param string $organizationUnitId
     * @param string $periodDescription
     * @param string $periodType
     * @param string $projectIdentifierId
     * @param int $quantityOfEvents
     * @param string $relatedSeriesOrGroupId
     * @param string $schemeId
     * @param string $seasonality
     * @param string $seasonId
     * @param bool $sellOnlyAsPartOfPrompt
     * @param string $startDate
     * @param int $subscriptionPeriod
     * @param bool $visibleBySubordinates
     */
    public function __construct($aclSchemeId = null, $canUserSelectEvents = null, $crossOrgUnitsAclSchemeId = null, \patest\StructType\GlobalString $description = null, $effectiveEndDate = null, $effectiveStartDate = null, $endDate = null, $hallId = null, $hallVersionId = null, $hospitalityInRegularSaleApplicationChannels = null, \patest\StructType\Subscription_Media $hospitalityMedia = null, $isActive = null, $isAvailableForDisplay = null, $isAvailableForSale = null, $isHospitalityAvailable = null, $isPrepaiedWaitingListAllowed = null, $isSeriesAllocated = null, $isSeriesGroup = null, $isWaitingListAllowed = null, $ledgerId = null, $masterHospitalitySeriesId = null, $masterSeriesId = null, \patest\StructType\Subscription_Media $media = null, \patest\StructType\Money $minPrice = null, $minQuantityOfEvents = null, \patest\StructType\GlobalString $name = null, $numberOfBonusEvents = null, $organizationUnitId = null, $periodDescription = null, $periodType = null, $projectIdentifierId = null, $quantityOfEvents = null, $relatedSeriesOrGroupId = null, $schemeId = null, $seasonality = null, $seasonId = null, $sellOnlyAsPartOfPrompt = null, $startDate = null, $subscriptionPeriod = null, $visibleBySubordinates = null)
    {
        $this
            ->setAclSchemeId($aclSchemeId)
            ->setCanUserSelectEvents($canUserSelectEvents)
            ->setCrossOrgUnitsAclSchemeId($crossOrgUnitsAclSchemeId)
            ->setDescription($description)
            ->setEffectiveEndDate($effectiveEndDate)
            ->setEffectiveStartDate($effectiveStartDate)
            ->setEndDate($endDate)
            ->setHallId($hallId)
            ->setHallVersionId($hallVersionId)
            ->setHospitalityInRegularSaleApplicationChannels($hospitalityInRegularSaleApplicationChannels)
            ->setHospitalityMedia($hospitalityMedia)
            ->setIsActive($isActive)
            ->setIsAvailableForDisplay($isAvailableForDisplay)
            ->setIsAvailableForSale($isAvailableForSale)
            ->setIsHospitalityAvailable($isHospitalityAvailable)
            ->setIsPrepaiedWaitingListAllowed($isPrepaiedWaitingListAllowed)
            ->setIsSeriesAllocated($isSeriesAllocated)
            ->setIsSeriesGroup($isSeriesGroup)
            ->setIsWaitingListAllowed($isWaitingListAllowed)
            ->setLedgerId($ledgerId)
            ->setMasterHospitalitySeriesId($masterHospitalitySeriesId)
            ->setMasterSeriesId($masterSeriesId)
            ->setMedia($media)
            ->setMinPrice($minPrice)
            ->setMinQuantityOfEvents($minQuantityOfEvents)
            ->setName($name)
            ->setNumberOfBonusEvents($numberOfBonusEvents)
            ->setOrganizationUnitId($organizationUnitId)
            ->setPeriodDescription($periodDescription)
            ->setPeriodType($periodType)
            ->setProjectIdentifierId($projectIdentifierId)
            ->setQuantityOfEvents($quantityOfEvents)
            ->setRelatedSeriesOrGroupId($relatedSeriesOrGroupId)
            ->setSchemeId($schemeId)
            ->setSeasonality($seasonality)
            ->setSeasonId($seasonId)
            ->setSellOnlyAsPartOfPrompt($sellOnlyAsPartOfPrompt)
            ->setStartDate($startDate)
            ->setSubscriptionPeriod($subscriptionPeriod)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get AclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAclSchemeId()
    {
        return isset($this->AclSchemeId) ? $this->AclSchemeId : null;
    }
    /**
     * Set AclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aclSchemeId
     * @return \patest\StructType\Ticketing_SeriesOrSeriesGroup
     */
    public function setAclSchemeId($aclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($aclSchemeId) && !(is_int($aclSchemeId) || ctype_digit($aclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aclSchemeId, true), gettype($aclSchemeId)), __LINE__);
        }
        if (is_null($aclSchemeId) || (is_array($aclSchemeId) && empty($aclSchemeId))) {
            unset($this->AclSchemeId);
        } else {
            $this->AclSchemeId = $aclSchemeId;
        }
        return $this;
    }
    /**
     * Get CanUserSelectEvents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanUserSelectEvents()
    {
        return isset($this->CanUserSelectEvents) ? $this->CanUserSelectEvents : null;
    }
    /**
     * Set CanUserSelectEvents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canUserSelectEvents
     * @return \patest\StructType\Ticketing_SeriesOrSeriesGroup
     */
    public function setCanUserSelectEvents($canUserSelectEvents = null)
    {
        // validation for constraint: boolean
        if (!is_null($canUserSelectEvents) && !is_bool($canUserSelectEvents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canUserSelectEvents, true), gettype($canUserSelectEvents)), __LINE__);
        }
        if (is_null($canUserSelectEvents) || (is_array($canUserSelectEvents) && empty($canUserSelectEvents))) {
            unset($this->CanUserSelectEvents);
        } else {
            $this->CanUserSelectEvents = $canUserSelectEvents;
        }
        return $this;
    }
    /**
     * Get CrossOrgUnitsAclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCrossOrgUnitsAclSchemeId()
    {
        return isset($this->CrossOrgUnitsAclSchemeId) ? $this->CrossOrgUnitsAclSchemeId : null;
    }
    /**
     * Set CrossOrgUnitsAclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $crossOrgUnitsAclSchemeId
     * @return \patest\StructType\Ticketing_SeriesOrSeriesGroup
     */
    public function setCrossOrgUnitsAclSchemeId($crossOrgUnitsAclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($crossOrgUnitsAclSchemeId) && !(is_int($crossOrgUnitsAclSchemeId) || ctype_digit($crossOrgUnitsAclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($crossOrgUnitsAclSchemeId, true), gettype($crossOrgUnitsAclSchemeId)), __LINE__);
        }
        if (is_null($crossOrgUnitsAclSchemeId) || (is_array($crossOrgUnitsAclSchemeId) && empty($crossOrgUnitsAclSchemeId))) {
            unset($this->CrossOrgUnitsAclSchemeId);
        } else {
            $this->CrossOrgUnitsAclSchemeId = $crossOrgUnitsAclSchemeId;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\Ticketing_SeriesOrSeriesGroup
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get EffectiveEndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEffectiveEndDate()
    {
        return isset($this->EffectiveEndDate) ? $this->EffectiveEndDate : null;
    }
    /**
     * Set EffectiveEndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $effectiveEndDate
     * @return \patest\StructType\Ticketing_SeriesOrSeriesGroup
     */
    public function setEffectiveEndDate($effectiveEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveEndDate) && !is_string($effectiveEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveEndDate, true), gettype($effectiveEndDate)), __LINE__);
        }
        if (is_null($effectiveEndDate) || (is_array($effectiveEndDate) && empty($effectiveEndDate))) {
            unset($this->EffectiveEndDate);
        } else {
            $this->EffectiveEndDate = $effectiveEndDate;
        }
        return $this;
    }
    /**
     * Get EffectiveStartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEffectiveStartDate()
    {
        return isset($this->EffectiveStartDate) ? $this->EffectiveStartDate : null;
    }
    /**
     * Set EffectiveStartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $effectiveStartDate
     * @return \patest\StructType\Ticketing_SeriesOrSeriesGroup
     */
    public function setEffectiveStartDate($effectiveStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveStartDate) && !is_string($effectiveStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveStartDate, true), gettype($effectiveStartDate)), __LINE__);
        }
        if (is_null($effectiveStartDate) || (is_array($effectiveStartDate) && empty($effectiveStartDate))) {
            unset($this->EffectiveStartDate);
        } else {
            $this->EffectiveStartDate = $effectiveStartDate;
        }
        return $this;
    }
    /**
     * Get EndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndDate()
    {
        return isset($this->EndDate) ? $this->EndDate : null;
    }
    /**
     * Set EndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endDate
     * @return \patest\StructType\Ticketing_SeriesOrSeriesGroup
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        if (is_null($endDate) || (is_array($endDate) && empty($endDate))) {
            unset($this->EndDate);
        } else {
            $this->EndDate = $endDate;
        }
        return $this;
    }
    /**
     * Get HallId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallId()
    {
        return isset($this->HallId) ? $this->HallId : null;
    }
    /**
     * Set HallId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallId
     * @return \patest\StructType\Ticketing_SeriesOrSeriesGroup
     */
    public function setHallId($hallId = null)
    {
        // validation for constraint: string
        if (!is_null($hallId) && !is_string($hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallId, true), gettype($hallId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallId, true)), __LINE__);
        }
        if (is_null($hallId) || (is_array($hallId) && empty($hallId))) {
            unset($this->HallId);
        } else {
            $this->HallId = $hallId;
        }
        return $this;
    }
    /**
     * Get HallVersionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallVersionId()
    {
        return isset($this->HallVersionId) ? $this->HallVersionId : null;
    }
    /**
     * Set HallVersionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallVersionId
     * @return \patest\StructType\Ticketing_SeriesOrSeriesGroup
     */
    public function setHallVersionId($hallVersionId = null)
    {
        // validation for constraint: string
        if (!is_null($hallVersionId) && !is_string($hallVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallVersionId, true), gettype($hallVersionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallVersionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallVersionId, true)), __LINE__);
        }
        if (is_null($hallVersionId) || (is_array($hallVersionId) && empty($hallVersionId))) {
            unset($this->HallVersionId);
        } else {
            $this->HallVersionId = $hallVersionId;
        }
        return $this;
    }
    /**
     * Get HospitalityInRegularSaleApplicationChannels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHospitalityInRegularSaleApplicationChannels()
    {
        return isset($this->HospitalityInRegularSaleApplicationChannels) ? $this->HospitalityInRegularSaleApplicationChannels : null;
    }
    /**
     * Set HospitalityInRegularSaleApplicationChannels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hospitalityInRegularSaleApplicationChannels
     * @return \patest\StructType\Ticketing_SeriesOrSeriesGroup
     */
    public function setHospitalityInRegularSaleApplicationChannels($hospitalityInRegularSaleApplicationChannels = null)
    {
        // validation for constraint: string
        if (!is_null($hospitalityInRegularSaleApplicationChannels) && !is_string($hospitalityInRegularSaleApplicationChannels)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hospitalityInRegularSaleApplicationChannels, true), gettype($hospitalityInRegularSaleApplicationChannels)), __LINE__);
        }
        if (is_null($hospitalityInRegularSaleApplicationChannels) || (is_array($hospitalityInRegularSaleApplicationChannels) && empty($hospitalityInRegularSaleApplicationChannels))) {
            unset($this->HospitalityInRegularSaleApplicationChannels);
        } else {
            $this->HospitalityInRegularSaleApplicationChannels = $hospitalityInRegularSaleApplicationChannels;
        }
        return $this;
    }
    /**
     * Get HospitalityMedia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Subscription_Media|null
     */
    public function getHospitalityMedia()
    {
        return isset($this->HospitalityMedia) ? $this->HospitalityMedia : null;
    }
    /**
     * Set HospitalityMedia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Subscription_Media $hospitalityMedia
     * @return \patest\StructType\Ticketing_SeriesOrSeriesGroup
     */
    public function setHospitalityMedia(\patest\StructType\Subscription_Media $hospitalityMedia = null)
    {
        if (is_null($hospitalityMedia) || (is_array($hospitalityMedia) && empty($hospitalityMedia))) {
            unset($this->HospitalityMedia);
        } else {
            $this->HospitalityMedia = $hospitalityMedia;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Ticketing_SeriesOrSeriesGroup
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsAvailableForDisplay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAvailableForDisplay()
    {
        return isset($this->IsAvailableForDisplay) ? $this->IsAvailableForDisplay : null;
    }
    /**
     * Set IsAvailableForDisplay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAvailableForDisplay
     * @return \patest\StructType\Ticketing_SeriesOrSeriesGroup
     */
    public function setIsAvailableForDisplay($isAvailableForDisplay = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAvailableForDisplay) && !is_bool($isAvailableForDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAvailableForDisplay, true), gettype($isAvailableForDisplay)), __LINE__);
        }
        if (is_null($isAvailableForDisplay) || (is_array($isAvailableForDisplay) && empty($isAvailableForDisplay))) {
            unset($this->IsAvailableForDisplay);
        } else {
            $this->IsAvailableForDisplay = $isAvailableForDisplay;
        }
        return $this;
    }
    /**
     * Get IsAvailableForSale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAvailableForSale()
    {
        return isset($this->IsAvailableForSale) ? $this->IsAvailableForSale : null;
    }
    /**
     * Set IsAvailableForSale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAvailableForSale
     * @return \patest\StructType\Ticketing_SeriesOrSeriesGroup
     */
    public function setIsAvailableForSale($isAvailableForSale = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAvailableForSale) && !is_bool($isAvailableForSale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAvailableForSale, true), gettype($isAvailableForSale)), __LINE__);
        }
        if (is_null($isAvailableForSale) || (is_array($isAvailableForSale) && empty($isAvailableForSale))) {
            unset($this->IsAvailableForSale);
        } else {
            $this->IsAvailableForSale = $isAvailableForSale;
        }
        return $this;
    }
    /**
     * Get IsHospitalityAvailable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsHospitalityAvailable()
    {
        return isset($this->IsHospitalityAvailable) ? $this->IsHospitalityAvailable : null;
    }
    /**
     * Set IsHospitalityAvailable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isHospitalityAvailable
     * @return \patest\StructType\Ticketing_SeriesOrSeriesGroup
     */
    public function setIsHospitalityAvailable($isHospitalityAvailable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHospitalityAvailable) && !is_bool($isHospitalityAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isHospitalityAvailable, true), gettype($isHospitalityAvailable)), __LINE__);
        }
        if (is_null($isHospitalityAvailable) || (is_array($isHospitalityAvailable) && empty($isHospitalityAvailable))) {
            unset($this->IsHospitalityAvailable);
        } else {
            $this->IsHospitalityAvailable = $isHospitalityAvailable;
        }
        return $this;
    }
    /**
     * Get IsPrepaiedWaitingListAllowed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPrepaiedWaitingListAllowed()
    {
        return isset($this->IsPrepaiedWaitingListAllowed) ? $this->IsPrepaiedWaitingListAllowed : null;
    }
    /**
     * Set IsPrepaiedWaitingListAllowed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPrepaiedWaitingListAllowed
     * @return \patest\StructType\Ticketing_SeriesOrSeriesGroup
     */
    public function setIsPrepaiedWaitingListAllowed($isPrepaiedWaitingListAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrepaiedWaitingListAllowed) && !is_bool($isPrepaiedWaitingListAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrepaiedWaitingListAllowed, true), gettype($isPrepaiedWaitingListAllowed)), __LINE__);
        }
        if (is_null($isPrepaiedWaitingListAllowed) || (is_array($isPrepaiedWaitingListAllowed) && empty($isPrepaiedWaitingListAllowed))) {
            unset($this->IsPrepaiedWaitingListAllowed);
        } else {
            $this->IsPrepaiedWaitingListAllowed = $isPrepaiedWaitingListAllowed;
        }
        return $this;
    }
    /**
     * Get IsSeriesAllocated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSeriesAllocated()
    {
        return isset($this->IsSeriesAllocated) ? $this->IsSeriesAllocated : null;
    }
    /**
     * Set IsSeriesAllocated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSeriesAllocated
     * @return \patest\StructType\Ticketing_SeriesOrSeriesGroup
     */
    public function setIsSeriesAllocated($isSeriesAllocated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSeriesAllocated) && !is_bool($isSeriesAllocated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSeriesAllocated, true), gettype($isSeriesAllocated)), __LINE__);
        }
        if (is_null($isSeriesAllocated) || (is_array($isSeriesAllocated) && empty($isSeriesAllocated))) {
            unset($this->IsSeriesAllocated);
        } else {
            $this->IsSeriesAllocated = $isSeriesAllocated;
        }
        return $this;
    }
    /**
     * Get IsSeriesGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSeriesGroup()
    {
        return isset($this->IsSeriesGroup) ? $this->IsSeriesGroup : null;
    }
    /**
     * Set IsSeriesGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSeriesGroup
     * @return \patest\StructType\Ticketing_SeriesOrSeriesGroup
     */
    public function setIsSeriesGroup($isSeriesGroup = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSeriesGroup) && !is_bool($isSeriesGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSeriesGroup, true), gettype($isSeriesGroup)), __LINE__);
        }
        if (is_null($isSeriesGroup) || (is_array($isSeriesGroup) && empty($isSeriesGroup))) {
            unset($this->IsSeriesGroup);
        } else {
            $this->IsSeriesGroup = $isSeriesGroup;
        }
        return $this;
    }
    /**
     * Get IsWaitingListAllowed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsWaitingListAllowed()
    {
        return isset($this->IsWaitingListAllowed) ? $this->IsWaitingListAllowed : null;
    }
    /**
     * Set IsWaitingListAllowed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isWaitingListAllowed
     * @return \patest\StructType\Ticketing_SeriesOrSeriesGroup
     */
    public function setIsWaitingListAllowed($isWaitingListAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isWaitingListAllowed) && !is_bool($isWaitingListAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isWaitingListAllowed, true), gettype($isWaitingListAllowed)), __LINE__);
        }
        if (is_null($isWaitingListAllowed) || (is_array($isWaitingListAllowed) && empty($isWaitingListAllowed))) {
            unset($this->IsWaitingListAllowed);
        } else {
            $this->IsWaitingListAllowed = $isWaitingListAllowed;
        }
        return $this;
    }
    /**
     * Get LedgerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLedgerId()
    {
        return isset($this->LedgerId) ? $this->LedgerId : null;
    }
    /**
     * Set LedgerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ledgerId
     * @return \patest\StructType\Ticketing_SeriesOrSeriesGroup
     */
    public function setLedgerId($ledgerId = null)
    {
        // validation for constraint: string
        if (!is_null($ledgerId) && !is_string($ledgerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ledgerId, true), gettype($ledgerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ledgerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ledgerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ledgerId, true)), __LINE__);
        }
        if (is_null($ledgerId) || (is_array($ledgerId) && empty($ledgerId))) {
            unset($this->LedgerId);
        } else {
            $this->LedgerId = $ledgerId;
        }
        return $this;
    }
    /**
     * Get MasterHospitalitySeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMasterHospitalitySeriesId()
    {
        return isset($this->MasterHospitalitySeriesId) ? $this->MasterHospitalitySeriesId : null;
    }
    /**
     * Set MasterHospitalitySeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $masterHospitalitySeriesId
     * @return \patest\StructType\Ticketing_SeriesOrSeriesGroup
     */
    public function setMasterHospitalitySeriesId($masterHospitalitySeriesId = null)
    {
        // validation for constraint: string
        if (!is_null($masterHospitalitySeriesId) && !is_string($masterHospitalitySeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterHospitalitySeriesId, true), gettype($masterHospitalitySeriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($masterHospitalitySeriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $masterHospitalitySeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($masterHospitalitySeriesId, true)), __LINE__);
        }
        if (is_null($masterHospitalitySeriesId) || (is_array($masterHospitalitySeriesId) && empty($masterHospitalitySeriesId))) {
            unset($this->MasterHospitalitySeriesId);
        } else {
            $this->MasterHospitalitySeriesId = $masterHospitalitySeriesId;
        }
        return $this;
    }
    /**
     * Get MasterSeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMasterSeriesId()
    {
        return isset($this->MasterSeriesId) ? $this->MasterSeriesId : null;
    }
    /**
     * Set MasterSeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $masterSeriesId
     * @return \patest\StructType\Ticketing_SeriesOrSeriesGroup
     */
    public function setMasterSeriesId($masterSeriesId = null)
    {
        // validation for constraint: string
        if (!is_null($masterSeriesId) && !is_string($masterSeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterSeriesId, true), gettype($masterSeriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($masterSeriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $masterSeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($masterSeriesId, true)), __LINE__);
        }
        if (is_null($masterSeriesId) || (is_array($masterSeriesId) && empty($masterSeriesId))) {
            unset($this->MasterSeriesId);
        } else {
            $this->MasterSeriesId = $masterSeriesId;
        }
        return $this;
    }
    /**
     * Get Media value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Subscription_Media|null
     */
    public function getMedia()
    {
        return isset($this->Media) ? $this->Media : null;
    }
    /**
     * Set Media value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Subscription_Media $media
     * @return \patest\StructType\Ticketing_SeriesOrSeriesGroup
     */
    public function setMedia(\patest\StructType\Subscription_Media $media = null)
    {
        if (is_null($media) || (is_array($media) && empty($media))) {
            unset($this->Media);
        } else {
            $this->Media = $media;
        }
        return $this;
    }
    /**
     * Get MinPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getMinPrice()
    {
        return isset($this->MinPrice) ? $this->MinPrice : null;
    }
    /**
     * Set MinPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $minPrice
     * @return \patest\StructType\Ticketing_SeriesOrSeriesGroup
     */
    public function setMinPrice(\patest\StructType\Money $minPrice = null)
    {
        if (is_null($minPrice) || (is_array($minPrice) && empty($minPrice))) {
            unset($this->MinPrice);
        } else {
            $this->MinPrice = $minPrice;
        }
        return $this;
    }
    /**
     * Get MinQuantityOfEvents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinQuantityOfEvents()
    {
        return isset($this->MinQuantityOfEvents) ? $this->MinQuantityOfEvents : null;
    }
    /**
     * Set MinQuantityOfEvents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minQuantityOfEvents
     * @return \patest\StructType\Ticketing_SeriesOrSeriesGroup
     */
    public function setMinQuantityOfEvents($minQuantityOfEvents = null)
    {
        // validation for constraint: int
        if (!is_null($minQuantityOfEvents) && !(is_int($minQuantityOfEvents) || ctype_digit($minQuantityOfEvents))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minQuantityOfEvents, true), gettype($minQuantityOfEvents)), __LINE__);
        }
        if (is_null($minQuantityOfEvents) || (is_array($minQuantityOfEvents) && empty($minQuantityOfEvents))) {
            unset($this->MinQuantityOfEvents);
        } else {
            $this->MinQuantityOfEvents = $minQuantityOfEvents;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Ticketing_SeriesOrSeriesGroup
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NumberOfBonusEvents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfBonusEvents()
    {
        return isset($this->NumberOfBonusEvents) ? $this->NumberOfBonusEvents : null;
    }
    /**
     * Set NumberOfBonusEvents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfBonusEvents
     * @return \patest\StructType\Ticketing_SeriesOrSeriesGroup
     */
    public function setNumberOfBonusEvents($numberOfBonusEvents = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfBonusEvents) && !(is_int($numberOfBonusEvents) || ctype_digit($numberOfBonusEvents))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfBonusEvents, true), gettype($numberOfBonusEvents)), __LINE__);
        }
        if (is_null($numberOfBonusEvents) || (is_array($numberOfBonusEvents) && empty($numberOfBonusEvents))) {
            unset($this->NumberOfBonusEvents);
        } else {
            $this->NumberOfBonusEvents = $numberOfBonusEvents;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Ticketing_SeriesOrSeriesGroup
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get PeriodDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPeriodDescription()
    {
        return isset($this->PeriodDescription) ? $this->PeriodDescription : null;
    }
    /**
     * Set PeriodDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $periodDescription
     * @return \patest\StructType\Ticketing_SeriesOrSeriesGroup
     */
    public function setPeriodDescription($periodDescription = null)
    {
        // validation for constraint: string
        if (!is_null($periodDescription) && !is_string($periodDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($periodDescription, true), gettype($periodDescription)), __LINE__);
        }
        if (is_null($periodDescription) || (is_array($periodDescription) && empty($periodDescription))) {
            unset($this->PeriodDescription);
        } else {
            $this->PeriodDescription = $periodDescription;
        }
        return $this;
    }
    /**
     * Get PeriodType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPeriodType()
    {
        return isset($this->PeriodType) ? $this->PeriodType : null;
    }
    /**
     * Set PeriodType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $periodType
     * @return \patest\StructType\Ticketing_SeriesOrSeriesGroup
     */
    public function setPeriodType($periodType = null)
    {
        // validation for constraint: string
        if (!is_null($periodType) && !is_string($periodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($periodType, true), gettype($periodType)), __LINE__);
        }
        if (is_null($periodType) || (is_array($periodType) && empty($periodType))) {
            unset($this->PeriodType);
        } else {
            $this->PeriodType = $periodType;
        }
        return $this;
    }
    /**
     * Get ProjectIdentifierId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProjectIdentifierId()
    {
        return isset($this->ProjectIdentifierId) ? $this->ProjectIdentifierId : null;
    }
    /**
     * Set ProjectIdentifierId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $projectIdentifierId
     * @return \patest\StructType\Ticketing_SeriesOrSeriesGroup
     */
    public function setProjectIdentifierId($projectIdentifierId = null)
    {
        // validation for constraint: string
        if (!is_null($projectIdentifierId) && !is_string($projectIdentifierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($projectIdentifierId, true), gettype($projectIdentifierId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($projectIdentifierId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $projectIdentifierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($projectIdentifierId, true)), __LINE__);
        }
        if (is_null($projectIdentifierId) || (is_array($projectIdentifierId) && empty($projectIdentifierId))) {
            unset($this->ProjectIdentifierId);
        } else {
            $this->ProjectIdentifierId = $projectIdentifierId;
        }
        return $this;
    }
    /**
     * Get QuantityOfEvents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQuantityOfEvents()
    {
        return isset($this->QuantityOfEvents) ? $this->QuantityOfEvents : null;
    }
    /**
     * Set QuantityOfEvents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $quantityOfEvents
     * @return \patest\StructType\Ticketing_SeriesOrSeriesGroup
     */
    public function setQuantityOfEvents($quantityOfEvents = null)
    {
        // validation for constraint: int
        if (!is_null($quantityOfEvents) && !(is_int($quantityOfEvents) || ctype_digit($quantityOfEvents))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantityOfEvents, true), gettype($quantityOfEvents)), __LINE__);
        }
        if (is_null($quantityOfEvents) || (is_array($quantityOfEvents) && empty($quantityOfEvents))) {
            unset($this->QuantityOfEvents);
        } else {
            $this->QuantityOfEvents = $quantityOfEvents;
        }
        return $this;
    }
    /**
     * Get RelatedSeriesOrGroupId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedSeriesOrGroupId()
    {
        return isset($this->RelatedSeriesOrGroupId) ? $this->RelatedSeriesOrGroupId : null;
    }
    /**
     * Set RelatedSeriesOrGroupId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedSeriesOrGroupId
     * @return \patest\StructType\Ticketing_SeriesOrSeriesGroup
     */
    public function setRelatedSeriesOrGroupId($relatedSeriesOrGroupId = null)
    {
        // validation for constraint: string
        if (!is_null($relatedSeriesOrGroupId) && !is_string($relatedSeriesOrGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedSeriesOrGroupId, true), gettype($relatedSeriesOrGroupId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relatedSeriesOrGroupId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relatedSeriesOrGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relatedSeriesOrGroupId, true)), __LINE__);
        }
        if (is_null($relatedSeriesOrGroupId) || (is_array($relatedSeriesOrGroupId) && empty($relatedSeriesOrGroupId))) {
            unset($this->RelatedSeriesOrGroupId);
        } else {
            $this->RelatedSeriesOrGroupId = $relatedSeriesOrGroupId;
        }
        return $this;
    }
    /**
     * Get SchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSchemeId()
    {
        return isset($this->SchemeId) ? $this->SchemeId : null;
    }
    /**
     * Set SchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $schemeId
     * @return \patest\StructType\Ticketing_SeriesOrSeriesGroup
     */
    public function setSchemeId($schemeId = null)
    {
        // validation for constraint: string
        if (!is_null($schemeId) && !is_string($schemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemeId, true), gettype($schemeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($schemeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $schemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($schemeId, true)), __LINE__);
        }
        if (is_null($schemeId) || (is_array($schemeId) && empty($schemeId))) {
            unset($this->SchemeId);
        } else {
            $this->SchemeId = $schemeId;
        }
        return $this;
    }
    /**
     * Get Seasonality value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeasonality()
    {
        return isset($this->Seasonality) ? $this->Seasonality : null;
    }
    /**
     * Set Seasonality value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SeriesSeasonality::valueIsValid()
     * @uses \patest\EnumType\SeriesSeasonality::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $seasonality
     * @return \patest\StructType\Ticketing_SeriesOrSeriesGroup
     */
    public function setSeasonality($seasonality = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SeriesSeasonality::valueIsValid($seasonality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SeriesSeasonality', is_array($seasonality) ? implode(', ', $seasonality) : var_export($seasonality, true), implode(', ', \patest\EnumType\SeriesSeasonality::getValidValues())), __LINE__);
        }
        if (is_null($seasonality) || (is_array($seasonality) && empty($seasonality))) {
            unset($this->Seasonality);
        } else {
            $this->Seasonality = $seasonality;
        }
        return $this;
    }
    /**
     * Get SeasonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeasonId()
    {
        return isset($this->SeasonId) ? $this->SeasonId : null;
    }
    /**
     * Set SeasonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seasonId
     * @return \patest\StructType\Ticketing_SeriesOrSeriesGroup
     */
    public function setSeasonId($seasonId = null)
    {
        // validation for constraint: string
        if (!is_null($seasonId) && !is_string($seasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seasonId, true), gettype($seasonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seasonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seasonId, true)), __LINE__);
        }
        if (is_null($seasonId) || (is_array($seasonId) && empty($seasonId))) {
            unset($this->SeasonId);
        } else {
            $this->SeasonId = $seasonId;
        }
        return $this;
    }
    /**
     * Get SellOnlyAsPartOfPrompt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSellOnlyAsPartOfPrompt()
    {
        return isset($this->SellOnlyAsPartOfPrompt) ? $this->SellOnlyAsPartOfPrompt : null;
    }
    /**
     * Set SellOnlyAsPartOfPrompt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $sellOnlyAsPartOfPrompt
     * @return \patest\StructType\Ticketing_SeriesOrSeriesGroup
     */
    public function setSellOnlyAsPartOfPrompt($sellOnlyAsPartOfPrompt = null)
    {
        // validation for constraint: boolean
        if (!is_null($sellOnlyAsPartOfPrompt) && !is_bool($sellOnlyAsPartOfPrompt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sellOnlyAsPartOfPrompt, true), gettype($sellOnlyAsPartOfPrompt)), __LINE__);
        }
        if (is_null($sellOnlyAsPartOfPrompt) || (is_array($sellOnlyAsPartOfPrompt) && empty($sellOnlyAsPartOfPrompt))) {
            unset($this->SellOnlyAsPartOfPrompt);
        } else {
            $this->SellOnlyAsPartOfPrompt = $sellOnlyAsPartOfPrompt;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDate()
    {
        return isset($this->StartDate) ? $this->StartDate : null;
    }
    /**
     * Set StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDate
     * @return \patest\StructType\Ticketing_SeriesOrSeriesGroup
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->StartDate);
        } else {
            $this->StartDate = $startDate;
        }
        return $this;
    }
    /**
     * Get SubscriptionPeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSubscriptionPeriod()
    {
        return isset($this->SubscriptionPeriod) ? $this->SubscriptionPeriod : null;
    }
    /**
     * Set SubscriptionPeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $subscriptionPeriod
     * @return \patest\StructType\Ticketing_SeriesOrSeriesGroup
     */
    public function setSubscriptionPeriod($subscriptionPeriod = null)
    {
        // validation for constraint: int
        if (!is_null($subscriptionPeriod) && !(is_int($subscriptionPeriod) || ctype_digit($subscriptionPeriod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($subscriptionPeriod, true), gettype($subscriptionPeriod)), __LINE__);
        }
        if (is_null($subscriptionPeriod) || (is_array($subscriptionPeriod) && empty($subscriptionPeriod))) {
            unset($this->SubscriptionPeriod);
        } else {
            $this->SubscriptionPeriod = $subscriptionPeriod;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Ticketing_SeriesOrSeriesGroup
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
