<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.SeriesExchangePolicy StructType
 * @subpackage Structs
 */
class Ticketing_SeriesExchangePolicy extends Ticketing_SeriesExchangePolicyBase
{
    /**
     * The DefaultSeatgeekAllocationTypeName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $DefaultSeatgeekAllocationTypeName;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * The SeriesName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SeriesName;
    /**
     * Constructor method for Ticketing.SeriesExchangePolicy
     * @uses Ticketing_SeriesExchangePolicy::setDefaultSeatgeekAllocationTypeName()
     * @uses Ticketing_SeriesExchangePolicy::setIsActive()
     * @uses Ticketing_SeriesExchangePolicy::setSeriesId()
     * @uses Ticketing_SeriesExchangePolicy::setSeriesName()
     * @param \patest\StructType\GlobalString $defaultSeatgeekAllocationTypeName
     * @param bool $isActive
     * @param string $seriesId
     * @param \patest\StructType\GlobalString $seriesName
     */
    public function __construct(\patest\StructType\GlobalString $defaultSeatgeekAllocationTypeName = null, $isActive = null, $seriesId = null, \patest\StructType\GlobalString $seriesName = null)
    {
        $this
            ->setDefaultSeatgeekAllocationTypeName($defaultSeatgeekAllocationTypeName)
            ->setIsActive($isActive)
            ->setSeriesId($seriesId)
            ->setSeriesName($seriesName);
    }
    /**
     * Get DefaultSeatgeekAllocationTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDefaultSeatgeekAllocationTypeName()
    {
        return isset($this->DefaultSeatgeekAllocationTypeName) ? $this->DefaultSeatgeekAllocationTypeName : null;
    }
    /**
     * Set DefaultSeatgeekAllocationTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $defaultSeatgeekAllocationTypeName
     * @return \patest\StructType\Ticketing_SeriesExchangePolicy
     */
    public function setDefaultSeatgeekAllocationTypeName(\patest\StructType\GlobalString $defaultSeatgeekAllocationTypeName = null)
    {
        if (is_null($defaultSeatgeekAllocationTypeName) || (is_array($defaultSeatgeekAllocationTypeName) && empty($defaultSeatgeekAllocationTypeName))) {
            unset($this->DefaultSeatgeekAllocationTypeName);
        } else {
            $this->DefaultSeatgeekAllocationTypeName = $defaultSeatgeekAllocationTypeName;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Ticketing_SeriesExchangePolicy
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\Ticketing_SeriesExchangePolicy
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
    /**
     * Get SeriesName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSeriesName()
    {
        return isset($this->SeriesName) ? $this->SeriesName : null;
    }
    /**
     * Set SeriesName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $seriesName
     * @return \patest\StructType\Ticketing_SeriesExchangePolicy
     */
    public function setSeriesName(\patest\StructType\GlobalString $seriesName = null)
    {
        if (is_null($seriesName) || (is_array($seriesName) && empty($seriesName))) {
            unset($this->SeriesName);
        } else {
            $this->SeriesName = $seriesName;
        }
        return $this;
    }
}
