<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.SelectedTicket StructType
 * @subpackage Structs
 */
class Ticketing_SelectedTicket extends AnyEntity
{
    /**
     * The AreaName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AreaName;
    /**
     * The PriceLevelName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceLevelName;
    /**
     * The RowName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RowName;
    /**
     * The SeatName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatName;
    /**
     * The SectorName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SectorName;
    /**
     * The Selected
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Selected;
    /**
     * The TicketId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketId;
    /**
     * Constructor method for Ticketing.SelectedTicket
     * @uses Ticketing_SelectedTicket::setAreaName()
     * @uses Ticketing_SelectedTicket::setPriceLevelName()
     * @uses Ticketing_SelectedTicket::setRowName()
     * @uses Ticketing_SelectedTicket::setSeatName()
     * @uses Ticketing_SelectedTicket::setSectorName()
     * @uses Ticketing_SelectedTicket::setSelected()
     * @uses Ticketing_SelectedTicket::setTicketId()
     * @param string $areaName
     * @param string $priceLevelName
     * @param string $rowName
     * @param string $seatName
     * @param string $sectorName
     * @param bool $selected
     * @param string $ticketId
     */
    public function __construct($areaName = null, $priceLevelName = null, $rowName = null, $seatName = null, $sectorName = null, $selected = null, $ticketId = null)
    {
        $this
            ->setAreaName($areaName)
            ->setPriceLevelName($priceLevelName)
            ->setRowName($rowName)
            ->setSeatName($seatName)
            ->setSectorName($sectorName)
            ->setSelected($selected)
            ->setTicketId($ticketId);
    }
    /**
     * Get AreaName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaName()
    {
        return isset($this->AreaName) ? $this->AreaName : null;
    }
    /**
     * Set AreaName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaName
     * @return \patest\StructType\Ticketing_SelectedTicket
     */
    public function setAreaName($areaName = null)
    {
        // validation for constraint: string
        if (!is_null($areaName) && !is_string($areaName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaName, true), gettype($areaName)), __LINE__);
        }
        if (is_null($areaName) || (is_array($areaName) && empty($areaName))) {
            unset($this->AreaName);
        } else {
            $this->AreaName = $areaName;
        }
        return $this;
    }
    /**
     * Get PriceLevelName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelName()
    {
        return isset($this->PriceLevelName) ? $this->PriceLevelName : null;
    }
    /**
     * Set PriceLevelName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelName
     * @return \patest\StructType\Ticketing_SelectedTicket
     */
    public function setPriceLevelName($priceLevelName = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelName) && !is_string($priceLevelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelName, true), gettype($priceLevelName)), __LINE__);
        }
        if (is_null($priceLevelName) || (is_array($priceLevelName) && empty($priceLevelName))) {
            unset($this->PriceLevelName);
        } else {
            $this->PriceLevelName = $priceLevelName;
        }
        return $this;
    }
    /**
     * Get RowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRowName()
    {
        return isset($this->RowName) ? $this->RowName : null;
    }
    /**
     * Set RowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rowName
     * @return \patest\StructType\Ticketing_SelectedTicket
     */
    public function setRowName($rowName = null)
    {
        // validation for constraint: string
        if (!is_null($rowName) && !is_string($rowName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rowName, true), gettype($rowName)), __LINE__);
        }
        if (is_null($rowName) || (is_array($rowName) && empty($rowName))) {
            unset($this->RowName);
        } else {
            $this->RowName = $rowName;
        }
        return $this;
    }
    /**
     * Get SeatName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatName()
    {
        return isset($this->SeatName) ? $this->SeatName : null;
    }
    /**
     * Set SeatName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatName
     * @return \patest\StructType\Ticketing_SelectedTicket
     */
    public function setSeatName($seatName = null)
    {
        // validation for constraint: string
        if (!is_null($seatName) && !is_string($seatName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatName, true), gettype($seatName)), __LINE__);
        }
        if (is_null($seatName) || (is_array($seatName) && empty($seatName))) {
            unset($this->SeatName);
        } else {
            $this->SeatName = $seatName;
        }
        return $this;
    }
    /**
     * Get SectorName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSectorName()
    {
        return isset($this->SectorName) ? $this->SectorName : null;
    }
    /**
     * Set SectorName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sectorName
     * @return \patest\StructType\Ticketing_SelectedTicket
     */
    public function setSectorName($sectorName = null)
    {
        // validation for constraint: string
        if (!is_null($sectorName) && !is_string($sectorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectorName, true), gettype($sectorName)), __LINE__);
        }
        if (is_null($sectorName) || (is_array($sectorName) && empty($sectorName))) {
            unset($this->SectorName);
        } else {
            $this->SectorName = $sectorName;
        }
        return $this;
    }
    /**
     * Get Selected value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSelected()
    {
        return isset($this->Selected) ? $this->Selected : null;
    }
    /**
     * Set Selected value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $selected
     * @return \patest\StructType\Ticketing_SelectedTicket
     */
    public function setSelected($selected = null)
    {
        // validation for constraint: boolean
        if (!is_null($selected) && !is_bool($selected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($selected, true), gettype($selected)), __LINE__);
        }
        if (is_null($selected) || (is_array($selected) && empty($selected))) {
            unset($this->Selected);
        } else {
            $this->Selected = $selected;
        }
        return $this;
    }
    /**
     * Get TicketId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketId()
    {
        return isset($this->TicketId) ? $this->TicketId : null;
    }
    /**
     * Set TicketId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketId
     * @return \patest\StructType\Ticketing_SelectedTicket
     */
    public function setTicketId($ticketId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketId) && !is_string($ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketId, true), gettype($ticketId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketId, true)), __LINE__);
        }
        if (is_null($ticketId) || (is_array($ticketId) && empty($ticketId))) {
            unset($this->TicketId);
        } else {
            $this->TicketId = $ticketId;
        }
        return $this;
    }
}
