<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.Sector StructType
 * @subpackage Structs
 */
class Ticketing_Sector extends VolatileEntity
{
    /**
     * The AreaMapGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaMapGuid;
    /**
     * The ContinuedBySectorGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ContinuedBySectorGuid;
    /**
     * The DesignXml
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DesignXml;
    /**
     * The MaxUnreservedSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxUnreservedSeats;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The Ordinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Ordinal;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Priority;
    /**
     * The Rows
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Rows;
    /**
     * Constructor method for Ticketing.Sector
     * @uses Ticketing_Sector::setAreaMapGuid()
     * @uses Ticketing_Sector::setContinuedBySectorGuid()
     * @uses Ticketing_Sector::setDesignXml()
     * @uses Ticketing_Sector::setMaxUnreservedSeats()
     * @uses Ticketing_Sector::setName()
     * @uses Ticketing_Sector::setOrdinal()
     * @uses Ticketing_Sector::setPriority()
     * @uses Ticketing_Sector::setRows()
     * @param string $areaMapGuid
     * @param string $continuedBySectorGuid
     * @param string $designXml
     * @param int $maxUnreservedSeats
     * @param \patest\StructType\GlobalString $name
     * @param int $ordinal
     * @param int $priority
     * @param string $rows
     */
    public function __construct($areaMapGuid = null, $continuedBySectorGuid = null, $designXml = null, $maxUnreservedSeats = null, \patest\StructType\GlobalString $name = null, $ordinal = null, $priority = null, $rows = null)
    {
        $this
            ->setAreaMapGuid($areaMapGuid)
            ->setContinuedBySectorGuid($continuedBySectorGuid)
            ->setDesignXml($designXml)
            ->setMaxUnreservedSeats($maxUnreservedSeats)
            ->setName($name)
            ->setOrdinal($ordinal)
            ->setPriority($priority)
            ->setRows($rows);
    }
    /**
     * Get AreaMapGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaMapGuid()
    {
        return isset($this->AreaMapGuid) ? $this->AreaMapGuid : null;
    }
    /**
     * Set AreaMapGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaMapGuid
     * @return \patest\StructType\Ticketing_Sector
     */
    public function setAreaMapGuid($areaMapGuid = null)
    {
        // validation for constraint: string
        if (!is_null($areaMapGuid) && !is_string($areaMapGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaMapGuid, true), gettype($areaMapGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaMapGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaMapGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaMapGuid, true)), __LINE__);
        }
        if (is_null($areaMapGuid) || (is_array($areaMapGuid) && empty($areaMapGuid))) {
            unset($this->AreaMapGuid);
        } else {
            $this->AreaMapGuid = $areaMapGuid;
        }
        return $this;
    }
    /**
     * Get ContinuedBySectorGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContinuedBySectorGuid()
    {
        return isset($this->ContinuedBySectorGuid) ? $this->ContinuedBySectorGuid : null;
    }
    /**
     * Set ContinuedBySectorGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $continuedBySectorGuid
     * @return \patest\StructType\Ticketing_Sector
     */
    public function setContinuedBySectorGuid($continuedBySectorGuid = null)
    {
        // validation for constraint: string
        if (!is_null($continuedBySectorGuid) && !is_string($continuedBySectorGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($continuedBySectorGuid, true), gettype($continuedBySectorGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($continuedBySectorGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $continuedBySectorGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($continuedBySectorGuid, true)), __LINE__);
        }
        if (is_null($continuedBySectorGuid) || (is_array($continuedBySectorGuid) && empty($continuedBySectorGuid))) {
            unset($this->ContinuedBySectorGuid);
        } else {
            $this->ContinuedBySectorGuid = $continuedBySectorGuid;
        }
        return $this;
    }
    /**
     * Get DesignXml value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDesignXml()
    {
        return isset($this->DesignXml) ? $this->DesignXml : null;
    }
    /**
     * Set DesignXml value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $designXml
     * @return \patest\StructType\Ticketing_Sector
     */
    public function setDesignXml($designXml = null)
    {
        // validation for constraint: string
        if (!is_null($designXml) && !is_string($designXml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($designXml, true), gettype($designXml)), __LINE__);
        }
        if (is_null($designXml) || (is_array($designXml) && empty($designXml))) {
            unset($this->DesignXml);
        } else {
            $this->DesignXml = $designXml;
        }
        return $this;
    }
    /**
     * Get MaxUnreservedSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxUnreservedSeats()
    {
        return isset($this->MaxUnreservedSeats) ? $this->MaxUnreservedSeats : null;
    }
    /**
     * Set MaxUnreservedSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxUnreservedSeats
     * @return \patest\StructType\Ticketing_Sector
     */
    public function setMaxUnreservedSeats($maxUnreservedSeats = null)
    {
        // validation for constraint: int
        if (!is_null($maxUnreservedSeats) && !(is_int($maxUnreservedSeats) || ctype_digit($maxUnreservedSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxUnreservedSeats, true), gettype($maxUnreservedSeats)), __LINE__);
        }
        if (is_null($maxUnreservedSeats) || (is_array($maxUnreservedSeats) && empty($maxUnreservedSeats))) {
            unset($this->MaxUnreservedSeats);
        } else {
            $this->MaxUnreservedSeats = $maxUnreservedSeats;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Ticketing_Sector
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Ordinal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrdinal()
    {
        return isset($this->Ordinal) ? $this->Ordinal : null;
    }
    /**
     * Set Ordinal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ordinal
     * @return \patest\StructType\Ticketing_Sector
     */
    public function setOrdinal($ordinal = null)
    {
        // validation for constraint: int
        if (!is_null($ordinal) && !(is_int($ordinal) || ctype_digit($ordinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordinal, true), gettype($ordinal)), __LINE__);
        }
        if (is_null($ordinal) || (is_array($ordinal) && empty($ordinal))) {
            unset($this->Ordinal);
        } else {
            $this->Ordinal = $ordinal;
        }
        return $this;
    }
    /**
     * Get Priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPriority()
    {
        return isset($this->Priority) ? $this->Priority : null;
    }
    /**
     * Set Priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $priority
     * @return \patest\StructType\Ticketing_Sector
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        if (is_null($priority) || (is_array($priority) && empty($priority))) {
            unset($this->Priority);
        } else {
            $this->Priority = $priority;
        }
        return $this;
    }
    /**
     * Get Rows value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRows()
    {
        return isset($this->Rows) ? $this->Rows : null;
    }
    /**
     * Set Rows value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rows
     * @return \patest\StructType\Ticketing_Sector
     */
    public function setRows($rows = null)
    {
        // validation for constraint: string
        if (!is_null($rows) && !is_string($rows)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rows, true), gettype($rows)), __LINE__);
        }
        if (is_null($rows) || (is_array($rows) && empty($rows))) {
            unset($this->Rows);
        } else {
            $this->Rows = $rows;
        }
        return $this;
    }
}
