<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.SeatingPlanRuntimeInfo StructType
 * @subpackage Structs
 */
class Ticketing_SeatingPlanRuntimeInfo extends AnyEntity
{
    /**
     * The AppServerNodeName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AppServerNodeName;
    /**
     * The CapacityCounters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_SeatingPlanCapacityCounters
     */
    public $CapacityCounters;
    /**
     * The CoreMemoryUsageKb
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CoreMemoryUsageKb;
    /**
     * The HallId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallId;
    /**
     * The HallVersionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallVersionId;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The LoadedAt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LoadedAt;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The SessionCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SessionCount;
    /**
     * The SessionsMemoryUsageKb
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $SessionsMemoryUsageKb;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * Constructor method for Ticketing.SeatingPlanRuntimeInfo
     * @uses Ticketing_SeatingPlanRuntimeInfo::setAppServerNodeName()
     * @uses Ticketing_SeatingPlanRuntimeInfo::setCapacityCounters()
     * @uses Ticketing_SeatingPlanRuntimeInfo::setCoreMemoryUsageKb()
     * @uses Ticketing_SeatingPlanRuntimeInfo::setHallId()
     * @uses Ticketing_SeatingPlanRuntimeInfo::setHallVersionId()
     * @uses Ticketing_SeatingPlanRuntimeInfo::setId()
     * @uses Ticketing_SeatingPlanRuntimeInfo::setLoadedAt()
     * @uses Ticketing_SeatingPlanRuntimeInfo::setName()
     * @uses Ticketing_SeatingPlanRuntimeInfo::setOrganizationUnitId()
     * @uses Ticketing_SeatingPlanRuntimeInfo::setSessionCount()
     * @uses Ticketing_SeatingPlanRuntimeInfo::setSessionsMemoryUsageKb()
     * @uses Ticketing_SeatingPlanRuntimeInfo::setStatus()
     * @uses Ticketing_SeatingPlanRuntimeInfo::setType()
     * @param string $appServerNodeName
     * @param \patest\StructType\Ticketing_SeatingPlanCapacityCounters $capacityCounters
     * @param float $coreMemoryUsageKb
     * @param string $hallId
     * @param string $hallVersionId
     * @param string $id
     * @param string $loadedAt
     * @param string $name
     * @param string $organizationUnitId
     * @param int $sessionCount
     * @param float $sessionsMemoryUsageKb
     * @param string $status
     * @param string $type
     */
    public function __construct($appServerNodeName = null, \patest\StructType\Ticketing_SeatingPlanCapacityCounters $capacityCounters = null, $coreMemoryUsageKb = null, $hallId = null, $hallVersionId = null, $id = null, $loadedAt = null, $name = null, $organizationUnitId = null, $sessionCount = null, $sessionsMemoryUsageKb = null, $status = null, $type = null)
    {
        $this
            ->setAppServerNodeName($appServerNodeName)
            ->setCapacityCounters($capacityCounters)
            ->setCoreMemoryUsageKb($coreMemoryUsageKb)
            ->setHallId($hallId)
            ->setHallVersionId($hallVersionId)
            ->setId($id)
            ->setLoadedAt($loadedAt)
            ->setName($name)
            ->setOrganizationUnitId($organizationUnitId)
            ->setSessionCount($sessionCount)
            ->setSessionsMemoryUsageKb($sessionsMemoryUsageKb)
            ->setStatus($status)
            ->setType($type);
    }
    /**
     * Get AppServerNodeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAppServerNodeName()
    {
        return isset($this->AppServerNodeName) ? $this->AppServerNodeName : null;
    }
    /**
     * Set AppServerNodeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $appServerNodeName
     * @return \patest\StructType\Ticketing_SeatingPlanRuntimeInfo
     */
    public function setAppServerNodeName($appServerNodeName = null)
    {
        // validation for constraint: string
        if (!is_null($appServerNodeName) && !is_string($appServerNodeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appServerNodeName, true), gettype($appServerNodeName)), __LINE__);
        }
        if (is_null($appServerNodeName) || (is_array($appServerNodeName) && empty($appServerNodeName))) {
            unset($this->AppServerNodeName);
        } else {
            $this->AppServerNodeName = $appServerNodeName;
        }
        return $this;
    }
    /**
     * Get CapacityCounters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_SeatingPlanCapacityCounters|null
     */
    public function getCapacityCounters()
    {
        return isset($this->CapacityCounters) ? $this->CapacityCounters : null;
    }
    /**
     * Set CapacityCounters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_SeatingPlanCapacityCounters $capacityCounters
     * @return \patest\StructType\Ticketing_SeatingPlanRuntimeInfo
     */
    public function setCapacityCounters(\patest\StructType\Ticketing_SeatingPlanCapacityCounters $capacityCounters = null)
    {
        if (is_null($capacityCounters) || (is_array($capacityCounters) && empty($capacityCounters))) {
            unset($this->CapacityCounters);
        } else {
            $this->CapacityCounters = $capacityCounters;
        }
        return $this;
    }
    /**
     * Get CoreMemoryUsageKb value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCoreMemoryUsageKb()
    {
        return isset($this->CoreMemoryUsageKb) ? $this->CoreMemoryUsageKb : null;
    }
    /**
     * Set CoreMemoryUsageKb value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $coreMemoryUsageKb
     * @return \patest\StructType\Ticketing_SeatingPlanRuntimeInfo
     */
    public function setCoreMemoryUsageKb($coreMemoryUsageKb = null)
    {
        // validation for constraint: float
        if (!is_null($coreMemoryUsageKb) && !(is_float($coreMemoryUsageKb) || is_numeric($coreMemoryUsageKb))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($coreMemoryUsageKb, true), gettype($coreMemoryUsageKb)), __LINE__);
        }
        if (is_null($coreMemoryUsageKb) || (is_array($coreMemoryUsageKb) && empty($coreMemoryUsageKb))) {
            unset($this->CoreMemoryUsageKb);
        } else {
            $this->CoreMemoryUsageKb = $coreMemoryUsageKb;
        }
        return $this;
    }
    /**
     * Get HallId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallId()
    {
        return isset($this->HallId) ? $this->HallId : null;
    }
    /**
     * Set HallId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallId
     * @return \patest\StructType\Ticketing_SeatingPlanRuntimeInfo
     */
    public function setHallId($hallId = null)
    {
        // validation for constraint: string
        if (!is_null($hallId) && !is_string($hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallId, true), gettype($hallId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallId, true)), __LINE__);
        }
        if (is_null($hallId) || (is_array($hallId) && empty($hallId))) {
            unset($this->HallId);
        } else {
            $this->HallId = $hallId;
        }
        return $this;
    }
    /**
     * Get HallVersionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallVersionId()
    {
        return isset($this->HallVersionId) ? $this->HallVersionId : null;
    }
    /**
     * Set HallVersionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallVersionId
     * @return \patest\StructType\Ticketing_SeatingPlanRuntimeInfo
     */
    public function setHallVersionId($hallVersionId = null)
    {
        // validation for constraint: string
        if (!is_null($hallVersionId) && !is_string($hallVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallVersionId, true), gettype($hallVersionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallVersionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallVersionId, true)), __LINE__);
        }
        if (is_null($hallVersionId) || (is_array($hallVersionId) && empty($hallVersionId))) {
            unset($this->HallVersionId);
        } else {
            $this->HallVersionId = $hallVersionId;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\Ticketing_SeatingPlanRuntimeInfo
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get LoadedAt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoadedAt()
    {
        return isset($this->LoadedAt) ? $this->LoadedAt : null;
    }
    /**
     * Set LoadedAt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loadedAt
     * @return \patest\StructType\Ticketing_SeatingPlanRuntimeInfo
     */
    public function setLoadedAt($loadedAt = null)
    {
        // validation for constraint: string
        if (!is_null($loadedAt) && !is_string($loadedAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loadedAt, true), gettype($loadedAt)), __LINE__);
        }
        if (is_null($loadedAt) || (is_array($loadedAt) && empty($loadedAt))) {
            unset($this->LoadedAt);
        } else {
            $this->LoadedAt = $loadedAt;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\Ticketing_SeatingPlanRuntimeInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Ticketing_SeatingPlanRuntimeInfo
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get SessionCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSessionCount()
    {
        return isset($this->SessionCount) ? $this->SessionCount : null;
    }
    /**
     * Set SessionCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $sessionCount
     * @return \patest\StructType\Ticketing_SeatingPlanRuntimeInfo
     */
    public function setSessionCount($sessionCount = null)
    {
        // validation for constraint: int
        if (!is_null($sessionCount) && !(is_int($sessionCount) || ctype_digit($sessionCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sessionCount, true), gettype($sessionCount)), __LINE__);
        }
        if (is_null($sessionCount) || (is_array($sessionCount) && empty($sessionCount))) {
            unset($this->SessionCount);
        } else {
            $this->SessionCount = $sessionCount;
        }
        return $this;
    }
    /**
     * Get SessionsMemoryUsageKb value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getSessionsMemoryUsageKb()
    {
        return isset($this->SessionsMemoryUsageKb) ? $this->SessionsMemoryUsageKb : null;
    }
    /**
     * Set SessionsMemoryUsageKb value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $sessionsMemoryUsageKb
     * @return \patest\StructType\Ticketing_SeatingPlanRuntimeInfo
     */
    public function setSessionsMemoryUsageKb($sessionsMemoryUsageKb = null)
    {
        // validation for constraint: float
        if (!is_null($sessionsMemoryUsageKb) && !(is_float($sessionsMemoryUsageKb) || is_numeric($sessionsMemoryUsageKb))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sessionsMemoryUsageKb, true), gettype($sessionsMemoryUsageKb)), __LINE__);
        }
        if (is_null($sessionsMemoryUsageKb) || (is_array($sessionsMemoryUsageKb) && empty($sessionsMemoryUsageKb))) {
            unset($this->SessionsMemoryUsageKb);
        } else {
            $this->SessionsMemoryUsageKb = $sessionsMemoryUsageKb;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SeatingPlanManagerStatus::valueIsValid()
     * @uses \patest\EnumType\SeatingPlanManagerStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\Ticketing_SeatingPlanRuntimeInfo
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SeatingPlanManagerStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SeatingPlanManagerStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\SeatingPlanManagerStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SeatingPlanOwnerType::valueIsValid()
     * @uses \patest\EnumType\SeatingPlanOwnerType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \patest\StructType\Ticketing_SeatingPlanRuntimeInfo
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SeatingPlanOwnerType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SeatingPlanOwnerType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \patest\EnumType\SeatingPlanOwnerType::getValidValues())), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
}
