<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.SeatingPlanRestrictionInfo StructType
 * @subpackage Structs
 */
class Ticketing_SeatingPlanRestrictionInfo extends AnyEntity
{
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The AreaName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AreaName;
    /**
     * The AvailableCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AvailableCount;
    /**
     * The ConsumedCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ConsumedCount;
    /**
     * The DefinedCapacity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DefinedCapacity;
    /**
     * The EffectiveCapacity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $EffectiveCapacity;
    /**
     * The EffectiveIsExclusive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $EffectiveIsExclusive;
    /**
     * The HallVersionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallVersionId;
    /**
     * The IsAvailableToUser
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAvailableToUser;
    /**
     * The IsCountWithAvailableSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsCountWithAvailableSeats;
    /**
     * The IsExclusive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsExclusive;
    /**
     * The IsExpired
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsExpired;
    /**
     * The ReservedCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ReservedCount;
    /**
     * The RestrictionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RestrictionId;
    /**
     * The RestrictionName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RestrictionName;
    /**
     * The RestrictionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RestrictionType;
    /**
     * The SeatingPlanId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeatingPlanId;
    /**
     * The ShowId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowId;
    /**
     * The SoldCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SoldCount;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The TemporarilyHeldCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TemporarilyHeldCount;
    /**
     * Constructor method for Ticketing.SeatingPlanRestrictionInfo
     * @uses Ticketing_SeatingPlanRestrictionInfo::setAreaId()
     * @uses Ticketing_SeatingPlanRestrictionInfo::setAreaName()
     * @uses Ticketing_SeatingPlanRestrictionInfo::setAvailableCount()
     * @uses Ticketing_SeatingPlanRestrictionInfo::setConsumedCount()
     * @uses Ticketing_SeatingPlanRestrictionInfo::setDefinedCapacity()
     * @uses Ticketing_SeatingPlanRestrictionInfo::setEffectiveCapacity()
     * @uses Ticketing_SeatingPlanRestrictionInfo::setEffectiveIsExclusive()
     * @uses Ticketing_SeatingPlanRestrictionInfo::setHallVersionId()
     * @uses Ticketing_SeatingPlanRestrictionInfo::setIsAvailableToUser()
     * @uses Ticketing_SeatingPlanRestrictionInfo::setIsCountWithAvailableSeats()
     * @uses Ticketing_SeatingPlanRestrictionInfo::setIsExclusive()
     * @uses Ticketing_SeatingPlanRestrictionInfo::setIsExpired()
     * @uses Ticketing_SeatingPlanRestrictionInfo::setReservedCount()
     * @uses Ticketing_SeatingPlanRestrictionInfo::setRestrictionId()
     * @uses Ticketing_SeatingPlanRestrictionInfo::setRestrictionName()
     * @uses Ticketing_SeatingPlanRestrictionInfo::setRestrictionType()
     * @uses Ticketing_SeatingPlanRestrictionInfo::setSeatingPlanId()
     * @uses Ticketing_SeatingPlanRestrictionInfo::setShowId()
     * @uses Ticketing_SeatingPlanRestrictionInfo::setSoldCount()
     * @uses Ticketing_SeatingPlanRestrictionInfo::setStatus()
     * @uses Ticketing_SeatingPlanRestrictionInfo::setTemporarilyHeldCount()
     * @param string $areaId
     * @param string $areaName
     * @param int $availableCount
     * @param int $consumedCount
     * @param int $definedCapacity
     * @param int $effectiveCapacity
     * @param bool $effectiveIsExclusive
     * @param string $hallVersionId
     * @param bool $isAvailableToUser
     * @param bool $isCountWithAvailableSeats
     * @param bool $isExclusive
     * @param bool $isExpired
     * @param int $reservedCount
     * @param string $restrictionId
     * @param string $restrictionName
     * @param string $restrictionType
     * @param string $seatingPlanId
     * @param string $showId
     * @param int $soldCount
     * @param string $status
     * @param int $temporarilyHeldCount
     */
    public function __construct($areaId = null, $areaName = null, $availableCount = null, $consumedCount = null, $definedCapacity = null, $effectiveCapacity = null, $effectiveIsExclusive = null, $hallVersionId = null, $isAvailableToUser = null, $isCountWithAvailableSeats = null, $isExclusive = null, $isExpired = null, $reservedCount = null, $restrictionId = null, $restrictionName = null, $restrictionType = null, $seatingPlanId = null, $showId = null, $soldCount = null, $status = null, $temporarilyHeldCount = null)
    {
        $this
            ->setAreaId($areaId)
            ->setAreaName($areaName)
            ->setAvailableCount($availableCount)
            ->setConsumedCount($consumedCount)
            ->setDefinedCapacity($definedCapacity)
            ->setEffectiveCapacity($effectiveCapacity)
            ->setEffectiveIsExclusive($effectiveIsExclusive)
            ->setHallVersionId($hallVersionId)
            ->setIsAvailableToUser($isAvailableToUser)
            ->setIsCountWithAvailableSeats($isCountWithAvailableSeats)
            ->setIsExclusive($isExclusive)
            ->setIsExpired($isExpired)
            ->setReservedCount($reservedCount)
            ->setRestrictionId($restrictionId)
            ->setRestrictionName($restrictionName)
            ->setRestrictionType($restrictionType)
            ->setSeatingPlanId($seatingPlanId)
            ->setShowId($showId)
            ->setSoldCount($soldCount)
            ->setStatus($status)
            ->setTemporarilyHeldCount($temporarilyHeldCount);
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\Ticketing_SeatingPlanRestrictionInfo
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get AreaName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaName()
    {
        return isset($this->AreaName) ? $this->AreaName : null;
    }
    /**
     * Set AreaName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaName
     * @return \patest\StructType\Ticketing_SeatingPlanRestrictionInfo
     */
    public function setAreaName($areaName = null)
    {
        // validation for constraint: string
        if (!is_null($areaName) && !is_string($areaName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaName, true), gettype($areaName)), __LINE__);
        }
        if (is_null($areaName) || (is_array($areaName) && empty($areaName))) {
            unset($this->AreaName);
        } else {
            $this->AreaName = $areaName;
        }
        return $this;
    }
    /**
     * Get AvailableCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAvailableCount()
    {
        return isset($this->AvailableCount) ? $this->AvailableCount : null;
    }
    /**
     * Set AvailableCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $availableCount
     * @return \patest\StructType\Ticketing_SeatingPlanRestrictionInfo
     */
    public function setAvailableCount($availableCount = null)
    {
        // validation for constraint: int
        if (!is_null($availableCount) && !(is_int($availableCount) || ctype_digit($availableCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($availableCount, true), gettype($availableCount)), __LINE__);
        }
        if (is_null($availableCount) || (is_array($availableCount) && empty($availableCount))) {
            unset($this->AvailableCount);
        } else {
            $this->AvailableCount = $availableCount;
        }
        return $this;
    }
    /**
     * Get ConsumedCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getConsumedCount()
    {
        return isset($this->ConsumedCount) ? $this->ConsumedCount : null;
    }
    /**
     * Set ConsumedCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $consumedCount
     * @return \patest\StructType\Ticketing_SeatingPlanRestrictionInfo
     */
    public function setConsumedCount($consumedCount = null)
    {
        // validation for constraint: int
        if (!is_null($consumedCount) && !(is_int($consumedCount) || ctype_digit($consumedCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($consumedCount, true), gettype($consumedCount)), __LINE__);
        }
        if (is_null($consumedCount) || (is_array($consumedCount) && empty($consumedCount))) {
            unset($this->ConsumedCount);
        } else {
            $this->ConsumedCount = $consumedCount;
        }
        return $this;
    }
    /**
     * Get DefinedCapacity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDefinedCapacity()
    {
        return isset($this->DefinedCapacity) ? $this->DefinedCapacity : null;
    }
    /**
     * Set DefinedCapacity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $definedCapacity
     * @return \patest\StructType\Ticketing_SeatingPlanRestrictionInfo
     */
    public function setDefinedCapacity($definedCapacity = null)
    {
        // validation for constraint: int
        if (!is_null($definedCapacity) && !(is_int($definedCapacity) || ctype_digit($definedCapacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($definedCapacity, true), gettype($definedCapacity)), __LINE__);
        }
        if (is_null($definedCapacity) || (is_array($definedCapacity) && empty($definedCapacity))) {
            unset($this->DefinedCapacity);
        } else {
            $this->DefinedCapacity = $definedCapacity;
        }
        return $this;
    }
    /**
     * Get EffectiveCapacity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEffectiveCapacity()
    {
        return isset($this->EffectiveCapacity) ? $this->EffectiveCapacity : null;
    }
    /**
     * Set EffectiveCapacity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $effectiveCapacity
     * @return \patest\StructType\Ticketing_SeatingPlanRestrictionInfo
     */
    public function setEffectiveCapacity($effectiveCapacity = null)
    {
        // validation for constraint: int
        if (!is_null($effectiveCapacity) && !(is_int($effectiveCapacity) || ctype_digit($effectiveCapacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($effectiveCapacity, true), gettype($effectiveCapacity)), __LINE__);
        }
        if (is_null($effectiveCapacity) || (is_array($effectiveCapacity) && empty($effectiveCapacity))) {
            unset($this->EffectiveCapacity);
        } else {
            $this->EffectiveCapacity = $effectiveCapacity;
        }
        return $this;
    }
    /**
     * Get EffectiveIsExclusive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getEffectiveIsExclusive()
    {
        return isset($this->EffectiveIsExclusive) ? $this->EffectiveIsExclusive : null;
    }
    /**
     * Set EffectiveIsExclusive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $effectiveIsExclusive
     * @return \patest\StructType\Ticketing_SeatingPlanRestrictionInfo
     */
    public function setEffectiveIsExclusive($effectiveIsExclusive = null)
    {
        // validation for constraint: boolean
        if (!is_null($effectiveIsExclusive) && !is_bool($effectiveIsExclusive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($effectiveIsExclusive, true), gettype($effectiveIsExclusive)), __LINE__);
        }
        if (is_null($effectiveIsExclusive) || (is_array($effectiveIsExclusive) && empty($effectiveIsExclusive))) {
            unset($this->EffectiveIsExclusive);
        } else {
            $this->EffectiveIsExclusive = $effectiveIsExclusive;
        }
        return $this;
    }
    /**
     * Get HallVersionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallVersionId()
    {
        return isset($this->HallVersionId) ? $this->HallVersionId : null;
    }
    /**
     * Set HallVersionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallVersionId
     * @return \patest\StructType\Ticketing_SeatingPlanRestrictionInfo
     */
    public function setHallVersionId($hallVersionId = null)
    {
        // validation for constraint: string
        if (!is_null($hallVersionId) && !is_string($hallVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallVersionId, true), gettype($hallVersionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallVersionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallVersionId, true)), __LINE__);
        }
        if (is_null($hallVersionId) || (is_array($hallVersionId) && empty($hallVersionId))) {
            unset($this->HallVersionId);
        } else {
            $this->HallVersionId = $hallVersionId;
        }
        return $this;
    }
    /**
     * Get IsAvailableToUser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAvailableToUser()
    {
        return isset($this->IsAvailableToUser) ? $this->IsAvailableToUser : null;
    }
    /**
     * Set IsAvailableToUser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAvailableToUser
     * @return \patest\StructType\Ticketing_SeatingPlanRestrictionInfo
     */
    public function setIsAvailableToUser($isAvailableToUser = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAvailableToUser) && !is_bool($isAvailableToUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAvailableToUser, true), gettype($isAvailableToUser)), __LINE__);
        }
        if (is_null($isAvailableToUser) || (is_array($isAvailableToUser) && empty($isAvailableToUser))) {
            unset($this->IsAvailableToUser);
        } else {
            $this->IsAvailableToUser = $isAvailableToUser;
        }
        return $this;
    }
    /**
     * Get IsCountWithAvailableSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsCountWithAvailableSeats()
    {
        return isset($this->IsCountWithAvailableSeats) ? $this->IsCountWithAvailableSeats : null;
    }
    /**
     * Set IsCountWithAvailableSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isCountWithAvailableSeats
     * @return \patest\StructType\Ticketing_SeatingPlanRestrictionInfo
     */
    public function setIsCountWithAvailableSeats($isCountWithAvailableSeats = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCountWithAvailableSeats) && !is_bool($isCountWithAvailableSeats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCountWithAvailableSeats, true), gettype($isCountWithAvailableSeats)), __LINE__);
        }
        if (is_null($isCountWithAvailableSeats) || (is_array($isCountWithAvailableSeats) && empty($isCountWithAvailableSeats))) {
            unset($this->IsCountWithAvailableSeats);
        } else {
            $this->IsCountWithAvailableSeats = $isCountWithAvailableSeats;
        }
        return $this;
    }
    /**
     * Get IsExclusive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsExclusive()
    {
        return isset($this->IsExclusive) ? $this->IsExclusive : null;
    }
    /**
     * Set IsExclusive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isExclusive
     * @return \patest\StructType\Ticketing_SeatingPlanRestrictionInfo
     */
    public function setIsExclusive($isExclusive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExclusive) && !is_bool($isExclusive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExclusive, true), gettype($isExclusive)), __LINE__);
        }
        if (is_null($isExclusive) || (is_array($isExclusive) && empty($isExclusive))) {
            unset($this->IsExclusive);
        } else {
            $this->IsExclusive = $isExclusive;
        }
        return $this;
    }
    /**
     * Get IsExpired value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsExpired()
    {
        return isset($this->IsExpired) ? $this->IsExpired : null;
    }
    /**
     * Set IsExpired value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isExpired
     * @return \patest\StructType\Ticketing_SeatingPlanRestrictionInfo
     */
    public function setIsExpired($isExpired = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExpired) && !is_bool($isExpired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExpired, true), gettype($isExpired)), __LINE__);
        }
        if (is_null($isExpired) || (is_array($isExpired) && empty($isExpired))) {
            unset($this->IsExpired);
        } else {
            $this->IsExpired = $isExpired;
        }
        return $this;
    }
    /**
     * Get ReservedCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getReservedCount()
    {
        return isset($this->ReservedCount) ? $this->ReservedCount : null;
    }
    /**
     * Set ReservedCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $reservedCount
     * @return \patest\StructType\Ticketing_SeatingPlanRestrictionInfo
     */
    public function setReservedCount($reservedCount = null)
    {
        // validation for constraint: int
        if (!is_null($reservedCount) && !(is_int($reservedCount) || ctype_digit($reservedCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reservedCount, true), gettype($reservedCount)), __LINE__);
        }
        if (is_null($reservedCount) || (is_array($reservedCount) && empty($reservedCount))) {
            unset($this->ReservedCount);
        } else {
            $this->ReservedCount = $reservedCount;
        }
        return $this;
    }
    /**
     * Get RestrictionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRestrictionId()
    {
        return isset($this->RestrictionId) ? $this->RestrictionId : null;
    }
    /**
     * Set RestrictionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $restrictionId
     * @return \patest\StructType\Ticketing_SeatingPlanRestrictionInfo
     */
    public function setRestrictionId($restrictionId = null)
    {
        // validation for constraint: string
        if (!is_null($restrictionId) && !is_string($restrictionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($restrictionId, true), gettype($restrictionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($restrictionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $restrictionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($restrictionId, true)), __LINE__);
        }
        if (is_null($restrictionId) || (is_array($restrictionId) && empty($restrictionId))) {
            unset($this->RestrictionId);
        } else {
            $this->RestrictionId = $restrictionId;
        }
        return $this;
    }
    /**
     * Get RestrictionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRestrictionName()
    {
        return isset($this->RestrictionName) ? $this->RestrictionName : null;
    }
    /**
     * Set RestrictionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $restrictionName
     * @return \patest\StructType\Ticketing_SeatingPlanRestrictionInfo
     */
    public function setRestrictionName($restrictionName = null)
    {
        // validation for constraint: string
        if (!is_null($restrictionName) && !is_string($restrictionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($restrictionName, true), gettype($restrictionName)), __LINE__);
        }
        if (is_null($restrictionName) || (is_array($restrictionName) && empty($restrictionName))) {
            unset($this->RestrictionName);
        } else {
            $this->RestrictionName = $restrictionName;
        }
        return $this;
    }
    /**
     * Get RestrictionType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRestrictionType()
    {
        return isset($this->RestrictionType) ? $this->RestrictionType : null;
    }
    /**
     * Set RestrictionType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\RestrictionType::valueIsValid()
     * @uses \patest\EnumType\RestrictionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $restrictionType
     * @return \patest\StructType\Ticketing_SeatingPlanRestrictionInfo
     */
    public function setRestrictionType($restrictionType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RestrictionType::valueIsValid($restrictionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RestrictionType', is_array($restrictionType) ? implode(', ', $restrictionType) : var_export($restrictionType, true), implode(', ', \patest\EnumType\RestrictionType::getValidValues())), __LINE__);
        }
        if (is_null($restrictionType) || (is_array($restrictionType) && empty($restrictionType))) {
            unset($this->RestrictionType);
        } else {
            $this->RestrictionType = $restrictionType;
        }
        return $this;
    }
    /**
     * Get SeatingPlanId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatingPlanId()
    {
        return isset($this->SeatingPlanId) ? $this->SeatingPlanId : null;
    }
    /**
     * Set SeatingPlanId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatingPlanId
     * @return \patest\StructType\Ticketing_SeatingPlanRestrictionInfo
     */
    public function setSeatingPlanId($seatingPlanId = null)
    {
        // validation for constraint: string
        if (!is_null($seatingPlanId) && !is_string($seatingPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatingPlanId, true), gettype($seatingPlanId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seatingPlanId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seatingPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seatingPlanId, true)), __LINE__);
        }
        if (is_null($seatingPlanId) || (is_array($seatingPlanId) && empty($seatingPlanId))) {
            unset($this->SeatingPlanId);
        } else {
            $this->SeatingPlanId = $seatingPlanId;
        }
        return $this;
    }
    /**
     * Get ShowId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowId()
    {
        return isset($this->ShowId) ? $this->ShowId : null;
    }
    /**
     * Set ShowId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showId
     * @return \patest\StructType\Ticketing_SeatingPlanRestrictionInfo
     */
    public function setShowId($showId = null)
    {
        // validation for constraint: string
        if (!is_null($showId) && !is_string($showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showId, true), gettype($showId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showId, true)), __LINE__);
        }
        if (is_null($showId) || (is_array($showId) && empty($showId))) {
            unset($this->ShowId);
        } else {
            $this->ShowId = $showId;
        }
        return $this;
    }
    /**
     * Get SoldCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSoldCount()
    {
        return isset($this->SoldCount) ? $this->SoldCount : null;
    }
    /**
     * Set SoldCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $soldCount
     * @return \patest\StructType\Ticketing_SeatingPlanRestrictionInfo
     */
    public function setSoldCount($soldCount = null)
    {
        // validation for constraint: int
        if (!is_null($soldCount) && !(is_int($soldCount) || ctype_digit($soldCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($soldCount, true), gettype($soldCount)), __LINE__);
        }
        if (is_null($soldCount) || (is_array($soldCount) && empty($soldCount))) {
            unset($this->SoldCount);
        } else {
            $this->SoldCount = $soldCount;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\EffectiveRestrictionStatus::valueIsValid()
     * @uses \patest\EnumType\EffectiveRestrictionStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\Ticketing_SeatingPlanRestrictionInfo
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\EffectiveRestrictionStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EffectiveRestrictionStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\EffectiveRestrictionStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TemporarilyHeldCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTemporarilyHeldCount()
    {
        return isset($this->TemporarilyHeldCount) ? $this->TemporarilyHeldCount : null;
    }
    /**
     * Set TemporarilyHeldCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $temporarilyHeldCount
     * @return \patest\StructType\Ticketing_SeatingPlanRestrictionInfo
     */
    public function setTemporarilyHeldCount($temporarilyHeldCount = null)
    {
        // validation for constraint: int
        if (!is_null($temporarilyHeldCount) && !(is_int($temporarilyHeldCount) || ctype_digit($temporarilyHeldCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($temporarilyHeldCount, true), gettype($temporarilyHeldCount)), __LINE__);
        }
        if (is_null($temporarilyHeldCount) || (is_array($temporarilyHeldCount) && empty($temporarilyHeldCount))) {
            unset($this->TemporarilyHeldCount);
        } else {
            $this->TemporarilyHeldCount = $temporarilyHeldCount;
        }
        return $this;
    }
}
