<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.SeatPropertiesDisplay StructType
 * @subpackage Structs
 */
class Ticketing_SeatPropertiesDisplay extends PersistableEntity
{
    /**
     * The ColorText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ColorText;
    /**
     * The GlobalName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $GlobalName;
    /**
     * The GraphicRepresentation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Graphics_GraphicRepresentation
     */
    public $GraphicRepresentation;
    /**
     * The LogicalName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LogicalName;
    /**
     * The MaskPercentage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaskPercentage;
    /**
     * The MaskType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MaskType;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Priority;
    /**
     * The SeatDisplayTypeEnum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatDisplayTypeEnum;
    /**
     * Constructor method for Ticketing.SeatPropertiesDisplay
     * @uses Ticketing_SeatPropertiesDisplay::setColorText()
     * @uses Ticketing_SeatPropertiesDisplay::setGlobalName()
     * @uses Ticketing_SeatPropertiesDisplay::setGraphicRepresentation()
     * @uses Ticketing_SeatPropertiesDisplay::setLogicalName()
     * @uses Ticketing_SeatPropertiesDisplay::setMaskPercentage()
     * @uses Ticketing_SeatPropertiesDisplay::setMaskType()
     * @uses Ticketing_SeatPropertiesDisplay::setOrganizationUnitId()
     * @uses Ticketing_SeatPropertiesDisplay::setPriority()
     * @uses Ticketing_SeatPropertiesDisplay::setSeatDisplayTypeEnum()
     * @param string $colorText
     * @param \patest\StructType\GlobalString $globalName
     * @param \patest\StructType\Graphics_GraphicRepresentation $graphicRepresentation
     * @param string $logicalName
     * @param int $maskPercentage
     * @param string $maskType
     * @param string $organizationUnitId
     * @param int $priority
     * @param string $seatDisplayTypeEnum
     */
    public function __construct($colorText = null, \patest\StructType\GlobalString $globalName = null, \patest\StructType\Graphics_GraphicRepresentation $graphicRepresentation = null, $logicalName = null, $maskPercentage = null, $maskType = null, $organizationUnitId = null, $priority = null, $seatDisplayTypeEnum = null)
    {
        $this
            ->setColorText($colorText)
            ->setGlobalName($globalName)
            ->setGraphicRepresentation($graphicRepresentation)
            ->setLogicalName($logicalName)
            ->setMaskPercentage($maskPercentage)
            ->setMaskType($maskType)
            ->setOrganizationUnitId($organizationUnitId)
            ->setPriority($priority)
            ->setSeatDisplayTypeEnum($seatDisplayTypeEnum);
    }
    /**
     * Get ColorText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getColorText()
    {
        return isset($this->ColorText) ? $this->ColorText : null;
    }
    /**
     * Set ColorText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $colorText
     * @return \patest\StructType\Ticketing_SeatPropertiesDisplay
     */
    public function setColorText($colorText = null)
    {
        // validation for constraint: string
        if (!is_null($colorText) && !is_string($colorText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($colorText, true), gettype($colorText)), __LINE__);
        }
        if (is_null($colorText) || (is_array($colorText) && empty($colorText))) {
            unset($this->ColorText);
        } else {
            $this->ColorText = $colorText;
        }
        return $this;
    }
    /**
     * Get GlobalName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getGlobalName()
    {
        return isset($this->GlobalName) ? $this->GlobalName : null;
    }
    /**
     * Set GlobalName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $globalName
     * @return \patest\StructType\Ticketing_SeatPropertiesDisplay
     */
    public function setGlobalName(\patest\StructType\GlobalString $globalName = null)
    {
        if (is_null($globalName) || (is_array($globalName) && empty($globalName))) {
            unset($this->GlobalName);
        } else {
            $this->GlobalName = $globalName;
        }
        return $this;
    }
    /**
     * Get GraphicRepresentation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Graphics_GraphicRepresentation|null
     */
    public function getGraphicRepresentation()
    {
        return isset($this->GraphicRepresentation) ? $this->GraphicRepresentation : null;
    }
    /**
     * Set GraphicRepresentation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Graphics_GraphicRepresentation $graphicRepresentation
     * @return \patest\StructType\Ticketing_SeatPropertiesDisplay
     */
    public function setGraphicRepresentation(\patest\StructType\Graphics_GraphicRepresentation $graphicRepresentation = null)
    {
        if (is_null($graphicRepresentation) || (is_array($graphicRepresentation) && empty($graphicRepresentation))) {
            unset($this->GraphicRepresentation);
        } else {
            $this->GraphicRepresentation = $graphicRepresentation;
        }
        return $this;
    }
    /**
     * Get LogicalName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLogicalName()
    {
        return isset($this->LogicalName) ? $this->LogicalName : null;
    }
    /**
     * Set LogicalName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $logicalName
     * @return \patest\StructType\Ticketing_SeatPropertiesDisplay
     */
    public function setLogicalName($logicalName = null)
    {
        // validation for constraint: string
        if (!is_null($logicalName) && !is_string($logicalName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logicalName, true), gettype($logicalName)), __LINE__);
        }
        if (is_null($logicalName) || (is_array($logicalName) && empty($logicalName))) {
            unset($this->LogicalName);
        } else {
            $this->LogicalName = $logicalName;
        }
        return $this;
    }
    /**
     * Get MaskPercentage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaskPercentage()
    {
        return isset($this->MaskPercentage) ? $this->MaskPercentage : null;
    }
    /**
     * Set MaskPercentage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maskPercentage
     * @return \patest\StructType\Ticketing_SeatPropertiesDisplay
     */
    public function setMaskPercentage($maskPercentage = null)
    {
        // validation for constraint: int
        if (!is_null($maskPercentage) && !(is_int($maskPercentage) || ctype_digit($maskPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maskPercentage, true), gettype($maskPercentage)), __LINE__);
        }
        if (is_null($maskPercentage) || (is_array($maskPercentage) && empty($maskPercentage))) {
            unset($this->MaskPercentage);
        } else {
            $this->MaskPercentage = $maskPercentage;
        }
        return $this;
    }
    /**
     * Get MaskType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMaskType()
    {
        return isset($this->MaskType) ? $this->MaskType : null;
    }
    /**
     * Set MaskType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\MaskTypes::valueIsValid()
     * @uses \patest\EnumType\MaskTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maskType
     * @return \patest\StructType\Ticketing_SeatPropertiesDisplay
     */
    public function setMaskType($maskType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\MaskTypes::valueIsValid($maskType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\MaskTypes', is_array($maskType) ? implode(', ', $maskType) : var_export($maskType, true), implode(', ', \patest\EnumType\MaskTypes::getValidValues())), __LINE__);
        }
        if (is_null($maskType) || (is_array($maskType) && empty($maskType))) {
            unset($this->MaskType);
        } else {
            $this->MaskType = $maskType;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Ticketing_SeatPropertiesDisplay
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get Priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPriority()
    {
        return isset($this->Priority) ? $this->Priority : null;
    }
    /**
     * Set Priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $priority
     * @return \patest\StructType\Ticketing_SeatPropertiesDisplay
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        if (is_null($priority) || (is_array($priority) && empty($priority))) {
            unset($this->Priority);
        } else {
            $this->Priority = $priority;
        }
        return $this;
    }
    /**
     * Get SeatDisplayTypeEnum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatDisplayTypeEnum()
    {
        return isset($this->SeatDisplayTypeEnum) ? $this->SeatDisplayTypeEnum : null;
    }
    /**
     * Set SeatDisplayTypeEnum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\DisplayTypes::valueIsValid()
     * @uses \patest\EnumType\DisplayTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $seatDisplayTypeEnum
     * @return \patest\StructType\Ticketing_SeatPropertiesDisplay
     */
    public function setSeatDisplayTypeEnum($seatDisplayTypeEnum = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DisplayTypes::valueIsValid($seatDisplayTypeEnum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DisplayTypes', is_array($seatDisplayTypeEnum) ? implode(', ', $seatDisplayTypeEnum) : var_export($seatDisplayTypeEnum, true), implode(', ', \patest\EnumType\DisplayTypes::getValidValues())), __LINE__);
        }
        if (is_null($seatDisplayTypeEnum) || (is_array($seatDisplayTypeEnum) && empty($seatDisplayTypeEnum))) {
            unset($this->SeatDisplayTypeEnum);
        } else {
            $this->SeatDisplayTypeEnum = $seatDisplayTypeEnum;
        }
        return $this;
    }
}
