<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.SeatInventoryLump StructType
 * @subpackage Structs
 */
class Ticketing_SeatInventoryLump extends AnyEntity
{
    /**
     * The AddedAt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AddedAt;
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The Cost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $Cost;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The FaceValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $FaceValue;
    /**
     * The FromSeatIdInAreaMap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FromSeatIdInAreaMap;
    /**
     * The InventoryNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $InventoryNumber;
    /**
     * The InventoryProviderId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InventoryProviderId;
    /**
     * The InventoryTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InventoryTypeId;
    /**
     * The InvoiceDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InvoiceDate;
    /**
     * The IsPaid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPaid;
    /**
     * The LiabilityStatusId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LiabilityStatusId;
    /**
     * The PriceLevelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceLevelId;
    /**
     * The RowName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RowName;
    /**
     * The SalesStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SalesStatus;
    /**
     * The SeatCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SeatCount;
    /**
     * The SeatRange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatRange;
    /**
     * The SeatRangeWithCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatRangeWithCount;
    /**
     * The SectorId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SectorId;
    /**
     * The Selected
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Selected;
    /**
     * The ToSeatIdInAreaMap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ToSeatIdInAreaMap;
    /**
     * Constructor method for Ticketing.SeatInventoryLump
     * @uses Ticketing_SeatInventoryLump::setAddedAt()
     * @uses Ticketing_SeatInventoryLump::setAreaId()
     * @uses Ticketing_SeatInventoryLump::setCost()
     * @uses Ticketing_SeatInventoryLump::setEventId()
     * @uses Ticketing_SeatInventoryLump::setFaceValue()
     * @uses Ticketing_SeatInventoryLump::setFromSeatIdInAreaMap()
     * @uses Ticketing_SeatInventoryLump::setInventoryNumber()
     * @uses Ticketing_SeatInventoryLump::setInventoryProviderId()
     * @uses Ticketing_SeatInventoryLump::setInventoryTypeId()
     * @uses Ticketing_SeatInventoryLump::setInvoiceDate()
     * @uses Ticketing_SeatInventoryLump::setIsPaid()
     * @uses Ticketing_SeatInventoryLump::setLiabilityStatusId()
     * @uses Ticketing_SeatInventoryLump::setPriceLevelId()
     * @uses Ticketing_SeatInventoryLump::setRowName()
     * @uses Ticketing_SeatInventoryLump::setSalesStatus()
     * @uses Ticketing_SeatInventoryLump::setSeatCount()
     * @uses Ticketing_SeatInventoryLump::setSeatRange()
     * @uses Ticketing_SeatInventoryLump::setSeatRangeWithCount()
     * @uses Ticketing_SeatInventoryLump::setSectorId()
     * @uses Ticketing_SeatInventoryLump::setSelected()
     * @uses Ticketing_SeatInventoryLump::setToSeatIdInAreaMap()
     * @param string $addedAt
     * @param string $areaId
     * @param \patest\StructType\Money $cost
     * @param string $eventId
     * @param \patest\StructType\Money $faceValue
     * @param int $fromSeatIdInAreaMap
     * @param int $inventoryNumber
     * @param string $inventoryProviderId
     * @param string $inventoryTypeId
     * @param string $invoiceDate
     * @param bool $isPaid
     * @param string $liabilityStatusId
     * @param string $priceLevelId
     * @param string $rowName
     * @param string $salesStatus
     * @param int $seatCount
     * @param string $seatRange
     * @param string $seatRangeWithCount
     * @param string $sectorId
     * @param bool $selected
     * @param int $toSeatIdInAreaMap
     */
    public function __construct($addedAt = null, $areaId = null, \patest\StructType\Money $cost = null, $eventId = null, \patest\StructType\Money $faceValue = null, $fromSeatIdInAreaMap = null, $inventoryNumber = null, $inventoryProviderId = null, $inventoryTypeId = null, $invoiceDate = null, $isPaid = null, $liabilityStatusId = null, $priceLevelId = null, $rowName = null, $salesStatus = null, $seatCount = null, $seatRange = null, $seatRangeWithCount = null, $sectorId = null, $selected = null, $toSeatIdInAreaMap = null)
    {
        $this
            ->setAddedAt($addedAt)
            ->setAreaId($areaId)
            ->setCost($cost)
            ->setEventId($eventId)
            ->setFaceValue($faceValue)
            ->setFromSeatIdInAreaMap($fromSeatIdInAreaMap)
            ->setInventoryNumber($inventoryNumber)
            ->setInventoryProviderId($inventoryProviderId)
            ->setInventoryTypeId($inventoryTypeId)
            ->setInvoiceDate($invoiceDate)
            ->setIsPaid($isPaid)
            ->setLiabilityStatusId($liabilityStatusId)
            ->setPriceLevelId($priceLevelId)
            ->setRowName($rowName)
            ->setSalesStatus($salesStatus)
            ->setSeatCount($seatCount)
            ->setSeatRange($seatRange)
            ->setSeatRangeWithCount($seatRangeWithCount)
            ->setSectorId($sectorId)
            ->setSelected($selected)
            ->setToSeatIdInAreaMap($toSeatIdInAreaMap);
    }
    /**
     * Get AddedAt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddedAt()
    {
        return isset($this->AddedAt) ? $this->AddedAt : null;
    }
    /**
     * Set AddedAt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $addedAt
     * @return \patest\StructType\Ticketing_SeatInventoryLump
     */
    public function setAddedAt($addedAt = null)
    {
        // validation for constraint: string
        if (!is_null($addedAt) && !is_string($addedAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addedAt, true), gettype($addedAt)), __LINE__);
        }
        if (is_null($addedAt) || (is_array($addedAt) && empty($addedAt))) {
            unset($this->AddedAt);
        } else {
            $this->AddedAt = $addedAt;
        }
        return $this;
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\Ticketing_SeatInventoryLump
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get Cost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCost()
    {
        return isset($this->Cost) ? $this->Cost : null;
    }
    /**
     * Set Cost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $cost
     * @return \patest\StructType\Ticketing_SeatInventoryLump
     */
    public function setCost(\patest\StructType\Money $cost = null)
    {
        if (is_null($cost) || (is_array($cost) && empty($cost))) {
            unset($this->Cost);
        } else {
            $this->Cost = $cost;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\Ticketing_SeatInventoryLump
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get FaceValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getFaceValue()
    {
        return isset($this->FaceValue) ? $this->FaceValue : null;
    }
    /**
     * Set FaceValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $faceValue
     * @return \patest\StructType\Ticketing_SeatInventoryLump
     */
    public function setFaceValue(\patest\StructType\Money $faceValue = null)
    {
        if (is_null($faceValue) || (is_array($faceValue) && empty($faceValue))) {
            unset($this->FaceValue);
        } else {
            $this->FaceValue = $faceValue;
        }
        return $this;
    }
    /**
     * Get FromSeatIdInAreaMap value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFromSeatIdInAreaMap()
    {
        return isset($this->FromSeatIdInAreaMap) ? $this->FromSeatIdInAreaMap : null;
    }
    /**
     * Set FromSeatIdInAreaMap value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $fromSeatIdInAreaMap
     * @return \patest\StructType\Ticketing_SeatInventoryLump
     */
    public function setFromSeatIdInAreaMap($fromSeatIdInAreaMap = null)
    {
        // validation for constraint: int
        if (!is_null($fromSeatIdInAreaMap) && !(is_int($fromSeatIdInAreaMap) || ctype_digit($fromSeatIdInAreaMap))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fromSeatIdInAreaMap, true), gettype($fromSeatIdInAreaMap)), __LINE__);
        }
        if (is_null($fromSeatIdInAreaMap) || (is_array($fromSeatIdInAreaMap) && empty($fromSeatIdInAreaMap))) {
            unset($this->FromSeatIdInAreaMap);
        } else {
            $this->FromSeatIdInAreaMap = $fromSeatIdInAreaMap;
        }
        return $this;
    }
    /**
     * Get InventoryNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInventoryNumber()
    {
        return isset($this->InventoryNumber) ? $this->InventoryNumber : null;
    }
    /**
     * Set InventoryNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $inventoryNumber
     * @return \patest\StructType\Ticketing_SeatInventoryLump
     */
    public function setInventoryNumber($inventoryNumber = null)
    {
        // validation for constraint: int
        if (!is_null($inventoryNumber) && !(is_int($inventoryNumber) || ctype_digit($inventoryNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($inventoryNumber, true), gettype($inventoryNumber)), __LINE__);
        }
        if (is_null($inventoryNumber) || (is_array($inventoryNumber) && empty($inventoryNumber))) {
            unset($this->InventoryNumber);
        } else {
            $this->InventoryNumber = $inventoryNumber;
        }
        return $this;
    }
    /**
     * Get InventoryProviderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInventoryProviderId()
    {
        return isset($this->InventoryProviderId) ? $this->InventoryProviderId : null;
    }
    /**
     * Set InventoryProviderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inventoryProviderId
     * @return \patest\StructType\Ticketing_SeatInventoryLump
     */
    public function setInventoryProviderId($inventoryProviderId = null)
    {
        // validation for constraint: string
        if (!is_null($inventoryProviderId) && !is_string($inventoryProviderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inventoryProviderId, true), gettype($inventoryProviderId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($inventoryProviderId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $inventoryProviderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($inventoryProviderId, true)), __LINE__);
        }
        if (is_null($inventoryProviderId) || (is_array($inventoryProviderId) && empty($inventoryProviderId))) {
            unset($this->InventoryProviderId);
        } else {
            $this->InventoryProviderId = $inventoryProviderId;
        }
        return $this;
    }
    /**
     * Get InventoryTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInventoryTypeId()
    {
        return isset($this->InventoryTypeId) ? $this->InventoryTypeId : null;
    }
    /**
     * Set InventoryTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inventoryTypeId
     * @return \patest\StructType\Ticketing_SeatInventoryLump
     */
    public function setInventoryTypeId($inventoryTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($inventoryTypeId) && !is_string($inventoryTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inventoryTypeId, true), gettype($inventoryTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($inventoryTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $inventoryTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($inventoryTypeId, true)), __LINE__);
        }
        if (is_null($inventoryTypeId) || (is_array($inventoryTypeId) && empty($inventoryTypeId))) {
            unset($this->InventoryTypeId);
        } else {
            $this->InventoryTypeId = $inventoryTypeId;
        }
        return $this;
    }
    /**
     * Get InvoiceDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInvoiceDate()
    {
        return isset($this->InvoiceDate) ? $this->InvoiceDate : null;
    }
    /**
     * Set InvoiceDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $invoiceDate
     * @return \patest\StructType\Ticketing_SeatInventoryLump
     */
    public function setInvoiceDate($invoiceDate = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceDate) && !is_string($invoiceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceDate, true), gettype($invoiceDate)), __LINE__);
        }
        if (is_null($invoiceDate) || (is_array($invoiceDate) && empty($invoiceDate))) {
            unset($this->InvoiceDate);
        } else {
            $this->InvoiceDate = $invoiceDate;
        }
        return $this;
    }
    /**
     * Get IsPaid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPaid()
    {
        return isset($this->IsPaid) ? $this->IsPaid : null;
    }
    /**
     * Set IsPaid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPaid
     * @return \patest\StructType\Ticketing_SeatInventoryLump
     */
    public function setIsPaid($isPaid = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPaid) && !is_bool($isPaid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPaid, true), gettype($isPaid)), __LINE__);
        }
        if (is_null($isPaid) || (is_array($isPaid) && empty($isPaid))) {
            unset($this->IsPaid);
        } else {
            $this->IsPaid = $isPaid;
        }
        return $this;
    }
    /**
     * Get LiabilityStatusId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLiabilityStatusId()
    {
        return isset($this->LiabilityStatusId) ? $this->LiabilityStatusId : null;
    }
    /**
     * Set LiabilityStatusId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $liabilityStatusId
     * @return \patest\StructType\Ticketing_SeatInventoryLump
     */
    public function setLiabilityStatusId($liabilityStatusId = null)
    {
        // validation for constraint: string
        if (!is_null($liabilityStatusId) && !is_string($liabilityStatusId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($liabilityStatusId, true), gettype($liabilityStatusId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($liabilityStatusId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $liabilityStatusId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($liabilityStatusId, true)), __LINE__);
        }
        if (is_null($liabilityStatusId) || (is_array($liabilityStatusId) && empty($liabilityStatusId))) {
            unset($this->LiabilityStatusId);
        } else {
            $this->LiabilityStatusId = $liabilityStatusId;
        }
        return $this;
    }
    /**
     * Get PriceLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelId()
    {
        return isset($this->PriceLevelId) ? $this->PriceLevelId : null;
    }
    /**
     * Set PriceLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelId
     * @return \patest\StructType\Ticketing_SeatInventoryLump
     */
    public function setPriceLevelId($priceLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelId) && !is_string($priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelId, true), gettype($priceLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceLevelId, true)), __LINE__);
        }
        if (is_null($priceLevelId) || (is_array($priceLevelId) && empty($priceLevelId))) {
            unset($this->PriceLevelId);
        } else {
            $this->PriceLevelId = $priceLevelId;
        }
        return $this;
    }
    /**
     * Get RowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRowName()
    {
        return isset($this->RowName) ? $this->RowName : null;
    }
    /**
     * Set RowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rowName
     * @return \patest\StructType\Ticketing_SeatInventoryLump
     */
    public function setRowName($rowName = null)
    {
        // validation for constraint: string
        if (!is_null($rowName) && !is_string($rowName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rowName, true), gettype($rowName)), __LINE__);
        }
        if (is_null($rowName) || (is_array($rowName) && empty($rowName))) {
            unset($this->RowName);
        } else {
            $this->RowName = $rowName;
        }
        return $this;
    }
    /**
     * Get SalesStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesStatus()
    {
        return isset($this->SalesStatus) ? $this->SalesStatus : null;
    }
    /**
     * Set SalesStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SeatSalesStatus::valueIsValid()
     * @uses \patest\EnumType\SeatSalesStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $salesStatus
     * @return \patest\StructType\Ticketing_SeatInventoryLump
     */
    public function setSalesStatus($salesStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SeatSalesStatus::valueIsValid($salesStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SeatSalesStatus', is_array($salesStatus) ? implode(', ', $salesStatus) : var_export($salesStatus, true), implode(', ', \patest\EnumType\SeatSalesStatus::getValidValues())), __LINE__);
        }
        if (is_null($salesStatus) || (is_array($salesStatus) && empty($salesStatus))) {
            unset($this->SalesStatus);
        } else {
            $this->SalesStatus = $salesStatus;
        }
        return $this;
    }
    /**
     * Get SeatCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSeatCount()
    {
        return isset($this->SeatCount) ? $this->SeatCount : null;
    }
    /**
     * Set SeatCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $seatCount
     * @return \patest\StructType\Ticketing_SeatInventoryLump
     */
    public function setSeatCount($seatCount = null)
    {
        // validation for constraint: int
        if (!is_null($seatCount) && !(is_int($seatCount) || ctype_digit($seatCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatCount, true), gettype($seatCount)), __LINE__);
        }
        if (is_null($seatCount) || (is_array($seatCount) && empty($seatCount))) {
            unset($this->SeatCount);
        } else {
            $this->SeatCount = $seatCount;
        }
        return $this;
    }
    /**
     * Get SeatRange value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatRange()
    {
        return isset($this->SeatRange) ? $this->SeatRange : null;
    }
    /**
     * Set SeatRange value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatRange
     * @return \patest\StructType\Ticketing_SeatInventoryLump
     */
    public function setSeatRange($seatRange = null)
    {
        // validation for constraint: string
        if (!is_null($seatRange) && !is_string($seatRange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatRange, true), gettype($seatRange)), __LINE__);
        }
        if (is_null($seatRange) || (is_array($seatRange) && empty($seatRange))) {
            unset($this->SeatRange);
        } else {
            $this->SeatRange = $seatRange;
        }
        return $this;
    }
    /**
     * Get SeatRangeWithCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatRangeWithCount()
    {
        return isset($this->SeatRangeWithCount) ? $this->SeatRangeWithCount : null;
    }
    /**
     * Set SeatRangeWithCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatRangeWithCount
     * @return \patest\StructType\Ticketing_SeatInventoryLump
     */
    public function setSeatRangeWithCount($seatRangeWithCount = null)
    {
        // validation for constraint: string
        if (!is_null($seatRangeWithCount) && !is_string($seatRangeWithCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatRangeWithCount, true), gettype($seatRangeWithCount)), __LINE__);
        }
        if (is_null($seatRangeWithCount) || (is_array($seatRangeWithCount) && empty($seatRangeWithCount))) {
            unset($this->SeatRangeWithCount);
        } else {
            $this->SeatRangeWithCount = $seatRangeWithCount;
        }
        return $this;
    }
    /**
     * Get SectorId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSectorId()
    {
        return isset($this->SectorId) ? $this->SectorId : null;
    }
    /**
     * Set SectorId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sectorId
     * @return \patest\StructType\Ticketing_SeatInventoryLump
     */
    public function setSectorId($sectorId = null)
    {
        // validation for constraint: string
        if (!is_null($sectorId) && !is_string($sectorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectorId, true), gettype($sectorId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sectorId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sectorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sectorId, true)), __LINE__);
        }
        if (is_null($sectorId) || (is_array($sectorId) && empty($sectorId))) {
            unset($this->SectorId);
        } else {
            $this->SectorId = $sectorId;
        }
        return $this;
    }
    /**
     * Get Selected value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSelected()
    {
        return isset($this->Selected) ? $this->Selected : null;
    }
    /**
     * Set Selected value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $selected
     * @return \patest\StructType\Ticketing_SeatInventoryLump
     */
    public function setSelected($selected = null)
    {
        // validation for constraint: boolean
        if (!is_null($selected) && !is_bool($selected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($selected, true), gettype($selected)), __LINE__);
        }
        if (is_null($selected) || (is_array($selected) && empty($selected))) {
            unset($this->Selected);
        } else {
            $this->Selected = $selected;
        }
        return $this;
    }
    /**
     * Get ToSeatIdInAreaMap value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getToSeatIdInAreaMap()
    {
        return isset($this->ToSeatIdInAreaMap) ? $this->ToSeatIdInAreaMap : null;
    }
    /**
     * Set ToSeatIdInAreaMap value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $toSeatIdInAreaMap
     * @return \patest\StructType\Ticketing_SeatInventoryLump
     */
    public function setToSeatIdInAreaMap($toSeatIdInAreaMap = null)
    {
        // validation for constraint: int
        if (!is_null($toSeatIdInAreaMap) && !(is_int($toSeatIdInAreaMap) || ctype_digit($toSeatIdInAreaMap))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($toSeatIdInAreaMap, true), gettype($toSeatIdInAreaMap)), __LINE__);
        }
        if (is_null($toSeatIdInAreaMap) || (is_array($toSeatIdInAreaMap) && empty($toSeatIdInAreaMap))) {
            unset($this->ToSeatIdInAreaMap);
        } else {
            $this->ToSeatIdInAreaMap = $toSeatIdInAreaMap;
        }
        return $this;
    }
}
