<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.SeatHistoryForAllocationAudit StructType
 * @subpackage Structs
 */
class Ticketing_SeatHistoryForAllocationAudit extends Ticketing_SeatHistory
{
    /**
     * The AllocationTypeId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AllocationTypeId;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The SeatIdsInAreaMap
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatIdsInAreaMap;
    /**
     * The ShowId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowId;
    /**
     * Constructor method for Ticketing.SeatHistoryForAllocationAudit
     * @uses Ticketing_SeatHistoryForAllocationAudit::setAllocationTypeId()
     * @uses Ticketing_SeatHistoryForAllocationAudit::setEventId()
     * @uses Ticketing_SeatHistoryForAllocationAudit::setSeatIdsInAreaMap()
     * @uses Ticketing_SeatHistoryForAllocationAudit::setShowId()
     * @param string $allocationTypeId
     * @param string $eventId
     * @param string $seatIdsInAreaMap
     * @param string $showId
     */
    public function __construct($allocationTypeId = null, $eventId = null, $seatIdsInAreaMap = null, $showId = null)
    {
        $this
            ->setAllocationTypeId($allocationTypeId)
            ->setEventId($eventId)
            ->setSeatIdsInAreaMap($seatIdsInAreaMap)
            ->setShowId($showId);
    }
    /**
     * Get AllocationTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAllocationTypeId()
    {
        return isset($this->AllocationTypeId) ? $this->AllocationTypeId : null;
    }
    /**
     * Set AllocationTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $allocationTypeId
     * @return \patest\StructType\Ticketing_SeatHistoryForAllocationAudit
     */
    public function setAllocationTypeId($allocationTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($allocationTypeId) && !is_string($allocationTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allocationTypeId, true), gettype($allocationTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($allocationTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $allocationTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($allocationTypeId, true)), __LINE__);
        }
        if (is_null($allocationTypeId) || (is_array($allocationTypeId) && empty($allocationTypeId))) {
            unset($this->AllocationTypeId);
        } else {
            $this->AllocationTypeId = $allocationTypeId;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\Ticketing_SeatHistoryForAllocationAudit
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get SeatIdsInAreaMap value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatIdsInAreaMap()
    {
        return isset($this->SeatIdsInAreaMap) ? $this->SeatIdsInAreaMap : null;
    }
    /**
     * Set SeatIdsInAreaMap value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatIdsInAreaMap
     * @return \patest\StructType\Ticketing_SeatHistoryForAllocationAudit
     */
    public function setSeatIdsInAreaMap($seatIdsInAreaMap = null)
    {
        // validation for constraint: string
        if (!is_null($seatIdsInAreaMap) && !is_string($seatIdsInAreaMap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatIdsInAreaMap, true), gettype($seatIdsInAreaMap)), __LINE__);
        }
        if (is_null($seatIdsInAreaMap) || (is_array($seatIdsInAreaMap) && empty($seatIdsInAreaMap))) {
            unset($this->SeatIdsInAreaMap);
        } else {
            $this->SeatIdsInAreaMap = $seatIdsInAreaMap;
        }
        return $this;
    }
    /**
     * Get ShowId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowId()
    {
        return isset($this->ShowId) ? $this->ShowId : null;
    }
    /**
     * Set ShowId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showId
     * @return \patest\StructType\Ticketing_SeatHistoryForAllocationAudit
     */
    public function setShowId($showId = null)
    {
        // validation for constraint: string
        if (!is_null($showId) && !is_string($showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showId, true), gettype($showId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showId, true)), __LINE__);
        }
        if (is_null($showId) || (is_array($showId) && empty($showId))) {
            unset($this->ShowId);
        } else {
            $this->ShowId = $showId;
        }
        return $this;
    }
}
