<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.SalesSeriesFilter StructType
 * @subpackage Structs
 */
class Ticketing_SalesSeriesFilter extends FilterEntity
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The HallId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallId;
    /**
     * The HospitalityFilterType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HospitalityFilterType;
    /**
     * The MasterSeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MasterSeriesId;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The QuantityOfEvents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $QuantityOfEvents;
    /**
     * The RelatedSeriesOrGroupId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelatedSeriesOrGroupId;
    /**
     * The SeasonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeasonId;
    /**
     * Constructor method for Ticketing.SalesSeriesFilter
     * @uses Ticketing_SalesSeriesFilter::setDescription()
     * @uses Ticketing_SalesSeriesFilter::setHallId()
     * @uses Ticketing_SalesSeriesFilter::setHospitalityFilterType()
     * @uses Ticketing_SalesSeriesFilter::setMasterSeriesId()
     * @uses Ticketing_SalesSeriesFilter::setName()
     * @uses Ticketing_SalesSeriesFilter::setQuantityOfEvents()
     * @uses Ticketing_SalesSeriesFilter::setRelatedSeriesOrGroupId()
     * @uses Ticketing_SalesSeriesFilter::setSeasonId()
     * @param string $description
     * @param string $hallId
     * @param string $hospitalityFilterType
     * @param string $masterSeriesId
     * @param string $name
     * @param int $quantityOfEvents
     * @param string $relatedSeriesOrGroupId
     * @param string $seasonId
     */
    public function __construct($description = null, $hallId = null, $hospitalityFilterType = null, $masterSeriesId = null, $name = null, $quantityOfEvents = null, $relatedSeriesOrGroupId = null, $seasonId = null)
    {
        $this
            ->setDescription($description)
            ->setHallId($hallId)
            ->setHospitalityFilterType($hospitalityFilterType)
            ->setMasterSeriesId($masterSeriesId)
            ->setName($name)
            ->setQuantityOfEvents($quantityOfEvents)
            ->setRelatedSeriesOrGroupId($relatedSeriesOrGroupId)
            ->setSeasonId($seasonId);
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \patest\StructType\Ticketing_SalesSeriesFilter
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get HallId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallId()
    {
        return isset($this->HallId) ? $this->HallId : null;
    }
    /**
     * Set HallId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallId
     * @return \patest\StructType\Ticketing_SalesSeriesFilter
     */
    public function setHallId($hallId = null)
    {
        // validation for constraint: string
        if (!is_null($hallId) && !is_string($hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallId, true), gettype($hallId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallId, true)), __LINE__);
        }
        if (is_null($hallId) || (is_array($hallId) && empty($hallId))) {
            unset($this->HallId);
        } else {
            $this->HallId = $hallId;
        }
        return $this;
    }
    /**
     * Get HospitalityFilterType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHospitalityFilterType()
    {
        return isset($this->HospitalityFilterType) ? $this->HospitalityFilterType : null;
    }
    /**
     * Set HospitalityFilterType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\HospitalityFilterType::valueIsValid()
     * @uses \patest\EnumType\HospitalityFilterType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hospitalityFilterType
     * @return \patest\StructType\Ticketing_SalesSeriesFilter
     */
    public function setHospitalityFilterType($hospitalityFilterType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\HospitalityFilterType::valueIsValid($hospitalityFilterType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\HospitalityFilterType', is_array($hospitalityFilterType) ? implode(', ', $hospitalityFilterType) : var_export($hospitalityFilterType, true), implode(', ', \patest\EnumType\HospitalityFilterType::getValidValues())), __LINE__);
        }
        if (is_null($hospitalityFilterType) || (is_array($hospitalityFilterType) && empty($hospitalityFilterType))) {
            unset($this->HospitalityFilterType);
        } else {
            $this->HospitalityFilterType = $hospitalityFilterType;
        }
        return $this;
    }
    /**
     * Get MasterSeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMasterSeriesId()
    {
        return isset($this->MasterSeriesId) ? $this->MasterSeriesId : null;
    }
    /**
     * Set MasterSeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $masterSeriesId
     * @return \patest\StructType\Ticketing_SalesSeriesFilter
     */
    public function setMasterSeriesId($masterSeriesId = null)
    {
        // validation for constraint: string
        if (!is_null($masterSeriesId) && !is_string($masterSeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterSeriesId, true), gettype($masterSeriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($masterSeriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $masterSeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($masterSeriesId, true)), __LINE__);
        }
        if (is_null($masterSeriesId) || (is_array($masterSeriesId) && empty($masterSeriesId))) {
            unset($this->MasterSeriesId);
        } else {
            $this->MasterSeriesId = $masterSeriesId;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\Ticketing_SalesSeriesFilter
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get QuantityOfEvents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQuantityOfEvents()
    {
        return isset($this->QuantityOfEvents) ? $this->QuantityOfEvents : null;
    }
    /**
     * Set QuantityOfEvents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $quantityOfEvents
     * @return \patest\StructType\Ticketing_SalesSeriesFilter
     */
    public function setQuantityOfEvents($quantityOfEvents = null)
    {
        // validation for constraint: int
        if (!is_null($quantityOfEvents) && !(is_int($quantityOfEvents) || ctype_digit($quantityOfEvents))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantityOfEvents, true), gettype($quantityOfEvents)), __LINE__);
        }
        if (is_null($quantityOfEvents) || (is_array($quantityOfEvents) && empty($quantityOfEvents))) {
            unset($this->QuantityOfEvents);
        } else {
            $this->QuantityOfEvents = $quantityOfEvents;
        }
        return $this;
    }
    /**
     * Get RelatedSeriesOrGroupId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedSeriesOrGroupId()
    {
        return isset($this->RelatedSeriesOrGroupId) ? $this->RelatedSeriesOrGroupId : null;
    }
    /**
     * Set RelatedSeriesOrGroupId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedSeriesOrGroupId
     * @return \patest\StructType\Ticketing_SalesSeriesFilter
     */
    public function setRelatedSeriesOrGroupId($relatedSeriesOrGroupId = null)
    {
        // validation for constraint: string
        if (!is_null($relatedSeriesOrGroupId) && !is_string($relatedSeriesOrGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedSeriesOrGroupId, true), gettype($relatedSeriesOrGroupId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relatedSeriesOrGroupId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relatedSeriesOrGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relatedSeriesOrGroupId, true)), __LINE__);
        }
        if (is_null($relatedSeriesOrGroupId) || (is_array($relatedSeriesOrGroupId) && empty($relatedSeriesOrGroupId))) {
            unset($this->RelatedSeriesOrGroupId);
        } else {
            $this->RelatedSeriesOrGroupId = $relatedSeriesOrGroupId;
        }
        return $this;
    }
    /**
     * Get SeasonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeasonId()
    {
        return isset($this->SeasonId) ? $this->SeasonId : null;
    }
    /**
     * Set SeasonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seasonId
     * @return \patest\StructType\Ticketing_SalesSeriesFilter
     */
    public function setSeasonId($seasonId = null)
    {
        // validation for constraint: string
        if (!is_null($seasonId) && !is_string($seasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seasonId, true), gettype($seasonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seasonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seasonId, true)), __LINE__);
        }
        if (is_null($seasonId) || (is_array($seasonId) && empty($seasonId))) {
            unset($this->SeasonId);
        } else {
            $this->SeasonId = $seasonId;
        }
        return $this;
    }
}
