<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.SalesEventFilter StructType
 * @subpackage Structs
 */
class Ticketing_SalesEventFilter extends Ticketing_EventFilter
{
    /**
     * The AssociatedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AssociatedDate;
    /**
     * The EventTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventTypeId;
    /**
     * The ExtendedData1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData1;
    /**
     * The ExtendedData10
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData10;
    /**
     * The ExtendedData11
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData11;
    /**
     * The ExtendedData12
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData12;
    /**
     * The ExtendedData13
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData13;
    /**
     * The ExtendedData14
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData14;
    /**
     * The ExtendedData2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData2;
    /**
     * The ExtendedData3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData3;
    /**
     * The ExtendedData4
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData4;
    /**
     * The ExtendedData5
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData5;
    /**
     * The ExtendedData6
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData6;
    /**
     * The ExtendedData7
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData7;
    /**
     * The ExtendedData8
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData8;
    /**
     * The ExtendedData9
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData9;
    /**
     * The GuidanceLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GuidanceLevel;
    /**
     * The GuidanceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GuidanceTypeId;
    /**
     * The HospitalityFilterType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HospitalityFilterType;
    /**
     * The SkillIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SkillIds;
    /**
     * The WithAvailableGuides
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $WithAvailableGuides;
    /**
     * Constructor method for Ticketing.SalesEventFilter
     * @uses Ticketing_SalesEventFilter::setAssociatedDate()
     * @uses Ticketing_SalesEventFilter::setEventTypeId()
     * @uses Ticketing_SalesEventFilter::setExtendedData1()
     * @uses Ticketing_SalesEventFilter::setExtendedData10()
     * @uses Ticketing_SalesEventFilter::setExtendedData11()
     * @uses Ticketing_SalesEventFilter::setExtendedData12()
     * @uses Ticketing_SalesEventFilter::setExtendedData13()
     * @uses Ticketing_SalesEventFilter::setExtendedData14()
     * @uses Ticketing_SalesEventFilter::setExtendedData2()
     * @uses Ticketing_SalesEventFilter::setExtendedData3()
     * @uses Ticketing_SalesEventFilter::setExtendedData4()
     * @uses Ticketing_SalesEventFilter::setExtendedData5()
     * @uses Ticketing_SalesEventFilter::setExtendedData6()
     * @uses Ticketing_SalesEventFilter::setExtendedData7()
     * @uses Ticketing_SalesEventFilter::setExtendedData8()
     * @uses Ticketing_SalesEventFilter::setExtendedData9()
     * @uses Ticketing_SalesEventFilter::setGuidanceLevel()
     * @uses Ticketing_SalesEventFilter::setGuidanceTypeId()
     * @uses Ticketing_SalesEventFilter::setHospitalityFilterType()
     * @uses Ticketing_SalesEventFilter::setSkillIds()
     * @uses Ticketing_SalesEventFilter::setWithAvailableGuides()
     * @param string $associatedDate
     * @param string $eventTypeId
     * @param string $extendedData1
     * @param string $extendedData10
     * @param string $extendedData11
     * @param string $extendedData12
     * @param string $extendedData13
     * @param string $extendedData14
     * @param string $extendedData2
     * @param string $extendedData3
     * @param string $extendedData4
     * @param string $extendedData5
     * @param string $extendedData6
     * @param string $extendedData7
     * @param string $extendedData8
     * @param string $extendedData9
     * @param string $guidanceLevel
     * @param string $guidanceTypeId
     * @param string $hospitalityFilterType
     * @param string $skillIds
     * @param bool $withAvailableGuides
     */
    public function __construct($associatedDate = null, $eventTypeId = null, $extendedData1 = null, $extendedData10 = null, $extendedData11 = null, $extendedData12 = null, $extendedData13 = null, $extendedData14 = null, $extendedData2 = null, $extendedData3 = null, $extendedData4 = null, $extendedData5 = null, $extendedData6 = null, $extendedData7 = null, $extendedData8 = null, $extendedData9 = null, $guidanceLevel = null, $guidanceTypeId = null, $hospitalityFilterType = null, $skillIds = null, $withAvailableGuides = null)
    {
        $this
            ->setAssociatedDate($associatedDate)
            ->setEventTypeId($eventTypeId)
            ->setExtendedData1($extendedData1)
            ->setExtendedData10($extendedData10)
            ->setExtendedData11($extendedData11)
            ->setExtendedData12($extendedData12)
            ->setExtendedData13($extendedData13)
            ->setExtendedData14($extendedData14)
            ->setExtendedData2($extendedData2)
            ->setExtendedData3($extendedData3)
            ->setExtendedData4($extendedData4)
            ->setExtendedData5($extendedData5)
            ->setExtendedData6($extendedData6)
            ->setExtendedData7($extendedData7)
            ->setExtendedData8($extendedData8)
            ->setExtendedData9($extendedData9)
            ->setGuidanceLevel($guidanceLevel)
            ->setGuidanceTypeId($guidanceTypeId)
            ->setHospitalityFilterType($hospitalityFilterType)
            ->setSkillIds($skillIds)
            ->setWithAvailableGuides($withAvailableGuides);
    }
    /**
     * Get AssociatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssociatedDate()
    {
        return isset($this->AssociatedDate) ? $this->AssociatedDate : null;
    }
    /**
     * Set AssociatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $associatedDate
     * @return \patest\StructType\Ticketing_SalesEventFilter
     */
    public function setAssociatedDate($associatedDate = null)
    {
        // validation for constraint: string
        if (!is_null($associatedDate) && !is_string($associatedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($associatedDate, true), gettype($associatedDate)), __LINE__);
        }
        if (is_null($associatedDate) || (is_array($associatedDate) && empty($associatedDate))) {
            unset($this->AssociatedDate);
        } else {
            $this->AssociatedDate = $associatedDate;
        }
        return $this;
    }
    /**
     * Get EventTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventTypeId()
    {
        return isset($this->EventTypeId) ? $this->EventTypeId : null;
    }
    /**
     * Set EventTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventTypeId
     * @return \patest\StructType\Ticketing_SalesEventFilter
     */
    public function setEventTypeId($eventTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($eventTypeId) && !is_string($eventTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventTypeId, true), gettype($eventTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventTypeId, true)), __LINE__);
        }
        if (is_null($eventTypeId) || (is_array($eventTypeId) && empty($eventTypeId))) {
            unset($this->EventTypeId);
        } else {
            $this->EventTypeId = $eventTypeId;
        }
        return $this;
    }
    /**
     * Get ExtendedData1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData1()
    {
        return isset($this->ExtendedData1) ? $this->ExtendedData1 : null;
    }
    /**
     * Set ExtendedData1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData1
     * @return \patest\StructType\Ticketing_SalesEventFilter
     */
    public function setExtendedData1($extendedData1 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData1) && !is_string($extendedData1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData1, true), gettype($extendedData1)), __LINE__);
        }
        if (is_null($extendedData1) || (is_array($extendedData1) && empty($extendedData1))) {
            unset($this->ExtendedData1);
        } else {
            $this->ExtendedData1 = $extendedData1;
        }
        return $this;
    }
    /**
     * Get ExtendedData10 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData10()
    {
        return isset($this->ExtendedData10) ? $this->ExtendedData10 : null;
    }
    /**
     * Set ExtendedData10 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData10
     * @return \patest\StructType\Ticketing_SalesEventFilter
     */
    public function setExtendedData10($extendedData10 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData10) && !is_string($extendedData10)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData10, true), gettype($extendedData10)), __LINE__);
        }
        if (is_null($extendedData10) || (is_array($extendedData10) && empty($extendedData10))) {
            unset($this->ExtendedData10);
        } else {
            $this->ExtendedData10 = $extendedData10;
        }
        return $this;
    }
    /**
     * Get ExtendedData11 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData11()
    {
        return isset($this->ExtendedData11) ? $this->ExtendedData11 : null;
    }
    /**
     * Set ExtendedData11 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData11
     * @return \patest\StructType\Ticketing_SalesEventFilter
     */
    public function setExtendedData11($extendedData11 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData11) && !is_string($extendedData11)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData11, true), gettype($extendedData11)), __LINE__);
        }
        if (is_null($extendedData11) || (is_array($extendedData11) && empty($extendedData11))) {
            unset($this->ExtendedData11);
        } else {
            $this->ExtendedData11 = $extendedData11;
        }
        return $this;
    }
    /**
     * Get ExtendedData12 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData12()
    {
        return isset($this->ExtendedData12) ? $this->ExtendedData12 : null;
    }
    /**
     * Set ExtendedData12 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData12
     * @return \patest\StructType\Ticketing_SalesEventFilter
     */
    public function setExtendedData12($extendedData12 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData12) && !is_string($extendedData12)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData12, true), gettype($extendedData12)), __LINE__);
        }
        if (is_null($extendedData12) || (is_array($extendedData12) && empty($extendedData12))) {
            unset($this->ExtendedData12);
        } else {
            $this->ExtendedData12 = $extendedData12;
        }
        return $this;
    }
    /**
     * Get ExtendedData13 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData13()
    {
        return isset($this->ExtendedData13) ? $this->ExtendedData13 : null;
    }
    /**
     * Set ExtendedData13 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData13
     * @return \patest\StructType\Ticketing_SalesEventFilter
     */
    public function setExtendedData13($extendedData13 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData13) && !is_string($extendedData13)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData13, true), gettype($extendedData13)), __LINE__);
        }
        if (is_null($extendedData13) || (is_array($extendedData13) && empty($extendedData13))) {
            unset($this->ExtendedData13);
        } else {
            $this->ExtendedData13 = $extendedData13;
        }
        return $this;
    }
    /**
     * Get ExtendedData14 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData14()
    {
        return isset($this->ExtendedData14) ? $this->ExtendedData14 : null;
    }
    /**
     * Set ExtendedData14 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData14
     * @return \patest\StructType\Ticketing_SalesEventFilter
     */
    public function setExtendedData14($extendedData14 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData14) && !is_string($extendedData14)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData14, true), gettype($extendedData14)), __LINE__);
        }
        if (is_null($extendedData14) || (is_array($extendedData14) && empty($extendedData14))) {
            unset($this->ExtendedData14);
        } else {
            $this->ExtendedData14 = $extendedData14;
        }
        return $this;
    }
    /**
     * Get ExtendedData2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData2()
    {
        return isset($this->ExtendedData2) ? $this->ExtendedData2 : null;
    }
    /**
     * Set ExtendedData2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData2
     * @return \patest\StructType\Ticketing_SalesEventFilter
     */
    public function setExtendedData2($extendedData2 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData2) && !is_string($extendedData2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData2, true), gettype($extendedData2)), __LINE__);
        }
        if (is_null($extendedData2) || (is_array($extendedData2) && empty($extendedData2))) {
            unset($this->ExtendedData2);
        } else {
            $this->ExtendedData2 = $extendedData2;
        }
        return $this;
    }
    /**
     * Get ExtendedData3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData3()
    {
        return isset($this->ExtendedData3) ? $this->ExtendedData3 : null;
    }
    /**
     * Set ExtendedData3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData3
     * @return \patest\StructType\Ticketing_SalesEventFilter
     */
    public function setExtendedData3($extendedData3 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData3) && !is_string($extendedData3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData3, true), gettype($extendedData3)), __LINE__);
        }
        if (is_null($extendedData3) || (is_array($extendedData3) && empty($extendedData3))) {
            unset($this->ExtendedData3);
        } else {
            $this->ExtendedData3 = $extendedData3;
        }
        return $this;
    }
    /**
     * Get ExtendedData4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData4()
    {
        return isset($this->ExtendedData4) ? $this->ExtendedData4 : null;
    }
    /**
     * Set ExtendedData4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData4
     * @return \patest\StructType\Ticketing_SalesEventFilter
     */
    public function setExtendedData4($extendedData4 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData4) && !is_string($extendedData4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData4, true), gettype($extendedData4)), __LINE__);
        }
        if (is_null($extendedData4) || (is_array($extendedData4) && empty($extendedData4))) {
            unset($this->ExtendedData4);
        } else {
            $this->ExtendedData4 = $extendedData4;
        }
        return $this;
    }
    /**
     * Get ExtendedData5 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData5()
    {
        return isset($this->ExtendedData5) ? $this->ExtendedData5 : null;
    }
    /**
     * Set ExtendedData5 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData5
     * @return \patest\StructType\Ticketing_SalesEventFilter
     */
    public function setExtendedData5($extendedData5 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData5) && !is_string($extendedData5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData5, true), gettype($extendedData5)), __LINE__);
        }
        if (is_null($extendedData5) || (is_array($extendedData5) && empty($extendedData5))) {
            unset($this->ExtendedData5);
        } else {
            $this->ExtendedData5 = $extendedData5;
        }
        return $this;
    }
    /**
     * Get ExtendedData6 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData6()
    {
        return isset($this->ExtendedData6) ? $this->ExtendedData6 : null;
    }
    /**
     * Set ExtendedData6 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData6
     * @return \patest\StructType\Ticketing_SalesEventFilter
     */
    public function setExtendedData6($extendedData6 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData6) && !is_string($extendedData6)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData6, true), gettype($extendedData6)), __LINE__);
        }
        if (is_null($extendedData6) || (is_array($extendedData6) && empty($extendedData6))) {
            unset($this->ExtendedData6);
        } else {
            $this->ExtendedData6 = $extendedData6;
        }
        return $this;
    }
    /**
     * Get ExtendedData7 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData7()
    {
        return isset($this->ExtendedData7) ? $this->ExtendedData7 : null;
    }
    /**
     * Set ExtendedData7 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData7
     * @return \patest\StructType\Ticketing_SalesEventFilter
     */
    public function setExtendedData7($extendedData7 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData7) && !is_string($extendedData7)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData7, true), gettype($extendedData7)), __LINE__);
        }
        if (is_null($extendedData7) || (is_array($extendedData7) && empty($extendedData7))) {
            unset($this->ExtendedData7);
        } else {
            $this->ExtendedData7 = $extendedData7;
        }
        return $this;
    }
    /**
     * Get ExtendedData8 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData8()
    {
        return isset($this->ExtendedData8) ? $this->ExtendedData8 : null;
    }
    /**
     * Set ExtendedData8 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData8
     * @return \patest\StructType\Ticketing_SalesEventFilter
     */
    public function setExtendedData8($extendedData8 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData8) && !is_string($extendedData8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData8, true), gettype($extendedData8)), __LINE__);
        }
        if (is_null($extendedData8) || (is_array($extendedData8) && empty($extendedData8))) {
            unset($this->ExtendedData8);
        } else {
            $this->ExtendedData8 = $extendedData8;
        }
        return $this;
    }
    /**
     * Get ExtendedData9 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData9()
    {
        return isset($this->ExtendedData9) ? $this->ExtendedData9 : null;
    }
    /**
     * Set ExtendedData9 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData9
     * @return \patest\StructType\Ticketing_SalesEventFilter
     */
    public function setExtendedData9($extendedData9 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData9) && !is_string($extendedData9)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData9, true), gettype($extendedData9)), __LINE__);
        }
        if (is_null($extendedData9) || (is_array($extendedData9) && empty($extendedData9))) {
            unset($this->ExtendedData9);
        } else {
            $this->ExtendedData9 = $extendedData9;
        }
        return $this;
    }
    /**
     * Get GuidanceLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGuidanceLevel()
    {
        return isset($this->GuidanceLevel) ? $this->GuidanceLevel : null;
    }
    /**
     * Set GuidanceLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\GuidanceLevel::valueIsValid()
     * @uses \patest\EnumType\GuidanceLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $guidanceLevel
     * @return \patest\StructType\Ticketing_SalesEventFilter
     */
    public function setGuidanceLevel($guidanceLevel = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\GuidanceLevel::valueIsValid($guidanceLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\GuidanceLevel', is_array($guidanceLevel) ? implode(', ', $guidanceLevel) : var_export($guidanceLevel, true), implode(', ', \patest\EnumType\GuidanceLevel::getValidValues())), __LINE__);
        }
        if (is_null($guidanceLevel) || (is_array($guidanceLevel) && empty($guidanceLevel))) {
            unset($this->GuidanceLevel);
        } else {
            $this->GuidanceLevel = $guidanceLevel;
        }
        return $this;
    }
    /**
     * Get GuidanceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGuidanceTypeId()
    {
        return isset($this->GuidanceTypeId) ? $this->GuidanceTypeId : null;
    }
    /**
     * Set GuidanceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $guidanceTypeId
     * @return \patest\StructType\Ticketing_SalesEventFilter
     */
    public function setGuidanceTypeId($guidanceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($guidanceTypeId) && !is_string($guidanceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guidanceTypeId, true), gettype($guidanceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($guidanceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $guidanceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($guidanceTypeId, true)), __LINE__);
        }
        if (is_null($guidanceTypeId) || (is_array($guidanceTypeId) && empty($guidanceTypeId))) {
            unset($this->GuidanceTypeId);
        } else {
            $this->GuidanceTypeId = $guidanceTypeId;
        }
        return $this;
    }
    /**
     * Get HospitalityFilterType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHospitalityFilterType()
    {
        return isset($this->HospitalityFilterType) ? $this->HospitalityFilterType : null;
    }
    /**
     * Set HospitalityFilterType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\HospitalityFilterType::valueIsValid()
     * @uses \patest\EnumType\HospitalityFilterType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hospitalityFilterType
     * @return \patest\StructType\Ticketing_SalesEventFilter
     */
    public function setHospitalityFilterType($hospitalityFilterType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\HospitalityFilterType::valueIsValid($hospitalityFilterType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\HospitalityFilterType', is_array($hospitalityFilterType) ? implode(', ', $hospitalityFilterType) : var_export($hospitalityFilterType, true), implode(', ', \patest\EnumType\HospitalityFilterType::getValidValues())), __LINE__);
        }
        if (is_null($hospitalityFilterType) || (is_array($hospitalityFilterType) && empty($hospitalityFilterType))) {
            unset($this->HospitalityFilterType);
        } else {
            $this->HospitalityFilterType = $hospitalityFilterType;
        }
        return $this;
    }
    /**
     * Get SkillIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSkillIds()
    {
        return isset($this->SkillIds) ? $this->SkillIds : null;
    }
    /**
     * Set SkillIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $skillIds
     * @return \patest\StructType\Ticketing_SalesEventFilter
     */
    public function setSkillIds($skillIds = null)
    {
        // validation for constraint: string
        if (!is_null($skillIds) && !is_string($skillIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($skillIds, true), gettype($skillIds)), __LINE__);
        }
        if (is_null($skillIds) || (is_array($skillIds) && empty($skillIds))) {
            unset($this->SkillIds);
        } else {
            $this->SkillIds = $skillIds;
        }
        return $this;
    }
    /**
     * Get WithAvailableGuides value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getWithAvailableGuides()
    {
        return isset($this->WithAvailableGuides) ? $this->WithAvailableGuides : null;
    }
    /**
     * Set WithAvailableGuides value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $withAvailableGuides
     * @return \patest\StructType\Ticketing_SalesEventFilter
     */
    public function setWithAvailableGuides($withAvailableGuides = null)
    {
        // validation for constraint: boolean
        if (!is_null($withAvailableGuides) && !is_bool($withAvailableGuides)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($withAvailableGuides, true), gettype($withAvailableGuides)), __LINE__);
        }
        if (is_null($withAvailableGuides) || (is_array($withAvailableGuides) && empty($withAvailableGuides))) {
            unset($this->WithAvailableGuides);
        } else {
            $this->WithAvailableGuides = $withAvailableGuides;
        }
        return $this;
    }
}
