<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.SaleStatusFilterEntity StructType
 * @subpackage Structs
 */
class Ticketing_SaleStatusFilterEntity extends Sales_ClientSalesTransactionFilterEntity
{
    /**
     * The PrintedStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PrintedStatus;
    /**
     * The RenewStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RenewStatus;
    /**
     * The ReservedStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ReservedStatus;
    /**
     * The SoldStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SoldStatus;
    /**
     * Constructor method for Ticketing.SaleStatusFilterEntity
     * @uses Ticketing_SaleStatusFilterEntity::setPrintedStatus()
     * @uses Ticketing_SaleStatusFilterEntity::setRenewStatus()
     * @uses Ticketing_SaleStatusFilterEntity::setReservedStatus()
     * @uses Ticketing_SaleStatusFilterEntity::setSoldStatus()
     * @param int $printedStatus
     * @param int $renewStatus
     * @param bool $reservedStatus
     * @param bool $soldStatus
     */
    public function __construct($printedStatus = null, $renewStatus = null, $reservedStatus = null, $soldStatus = null)
    {
        $this
            ->setPrintedStatus($printedStatus)
            ->setRenewStatus($renewStatus)
            ->setReservedStatus($reservedStatus)
            ->setSoldStatus($soldStatus);
    }
    /**
     * Get PrintedStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrintedStatus()
    {
        return isset($this->PrintedStatus) ? $this->PrintedStatus : null;
    }
    /**
     * Set PrintedStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $printedStatus
     * @return \patest\StructType\Ticketing_SaleStatusFilterEntity
     */
    public function setPrintedStatus($printedStatus = null)
    {
        // validation for constraint: int
        if (!is_null($printedStatus) && !(is_int($printedStatus) || ctype_digit($printedStatus))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($printedStatus, true), gettype($printedStatus)), __LINE__);
        }
        if (is_null($printedStatus) || (is_array($printedStatus) && empty($printedStatus))) {
            unset($this->PrintedStatus);
        } else {
            $this->PrintedStatus = $printedStatus;
        }
        return $this;
    }
    /**
     * Get RenewStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRenewStatus()
    {
        return isset($this->RenewStatus) ? $this->RenewStatus : null;
    }
    /**
     * Set RenewStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $renewStatus
     * @return \patest\StructType\Ticketing_SaleStatusFilterEntity
     */
    public function setRenewStatus($renewStatus = null)
    {
        // validation for constraint: int
        if (!is_null($renewStatus) && !(is_int($renewStatus) || ctype_digit($renewStatus))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($renewStatus, true), gettype($renewStatus)), __LINE__);
        }
        if (is_null($renewStatus) || (is_array($renewStatus) && empty($renewStatus))) {
            unset($this->RenewStatus);
        } else {
            $this->RenewStatus = $renewStatus;
        }
        return $this;
    }
    /**
     * Get ReservedStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getReservedStatus()
    {
        return isset($this->ReservedStatus) ? $this->ReservedStatus : null;
    }
    /**
     * Set ReservedStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $reservedStatus
     * @return \patest\StructType\Ticketing_SaleStatusFilterEntity
     */
    public function setReservedStatus($reservedStatus = null)
    {
        // validation for constraint: boolean
        if (!is_null($reservedStatus) && !is_bool($reservedStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($reservedStatus, true), gettype($reservedStatus)), __LINE__);
        }
        if (is_null($reservedStatus) || (is_array($reservedStatus) && empty($reservedStatus))) {
            unset($this->ReservedStatus);
        } else {
            $this->ReservedStatus = $reservedStatus;
        }
        return $this;
    }
    /**
     * Get SoldStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSoldStatus()
    {
        return isset($this->SoldStatus) ? $this->SoldStatus : null;
    }
    /**
     * Set SoldStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $soldStatus
     * @return \patest\StructType\Ticketing_SaleStatusFilterEntity
     */
    public function setSoldStatus($soldStatus = null)
    {
        // validation for constraint: boolean
        if (!is_null($soldStatus) && !is_bool($soldStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($soldStatus, true), gettype($soldStatus)), __LINE__);
        }
        if (is_null($soldStatus) || (is_array($soldStatus) && empty($soldStatus))) {
            unset($this->SoldStatus);
        } else {
            $this->SoldStatus = $soldStatus;
        }
        return $this;
    }
}
