<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.ProductToRequestTypesXRef StructType
 * @subpackage Structs
 */
class Ticketing_ProductToRequestTypesXRef extends AnyEntity
{
    /**
     * The HolderCompanyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HolderCompanyId;
    /**
     * The ProductGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProductGuid;
    /**
     * The RequestTypeGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RequestTypeGuid;
    /**
     * Constructor method for Ticketing.ProductToRequestTypesXRef
     * @uses Ticketing_ProductToRequestTypesXRef::setHolderCompanyId()
     * @uses Ticketing_ProductToRequestTypesXRef::setProductGuid()
     * @uses Ticketing_ProductToRequestTypesXRef::setRequestTypeGuid()
     * @param int $holderCompanyId
     * @param string $productGuid
     * @param string $requestTypeGuid
     */
    public function __construct($holderCompanyId = null, $productGuid = null, $requestTypeGuid = null)
    {
        $this
            ->setHolderCompanyId($holderCompanyId)
            ->setProductGuid($productGuid)
            ->setRequestTypeGuid($requestTypeGuid);
    }
    /**
     * Get HolderCompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHolderCompanyId()
    {
        return isset($this->HolderCompanyId) ? $this->HolderCompanyId : null;
    }
    /**
     * Set HolderCompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $holderCompanyId
     * @return \patest\StructType\Ticketing_ProductToRequestTypesXRef
     */
    public function setHolderCompanyId($holderCompanyId = null)
    {
        // validation for constraint: int
        if (!is_null($holderCompanyId) && !(is_int($holderCompanyId) || ctype_digit($holderCompanyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($holderCompanyId, true), gettype($holderCompanyId)), __LINE__);
        }
        if (is_null($holderCompanyId) || (is_array($holderCompanyId) && empty($holderCompanyId))) {
            unset($this->HolderCompanyId);
        } else {
            $this->HolderCompanyId = $holderCompanyId;
        }
        return $this;
    }
    /**
     * Get ProductGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductGuid()
    {
        return isset($this->ProductGuid) ? $this->ProductGuid : null;
    }
    /**
     * Set ProductGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productGuid
     * @return \patest\StructType\Ticketing_ProductToRequestTypesXRef
     */
    public function setProductGuid($productGuid = null)
    {
        // validation for constraint: string
        if (!is_null($productGuid) && !is_string($productGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productGuid, true), gettype($productGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($productGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $productGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($productGuid, true)), __LINE__);
        }
        if (is_null($productGuid) || (is_array($productGuid) && empty($productGuid))) {
            unset($this->ProductGuid);
        } else {
            $this->ProductGuid = $productGuid;
        }
        return $this;
    }
    /**
     * Get RequestTypeGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTypeGuid()
    {
        return isset($this->RequestTypeGuid) ? $this->RequestTypeGuid : null;
    }
    /**
     * Set RequestTypeGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTypeGuid
     * @return \patest\StructType\Ticketing_ProductToRequestTypesXRef
     */
    public function setRequestTypeGuid($requestTypeGuid = null)
    {
        // validation for constraint: string
        if (!is_null($requestTypeGuid) && !is_string($requestTypeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTypeGuid, true), gettype($requestTypeGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($requestTypeGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $requestTypeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($requestTypeGuid, true)), __LINE__);
        }
        if (is_null($requestTypeGuid) || (is_array($requestTypeGuid) && empty($requestTypeGuid))) {
            unset($this->RequestTypeGuid);
        } else {
            $this->RequestTypeGuid = $requestTypeGuid;
        }
        return $this;
    }
}
