<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.ProcessBallot StructType
 * @subpackage Structs
 */
class Ticketing_ProcessBallot extends AnyEntity
{
    /**
     * The BallotId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BallotId;
    /**
     * The BallotName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BallotName;
    /**
     * The BallotVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BallotVersion;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The HolderCompanyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HolderCompanyId;
    /**
     * The Sections
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_ProcessBallotLine
     */
    public $Sections;
    /**
     * Constructor method for Ticketing.ProcessBallot
     * @uses Ticketing_ProcessBallot::setBallotId()
     * @uses Ticketing_ProcessBallot::setBallotName()
     * @uses Ticketing_ProcessBallot::setBallotVersion()
     * @uses Ticketing_ProcessBallot::setEventId()
     * @uses Ticketing_ProcessBallot::setHolderCompanyId()
     * @uses Ticketing_ProcessBallot::setSections()
     * @param string $ballotId
     * @param string $ballotName
     * @param string $ballotVersion
     * @param string $eventId
     * @param int $holderCompanyId
     * @param \patest\StructType\RecordSetOfTicketing_ProcessBallotLine $sections
     */
    public function __construct($ballotId = null, $ballotName = null, $ballotVersion = null, $eventId = null, $holderCompanyId = null, \patest\StructType\RecordSetOfTicketing_ProcessBallotLine $sections = null)
    {
        $this
            ->setBallotId($ballotId)
            ->setBallotName($ballotName)
            ->setBallotVersion($ballotVersion)
            ->setEventId($eventId)
            ->setHolderCompanyId($holderCompanyId)
            ->setSections($sections);
    }
    /**
     * Get BallotId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBallotId()
    {
        return isset($this->BallotId) ? $this->BallotId : null;
    }
    /**
     * Set BallotId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ballotId
     * @return \patest\StructType\Ticketing_ProcessBallot
     */
    public function setBallotId($ballotId = null)
    {
        // validation for constraint: string
        if (!is_null($ballotId) && !is_string($ballotId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ballotId, true), gettype($ballotId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ballotId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ballotId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ballotId, true)), __LINE__);
        }
        if (is_null($ballotId) || (is_array($ballotId) && empty($ballotId))) {
            unset($this->BallotId);
        } else {
            $this->BallotId = $ballotId;
        }
        return $this;
    }
    /**
     * Get BallotName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBallotName()
    {
        return isset($this->BallotName) ? $this->BallotName : null;
    }
    /**
     * Set BallotName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ballotName
     * @return \patest\StructType\Ticketing_ProcessBallot
     */
    public function setBallotName($ballotName = null)
    {
        // validation for constraint: string
        if (!is_null($ballotName) && !is_string($ballotName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ballotName, true), gettype($ballotName)), __LINE__);
        }
        if (is_null($ballotName) || (is_array($ballotName) && empty($ballotName))) {
            unset($this->BallotName);
        } else {
            $this->BallotName = $ballotName;
        }
        return $this;
    }
    /**
     * Get BallotVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBallotVersion()
    {
        return isset($this->BallotVersion) ? $this->BallotVersion : null;
    }
    /**
     * Set BallotVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BallotVersion::valueIsValid()
     * @uses \patest\EnumType\BallotVersion::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ballotVersion
     * @return \patest\StructType\Ticketing_ProcessBallot
     */
    public function setBallotVersion($ballotVersion = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BallotVersion::valueIsValid($ballotVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BallotVersion', is_array($ballotVersion) ? implode(', ', $ballotVersion) : var_export($ballotVersion, true), implode(', ', \patest\EnumType\BallotVersion::getValidValues())), __LINE__);
        }
        if (is_null($ballotVersion) || (is_array($ballotVersion) && empty($ballotVersion))) {
            unset($this->BallotVersion);
        } else {
            $this->BallotVersion = $ballotVersion;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\Ticketing_ProcessBallot
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get HolderCompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHolderCompanyId()
    {
        return isset($this->HolderCompanyId) ? $this->HolderCompanyId : null;
    }
    /**
     * Set HolderCompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $holderCompanyId
     * @return \patest\StructType\Ticketing_ProcessBallot
     */
    public function setHolderCompanyId($holderCompanyId = null)
    {
        // validation for constraint: int
        if (!is_null($holderCompanyId) && !(is_int($holderCompanyId) || ctype_digit($holderCompanyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($holderCompanyId, true), gettype($holderCompanyId)), __LINE__);
        }
        if (is_null($holderCompanyId) || (is_array($holderCompanyId) && empty($holderCompanyId))) {
            unset($this->HolderCompanyId);
        } else {
            $this->HolderCompanyId = $holderCompanyId;
        }
        return $this;
    }
    /**
     * Get Sections value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_ProcessBallotLine|null
     */
    public function getSections()
    {
        return isset($this->Sections) ? $this->Sections : null;
    }
    /**
     * Set Sections value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_ProcessBallotLine $sections
     * @return \patest\StructType\Ticketing_ProcessBallot
     */
    public function setSections(\patest\StructType\RecordSetOfTicketing_ProcessBallotLine $sections = null)
    {
        if (is_null($sections) || (is_array($sections) && empty($sections))) {
            unset($this->Sections);
        } else {
            $this->Sections = $sections;
        }
        return $this;
    }
}
