<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.Printing.PerformerEvent StructType
 * @subpackage Structs
 */
class Ticketing_Printing_PerformerEvent extends Printing_Item_ComplexProperty_Base
{
    /**
     * The Ordinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Ordinal;
    /**
     * The PerformerName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PerformerName;
    /**
     * The PerformerType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PerformerType;
    /**
     * Constructor method for Ticketing.Printing.PerformerEvent
     * @uses Ticketing_Printing_PerformerEvent::setOrdinal()
     * @uses Ticketing_Printing_PerformerEvent::setPerformerName()
     * @uses Ticketing_Printing_PerformerEvent::setPerformerType()
     * @param int $ordinal
     * @param string $performerName
     * @param string $performerType
     */
    public function __construct($ordinal = null, $performerName = null, $performerType = null)
    {
        $this
            ->setOrdinal($ordinal)
            ->setPerformerName($performerName)
            ->setPerformerType($performerType);
    }
    /**
     * Get Ordinal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrdinal()
    {
        return isset($this->Ordinal) ? $this->Ordinal : null;
    }
    /**
     * Set Ordinal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ordinal
     * @return \patest\StructType\Ticketing_Printing_PerformerEvent
     */
    public function setOrdinal($ordinal = null)
    {
        // validation for constraint: int
        if (!is_null($ordinal) && !(is_int($ordinal) || ctype_digit($ordinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordinal, true), gettype($ordinal)), __LINE__);
        }
        if (is_null($ordinal) || (is_array($ordinal) && empty($ordinal))) {
            unset($this->Ordinal);
        } else {
            $this->Ordinal = $ordinal;
        }
        return $this;
    }
    /**
     * Get PerformerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPerformerName()
    {
        return isset($this->PerformerName) ? $this->PerformerName : null;
    }
    /**
     * Set PerformerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $performerName
     * @return \patest\StructType\Ticketing_Printing_PerformerEvent
     */
    public function setPerformerName($performerName = null)
    {
        // validation for constraint: string
        if (!is_null($performerName) && !is_string($performerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($performerName, true), gettype($performerName)), __LINE__);
        }
        if (is_null($performerName) || (is_array($performerName) && empty($performerName))) {
            unset($this->PerformerName);
        } else {
            $this->PerformerName = $performerName;
        }
        return $this;
    }
    /**
     * Get PerformerType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPerformerType()
    {
        return isset($this->PerformerType) ? $this->PerformerType : null;
    }
    /**
     * Set PerformerType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PerformerType::valueIsValid()
     * @uses \patest\EnumType\PerformerType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $performerType
     * @return \patest\StructType\Ticketing_Printing_PerformerEvent
     */
    public function setPerformerType($performerType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PerformerType::valueIsValid($performerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PerformerType', is_array($performerType) ? implode(', ', $performerType) : var_export($performerType, true), implode(', ', \patest\EnumType\PerformerType::getValidValues())), __LINE__);
        }
        if (is_null($performerType) || (is_array($performerType) && empty($performerType))) {
            unset($this->PerformerType);
        } else {
            $this->PerformerType = $performerType;
        }
        return $this;
    }
}
