<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.PrintedMobileTicket StructType
 * @subpackage Structs
 */
class Ticketing_PrintedMobileTicket extends PersistableEntity
{
    /**
     * The GeneratedDocument
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GeneratedDocument;
    /**
     * The IsGeneratedDocumentCompressed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsGeneratedDocumentCompressed;
    /**
     * The PrintDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrintDate;
    /**
     * The ReferenceEntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReferenceEntityName;
    /**
     * The ReferenceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ReferenceId;
    /**
     * Constructor method for Ticketing.PrintedMobileTicket
     * @uses Ticketing_PrintedMobileTicket::setGeneratedDocument()
     * @uses Ticketing_PrintedMobileTicket::setIsGeneratedDocumentCompressed()
     * @uses Ticketing_PrintedMobileTicket::setPrintDate()
     * @uses Ticketing_PrintedMobileTicket::setReferenceEntityName()
     * @uses Ticketing_PrintedMobileTicket::setReferenceId()
     * @param string $generatedDocument
     * @param bool $isGeneratedDocumentCompressed
     * @param string $printDate
     * @param string $referenceEntityName
     * @param string $referenceId
     */
    public function __construct($generatedDocument = null, $isGeneratedDocumentCompressed = null, $printDate = null, $referenceEntityName = null, $referenceId = null)
    {
        $this
            ->setGeneratedDocument($generatedDocument)
            ->setIsGeneratedDocumentCompressed($isGeneratedDocumentCompressed)
            ->setPrintDate($printDate)
            ->setReferenceEntityName($referenceEntityName)
            ->setReferenceId($referenceId);
    }
    /**
     * Get GeneratedDocument value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGeneratedDocument()
    {
        return isset($this->GeneratedDocument) ? $this->GeneratedDocument : null;
    }
    /**
     * Set GeneratedDocument value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $generatedDocument
     * @return \patest\StructType\Ticketing_PrintedMobileTicket
     */
    public function setGeneratedDocument($generatedDocument = null)
    {
        // validation for constraint: string
        if (!is_null($generatedDocument) && !is_string($generatedDocument)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($generatedDocument, true), gettype($generatedDocument)), __LINE__);
        }
        if (is_null($generatedDocument) || (is_array($generatedDocument) && empty($generatedDocument))) {
            unset($this->GeneratedDocument);
        } else {
            $this->GeneratedDocument = $generatedDocument;
        }
        return $this;
    }
    /**
     * Get IsGeneratedDocumentCompressed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsGeneratedDocumentCompressed()
    {
        return isset($this->IsGeneratedDocumentCompressed) ? $this->IsGeneratedDocumentCompressed : null;
    }
    /**
     * Set IsGeneratedDocumentCompressed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isGeneratedDocumentCompressed
     * @return \patest\StructType\Ticketing_PrintedMobileTicket
     */
    public function setIsGeneratedDocumentCompressed($isGeneratedDocumentCompressed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGeneratedDocumentCompressed) && !is_bool($isGeneratedDocumentCompressed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isGeneratedDocumentCompressed, true), gettype($isGeneratedDocumentCompressed)), __LINE__);
        }
        if (is_null($isGeneratedDocumentCompressed) || (is_array($isGeneratedDocumentCompressed) && empty($isGeneratedDocumentCompressed))) {
            unset($this->IsGeneratedDocumentCompressed);
        } else {
            $this->IsGeneratedDocumentCompressed = $isGeneratedDocumentCompressed;
        }
        return $this;
    }
    /**
     * Get PrintDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrintDate()
    {
        return isset($this->PrintDate) ? $this->PrintDate : null;
    }
    /**
     * Set PrintDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $printDate
     * @return \patest\StructType\Ticketing_PrintedMobileTicket
     */
    public function setPrintDate($printDate = null)
    {
        // validation for constraint: string
        if (!is_null($printDate) && !is_string($printDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printDate, true), gettype($printDate)), __LINE__);
        }
        if (is_null($printDate) || (is_array($printDate) && empty($printDate))) {
            unset($this->PrintDate);
        } else {
            $this->PrintDate = $printDate;
        }
        return $this;
    }
    /**
     * Get ReferenceEntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferenceEntityName()
    {
        return isset($this->ReferenceEntityName) ? $this->ReferenceEntityName : null;
    }
    /**
     * Set ReferenceEntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referenceEntityName
     * @return \patest\StructType\Ticketing_PrintedMobileTicket
     */
    public function setReferenceEntityName($referenceEntityName = null)
    {
        // validation for constraint: string
        if (!is_null($referenceEntityName) && !is_string($referenceEntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceEntityName, true), gettype($referenceEntityName)), __LINE__);
        }
        if (is_null($referenceEntityName) || (is_array($referenceEntityName) && empty($referenceEntityName))) {
            unset($this->ReferenceEntityName);
        } else {
            $this->ReferenceEntityName = $referenceEntityName;
        }
        return $this;
    }
    /**
     * Get ReferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferenceId()
    {
        return isset($this->ReferenceId) ? $this->ReferenceId : null;
    }
    /**
     * Set ReferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referenceId
     * @return \patest\StructType\Ticketing_PrintedMobileTicket
     */
    public function setReferenceId($referenceId = null)
    {
        // validation for constraint: string
        if (!is_null($referenceId) && !is_string($referenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceId, true), gettype($referenceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($referenceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $referenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($referenceId, true)), __LINE__);
        }
        if (is_null($referenceId) || (is_array($referenceId) && empty($referenceId))) {
            unset($this->ReferenceId);
        } else {
            $this->ReferenceId = $referenceId;
        }
        return $this;
    }
}
