<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.PriceListShowDistributionItem StructType
 * @subpackage Structs
 */
class Ticketing_PriceListShowDistributionItem extends PersistableEntity
{
    /**
     * The DistributionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DistributionId;
    /**
     * The ShowId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowId;
    /**
     * The ShowName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $ShowName;
    /**
     * The ShowPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ShowPrice;
    /**
     * The TotalPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TotalPrice;
    /**
     * Constructor method for Ticketing.PriceListShowDistributionItem
     * @uses Ticketing_PriceListShowDistributionItem::setDistributionId()
     * @uses Ticketing_PriceListShowDistributionItem::setShowId()
     * @uses Ticketing_PriceListShowDistributionItem::setShowName()
     * @uses Ticketing_PriceListShowDistributionItem::setShowPrice()
     * @uses Ticketing_PriceListShowDistributionItem::setTotalPrice()
     * @param string $distributionId
     * @param string $showId
     * @param \patest\StructType\GlobalString $showName
     * @param float $showPrice
     * @param float $totalPrice
     */
    public function __construct($distributionId = null, $showId = null, \patest\StructType\GlobalString $showName = null, $showPrice = null, $totalPrice = null)
    {
        $this
            ->setDistributionId($distributionId)
            ->setShowId($showId)
            ->setShowName($showName)
            ->setShowPrice($showPrice)
            ->setTotalPrice($totalPrice);
    }
    /**
     * Get DistributionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDistributionId()
    {
        return isset($this->DistributionId) ? $this->DistributionId : null;
    }
    /**
     * Set DistributionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $distributionId
     * @return \patest\StructType\Ticketing_PriceListShowDistributionItem
     */
    public function setDistributionId($distributionId = null)
    {
        // validation for constraint: string
        if (!is_null($distributionId) && !is_string($distributionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($distributionId, true), gettype($distributionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($distributionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $distributionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($distributionId, true)), __LINE__);
        }
        if (is_null($distributionId) || (is_array($distributionId) && empty($distributionId))) {
            unset($this->DistributionId);
        } else {
            $this->DistributionId = $distributionId;
        }
        return $this;
    }
    /**
     * Get ShowId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowId()
    {
        return isset($this->ShowId) ? $this->ShowId : null;
    }
    /**
     * Set ShowId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showId
     * @return \patest\StructType\Ticketing_PriceListShowDistributionItem
     */
    public function setShowId($showId = null)
    {
        // validation for constraint: string
        if (!is_null($showId) && !is_string($showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showId, true), gettype($showId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showId, true)), __LINE__);
        }
        if (is_null($showId) || (is_array($showId) && empty($showId))) {
            unset($this->ShowId);
        } else {
            $this->ShowId = $showId;
        }
        return $this;
    }
    /**
     * Get ShowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getShowName()
    {
        return isset($this->ShowName) ? $this->ShowName : null;
    }
    /**
     * Set ShowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $showName
     * @return \patest\StructType\Ticketing_PriceListShowDistributionItem
     */
    public function setShowName(\patest\StructType\GlobalString $showName = null)
    {
        if (is_null($showName) || (is_array($showName) && empty($showName))) {
            unset($this->ShowName);
        } else {
            $this->ShowName = $showName;
        }
        return $this;
    }
    /**
     * Get ShowPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getShowPrice()
    {
        return isset($this->ShowPrice) ? $this->ShowPrice : null;
    }
    /**
     * Set ShowPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $showPrice
     * @return \patest\StructType\Ticketing_PriceListShowDistributionItem
     */
    public function setShowPrice($showPrice = null)
    {
        // validation for constraint: float
        if (!is_null($showPrice) && !(is_float($showPrice) || is_numeric($showPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($showPrice, true), gettype($showPrice)), __LINE__);
        }
        if (is_null($showPrice) || (is_array($showPrice) && empty($showPrice))) {
            unset($this->ShowPrice);
        } else {
            $this->ShowPrice = $showPrice;
        }
        return $this;
    }
    /**
     * Get TotalPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTotalPrice()
    {
        return isset($this->TotalPrice) ? $this->TotalPrice : null;
    }
    /**
     * Set TotalPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $totalPrice
     * @return \patest\StructType\Ticketing_PriceListShowDistributionItem
     */
    public function setTotalPrice($totalPrice = null)
    {
        // validation for constraint: float
        if (!is_null($totalPrice) && !(is_float($totalPrice) || is_numeric($totalPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalPrice, true), gettype($totalPrice)), __LINE__);
        }
        if (is_null($totalPrice) || (is_array($totalPrice) && empty($totalPrice))) {
            unset($this->TotalPrice);
        } else {
            $this->TotalPrice = $totalPrice;
        }
        return $this;
    }
}
