<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.PriceListShowDistribution StructType
 * @subpackage Structs
 */
class Ticketing_PriceListShowDistribution extends PersistableEntity
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsItemsMismatchError
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsItemsMismatchError;
    /**
     * The IsValid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsValid;
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_PriceListShowDistributionItem
     */
    public $Items;
    /**
     * The PriceListId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceListId;
    /**
     * The SeriesIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SeriesIds
     */
    public $SeriesIds;
    /**
     * The ValidationErrors
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidationErrors;
    /**
     * Constructor method for Ticketing.PriceListShowDistribution
     * @uses Ticketing_PriceListShowDistribution::setDescription()
     * @uses Ticketing_PriceListShowDistribution::setIsActive()
     * @uses Ticketing_PriceListShowDistribution::setIsItemsMismatchError()
     * @uses Ticketing_PriceListShowDistribution::setIsValid()
     * @uses Ticketing_PriceListShowDistribution::setItems()
     * @uses Ticketing_PriceListShowDistribution::setPriceListId()
     * @uses Ticketing_PriceListShowDistribution::setSeriesIds()
     * @uses Ticketing_PriceListShowDistribution::setValidationErrors()
     * @param string $description
     * @param bool $isActive
     * @param bool $isItemsMismatchError
     * @param bool $isValid
     * @param \patest\StructType\RecordSetOfTicketing_PriceListShowDistributionItem $items
     * @param string $priceListId
     * @param \patest\StructType\SeriesIds $seriesIds
     * @param string $validationErrors
     */
    public function __construct($description = null, $isActive = null, $isItemsMismatchError = null, $isValid = null, \patest\StructType\RecordSetOfTicketing_PriceListShowDistributionItem $items = null, $priceListId = null, \patest\StructType\SeriesIds $seriesIds = null, $validationErrors = null)
    {
        $this
            ->setDescription($description)
            ->setIsActive($isActive)
            ->setIsItemsMismatchError($isItemsMismatchError)
            ->setIsValid($isValid)
            ->setItems($items)
            ->setPriceListId($priceListId)
            ->setSeriesIds($seriesIds)
            ->setValidationErrors($validationErrors);
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \patest\StructType\Ticketing_PriceListShowDistribution
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Ticketing_PriceListShowDistribution
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsItemsMismatchError value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsItemsMismatchError()
    {
        return isset($this->IsItemsMismatchError) ? $this->IsItemsMismatchError : null;
    }
    /**
     * Set IsItemsMismatchError value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isItemsMismatchError
     * @return \patest\StructType\Ticketing_PriceListShowDistribution
     */
    public function setIsItemsMismatchError($isItemsMismatchError = null)
    {
        // validation for constraint: boolean
        if (!is_null($isItemsMismatchError) && !is_bool($isItemsMismatchError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isItemsMismatchError, true), gettype($isItemsMismatchError)), __LINE__);
        }
        if (is_null($isItemsMismatchError) || (is_array($isItemsMismatchError) && empty($isItemsMismatchError))) {
            unset($this->IsItemsMismatchError);
        } else {
            $this->IsItemsMismatchError = $isItemsMismatchError;
        }
        return $this;
    }
    /**
     * Get IsValid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsValid()
    {
        return isset($this->IsValid) ? $this->IsValid : null;
    }
    /**
     * Set IsValid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isValid
     * @return \patest\StructType\Ticketing_PriceListShowDistribution
     */
    public function setIsValid($isValid = null)
    {
        // validation for constraint: boolean
        if (!is_null($isValid) && !is_bool($isValid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isValid, true), gettype($isValid)), __LINE__);
        }
        if (is_null($isValid) || (is_array($isValid) && empty($isValid))) {
            unset($this->IsValid);
        } else {
            $this->IsValid = $isValid;
        }
        return $this;
    }
    /**
     * Get Items value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_PriceListShowDistributionItem|null
     */
    public function getItems()
    {
        return isset($this->Items) ? $this->Items : null;
    }
    /**
     * Set Items value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_PriceListShowDistributionItem $items
     * @return \patest\StructType\Ticketing_PriceListShowDistribution
     */
    public function setItems(\patest\StructType\RecordSetOfTicketing_PriceListShowDistributionItem $items = null)
    {
        if (is_null($items) || (is_array($items) && empty($items))) {
            unset($this->Items);
        } else {
            $this->Items = $items;
        }
        return $this;
    }
    /**
     * Get PriceListId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceListId()
    {
        return isset($this->PriceListId) ? $this->PriceListId : null;
    }
    /**
     * Set PriceListId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceListId
     * @return \patest\StructType\Ticketing_PriceListShowDistribution
     */
    public function setPriceListId($priceListId = null)
    {
        // validation for constraint: string
        if (!is_null($priceListId) && !is_string($priceListId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceListId, true), gettype($priceListId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceListId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceListId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceListId, true)), __LINE__);
        }
        if (is_null($priceListId) || (is_array($priceListId) && empty($priceListId))) {
            unset($this->PriceListId);
        } else {
            $this->PriceListId = $priceListId;
        }
        return $this;
    }
    /**
     * Get SeriesIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SeriesIds|null
     */
    public function getSeriesIds()
    {
        return isset($this->SeriesIds) ? $this->SeriesIds : null;
    }
    /**
     * Set SeriesIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SeriesIds $seriesIds
     * @return \patest\StructType\Ticketing_PriceListShowDistribution
     */
    public function setSeriesIds(\patest\StructType\SeriesIds $seriesIds = null)
    {
        if (is_null($seriesIds) || (is_array($seriesIds) && empty($seriesIds))) {
            unset($this->SeriesIds);
        } else {
            $this->SeriesIds = $seriesIds;
        }
        return $this;
    }
    /**
     * Get ValidationErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidationErrors()
    {
        return isset($this->ValidationErrors) ? $this->ValidationErrors : null;
    }
    /**
     * Set ValidationErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validationErrors
     * @return \patest\StructType\Ticketing_PriceListShowDistribution
     */
    public function setValidationErrors($validationErrors = null)
    {
        // validation for constraint: string
        if (!is_null($validationErrors) && !is_string($validationErrors)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validationErrors, true), gettype($validationErrors)), __LINE__);
        }
        if (is_null($validationErrors) || (is_array($validationErrors) && empty($validationErrors))) {
            unset($this->ValidationErrors);
        } else {
            $this->ValidationErrors = $validationErrors;
        }
        return $this;
    }
}
