<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.Presale StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Ticketing.Presale
 * @subpackage Structs
 */
class Ticketing_Presale extends DistributableEntity
{
    /**
     * The AccessCodeMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $AccessCodeMode;
    /**
     * The AccessCodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_AccessCode
     */
    public $AccessCodes;
    /**
     * The AccessCodesCount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AccessCodesCount;
    /**
     * The AccessCreditCardTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AccessCreditCardTypeIds
     */
    public $AccessCreditCardTypeIds;
    /**
     * The AccessCreditCompanyId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessCreditCompanyId;
    /**
     * The AllocationTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AllocationTypeIds
     */
    public $AllocationTypeIds;
    /**
     * The AllowAdvertisingOnSeatGeek
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowAdvertisingOnSeatGeek;
    /**
     * The ClientTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ClientTypeIds
     */
    public $ClientTypeIds;
    /**
     * The DisplayDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $DisplayDescription;
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $DisplayName;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The EndDateUTC
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndDateUTC;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The IconUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IconUrl;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsCodeTextSecret
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsCodeTextSecret;
    /**
     * The MaxTicketsPerAccessCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxTicketsPerAccessCode;
    /**
     * The MaxTicketsPerCustomer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxTicketsPerCustomer;
    /**
     * The MaxTransactionsPerAccessCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $MaxTransactionsPerAccessCode;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The OverrideId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OverrideId;
    /**
     * The PaymentCorrelation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $PaymentCorrelation;
    /**
     * The PaymentCreditCardTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PaymentCreditCardTypeIds
     */
    public $PaymentCreditCardTypeIds;
    /**
     * The PaymentCreditCompanyId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentCreditCompanyId;
    /**
     * The PaymentMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $PaymentMode;
    /**
     * The PriceTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PriceTypeIds
     */
    public $PriceTypeIds;
    /**
     * The RankWeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RankWeight;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * The ShowId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowId;
    /**
     * The ShowTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowTypeId;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The StartDateUTC
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartDateUTC;
    /**
     * The TestClientTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TestClientTypeId;
    /**
     * The VisibilityEndDateUTC
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VisibilityEndDateUTC;
    /**
     * The VisibilityStart
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RelativeTime
     */
    public $VisibilityStart;
    /**
     * The VisibilityStartDateUTC
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VisibilityStartDateUTC;
    /**
     * The WrongCardMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WrongCardMessage;
    /**
     * Constructor method for Ticketing.Presale
     * @uses Ticketing_Presale::setAccessCodeMode()
     * @uses Ticketing_Presale::setAccessCodes()
     * @uses Ticketing_Presale::setAccessCodesCount()
     * @uses Ticketing_Presale::setAccessCreditCardTypeIds()
     * @uses Ticketing_Presale::setAccessCreditCompanyId()
     * @uses Ticketing_Presale::setAllocationTypeIds()
     * @uses Ticketing_Presale::setAllowAdvertisingOnSeatGeek()
     * @uses Ticketing_Presale::setClientTypeIds()
     * @uses Ticketing_Presale::setDisplayDescription()
     * @uses Ticketing_Presale::setDisplayName()
     * @uses Ticketing_Presale::setEndDate()
     * @uses Ticketing_Presale::setEndDateUTC()
     * @uses Ticketing_Presale::setEventId()
     * @uses Ticketing_Presale::setIconUrl()
     * @uses Ticketing_Presale::setIsActive()
     * @uses Ticketing_Presale::setIsCodeTextSecret()
     * @uses Ticketing_Presale::setMaxTicketsPerAccessCode()
     * @uses Ticketing_Presale::setMaxTicketsPerCustomer()
     * @uses Ticketing_Presale::setMaxTransactionsPerAccessCode()
     * @uses Ticketing_Presale::setName()
     * @uses Ticketing_Presale::setOverrideId()
     * @uses Ticketing_Presale::setPaymentCorrelation()
     * @uses Ticketing_Presale::setPaymentCreditCardTypeIds()
     * @uses Ticketing_Presale::setPaymentCreditCompanyId()
     * @uses Ticketing_Presale::setPaymentMode()
     * @uses Ticketing_Presale::setPriceTypeIds()
     * @uses Ticketing_Presale::setRankWeight()
     * @uses Ticketing_Presale::setSeriesId()
     * @uses Ticketing_Presale::setShowId()
     * @uses Ticketing_Presale::setShowTypeId()
     * @uses Ticketing_Presale::setStartDate()
     * @uses Ticketing_Presale::setStartDateUTC()
     * @uses Ticketing_Presale::setTestClientTypeId()
     * @uses Ticketing_Presale::setVisibilityEndDateUTC()
     * @uses Ticketing_Presale::setVisibilityStart()
     * @uses Ticketing_Presale::setVisibilityStartDateUTC()
     * @uses Ticketing_Presale::setWrongCardMessage()
     * @param string[] $accessCodeMode
     * @param \patest\StructType\RecordSetOfTicketing_AccessCode $accessCodes
     * @param int $accessCodesCount
     * @param \patest\StructType\AccessCreditCardTypeIds $accessCreditCardTypeIds
     * @param string $accessCreditCompanyId
     * @param \patest\StructType\AllocationTypeIds $allocationTypeIds
     * @param bool $allowAdvertisingOnSeatGeek
     * @param \patest\StructType\ClientTypeIds $clientTypeIds
     * @param \patest\StructType\GlobalString $displayDescription
     * @param \patest\StructType\GlobalString $displayName
     * @param string $endDate
     * @param string $endDateUTC
     * @param string $eventId
     * @param string $iconUrl
     * @param bool $isActive
     * @param bool $isCodeTextSecret
     * @param int $maxTicketsPerAccessCode
     * @param int $maxTicketsPerCustomer
     * @param string[] $maxTransactionsPerAccessCode
     * @param \patest\StructType\GlobalString $name
     * @param string $overrideId
     * @param string[] $paymentCorrelation
     * @param \patest\StructType\PaymentCreditCardTypeIds $paymentCreditCardTypeIds
     * @param string $paymentCreditCompanyId
     * @param string[] $paymentMode
     * @param \patest\StructType\PriceTypeIds $priceTypeIds
     * @param int $rankWeight
     * @param string $seriesId
     * @param string $showId
     * @param string $showTypeId
     * @param string $startDate
     * @param string $startDateUTC
     * @param string $testClientTypeId
     * @param string $visibilityEndDateUTC
     * @param \patest\StructType\RelativeTime $visibilityStart
     * @param string $visibilityStartDateUTC
     * @param string $wrongCardMessage
     */
    public function __construct(array $accessCodeMode = array(), \patest\StructType\RecordSetOfTicketing_AccessCode $accessCodes = null, $accessCodesCount = null, \patest\StructType\AccessCreditCardTypeIds $accessCreditCardTypeIds = null, $accessCreditCompanyId = null, \patest\StructType\AllocationTypeIds $allocationTypeIds = null, $allowAdvertisingOnSeatGeek = null, \patest\StructType\ClientTypeIds $clientTypeIds = null, \patest\StructType\GlobalString $displayDescription = null, \patest\StructType\GlobalString $displayName = null, $endDate = null, $endDateUTC = null, $eventId = null, $iconUrl = null, $isActive = null, $isCodeTextSecret = null, $maxTicketsPerAccessCode = null, $maxTicketsPerCustomer = null, array $maxTransactionsPerAccessCode = array(), \patest\StructType\GlobalString $name = null, $overrideId = null, array $paymentCorrelation = array(), \patest\StructType\PaymentCreditCardTypeIds $paymentCreditCardTypeIds = null, $paymentCreditCompanyId = null, array $paymentMode = array(), \patest\StructType\PriceTypeIds $priceTypeIds = null, $rankWeight = null, $seriesId = null, $showId = null, $showTypeId = null, $startDate = null, $startDateUTC = null, $testClientTypeId = null, $visibilityEndDateUTC = null, \patest\StructType\RelativeTime $visibilityStart = null, $visibilityStartDateUTC = null, $wrongCardMessage = null)
    {
        $this
            ->setAccessCodeMode($accessCodeMode)
            ->setAccessCodes($accessCodes)
            ->setAccessCodesCount($accessCodesCount)
            ->setAccessCreditCardTypeIds($accessCreditCardTypeIds)
            ->setAccessCreditCompanyId($accessCreditCompanyId)
            ->setAllocationTypeIds($allocationTypeIds)
            ->setAllowAdvertisingOnSeatGeek($allowAdvertisingOnSeatGeek)
            ->setClientTypeIds($clientTypeIds)
            ->setDisplayDescription($displayDescription)
            ->setDisplayName($displayName)
            ->setEndDate($endDate)
            ->setEndDateUTC($endDateUTC)
            ->setEventId($eventId)
            ->setIconUrl($iconUrl)
            ->setIsActive($isActive)
            ->setIsCodeTextSecret($isCodeTextSecret)
            ->setMaxTicketsPerAccessCode($maxTicketsPerAccessCode)
            ->setMaxTicketsPerCustomer($maxTicketsPerCustomer)
            ->setMaxTransactionsPerAccessCode($maxTransactionsPerAccessCode)
            ->setName($name)
            ->setOverrideId($overrideId)
            ->setPaymentCorrelation($paymentCorrelation)
            ->setPaymentCreditCardTypeIds($paymentCreditCardTypeIds)
            ->setPaymentCreditCompanyId($paymentCreditCompanyId)
            ->setPaymentMode($paymentMode)
            ->setPriceTypeIds($priceTypeIds)
            ->setRankWeight($rankWeight)
            ->setSeriesId($seriesId)
            ->setShowId($showId)
            ->setShowTypeId($showTypeId)
            ->setStartDate($startDate)
            ->setStartDateUTC($startDateUTC)
            ->setTestClientTypeId($testClientTypeId)
            ->setVisibilityEndDateUTC($visibilityEndDateUTC)
            ->setVisibilityStart($visibilityStart)
            ->setVisibilityStartDateUTC($visibilityStartDateUTC)
            ->setWrongCardMessage($wrongCardMessage);
    }
    /**
     * Get AccessCodeMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAccessCodeMode()
    {
        return isset($this->AccessCodeMode) ? $this->AccessCodeMode : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAccessCodeMode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccessCodeMode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccessCodeModeForArrayConstraintsFromSetAccessCodeMode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ticketing_PresaleAccessCodeModeItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\AccessCodeScheme::valueIsValid($ticketing_PresaleAccessCodeModeItem)) {
                $invalidValues[] = is_object($ticketing_PresaleAccessCodeModeItem) ? get_class($ticketing_PresaleAccessCodeModeItem) : sprintf('%s(%s)', gettype($ticketing_PresaleAccessCodeModeItem), var_export($ticketing_PresaleAccessCodeModeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AccessCodeScheme', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\AccessCodeScheme::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AccessCodeMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AccessCodeScheme::valueIsValid()
     * @uses \patest\EnumType\AccessCodeScheme::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $accessCodeMode
     * @return \patest\StructType\Ticketing_Presale
     */
    public function setAccessCodeMode(array $accessCodeMode = array())
    {
        // validation for constraint: list
        if ('' !== ($accessCodeModeArrayErrorMessage = self::validateAccessCodeModeForArrayConstraintsFromSetAccessCodeMode($accessCodeMode))) {
            throw new \InvalidArgumentException($accessCodeModeArrayErrorMessage, __LINE__);
        }
        if (is_null($accessCodeMode) || (is_array($accessCodeMode) && empty($accessCodeMode))) {
            unset($this->AccessCodeMode);
        } else {
            $this->AccessCodeMode = is_array($accessCodeMode) ? implode(' ', $accessCodeMode) : null;
        }
        return $this;
    }
    /**
     * Get AccessCodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_AccessCode|null
     */
    public function getAccessCodes()
    {
        return isset($this->AccessCodes) ? $this->AccessCodes : null;
    }
    /**
     * Set AccessCodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_AccessCode $accessCodes
     * @return \patest\StructType\Ticketing_Presale
     */
    public function setAccessCodes(\patest\StructType\RecordSetOfTicketing_AccessCode $accessCodes = null)
    {
        if (is_null($accessCodes) || (is_array($accessCodes) && empty($accessCodes))) {
            unset($this->AccessCodes);
        } else {
            $this->AccessCodes = $accessCodes;
        }
        return $this;
    }
    /**
     * Get AccessCodesCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAccessCodesCount()
    {
        return isset($this->AccessCodesCount) ? $this->AccessCodesCount : null;
    }
    /**
     * Set AccessCodesCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $accessCodesCount
     * @return \patest\StructType\Ticketing_Presale
     */
    public function setAccessCodesCount($accessCodesCount = null)
    {
        // validation for constraint: int
        if (!is_null($accessCodesCount) && !(is_int($accessCodesCount) || ctype_digit($accessCodesCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accessCodesCount, true), gettype($accessCodesCount)), __LINE__);
        }
        if (is_null($accessCodesCount) || (is_array($accessCodesCount) && empty($accessCodesCount))) {
            unset($this->AccessCodesCount);
        } else {
            $this->AccessCodesCount = $accessCodesCount;
        }
        return $this;
    }
    /**
     * Get AccessCreditCardTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AccessCreditCardTypeIds|null
     */
    public function getAccessCreditCardTypeIds()
    {
        return isset($this->AccessCreditCardTypeIds) ? $this->AccessCreditCardTypeIds : null;
    }
    /**
     * Set AccessCreditCardTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AccessCreditCardTypeIds $accessCreditCardTypeIds
     * @return \patest\StructType\Ticketing_Presale
     */
    public function setAccessCreditCardTypeIds(\patest\StructType\AccessCreditCardTypeIds $accessCreditCardTypeIds = null)
    {
        if (is_null($accessCreditCardTypeIds) || (is_array($accessCreditCardTypeIds) && empty($accessCreditCardTypeIds))) {
            unset($this->AccessCreditCardTypeIds);
        } else {
            $this->AccessCreditCardTypeIds = $accessCreditCardTypeIds;
        }
        return $this;
    }
    /**
     * Get AccessCreditCompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessCreditCompanyId()
    {
        return isset($this->AccessCreditCompanyId) ? $this->AccessCreditCompanyId : null;
    }
    /**
     * Set AccessCreditCompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessCreditCompanyId
     * @return \patest\StructType\Ticketing_Presale
     */
    public function setAccessCreditCompanyId($accessCreditCompanyId = null)
    {
        // validation for constraint: string
        if (!is_null($accessCreditCompanyId) && !is_string($accessCreditCompanyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessCreditCompanyId, true), gettype($accessCreditCompanyId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessCreditCompanyId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessCreditCompanyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessCreditCompanyId, true)), __LINE__);
        }
        if (is_null($accessCreditCompanyId) || (is_array($accessCreditCompanyId) && empty($accessCreditCompanyId))) {
            unset($this->AccessCreditCompanyId);
        } else {
            $this->AccessCreditCompanyId = $accessCreditCompanyId;
        }
        return $this;
    }
    /**
     * Get AllocationTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AllocationTypeIds|null
     */
    public function getAllocationTypeIds()
    {
        return isset($this->AllocationTypeIds) ? $this->AllocationTypeIds : null;
    }
    /**
     * Set AllocationTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AllocationTypeIds $allocationTypeIds
     * @return \patest\StructType\Ticketing_Presale
     */
    public function setAllocationTypeIds(\patest\StructType\AllocationTypeIds $allocationTypeIds = null)
    {
        if (is_null($allocationTypeIds) || (is_array($allocationTypeIds) && empty($allocationTypeIds))) {
            unset($this->AllocationTypeIds);
        } else {
            $this->AllocationTypeIds = $allocationTypeIds;
        }
        return $this;
    }
    /**
     * Get AllowAdvertisingOnSeatGeek value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowAdvertisingOnSeatGeek()
    {
        return isset($this->AllowAdvertisingOnSeatGeek) ? $this->AllowAdvertisingOnSeatGeek : null;
    }
    /**
     * Set AllowAdvertisingOnSeatGeek value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowAdvertisingOnSeatGeek
     * @return \patest\StructType\Ticketing_Presale
     */
    public function setAllowAdvertisingOnSeatGeek($allowAdvertisingOnSeatGeek = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowAdvertisingOnSeatGeek) && !is_bool($allowAdvertisingOnSeatGeek)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowAdvertisingOnSeatGeek, true), gettype($allowAdvertisingOnSeatGeek)), __LINE__);
        }
        if (is_null($allowAdvertisingOnSeatGeek) || (is_array($allowAdvertisingOnSeatGeek) && empty($allowAdvertisingOnSeatGeek))) {
            unset($this->AllowAdvertisingOnSeatGeek);
        } else {
            $this->AllowAdvertisingOnSeatGeek = $allowAdvertisingOnSeatGeek;
        }
        return $this;
    }
    /**
     * Get ClientTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ClientTypeIds|null
     */
    public function getClientTypeIds()
    {
        return isset($this->ClientTypeIds) ? $this->ClientTypeIds : null;
    }
    /**
     * Set ClientTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ClientTypeIds $clientTypeIds
     * @return \patest\StructType\Ticketing_Presale
     */
    public function setClientTypeIds(\patest\StructType\ClientTypeIds $clientTypeIds = null)
    {
        if (is_null($clientTypeIds) || (is_array($clientTypeIds) && empty($clientTypeIds))) {
            unset($this->ClientTypeIds);
        } else {
            $this->ClientTypeIds = $clientTypeIds;
        }
        return $this;
    }
    /**
     * Get DisplayDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDisplayDescription()
    {
        return isset($this->DisplayDescription) ? $this->DisplayDescription : null;
    }
    /**
     * Set DisplayDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $displayDescription
     * @return \patest\StructType\Ticketing_Presale
     */
    public function setDisplayDescription(\patest\StructType\GlobalString $displayDescription = null)
    {
        if (is_null($displayDescription) || (is_array($displayDescription) && empty($displayDescription))) {
            unset($this->DisplayDescription);
        } else {
            $this->DisplayDescription = $displayDescription;
        }
        return $this;
    }
    /**
     * Get DisplayName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDisplayName()
    {
        return isset($this->DisplayName) ? $this->DisplayName : null;
    }
    /**
     * Set DisplayName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $displayName
     * @return \patest\StructType\Ticketing_Presale
     */
    public function setDisplayName(\patest\StructType\GlobalString $displayName = null)
    {
        if (is_null($displayName) || (is_array($displayName) && empty($displayName))) {
            unset($this->DisplayName);
        } else {
            $this->DisplayName = $displayName;
        }
        return $this;
    }
    /**
     * Get EndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndDate()
    {
        return isset($this->EndDate) ? $this->EndDate : null;
    }
    /**
     * Set EndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endDate
     * @return \patest\StructType\Ticketing_Presale
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        if (is_null($endDate) || (is_array($endDate) && empty($endDate))) {
            unset($this->EndDate);
        } else {
            $this->EndDate = $endDate;
        }
        return $this;
    }
    /**
     * Get EndDateUTC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndDateUTC()
    {
        return isset($this->EndDateUTC) ? $this->EndDateUTC : null;
    }
    /**
     * Set EndDateUTC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endDateUTC
     * @return \patest\StructType\Ticketing_Presale
     */
    public function setEndDateUTC($endDateUTC = null)
    {
        // validation for constraint: string
        if (!is_null($endDateUTC) && !is_string($endDateUTC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDateUTC, true), gettype($endDateUTC)), __LINE__);
        }
        if (is_null($endDateUTC) || (is_array($endDateUTC) && empty($endDateUTC))) {
            unset($this->EndDateUTC);
        } else {
            $this->EndDateUTC = $endDateUTC;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\Ticketing_Presale
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get IconUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIconUrl()
    {
        return isset($this->IconUrl) ? $this->IconUrl : null;
    }
    /**
     * Set IconUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iconUrl
     * @return \patest\StructType\Ticketing_Presale
     */
    public function setIconUrl($iconUrl = null)
    {
        // validation for constraint: string
        if (!is_null($iconUrl) && !is_string($iconUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iconUrl, true), gettype($iconUrl)), __LINE__);
        }
        if (is_null($iconUrl) || (is_array($iconUrl) && empty($iconUrl))) {
            unset($this->IconUrl);
        } else {
            $this->IconUrl = $iconUrl;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Ticketing_Presale
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsCodeTextSecret value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsCodeTextSecret()
    {
        return isset($this->IsCodeTextSecret) ? $this->IsCodeTextSecret : null;
    }
    /**
     * Set IsCodeTextSecret value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isCodeTextSecret
     * @return \patest\StructType\Ticketing_Presale
     */
    public function setIsCodeTextSecret($isCodeTextSecret = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCodeTextSecret) && !is_bool($isCodeTextSecret)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCodeTextSecret, true), gettype($isCodeTextSecret)), __LINE__);
        }
        if (is_null($isCodeTextSecret) || (is_array($isCodeTextSecret) && empty($isCodeTextSecret))) {
            unset($this->IsCodeTextSecret);
        } else {
            $this->IsCodeTextSecret = $isCodeTextSecret;
        }
        return $this;
    }
    /**
     * Get MaxTicketsPerAccessCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxTicketsPerAccessCode()
    {
        return isset($this->MaxTicketsPerAccessCode) ? $this->MaxTicketsPerAccessCode : null;
    }
    /**
     * Set MaxTicketsPerAccessCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxTicketsPerAccessCode
     * @return \patest\StructType\Ticketing_Presale
     */
    public function setMaxTicketsPerAccessCode($maxTicketsPerAccessCode = null)
    {
        // validation for constraint: int
        if (!is_null($maxTicketsPerAccessCode) && !(is_int($maxTicketsPerAccessCode) || ctype_digit($maxTicketsPerAccessCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxTicketsPerAccessCode, true), gettype($maxTicketsPerAccessCode)), __LINE__);
        }
        if (is_null($maxTicketsPerAccessCode) || (is_array($maxTicketsPerAccessCode) && empty($maxTicketsPerAccessCode))) {
            unset($this->MaxTicketsPerAccessCode);
        } else {
            $this->MaxTicketsPerAccessCode = $maxTicketsPerAccessCode;
        }
        return $this;
    }
    /**
     * Get MaxTicketsPerCustomer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxTicketsPerCustomer()
    {
        return isset($this->MaxTicketsPerCustomer) ? $this->MaxTicketsPerCustomer : null;
    }
    /**
     * Set MaxTicketsPerCustomer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxTicketsPerCustomer
     * @return \patest\StructType\Ticketing_Presale
     */
    public function setMaxTicketsPerCustomer($maxTicketsPerCustomer = null)
    {
        // validation for constraint: int
        if (!is_null($maxTicketsPerCustomer) && !(is_int($maxTicketsPerCustomer) || ctype_digit($maxTicketsPerCustomer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxTicketsPerCustomer, true), gettype($maxTicketsPerCustomer)), __LINE__);
        }
        if (is_null($maxTicketsPerCustomer) || (is_array($maxTicketsPerCustomer) && empty($maxTicketsPerCustomer))) {
            unset($this->MaxTicketsPerCustomer);
        } else {
            $this->MaxTicketsPerCustomer = $maxTicketsPerCustomer;
        }
        return $this;
    }
    /**
     * Get MaxTransactionsPerAccessCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getMaxTransactionsPerAccessCode()
    {
        return isset($this->MaxTransactionsPerAccessCode) ? $this->MaxTransactionsPerAccessCode : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMaxTransactionsPerAccessCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMaxTransactionsPerAccessCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMaxTransactionsPerAccessCodeForArrayConstraintsFromSetMaxTransactionsPerAccessCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ticketing_PresaleMaxTransactionsPerAccessCodeItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\AccessCodeUsageType::valueIsValid($ticketing_PresaleMaxTransactionsPerAccessCodeItem)) {
                $invalidValues[] = is_object($ticketing_PresaleMaxTransactionsPerAccessCodeItem) ? get_class($ticketing_PresaleMaxTransactionsPerAccessCodeItem) : sprintf('%s(%s)', gettype($ticketing_PresaleMaxTransactionsPerAccessCodeItem), var_export($ticketing_PresaleMaxTransactionsPerAccessCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AccessCodeUsageType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\AccessCodeUsageType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MaxTransactionsPerAccessCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AccessCodeUsageType::valueIsValid()
     * @uses \patest\EnumType\AccessCodeUsageType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $maxTransactionsPerAccessCode
     * @return \patest\StructType\Ticketing_Presale
     */
    public function setMaxTransactionsPerAccessCode(array $maxTransactionsPerAccessCode = array())
    {
        // validation for constraint: list
        if ('' !== ($maxTransactionsPerAccessCodeArrayErrorMessage = self::validateMaxTransactionsPerAccessCodeForArrayConstraintsFromSetMaxTransactionsPerAccessCode($maxTransactionsPerAccessCode))) {
            throw new \InvalidArgumentException($maxTransactionsPerAccessCodeArrayErrorMessage, __LINE__);
        }
        if (is_null($maxTransactionsPerAccessCode) || (is_array($maxTransactionsPerAccessCode) && empty($maxTransactionsPerAccessCode))) {
            unset($this->MaxTransactionsPerAccessCode);
        } else {
            $this->MaxTransactionsPerAccessCode = is_array($maxTransactionsPerAccessCode) ? implode(' ', $maxTransactionsPerAccessCode) : null;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Ticketing_Presale
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OverrideId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOverrideId()
    {
        return isset($this->OverrideId) ? $this->OverrideId : null;
    }
    /**
     * Set OverrideId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $overrideId
     * @return \patest\StructType\Ticketing_Presale
     */
    public function setOverrideId($overrideId = null)
    {
        // validation for constraint: string
        if (!is_null($overrideId) && !is_string($overrideId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($overrideId, true), gettype($overrideId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($overrideId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $overrideId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($overrideId, true)), __LINE__);
        }
        if (is_null($overrideId) || (is_array($overrideId) && empty($overrideId))) {
            unset($this->OverrideId);
        } else {
            $this->OverrideId = $overrideId;
        }
        return $this;
    }
    /**
     * Get PaymentCorrelation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getPaymentCorrelation()
    {
        return isset($this->PaymentCorrelation) ? $this->PaymentCorrelation : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentCorrelation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentCorrelation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentCorrelationForArrayConstraintsFromSetPaymentCorrelation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ticketing_PresalePaymentCorrelationItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\PaymentCorrelationType::valueIsValid($ticketing_PresalePaymentCorrelationItem)) {
                $invalidValues[] = is_object($ticketing_PresalePaymentCorrelationItem) ? get_class($ticketing_PresalePaymentCorrelationItem) : sprintf('%s(%s)', gettype($ticketing_PresalePaymentCorrelationItem), var_export($ticketing_PresalePaymentCorrelationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentCorrelationType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\PaymentCorrelationType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentCorrelation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentCorrelationType::valueIsValid()
     * @uses \patest\EnumType\PaymentCorrelationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $paymentCorrelation
     * @return \patest\StructType\Ticketing_Presale
     */
    public function setPaymentCorrelation(array $paymentCorrelation = array())
    {
        // validation for constraint: list
        if ('' !== ($paymentCorrelationArrayErrorMessage = self::validatePaymentCorrelationForArrayConstraintsFromSetPaymentCorrelation($paymentCorrelation))) {
            throw new \InvalidArgumentException($paymentCorrelationArrayErrorMessage, __LINE__);
        }
        if (is_null($paymentCorrelation) || (is_array($paymentCorrelation) && empty($paymentCorrelation))) {
            unset($this->PaymentCorrelation);
        } else {
            $this->PaymentCorrelation = is_array($paymentCorrelation) ? implode(' ', $paymentCorrelation) : null;
        }
        return $this;
    }
    /**
     * Get PaymentCreditCardTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PaymentCreditCardTypeIds|null
     */
    public function getPaymentCreditCardTypeIds()
    {
        return isset($this->PaymentCreditCardTypeIds) ? $this->PaymentCreditCardTypeIds : null;
    }
    /**
     * Set PaymentCreditCardTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PaymentCreditCardTypeIds $paymentCreditCardTypeIds
     * @return \patest\StructType\Ticketing_Presale
     */
    public function setPaymentCreditCardTypeIds(\patest\StructType\PaymentCreditCardTypeIds $paymentCreditCardTypeIds = null)
    {
        if (is_null($paymentCreditCardTypeIds) || (is_array($paymentCreditCardTypeIds) && empty($paymentCreditCardTypeIds))) {
            unset($this->PaymentCreditCardTypeIds);
        } else {
            $this->PaymentCreditCardTypeIds = $paymentCreditCardTypeIds;
        }
        return $this;
    }
    /**
     * Get PaymentCreditCompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentCreditCompanyId()
    {
        return isset($this->PaymentCreditCompanyId) ? $this->PaymentCreditCompanyId : null;
    }
    /**
     * Set PaymentCreditCompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentCreditCompanyId
     * @return \patest\StructType\Ticketing_Presale
     */
    public function setPaymentCreditCompanyId($paymentCreditCompanyId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentCreditCompanyId) && !is_string($paymentCreditCompanyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentCreditCompanyId, true), gettype($paymentCreditCompanyId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentCreditCompanyId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentCreditCompanyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentCreditCompanyId, true)), __LINE__);
        }
        if (is_null($paymentCreditCompanyId) || (is_array($paymentCreditCompanyId) && empty($paymentCreditCompanyId))) {
            unset($this->PaymentCreditCompanyId);
        } else {
            $this->PaymentCreditCompanyId = $paymentCreditCompanyId;
        }
        return $this;
    }
    /**
     * Get PaymentMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getPaymentMode()
    {
        return isset($this->PaymentMode) ? $this->PaymentMode : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentMode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentMode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentModeForArrayConstraintsFromSetPaymentMode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ticketing_PresalePaymentModeItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\PaymentValidationScheme::valueIsValid($ticketing_PresalePaymentModeItem)) {
                $invalidValues[] = is_object($ticketing_PresalePaymentModeItem) ? get_class($ticketing_PresalePaymentModeItem) : sprintf('%s(%s)', gettype($ticketing_PresalePaymentModeItem), var_export($ticketing_PresalePaymentModeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentValidationScheme', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\PaymentValidationScheme::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentValidationScheme::valueIsValid()
     * @uses \patest\EnumType\PaymentValidationScheme::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $paymentMode
     * @return \patest\StructType\Ticketing_Presale
     */
    public function setPaymentMode(array $paymentMode = array())
    {
        // validation for constraint: list
        if ('' !== ($paymentModeArrayErrorMessage = self::validatePaymentModeForArrayConstraintsFromSetPaymentMode($paymentMode))) {
            throw new \InvalidArgumentException($paymentModeArrayErrorMessage, __LINE__);
        }
        if (is_null($paymentMode) || (is_array($paymentMode) && empty($paymentMode))) {
            unset($this->PaymentMode);
        } else {
            $this->PaymentMode = is_array($paymentMode) ? implode(' ', $paymentMode) : null;
        }
        return $this;
    }
    /**
     * Get PriceTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PriceTypeIds|null
     */
    public function getPriceTypeIds()
    {
        return isset($this->PriceTypeIds) ? $this->PriceTypeIds : null;
    }
    /**
     * Set PriceTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PriceTypeIds $priceTypeIds
     * @return \patest\StructType\Ticketing_Presale
     */
    public function setPriceTypeIds(\patest\StructType\PriceTypeIds $priceTypeIds = null)
    {
        if (is_null($priceTypeIds) || (is_array($priceTypeIds) && empty($priceTypeIds))) {
            unset($this->PriceTypeIds);
        } else {
            $this->PriceTypeIds = $priceTypeIds;
        }
        return $this;
    }
    /**
     * Get RankWeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRankWeight()
    {
        return isset($this->RankWeight) ? $this->RankWeight : null;
    }
    /**
     * Set RankWeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $rankWeight
     * @return \patest\StructType\Ticketing_Presale
     */
    public function setRankWeight($rankWeight = null)
    {
        // validation for constraint: int
        if (!is_null($rankWeight) && !(is_int($rankWeight) || ctype_digit($rankWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rankWeight, true), gettype($rankWeight)), __LINE__);
        }
        if (is_null($rankWeight) || (is_array($rankWeight) && empty($rankWeight))) {
            unset($this->RankWeight);
        } else {
            $this->RankWeight = $rankWeight;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\Ticketing_Presale
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
    /**
     * Get ShowId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowId()
    {
        return isset($this->ShowId) ? $this->ShowId : null;
    }
    /**
     * Set ShowId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showId
     * @return \patest\StructType\Ticketing_Presale
     */
    public function setShowId($showId = null)
    {
        // validation for constraint: string
        if (!is_null($showId) && !is_string($showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showId, true), gettype($showId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showId, true)), __LINE__);
        }
        if (is_null($showId) || (is_array($showId) && empty($showId))) {
            unset($this->ShowId);
        } else {
            $this->ShowId = $showId;
        }
        return $this;
    }
    /**
     * Get ShowTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowTypeId()
    {
        return isset($this->ShowTypeId) ? $this->ShowTypeId : null;
    }
    /**
     * Set ShowTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showTypeId
     * @return \patest\StructType\Ticketing_Presale
     */
    public function setShowTypeId($showTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($showTypeId) && !is_string($showTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showTypeId, true), gettype($showTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showTypeId, true)), __LINE__);
        }
        if (is_null($showTypeId) || (is_array($showTypeId) && empty($showTypeId))) {
            unset($this->ShowTypeId);
        } else {
            $this->ShowTypeId = $showTypeId;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDate()
    {
        return isset($this->StartDate) ? $this->StartDate : null;
    }
    /**
     * Set StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDate
     * @return \patest\StructType\Ticketing_Presale
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->StartDate);
        } else {
            $this->StartDate = $startDate;
        }
        return $this;
    }
    /**
     * Get StartDateUTC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDateUTC()
    {
        return isset($this->StartDateUTC) ? $this->StartDateUTC : null;
    }
    /**
     * Set StartDateUTC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDateUTC
     * @return \patest\StructType\Ticketing_Presale
     */
    public function setStartDateUTC($startDateUTC = null)
    {
        // validation for constraint: string
        if (!is_null($startDateUTC) && !is_string($startDateUTC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDateUTC, true), gettype($startDateUTC)), __LINE__);
        }
        if (is_null($startDateUTC) || (is_array($startDateUTC) && empty($startDateUTC))) {
            unset($this->StartDateUTC);
        } else {
            $this->StartDateUTC = $startDateUTC;
        }
        return $this;
    }
    /**
     * Get TestClientTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTestClientTypeId()
    {
        return isset($this->TestClientTypeId) ? $this->TestClientTypeId : null;
    }
    /**
     * Set TestClientTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $testClientTypeId
     * @return \patest\StructType\Ticketing_Presale
     */
    public function setTestClientTypeId($testClientTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($testClientTypeId) && !is_string($testClientTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($testClientTypeId, true), gettype($testClientTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($testClientTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $testClientTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($testClientTypeId, true)), __LINE__);
        }
        if (is_null($testClientTypeId) || (is_array($testClientTypeId) && empty($testClientTypeId))) {
            unset($this->TestClientTypeId);
        } else {
            $this->TestClientTypeId = $testClientTypeId;
        }
        return $this;
    }
    /**
     * Get VisibilityEndDateUTC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisibilityEndDateUTC()
    {
        return isset($this->VisibilityEndDateUTC) ? $this->VisibilityEndDateUTC : null;
    }
    /**
     * Set VisibilityEndDateUTC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visibilityEndDateUTC
     * @return \patest\StructType\Ticketing_Presale
     */
    public function setVisibilityEndDateUTC($visibilityEndDateUTC = null)
    {
        // validation for constraint: string
        if (!is_null($visibilityEndDateUTC) && !is_string($visibilityEndDateUTC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visibilityEndDateUTC, true), gettype($visibilityEndDateUTC)), __LINE__);
        }
        if (is_null($visibilityEndDateUTC) || (is_array($visibilityEndDateUTC) && empty($visibilityEndDateUTC))) {
            unset($this->VisibilityEndDateUTC);
        } else {
            $this->VisibilityEndDateUTC = $visibilityEndDateUTC;
        }
        return $this;
    }
    /**
     * Get VisibilityStart value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RelativeTime|null
     */
    public function getVisibilityStart()
    {
        return isset($this->VisibilityStart) ? $this->VisibilityStart : null;
    }
    /**
     * Set VisibilityStart value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RelativeTime $visibilityStart
     * @return \patest\StructType\Ticketing_Presale
     */
    public function setVisibilityStart(\patest\StructType\RelativeTime $visibilityStart = null)
    {
        if (is_null($visibilityStart) || (is_array($visibilityStart) && empty($visibilityStart))) {
            unset($this->VisibilityStart);
        } else {
            $this->VisibilityStart = $visibilityStart;
        }
        return $this;
    }
    /**
     * Get VisibilityStartDateUTC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisibilityStartDateUTC()
    {
        return isset($this->VisibilityStartDateUTC) ? $this->VisibilityStartDateUTC : null;
    }
    /**
     * Set VisibilityStartDateUTC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visibilityStartDateUTC
     * @return \patest\StructType\Ticketing_Presale
     */
    public function setVisibilityStartDateUTC($visibilityStartDateUTC = null)
    {
        // validation for constraint: string
        if (!is_null($visibilityStartDateUTC) && !is_string($visibilityStartDateUTC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visibilityStartDateUTC, true), gettype($visibilityStartDateUTC)), __LINE__);
        }
        if (is_null($visibilityStartDateUTC) || (is_array($visibilityStartDateUTC) && empty($visibilityStartDateUTC))) {
            unset($this->VisibilityStartDateUTC);
        } else {
            $this->VisibilityStartDateUTC = $visibilityStartDateUTC;
        }
        return $this;
    }
    /**
     * Get WrongCardMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWrongCardMessage()
    {
        return isset($this->WrongCardMessage) ? $this->WrongCardMessage : null;
    }
    /**
     * Set WrongCardMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $wrongCardMessage
     * @return \patest\StructType\Ticketing_Presale
     */
    public function setWrongCardMessage($wrongCardMessage = null)
    {
        // validation for constraint: string
        if (!is_null($wrongCardMessage) && !is_string($wrongCardMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wrongCardMessage, true), gettype($wrongCardMessage)), __LINE__);
        }
        if (is_null($wrongCardMessage) || (is_array($wrongCardMessage) && empty($wrongCardMessage))) {
            unset($this->WrongCardMessage);
        } else {
            $this->WrongCardMessage = $wrongCardMessage;
        }
        return $this;
    }
}
