<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.PerformerEvent StructType
 * @subpackage Structs
 */
class Ticketing_PerformerEvent extends PersistableEntity
{
    /**
     * The EntityType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityType;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The Ordinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Ordinal;
    /**
     * The PerformerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PerformerId;
    /**
     * The PerformerName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PerformerName;
    /**
     * The PerformerType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PerformerType;
    /**
     * The SgoPerformerId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SgoPerformerId;
    /**
     * Constructor method for Ticketing.PerformerEvent
     * @uses Ticketing_PerformerEvent::setEntityType()
     * @uses Ticketing_PerformerEvent::setEventId()
     * @uses Ticketing_PerformerEvent::setOrdinal()
     * @uses Ticketing_PerformerEvent::setPerformerId()
     * @uses Ticketing_PerformerEvent::setPerformerName()
     * @uses Ticketing_PerformerEvent::setPerformerType()
     * @uses Ticketing_PerformerEvent::setSgoPerformerId()
     * @param string $entityType
     * @param string $eventId
     * @param int $ordinal
     * @param string $performerId
     * @param string $performerName
     * @param string $performerType
     * @param int $sgoPerformerId
     */
    public function __construct($entityType = null, $eventId = null, $ordinal = null, $performerId = null, $performerName = null, $performerType = null, $sgoPerformerId = null)
    {
        $this
            ->setEntityType($entityType)
            ->setEventId($eventId)
            ->setOrdinal($ordinal)
            ->setPerformerId($performerId)
            ->setPerformerName($performerName)
            ->setPerformerType($performerType)
            ->setSgoPerformerId($sgoPerformerId);
    }
    /**
     * Get EntityType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityType()
    {
        return isset($this->EntityType) ? $this->EntityType : null;
    }
    /**
     * Set EntityType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PerformerEntityType::valueIsValid()
     * @uses \patest\EnumType\PerformerEntityType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $entityType
     * @return \patest\StructType\Ticketing_PerformerEvent
     */
    public function setEntityType($entityType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PerformerEntityType::valueIsValid($entityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PerformerEntityType', is_array($entityType) ? implode(', ', $entityType) : var_export($entityType, true), implode(', ', \patest\EnumType\PerformerEntityType::getValidValues())), __LINE__);
        }
        if (is_null($entityType) || (is_array($entityType) && empty($entityType))) {
            unset($this->EntityType);
        } else {
            $this->EntityType = $entityType;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\Ticketing_PerformerEvent
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get Ordinal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrdinal()
    {
        return isset($this->Ordinal) ? $this->Ordinal : null;
    }
    /**
     * Set Ordinal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ordinal
     * @return \patest\StructType\Ticketing_PerformerEvent
     */
    public function setOrdinal($ordinal = null)
    {
        // validation for constraint: int
        if (!is_null($ordinal) && !(is_int($ordinal) || ctype_digit($ordinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordinal, true), gettype($ordinal)), __LINE__);
        }
        if (is_null($ordinal) || (is_array($ordinal) && empty($ordinal))) {
            unset($this->Ordinal);
        } else {
            $this->Ordinal = $ordinal;
        }
        return $this;
    }
    /**
     * Get PerformerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPerformerId()
    {
        return isset($this->PerformerId) ? $this->PerformerId : null;
    }
    /**
     * Set PerformerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $performerId
     * @return \patest\StructType\Ticketing_PerformerEvent
     */
    public function setPerformerId($performerId = null)
    {
        // validation for constraint: string
        if (!is_null($performerId) && !is_string($performerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($performerId, true), gettype($performerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($performerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $performerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($performerId, true)), __LINE__);
        }
        if (is_null($performerId) || (is_array($performerId) && empty($performerId))) {
            unset($this->PerformerId);
        } else {
            $this->PerformerId = $performerId;
        }
        return $this;
    }
    /**
     * Get PerformerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPerformerName()
    {
        return isset($this->PerformerName) ? $this->PerformerName : null;
    }
    /**
     * Set PerformerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $performerName
     * @return \patest\StructType\Ticketing_PerformerEvent
     */
    public function setPerformerName($performerName = null)
    {
        // validation for constraint: string
        if (!is_null($performerName) && !is_string($performerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($performerName, true), gettype($performerName)), __LINE__);
        }
        if (is_null($performerName) || (is_array($performerName) && empty($performerName))) {
            unset($this->PerformerName);
        } else {
            $this->PerformerName = $performerName;
        }
        return $this;
    }
    /**
     * Get PerformerType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPerformerType()
    {
        return isset($this->PerformerType) ? $this->PerformerType : null;
    }
    /**
     * Set PerformerType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PerformerType::valueIsValid()
     * @uses \patest\EnumType\PerformerType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $performerType
     * @return \patest\StructType\Ticketing_PerformerEvent
     */
    public function setPerformerType($performerType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PerformerType::valueIsValid($performerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PerformerType', is_array($performerType) ? implode(', ', $performerType) : var_export($performerType, true), implode(', ', \patest\EnumType\PerformerType::getValidValues())), __LINE__);
        }
        if (is_null($performerType) || (is_array($performerType) && empty($performerType))) {
            unset($this->PerformerType);
        } else {
            $this->PerformerType = $performerType;
        }
        return $this;
    }
    /**
     * Get SgoPerformerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSgoPerformerId()
    {
        return isset($this->SgoPerformerId) ? $this->SgoPerformerId : null;
    }
    /**
     * Set SgoPerformerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $sgoPerformerId
     * @return \patest\StructType\Ticketing_PerformerEvent
     */
    public function setSgoPerformerId($sgoPerformerId = null)
    {
        // validation for constraint: int
        if (!is_null($sgoPerformerId) && !(is_int($sgoPerformerId) || ctype_digit($sgoPerformerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sgoPerformerId, true), gettype($sgoPerformerId)), __LINE__);
        }
        if (is_null($sgoPerformerId) || (is_array($sgoPerformerId) && empty($sgoPerformerId))) {
            unset($this->SgoPerformerId);
        } else {
            $this->SgoPerformerId = $sgoPerformerId;
        }
        return $this;
    }
}
