<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * Ticketing.PayUnpaidTicketsByTicketSchemeLogFulfillmentsFilter StructType
 * @subpackage Structs
 */
class Ticketing_PayUnpaidTicketsByTicketSchemeLogFulfillmentsFilter extends FilterEntity
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * The ViewErrorsOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ViewErrorsOnly;
    /**
     * Constructor method for
     * Ticketing.PayUnpaidTicketsByTicketSchemeLogFulfillmentsFilter
     * @uses Ticketing_PayUnpaidTicketsByTicketSchemeLogFulfillmentsFilter::setClientId()
     * @uses Ticketing_PayUnpaidTicketsByTicketSchemeLogFulfillmentsFilter::setState()
     * @uses Ticketing_PayUnpaidTicketsByTicketSchemeLogFulfillmentsFilter::setViewErrorsOnly()
     * @param string $clientId
     * @param string $state
     * @param bool $viewErrorsOnly
     */
    public function __construct($clientId = null, $state = null, $viewErrorsOnly = null)
    {
        $this
            ->setClientId($clientId)
            ->setState($state)
            ->setViewErrorsOnly($viewErrorsOnly);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Ticketing_PayUnpaidTicketsByTicketSchemeLogFulfillmentsFilter
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $state
     * @return \patest\StructType\Ticketing_PayUnpaidTicketsByTicketSchemeLogFulfillmentsFilter
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
    /**
     * Get ViewErrorsOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getViewErrorsOnly()
    {
        return isset($this->ViewErrorsOnly) ? $this->ViewErrorsOnly : null;
    }
    /**
     * Set ViewErrorsOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $viewErrorsOnly
     * @return \patest\StructType\Ticketing_PayUnpaidTicketsByTicketSchemeLogFulfillmentsFilter
     */
    public function setViewErrorsOnly($viewErrorsOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($viewErrorsOnly) && !is_bool($viewErrorsOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($viewErrorsOnly, true), gettype($viewErrorsOnly)), __LINE__);
        }
        if (is_null($viewErrorsOnly) || (is_array($viewErrorsOnly) && empty($viewErrorsOnly))) {
            unset($this->ViewErrorsOnly);
        } else {
            $this->ViewErrorsOnly = $viewErrorsOnly;
        }
        return $this;
    }
}
