<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.PayUnpaidTicketsByTicketSchemeLogFulfillment
 * StructType
 * @subpackage Structs
 */
class Ticketing_PayUnpaidTicketsByTicketSchemeLogFulfillment extends PersistableEntity
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The ErrorMsg
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorMsg;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The PaymentTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentTokenId;
    /**
     * The PayUnpaidTicketsByTicketSchemeLogId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PayUnpaidTicketsByTicketSchemeLogId;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * The SuccessfullyPaid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SuccessfullyPaid;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * The UnpaidTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $UnpaidTickets;
    /**
     * Constructor method for Ticketing.PayUnpaidTicketsByTicketSchemeLogFulfillment
     * @uses Ticketing_PayUnpaidTicketsByTicketSchemeLogFulfillment::setClientId()
     * @uses Ticketing_PayUnpaidTicketsByTicketSchemeLogFulfillment::setErrorMsg()
     * @uses Ticketing_PayUnpaidTicketsByTicketSchemeLogFulfillment::setPaymentMethodId()
     * @uses Ticketing_PayUnpaidTicketsByTicketSchemeLogFulfillment::setPaymentTokenId()
     * @uses Ticketing_PayUnpaidTicketsByTicketSchemeLogFulfillment::setPayUnpaidTicketsByTicketSchemeLogId()
     * @uses Ticketing_PayUnpaidTicketsByTicketSchemeLogFulfillment::setState()
     * @uses Ticketing_PayUnpaidTicketsByTicketSchemeLogFulfillment::setSuccessfullyPaid()
     * @uses Ticketing_PayUnpaidTicketsByTicketSchemeLogFulfillment::setTransactionNumber()
     * @uses Ticketing_PayUnpaidTicketsByTicketSchemeLogFulfillment::setUnpaidTickets()
     * @param string $clientId
     * @param string $errorMsg
     * @param string $paymentMethodId
     * @param string $paymentTokenId
     * @param string $payUnpaidTicketsByTicketSchemeLogId
     * @param string $state
     * @param int $successfullyPaid
     * @param int $transactionNumber
     * @param int $unpaidTickets
     */
    public function __construct($clientId = null, $errorMsg = null, $paymentMethodId = null, $paymentTokenId = null, $payUnpaidTicketsByTicketSchemeLogId = null, $state = null, $successfullyPaid = null, $transactionNumber = null, $unpaidTickets = null)
    {
        $this
            ->setClientId($clientId)
            ->setErrorMsg($errorMsg)
            ->setPaymentMethodId($paymentMethodId)
            ->setPaymentTokenId($paymentTokenId)
            ->setPayUnpaidTicketsByTicketSchemeLogId($payUnpaidTicketsByTicketSchemeLogId)
            ->setState($state)
            ->setSuccessfullyPaid($successfullyPaid)
            ->setTransactionNumber($transactionNumber)
            ->setUnpaidTickets($unpaidTickets);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Ticketing_PayUnpaidTicketsByTicketSchemeLogFulfillment
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get ErrorMsg value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorMsg()
    {
        return isset($this->ErrorMsg) ? $this->ErrorMsg : null;
    }
    /**
     * Set ErrorMsg value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorMsg
     * @return \patest\StructType\Ticketing_PayUnpaidTicketsByTicketSchemeLogFulfillment
     */
    public function setErrorMsg($errorMsg = null)
    {
        // validation for constraint: string
        if (!is_null($errorMsg) && !is_string($errorMsg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMsg, true), gettype($errorMsg)), __LINE__);
        }
        if (is_null($errorMsg) || (is_array($errorMsg) && empty($errorMsg))) {
            unset($this->ErrorMsg);
        } else {
            $this->ErrorMsg = $errorMsg;
        }
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return isset($this->PaymentMethodId) ? $this->PaymentMethodId : null;
    }
    /**
     * Set PaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodId
     * @return \patest\StructType\Ticketing_PayUnpaidTicketsByTicketSchemeLogFulfillment
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        if (is_null($paymentMethodId) || (is_array($paymentMethodId) && empty($paymentMethodId))) {
            unset($this->PaymentMethodId);
        } else {
            $this->PaymentMethodId = $paymentMethodId;
        }
        return $this;
    }
    /**
     * Get PaymentTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentTokenId()
    {
        return isset($this->PaymentTokenId) ? $this->PaymentTokenId : null;
    }
    /**
     * Set PaymentTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentTokenId
     * @return \patest\StructType\Ticketing_PayUnpaidTicketsByTicketSchemeLogFulfillment
     */
    public function setPaymentTokenId($paymentTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTokenId) && !is_string($paymentTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTokenId, true), gettype($paymentTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentTokenId, true)), __LINE__);
        }
        if (is_null($paymentTokenId) || (is_array($paymentTokenId) && empty($paymentTokenId))) {
            unset($this->PaymentTokenId);
        } else {
            $this->PaymentTokenId = $paymentTokenId;
        }
        return $this;
    }
    /**
     * Get PayUnpaidTicketsByTicketSchemeLogId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayUnpaidTicketsByTicketSchemeLogId()
    {
        return isset($this->PayUnpaidTicketsByTicketSchemeLogId) ? $this->PayUnpaidTicketsByTicketSchemeLogId : null;
    }
    /**
     * Set PayUnpaidTicketsByTicketSchemeLogId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payUnpaidTicketsByTicketSchemeLogId
     * @return \patest\StructType\Ticketing_PayUnpaidTicketsByTicketSchemeLogFulfillment
     */
    public function setPayUnpaidTicketsByTicketSchemeLogId($payUnpaidTicketsByTicketSchemeLogId = null)
    {
        // validation for constraint: string
        if (!is_null($payUnpaidTicketsByTicketSchemeLogId) && !is_string($payUnpaidTicketsByTicketSchemeLogId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payUnpaidTicketsByTicketSchemeLogId, true), gettype($payUnpaidTicketsByTicketSchemeLogId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($payUnpaidTicketsByTicketSchemeLogId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $payUnpaidTicketsByTicketSchemeLogId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($payUnpaidTicketsByTicketSchemeLogId, true)), __LINE__);
        }
        if (is_null($payUnpaidTicketsByTicketSchemeLogId) || (is_array($payUnpaidTicketsByTicketSchemeLogId) && empty($payUnpaidTicketsByTicketSchemeLogId))) {
            unset($this->PayUnpaidTicketsByTicketSchemeLogId);
        } else {
            $this->PayUnpaidTicketsByTicketSchemeLogId = $payUnpaidTicketsByTicketSchemeLogId;
        }
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\EnrollmentPayUnpaidTicketsByTicketSchemeLogStatus::valueIsValid()
     * @uses \patest\EnumType\EnrollmentPayUnpaidTicketsByTicketSchemeLogStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \patest\StructType\Ticketing_PayUnpaidTicketsByTicketSchemeLogFulfillment
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\EnrollmentPayUnpaidTicketsByTicketSchemeLogStatus::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EnrollmentPayUnpaidTicketsByTicketSchemeLogStatus', is_array($state) ? implode(', ', $state) : var_export($state, true), implode(', ', \patest\EnumType\EnrollmentPayUnpaidTicketsByTicketSchemeLogStatus::getValidValues())), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
    /**
     * Get SuccessfullyPaid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSuccessfullyPaid()
    {
        return isset($this->SuccessfullyPaid) ? $this->SuccessfullyPaid : null;
    }
    /**
     * Set SuccessfullyPaid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $successfullyPaid
     * @return \patest\StructType\Ticketing_PayUnpaidTicketsByTicketSchemeLogFulfillment
     */
    public function setSuccessfullyPaid($successfullyPaid = null)
    {
        // validation for constraint: int
        if (!is_null($successfullyPaid) && !(is_int($successfullyPaid) || ctype_digit($successfullyPaid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($successfullyPaid, true), gettype($successfullyPaid)), __LINE__);
        }
        if (is_null($successfullyPaid) || (is_array($successfullyPaid) && empty($successfullyPaid))) {
            unset($this->SuccessfullyPaid);
        } else {
            $this->SuccessfullyPaid = $successfullyPaid;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Ticketing_PayUnpaidTicketsByTicketSchemeLogFulfillment
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
    /**
     * Get UnpaidTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUnpaidTickets()
    {
        return isset($this->UnpaidTickets) ? $this->UnpaidTickets : null;
    }
    /**
     * Set UnpaidTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $unpaidTickets
     * @return \patest\StructType\Ticketing_PayUnpaidTicketsByTicketSchemeLogFulfillment
     */
    public function setUnpaidTickets($unpaidTickets = null)
    {
        // validation for constraint: int
        if (!is_null($unpaidTickets) && !(is_int($unpaidTickets) || ctype_digit($unpaidTickets))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($unpaidTickets, true), gettype($unpaidTickets)), __LINE__);
        }
        if (is_null($unpaidTickets) || (is_array($unpaidTickets) && empty($unpaidTickets))) {
            unset($this->UnpaidTickets);
        } else {
            $this->UnpaidTickets = $unpaidTickets;
        }
        return $this;
    }
}
