<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.PartyTicket StructType
 * @subpackage Structs
 */
class Ticketing_PartyTicket extends PersistableEntity
{
    /**
     * The CanAnyonePartyClaim
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanAnyonePartyClaim;
    /**
     * The CreationDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDateTime;
    /**
     * The LastUpdateDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastUpdateDateTime;
    /**
     * The OriginalTicketId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OriginalTicketId;
    /**
     * The PartyId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PartyId;
    /**
     * The SeatGeekPartyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SeatGeekPartyId;
    /**
     * The TicketId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketId;
    /**
     * Constructor method for Ticketing.PartyTicket
     * @uses Ticketing_PartyTicket::setCanAnyonePartyClaim()
     * @uses Ticketing_PartyTicket::setCreationDateTime()
     * @uses Ticketing_PartyTicket::setLastUpdateDateTime()
     * @uses Ticketing_PartyTicket::setOriginalTicketId()
     * @uses Ticketing_PartyTicket::setPartyId()
     * @uses Ticketing_PartyTicket::setSeatGeekPartyId()
     * @uses Ticketing_PartyTicket::setTicketId()
     * @param bool $canAnyonePartyClaim
     * @param string $creationDateTime
     * @param string $lastUpdateDateTime
     * @param string $originalTicketId
     * @param string $partyId
     * @param int $seatGeekPartyId
     * @param string $ticketId
     */
    public function __construct($canAnyonePartyClaim = null, $creationDateTime = null, $lastUpdateDateTime = null, $originalTicketId = null, $partyId = null, $seatGeekPartyId = null, $ticketId = null)
    {
        $this
            ->setCanAnyonePartyClaim($canAnyonePartyClaim)
            ->setCreationDateTime($creationDateTime)
            ->setLastUpdateDateTime($lastUpdateDateTime)
            ->setOriginalTicketId($originalTicketId)
            ->setPartyId($partyId)
            ->setSeatGeekPartyId($seatGeekPartyId)
            ->setTicketId($ticketId);
    }
    /**
     * Get CanAnyonePartyClaim value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanAnyonePartyClaim()
    {
        return isset($this->CanAnyonePartyClaim) ? $this->CanAnyonePartyClaim : null;
    }
    /**
     * Set CanAnyonePartyClaim value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canAnyonePartyClaim
     * @return \patest\StructType\Ticketing_PartyTicket
     */
    public function setCanAnyonePartyClaim($canAnyonePartyClaim = null)
    {
        // validation for constraint: boolean
        if (!is_null($canAnyonePartyClaim) && !is_bool($canAnyonePartyClaim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canAnyonePartyClaim, true), gettype($canAnyonePartyClaim)), __LINE__);
        }
        if (is_null($canAnyonePartyClaim) || (is_array($canAnyonePartyClaim) && empty($canAnyonePartyClaim))) {
            unset($this->CanAnyonePartyClaim);
        } else {
            $this->CanAnyonePartyClaim = $canAnyonePartyClaim;
        }
        return $this;
    }
    /**
     * Get CreationDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDateTime()
    {
        return isset($this->CreationDateTime) ? $this->CreationDateTime : null;
    }
    /**
     * Set CreationDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDateTime
     * @return \patest\StructType\Ticketing_PartyTicket
     */
    public function setCreationDateTime($creationDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($creationDateTime) && !is_string($creationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDateTime, true), gettype($creationDateTime)), __LINE__);
        }
        if (is_null($creationDateTime) || (is_array($creationDateTime) && empty($creationDateTime))) {
            unset($this->CreationDateTime);
        } else {
            $this->CreationDateTime = $creationDateTime;
        }
        return $this;
    }
    /**
     * Get LastUpdateDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastUpdateDateTime()
    {
        return isset($this->LastUpdateDateTime) ? $this->LastUpdateDateTime : null;
    }
    /**
     * Set LastUpdateDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastUpdateDateTime
     * @return \patest\StructType\Ticketing_PartyTicket
     */
    public function setLastUpdateDateTime($lastUpdateDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateDateTime) && !is_string($lastUpdateDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUpdateDateTime, true), gettype($lastUpdateDateTime)), __LINE__);
        }
        if (is_null($lastUpdateDateTime) || (is_array($lastUpdateDateTime) && empty($lastUpdateDateTime))) {
            unset($this->LastUpdateDateTime);
        } else {
            $this->LastUpdateDateTime = $lastUpdateDateTime;
        }
        return $this;
    }
    /**
     * Get OriginalTicketId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalTicketId()
    {
        return isset($this->OriginalTicketId) ? $this->OriginalTicketId : null;
    }
    /**
     * Set OriginalTicketId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalTicketId
     * @return \patest\StructType\Ticketing_PartyTicket
     */
    public function setOriginalTicketId($originalTicketId = null)
    {
        // validation for constraint: string
        if (!is_null($originalTicketId) && !is_string($originalTicketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalTicketId, true), gettype($originalTicketId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($originalTicketId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $originalTicketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($originalTicketId, true)), __LINE__);
        }
        if (is_null($originalTicketId) || (is_array($originalTicketId) && empty($originalTicketId))) {
            unset($this->OriginalTicketId);
        } else {
            $this->OriginalTicketId = $originalTicketId;
        }
        return $this;
    }
    /**
     * Get PartyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPartyId()
    {
        return isset($this->PartyId) ? $this->PartyId : null;
    }
    /**
     * Set PartyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $partyId
     * @return \patest\StructType\Ticketing_PartyTicket
     */
    public function setPartyId($partyId = null)
    {
        // validation for constraint: string
        if (!is_null($partyId) && !is_string($partyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partyId, true), gettype($partyId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($partyId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $partyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($partyId, true)), __LINE__);
        }
        if (is_null($partyId) || (is_array($partyId) && empty($partyId))) {
            unset($this->PartyId);
        } else {
            $this->PartyId = $partyId;
        }
        return $this;
    }
    /**
     * Get SeatGeekPartyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSeatGeekPartyId()
    {
        return isset($this->SeatGeekPartyId) ? $this->SeatGeekPartyId : null;
    }
    /**
     * Set SeatGeekPartyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $seatGeekPartyId
     * @return \patest\StructType\Ticketing_PartyTicket
     */
    public function setSeatGeekPartyId($seatGeekPartyId = null)
    {
        // validation for constraint: int
        if (!is_null($seatGeekPartyId) && !(is_int($seatGeekPartyId) || ctype_digit($seatGeekPartyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatGeekPartyId, true), gettype($seatGeekPartyId)), __LINE__);
        }
        if (is_null($seatGeekPartyId) || (is_array($seatGeekPartyId) && empty($seatGeekPartyId))) {
            unset($this->SeatGeekPartyId);
        } else {
            $this->SeatGeekPartyId = $seatGeekPartyId;
        }
        return $this;
    }
    /**
     * Get TicketId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketId()
    {
        return isset($this->TicketId) ? $this->TicketId : null;
    }
    /**
     * Set TicketId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketId
     * @return \patest\StructType\Ticketing_PartyTicket
     */
    public function setTicketId($ticketId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketId) && !is_string($ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketId, true), gettype($ticketId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketId, true)), __LINE__);
        }
        if (is_null($ticketId) || (is_array($ticketId) && empty($ticketId))) {
            unset($this->TicketId);
        } else {
            $this->TicketId = $ticketId;
        }
        return $this;
    }
}
