<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.Party StructType
 * @subpackage Structs
 */
class Ticketing_Party extends PersistableEntity
{
    /**
     * The CreationDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDateTime;
    /**
     * The DeletionAdminClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DeletionAdminClientId;
    /**
     * The DeletionDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeletionDateTime;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The HostClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HostClientId;
    /**
     * The LastUpdateDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastUpdateDateTime;
    /**
     * The SeatGeekLinkGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeatGeekLinkGuid;
    /**
     * The SeatGeekPartyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SeatGeekPartyId;
    /**
     * Constructor method for Ticketing.Party
     * @uses Ticketing_Party::setCreationDateTime()
     * @uses Ticketing_Party::setDeletionAdminClientId()
     * @uses Ticketing_Party::setDeletionDateTime()
     * @uses Ticketing_Party::setEventId()
     * @uses Ticketing_Party::setHostClientId()
     * @uses Ticketing_Party::setLastUpdateDateTime()
     * @uses Ticketing_Party::setSeatGeekLinkGuid()
     * @uses Ticketing_Party::setSeatGeekPartyId()
     * @param string $creationDateTime
     * @param string $deletionAdminClientId
     * @param string $deletionDateTime
     * @param string $eventId
     * @param string $hostClientId
     * @param string $lastUpdateDateTime
     * @param string $seatGeekLinkGuid
     * @param int $seatGeekPartyId
     */
    public function __construct($creationDateTime = null, $deletionAdminClientId = null, $deletionDateTime = null, $eventId = null, $hostClientId = null, $lastUpdateDateTime = null, $seatGeekLinkGuid = null, $seatGeekPartyId = null)
    {
        $this
            ->setCreationDateTime($creationDateTime)
            ->setDeletionAdminClientId($deletionAdminClientId)
            ->setDeletionDateTime($deletionDateTime)
            ->setEventId($eventId)
            ->setHostClientId($hostClientId)
            ->setLastUpdateDateTime($lastUpdateDateTime)
            ->setSeatGeekLinkGuid($seatGeekLinkGuid)
            ->setSeatGeekPartyId($seatGeekPartyId);
    }
    /**
     * Get CreationDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDateTime()
    {
        return isset($this->CreationDateTime) ? $this->CreationDateTime : null;
    }
    /**
     * Set CreationDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDateTime
     * @return \patest\StructType\Ticketing_Party
     */
    public function setCreationDateTime($creationDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($creationDateTime) && !is_string($creationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDateTime, true), gettype($creationDateTime)), __LINE__);
        }
        if (is_null($creationDateTime) || (is_array($creationDateTime) && empty($creationDateTime))) {
            unset($this->CreationDateTime);
        } else {
            $this->CreationDateTime = $creationDateTime;
        }
        return $this;
    }
    /**
     * Get DeletionAdminClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeletionAdminClientId()
    {
        return isset($this->DeletionAdminClientId) ? $this->DeletionAdminClientId : null;
    }
    /**
     * Set DeletionAdminClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deletionAdminClientId
     * @return \patest\StructType\Ticketing_Party
     */
    public function setDeletionAdminClientId($deletionAdminClientId = null)
    {
        // validation for constraint: string
        if (!is_null($deletionAdminClientId) && !is_string($deletionAdminClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deletionAdminClientId, true), gettype($deletionAdminClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($deletionAdminClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $deletionAdminClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($deletionAdminClientId, true)), __LINE__);
        }
        if (is_null($deletionAdminClientId) || (is_array($deletionAdminClientId) && empty($deletionAdminClientId))) {
            unset($this->DeletionAdminClientId);
        } else {
            $this->DeletionAdminClientId = $deletionAdminClientId;
        }
        return $this;
    }
    /**
     * Get DeletionDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeletionDateTime()
    {
        return isset($this->DeletionDateTime) ? $this->DeletionDateTime : null;
    }
    /**
     * Set DeletionDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deletionDateTime
     * @return \patest\StructType\Ticketing_Party
     */
    public function setDeletionDateTime($deletionDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($deletionDateTime) && !is_string($deletionDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deletionDateTime, true), gettype($deletionDateTime)), __LINE__);
        }
        if (is_null($deletionDateTime) || (is_array($deletionDateTime) && empty($deletionDateTime))) {
            unset($this->DeletionDateTime);
        } else {
            $this->DeletionDateTime = $deletionDateTime;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\Ticketing_Party
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get HostClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHostClientId()
    {
        return isset($this->HostClientId) ? $this->HostClientId : null;
    }
    /**
     * Set HostClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hostClientId
     * @return \patest\StructType\Ticketing_Party
     */
    public function setHostClientId($hostClientId = null)
    {
        // validation for constraint: string
        if (!is_null($hostClientId) && !is_string($hostClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hostClientId, true), gettype($hostClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hostClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hostClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hostClientId, true)), __LINE__);
        }
        if (is_null($hostClientId) || (is_array($hostClientId) && empty($hostClientId))) {
            unset($this->HostClientId);
        } else {
            $this->HostClientId = $hostClientId;
        }
        return $this;
    }
    /**
     * Get LastUpdateDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastUpdateDateTime()
    {
        return isset($this->LastUpdateDateTime) ? $this->LastUpdateDateTime : null;
    }
    /**
     * Set LastUpdateDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastUpdateDateTime
     * @return \patest\StructType\Ticketing_Party
     */
    public function setLastUpdateDateTime($lastUpdateDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateDateTime) && !is_string($lastUpdateDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUpdateDateTime, true), gettype($lastUpdateDateTime)), __LINE__);
        }
        if (is_null($lastUpdateDateTime) || (is_array($lastUpdateDateTime) && empty($lastUpdateDateTime))) {
            unset($this->LastUpdateDateTime);
        } else {
            $this->LastUpdateDateTime = $lastUpdateDateTime;
        }
        return $this;
    }
    /**
     * Get SeatGeekLinkGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatGeekLinkGuid()
    {
        return isset($this->SeatGeekLinkGuid) ? $this->SeatGeekLinkGuid : null;
    }
    /**
     * Set SeatGeekLinkGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatGeekLinkGuid
     * @return \patest\StructType\Ticketing_Party
     */
    public function setSeatGeekLinkGuid($seatGeekLinkGuid = null)
    {
        // validation for constraint: string
        if (!is_null($seatGeekLinkGuid) && !is_string($seatGeekLinkGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatGeekLinkGuid, true), gettype($seatGeekLinkGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seatGeekLinkGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seatGeekLinkGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seatGeekLinkGuid, true)), __LINE__);
        }
        if (is_null($seatGeekLinkGuid) || (is_array($seatGeekLinkGuid) && empty($seatGeekLinkGuid))) {
            unset($this->SeatGeekLinkGuid);
        } else {
            $this->SeatGeekLinkGuid = $seatGeekLinkGuid;
        }
        return $this;
    }
    /**
     * Get SeatGeekPartyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSeatGeekPartyId()
    {
        return isset($this->SeatGeekPartyId) ? $this->SeatGeekPartyId : null;
    }
    /**
     * Set SeatGeekPartyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $seatGeekPartyId
     * @return \patest\StructType\Ticketing_Party
     */
    public function setSeatGeekPartyId($seatGeekPartyId = null)
    {
        // validation for constraint: int
        if (!is_null($seatGeekPartyId) && !(is_int($seatGeekPartyId) || ctype_digit($seatGeekPartyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatGeekPartyId, true), gettype($seatGeekPartyId)), __LINE__);
        }
        if (is_null($seatGeekPartyId) || (is_array($seatGeekPartyId) && empty($seatGeekPartyId))) {
            unset($this->SeatGeekPartyId);
        } else {
            $this->SeatGeekPartyId = $seatGeekPartyId;
        }
        return $this;
    }
}
