<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.MoveAudienceAudit StructType
 * @subpackage Structs
 */
class Ticketing_MoveAudienceAudit extends DistributableEntity
{
    /**
     * The ClientDisplayName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientDisplayName;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The DateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateTime;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The OwnerDisplayName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OwnerDisplayName;
    /**
     * The OwnerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OwnerId;
    /**
     * The SourceAllocationsIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SourceAllocationsIds;
    /**
     * The SourceAreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SourceAreaId;
    /**
     * The SourceAreaName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SourceAreaName;
    /**
     * The SourceEventDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SourceEventDate;
    /**
     * The SourceEventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SourceEventId;
    /**
     * The SourceEventName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SourceEventName;
    /**
     * The SourceEventNameAndDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SourceEventNameAndDate;
    /**
     * The SourceHallName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SourceHallName;
    /**
     * The SourceLockId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SourceLockId;
    /**
     * The SourcePriceLevelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SourcePriceLevelId;
    /**
     * The SourceSeatId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SourceSeatId;
    /**
     * The SourceSeatNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SourceSeatNumber;
    /**
     * The SourceSeatRow
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SourceSeatRow;
    /**
     * The TargetAllocationsIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TargetAllocationsIds;
    /**
     * The TargetAreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetAreaId;
    /**
     * The TargetAreaName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $TargetAreaName;
    /**
     * The TargetEventDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TargetEventDate;
    /**
     * The TargetEventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetEventId;
    /**
     * The TargetEventName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $TargetEventName;
    /**
     * The TargetEventNameAndDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TargetEventNameAndDate;
    /**
     * The TargetHallName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $TargetHallName;
    /**
     * The TargetLockId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetLockId;
    /**
     * The TargetPriceLevelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetPriceLevelId;
    /**
     * The TargetSeatId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TargetSeatId;
    /**
     * The TargetSeatNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TargetSeatNumber;
    /**
     * The TargetSeatRow
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TargetSeatRow;
    /**
     * The TicketId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketId;
    /**
     * The TransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionId;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserName;
    /**
     * Constructor method for Ticketing.MoveAudienceAudit
     * @uses Ticketing_MoveAudienceAudit::setClientDisplayName()
     * @uses Ticketing_MoveAudienceAudit::setClientId()
     * @uses Ticketing_MoveAudienceAudit::setDateTime()
     * @uses Ticketing_MoveAudienceAudit::setOrganizationUnitId()
     * @uses Ticketing_MoveAudienceAudit::setOwnerDisplayName()
     * @uses Ticketing_MoveAudienceAudit::setOwnerId()
     * @uses Ticketing_MoveAudienceAudit::setSourceAllocationsIds()
     * @uses Ticketing_MoveAudienceAudit::setSourceAreaId()
     * @uses Ticketing_MoveAudienceAudit::setSourceAreaName()
     * @uses Ticketing_MoveAudienceAudit::setSourceEventDate()
     * @uses Ticketing_MoveAudienceAudit::setSourceEventId()
     * @uses Ticketing_MoveAudienceAudit::setSourceEventName()
     * @uses Ticketing_MoveAudienceAudit::setSourceEventNameAndDate()
     * @uses Ticketing_MoveAudienceAudit::setSourceHallName()
     * @uses Ticketing_MoveAudienceAudit::setSourceLockId()
     * @uses Ticketing_MoveAudienceAudit::setSourcePriceLevelId()
     * @uses Ticketing_MoveAudienceAudit::setSourceSeatId()
     * @uses Ticketing_MoveAudienceAudit::setSourceSeatNumber()
     * @uses Ticketing_MoveAudienceAudit::setSourceSeatRow()
     * @uses Ticketing_MoveAudienceAudit::setTargetAllocationsIds()
     * @uses Ticketing_MoveAudienceAudit::setTargetAreaId()
     * @uses Ticketing_MoveAudienceAudit::setTargetAreaName()
     * @uses Ticketing_MoveAudienceAudit::setTargetEventDate()
     * @uses Ticketing_MoveAudienceAudit::setTargetEventId()
     * @uses Ticketing_MoveAudienceAudit::setTargetEventName()
     * @uses Ticketing_MoveAudienceAudit::setTargetEventNameAndDate()
     * @uses Ticketing_MoveAudienceAudit::setTargetHallName()
     * @uses Ticketing_MoveAudienceAudit::setTargetLockId()
     * @uses Ticketing_MoveAudienceAudit::setTargetPriceLevelId()
     * @uses Ticketing_MoveAudienceAudit::setTargetSeatId()
     * @uses Ticketing_MoveAudienceAudit::setTargetSeatNumber()
     * @uses Ticketing_MoveAudienceAudit::setTargetSeatRow()
     * @uses Ticketing_MoveAudienceAudit::setTicketId()
     * @uses Ticketing_MoveAudienceAudit::setTransactionId()
     * @uses Ticketing_MoveAudienceAudit::setTransactionNumber()
     * @uses Ticketing_MoveAudienceAudit::setUserName()
     * @param string $clientDisplayName
     * @param string $clientId
     * @param string $dateTime
     * @param string $organizationUnitId
     * @param string $ownerDisplayName
     * @param string $ownerId
     * @param string $sourceAllocationsIds
     * @param string $sourceAreaId
     * @param \patest\StructType\GlobalString $sourceAreaName
     * @param string $sourceEventDate
     * @param string $sourceEventId
     * @param \patest\StructType\GlobalString $sourceEventName
     * @param string $sourceEventNameAndDate
     * @param \patest\StructType\GlobalString $sourceHallName
     * @param string $sourceLockId
     * @param string $sourcePriceLevelId
     * @param int $sourceSeatId
     * @param string $sourceSeatNumber
     * @param string $sourceSeatRow
     * @param string $targetAllocationsIds
     * @param string $targetAreaId
     * @param \patest\StructType\GlobalString $targetAreaName
     * @param string $targetEventDate
     * @param string $targetEventId
     * @param \patest\StructType\GlobalString $targetEventName
     * @param string $targetEventNameAndDate
     * @param \patest\StructType\GlobalString $targetHallName
     * @param string $targetLockId
     * @param string $targetPriceLevelId
     * @param int $targetSeatId
     * @param string $targetSeatNumber
     * @param string $targetSeatRow
     * @param string $ticketId
     * @param string $transactionId
     * @param int $transactionNumber
     * @param string $userName
     */
    public function __construct($clientDisplayName = null, $clientId = null, $dateTime = null, $organizationUnitId = null, $ownerDisplayName = null, $ownerId = null, $sourceAllocationsIds = null, $sourceAreaId = null, \patest\StructType\GlobalString $sourceAreaName = null, $sourceEventDate = null, $sourceEventId = null, \patest\StructType\GlobalString $sourceEventName = null, $sourceEventNameAndDate = null, \patest\StructType\GlobalString $sourceHallName = null, $sourceLockId = null, $sourcePriceLevelId = null, $sourceSeatId = null, $sourceSeatNumber = null, $sourceSeatRow = null, $targetAllocationsIds = null, $targetAreaId = null, \patest\StructType\GlobalString $targetAreaName = null, $targetEventDate = null, $targetEventId = null, \patest\StructType\GlobalString $targetEventName = null, $targetEventNameAndDate = null, \patest\StructType\GlobalString $targetHallName = null, $targetLockId = null, $targetPriceLevelId = null, $targetSeatId = null, $targetSeatNumber = null, $targetSeatRow = null, $ticketId = null, $transactionId = null, $transactionNumber = null, $userName = null)
    {
        $this
            ->setClientDisplayName($clientDisplayName)
            ->setClientId($clientId)
            ->setDateTime($dateTime)
            ->setOrganizationUnitId($organizationUnitId)
            ->setOwnerDisplayName($ownerDisplayName)
            ->setOwnerId($ownerId)
            ->setSourceAllocationsIds($sourceAllocationsIds)
            ->setSourceAreaId($sourceAreaId)
            ->setSourceAreaName($sourceAreaName)
            ->setSourceEventDate($sourceEventDate)
            ->setSourceEventId($sourceEventId)
            ->setSourceEventName($sourceEventName)
            ->setSourceEventNameAndDate($sourceEventNameAndDate)
            ->setSourceHallName($sourceHallName)
            ->setSourceLockId($sourceLockId)
            ->setSourcePriceLevelId($sourcePriceLevelId)
            ->setSourceSeatId($sourceSeatId)
            ->setSourceSeatNumber($sourceSeatNumber)
            ->setSourceSeatRow($sourceSeatRow)
            ->setTargetAllocationsIds($targetAllocationsIds)
            ->setTargetAreaId($targetAreaId)
            ->setTargetAreaName($targetAreaName)
            ->setTargetEventDate($targetEventDate)
            ->setTargetEventId($targetEventId)
            ->setTargetEventName($targetEventName)
            ->setTargetEventNameAndDate($targetEventNameAndDate)
            ->setTargetHallName($targetHallName)
            ->setTargetLockId($targetLockId)
            ->setTargetPriceLevelId($targetPriceLevelId)
            ->setTargetSeatId($targetSeatId)
            ->setTargetSeatNumber($targetSeatNumber)
            ->setTargetSeatRow($targetSeatRow)
            ->setTicketId($ticketId)
            ->setTransactionId($transactionId)
            ->setTransactionNumber($transactionNumber)
            ->setUserName($userName);
    }
    /**
     * Get ClientDisplayName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientDisplayName()
    {
        return isset($this->ClientDisplayName) ? $this->ClientDisplayName : null;
    }
    /**
     * Set ClientDisplayName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientDisplayName
     * @return \patest\StructType\Ticketing_MoveAudienceAudit
     */
    public function setClientDisplayName($clientDisplayName = null)
    {
        // validation for constraint: string
        if (!is_null($clientDisplayName) && !is_string($clientDisplayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientDisplayName, true), gettype($clientDisplayName)), __LINE__);
        }
        if (is_null($clientDisplayName) || (is_array($clientDisplayName) && empty($clientDisplayName))) {
            unset($this->ClientDisplayName);
        } else {
            $this->ClientDisplayName = $clientDisplayName;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Ticketing_MoveAudienceAudit
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get DateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateTime()
    {
        return isset($this->DateTime) ? $this->DateTime : null;
    }
    /**
     * Set DateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateTime
     * @return \patest\StructType\Ticketing_MoveAudienceAudit
     */
    public function setDateTime($dateTime = null)
    {
        // validation for constraint: string
        if (!is_null($dateTime) && !is_string($dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTime, true), gettype($dateTime)), __LINE__);
        }
        if (is_null($dateTime) || (is_array($dateTime) && empty($dateTime))) {
            unset($this->DateTime);
        } else {
            $this->DateTime = $dateTime;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Ticketing_MoveAudienceAudit
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get OwnerDisplayName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerDisplayName()
    {
        return isset($this->OwnerDisplayName) ? $this->OwnerDisplayName : null;
    }
    /**
     * Set OwnerDisplayName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerDisplayName
     * @return \patest\StructType\Ticketing_MoveAudienceAudit
     */
    public function setOwnerDisplayName($ownerDisplayName = null)
    {
        // validation for constraint: string
        if (!is_null($ownerDisplayName) && !is_string($ownerDisplayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerDisplayName, true), gettype($ownerDisplayName)), __LINE__);
        }
        if (is_null($ownerDisplayName) || (is_array($ownerDisplayName) && empty($ownerDisplayName))) {
            unset($this->OwnerDisplayName);
        } else {
            $this->OwnerDisplayName = $ownerDisplayName;
        }
        return $this;
    }
    /**
     * Get OwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerId()
    {
        return isset($this->OwnerId) ? $this->OwnerId : null;
    }
    /**
     * Set OwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerId
     * @return \patest\StructType\Ticketing_MoveAudienceAudit
     */
    public function setOwnerId($ownerId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerId) && !is_string($ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerId, true), gettype($ownerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ownerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ownerId, true)), __LINE__);
        }
        if (is_null($ownerId) || (is_array($ownerId) && empty($ownerId))) {
            unset($this->OwnerId);
        } else {
            $this->OwnerId = $ownerId;
        }
        return $this;
    }
    /**
     * Get SourceAllocationsIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSourceAllocationsIds()
    {
        return isset($this->SourceAllocationsIds) ? $this->SourceAllocationsIds : null;
    }
    /**
     * Set SourceAllocationsIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sourceAllocationsIds
     * @return \patest\StructType\Ticketing_MoveAudienceAudit
     */
    public function setSourceAllocationsIds($sourceAllocationsIds = null)
    {
        // validation for constraint: string
        if (!is_null($sourceAllocationsIds) && !is_string($sourceAllocationsIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceAllocationsIds, true), gettype($sourceAllocationsIds)), __LINE__);
        }
        if (is_null($sourceAllocationsIds) || (is_array($sourceAllocationsIds) && empty($sourceAllocationsIds))) {
            unset($this->SourceAllocationsIds);
        } else {
            $this->SourceAllocationsIds = $sourceAllocationsIds;
        }
        return $this;
    }
    /**
     * Get SourceAreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSourceAreaId()
    {
        return isset($this->SourceAreaId) ? $this->SourceAreaId : null;
    }
    /**
     * Set SourceAreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sourceAreaId
     * @return \patest\StructType\Ticketing_MoveAudienceAudit
     */
    public function setSourceAreaId($sourceAreaId = null)
    {
        // validation for constraint: string
        if (!is_null($sourceAreaId) && !is_string($sourceAreaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceAreaId, true), gettype($sourceAreaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sourceAreaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sourceAreaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sourceAreaId, true)), __LINE__);
        }
        if (is_null($sourceAreaId) || (is_array($sourceAreaId) && empty($sourceAreaId))) {
            unset($this->SourceAreaId);
        } else {
            $this->SourceAreaId = $sourceAreaId;
        }
        return $this;
    }
    /**
     * Get SourceAreaName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSourceAreaName()
    {
        return isset($this->SourceAreaName) ? $this->SourceAreaName : null;
    }
    /**
     * Set SourceAreaName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $sourceAreaName
     * @return \patest\StructType\Ticketing_MoveAudienceAudit
     */
    public function setSourceAreaName(\patest\StructType\GlobalString $sourceAreaName = null)
    {
        if (is_null($sourceAreaName) || (is_array($sourceAreaName) && empty($sourceAreaName))) {
            unset($this->SourceAreaName);
        } else {
            $this->SourceAreaName = $sourceAreaName;
        }
        return $this;
    }
    /**
     * Get SourceEventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSourceEventDate()
    {
        return isset($this->SourceEventDate) ? $this->SourceEventDate : null;
    }
    /**
     * Set SourceEventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sourceEventDate
     * @return \patest\StructType\Ticketing_MoveAudienceAudit
     */
    public function setSourceEventDate($sourceEventDate = null)
    {
        // validation for constraint: string
        if (!is_null($sourceEventDate) && !is_string($sourceEventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceEventDate, true), gettype($sourceEventDate)), __LINE__);
        }
        if (is_null($sourceEventDate) || (is_array($sourceEventDate) && empty($sourceEventDate))) {
            unset($this->SourceEventDate);
        } else {
            $this->SourceEventDate = $sourceEventDate;
        }
        return $this;
    }
    /**
     * Get SourceEventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSourceEventId()
    {
        return isset($this->SourceEventId) ? $this->SourceEventId : null;
    }
    /**
     * Set SourceEventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sourceEventId
     * @return \patest\StructType\Ticketing_MoveAudienceAudit
     */
    public function setSourceEventId($sourceEventId = null)
    {
        // validation for constraint: string
        if (!is_null($sourceEventId) && !is_string($sourceEventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceEventId, true), gettype($sourceEventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sourceEventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sourceEventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sourceEventId, true)), __LINE__);
        }
        if (is_null($sourceEventId) || (is_array($sourceEventId) && empty($sourceEventId))) {
            unset($this->SourceEventId);
        } else {
            $this->SourceEventId = $sourceEventId;
        }
        return $this;
    }
    /**
     * Get SourceEventName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSourceEventName()
    {
        return isset($this->SourceEventName) ? $this->SourceEventName : null;
    }
    /**
     * Set SourceEventName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $sourceEventName
     * @return \patest\StructType\Ticketing_MoveAudienceAudit
     */
    public function setSourceEventName(\patest\StructType\GlobalString $sourceEventName = null)
    {
        if (is_null($sourceEventName) || (is_array($sourceEventName) && empty($sourceEventName))) {
            unset($this->SourceEventName);
        } else {
            $this->SourceEventName = $sourceEventName;
        }
        return $this;
    }
    /**
     * Get SourceEventNameAndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSourceEventNameAndDate()
    {
        return isset($this->SourceEventNameAndDate) ? $this->SourceEventNameAndDate : null;
    }
    /**
     * Set SourceEventNameAndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sourceEventNameAndDate
     * @return \patest\StructType\Ticketing_MoveAudienceAudit
     */
    public function setSourceEventNameAndDate($sourceEventNameAndDate = null)
    {
        // validation for constraint: string
        if (!is_null($sourceEventNameAndDate) && !is_string($sourceEventNameAndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceEventNameAndDate, true), gettype($sourceEventNameAndDate)), __LINE__);
        }
        if (is_null($sourceEventNameAndDate) || (is_array($sourceEventNameAndDate) && empty($sourceEventNameAndDate))) {
            unset($this->SourceEventNameAndDate);
        } else {
            $this->SourceEventNameAndDate = $sourceEventNameAndDate;
        }
        return $this;
    }
    /**
     * Get SourceHallName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSourceHallName()
    {
        return isset($this->SourceHallName) ? $this->SourceHallName : null;
    }
    /**
     * Set SourceHallName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $sourceHallName
     * @return \patest\StructType\Ticketing_MoveAudienceAudit
     */
    public function setSourceHallName(\patest\StructType\GlobalString $sourceHallName = null)
    {
        if (is_null($sourceHallName) || (is_array($sourceHallName) && empty($sourceHallName))) {
            unset($this->SourceHallName);
        } else {
            $this->SourceHallName = $sourceHallName;
        }
        return $this;
    }
    /**
     * Get SourceLockId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSourceLockId()
    {
        return isset($this->SourceLockId) ? $this->SourceLockId : null;
    }
    /**
     * Set SourceLockId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sourceLockId
     * @return \patest\StructType\Ticketing_MoveAudienceAudit
     */
    public function setSourceLockId($sourceLockId = null)
    {
        // validation for constraint: string
        if (!is_null($sourceLockId) && !is_string($sourceLockId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceLockId, true), gettype($sourceLockId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sourceLockId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sourceLockId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sourceLockId, true)), __LINE__);
        }
        if (is_null($sourceLockId) || (is_array($sourceLockId) && empty($sourceLockId))) {
            unset($this->SourceLockId);
        } else {
            $this->SourceLockId = $sourceLockId;
        }
        return $this;
    }
    /**
     * Get SourcePriceLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSourcePriceLevelId()
    {
        return isset($this->SourcePriceLevelId) ? $this->SourcePriceLevelId : null;
    }
    /**
     * Set SourcePriceLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sourcePriceLevelId
     * @return \patest\StructType\Ticketing_MoveAudienceAudit
     */
    public function setSourcePriceLevelId($sourcePriceLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($sourcePriceLevelId) && !is_string($sourcePriceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourcePriceLevelId, true), gettype($sourcePriceLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sourcePriceLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sourcePriceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sourcePriceLevelId, true)), __LINE__);
        }
        if (is_null($sourcePriceLevelId) || (is_array($sourcePriceLevelId) && empty($sourcePriceLevelId))) {
            unset($this->SourcePriceLevelId);
        } else {
            $this->SourcePriceLevelId = $sourcePriceLevelId;
        }
        return $this;
    }
    /**
     * Get SourceSeatId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSourceSeatId()
    {
        return isset($this->SourceSeatId) ? $this->SourceSeatId : null;
    }
    /**
     * Set SourceSeatId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $sourceSeatId
     * @return \patest\StructType\Ticketing_MoveAudienceAudit
     */
    public function setSourceSeatId($sourceSeatId = null)
    {
        // validation for constraint: int
        if (!is_null($sourceSeatId) && !(is_int($sourceSeatId) || ctype_digit($sourceSeatId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sourceSeatId, true), gettype($sourceSeatId)), __LINE__);
        }
        if (is_null($sourceSeatId) || (is_array($sourceSeatId) && empty($sourceSeatId))) {
            unset($this->SourceSeatId);
        } else {
            $this->SourceSeatId = $sourceSeatId;
        }
        return $this;
    }
    /**
     * Get SourceSeatNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSourceSeatNumber()
    {
        return isset($this->SourceSeatNumber) ? $this->SourceSeatNumber : null;
    }
    /**
     * Set SourceSeatNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sourceSeatNumber
     * @return \patest\StructType\Ticketing_MoveAudienceAudit
     */
    public function setSourceSeatNumber($sourceSeatNumber = null)
    {
        // validation for constraint: string
        if (!is_null($sourceSeatNumber) && !is_string($sourceSeatNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceSeatNumber, true), gettype($sourceSeatNumber)), __LINE__);
        }
        if (is_null($sourceSeatNumber) || (is_array($sourceSeatNumber) && empty($sourceSeatNumber))) {
            unset($this->SourceSeatNumber);
        } else {
            $this->SourceSeatNumber = $sourceSeatNumber;
        }
        return $this;
    }
    /**
     * Get SourceSeatRow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSourceSeatRow()
    {
        return isset($this->SourceSeatRow) ? $this->SourceSeatRow : null;
    }
    /**
     * Set SourceSeatRow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sourceSeatRow
     * @return \patest\StructType\Ticketing_MoveAudienceAudit
     */
    public function setSourceSeatRow($sourceSeatRow = null)
    {
        // validation for constraint: string
        if (!is_null($sourceSeatRow) && !is_string($sourceSeatRow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceSeatRow, true), gettype($sourceSeatRow)), __LINE__);
        }
        if (is_null($sourceSeatRow) || (is_array($sourceSeatRow) && empty($sourceSeatRow))) {
            unset($this->SourceSeatRow);
        } else {
            $this->SourceSeatRow = $sourceSeatRow;
        }
        return $this;
    }
    /**
     * Get TargetAllocationsIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetAllocationsIds()
    {
        return isset($this->TargetAllocationsIds) ? $this->TargetAllocationsIds : null;
    }
    /**
     * Set TargetAllocationsIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetAllocationsIds
     * @return \patest\StructType\Ticketing_MoveAudienceAudit
     */
    public function setTargetAllocationsIds($targetAllocationsIds = null)
    {
        // validation for constraint: string
        if (!is_null($targetAllocationsIds) && !is_string($targetAllocationsIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetAllocationsIds, true), gettype($targetAllocationsIds)), __LINE__);
        }
        if (is_null($targetAllocationsIds) || (is_array($targetAllocationsIds) && empty($targetAllocationsIds))) {
            unset($this->TargetAllocationsIds);
        } else {
            $this->TargetAllocationsIds = $targetAllocationsIds;
        }
        return $this;
    }
    /**
     * Get TargetAreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetAreaId()
    {
        return isset($this->TargetAreaId) ? $this->TargetAreaId : null;
    }
    /**
     * Set TargetAreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetAreaId
     * @return \patest\StructType\Ticketing_MoveAudienceAudit
     */
    public function setTargetAreaId($targetAreaId = null)
    {
        // validation for constraint: string
        if (!is_null($targetAreaId) && !is_string($targetAreaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetAreaId, true), gettype($targetAreaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetAreaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetAreaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetAreaId, true)), __LINE__);
        }
        if (is_null($targetAreaId) || (is_array($targetAreaId) && empty($targetAreaId))) {
            unset($this->TargetAreaId);
        } else {
            $this->TargetAreaId = $targetAreaId;
        }
        return $this;
    }
    /**
     * Get TargetAreaName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getTargetAreaName()
    {
        return isset($this->TargetAreaName) ? $this->TargetAreaName : null;
    }
    /**
     * Set TargetAreaName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $targetAreaName
     * @return \patest\StructType\Ticketing_MoveAudienceAudit
     */
    public function setTargetAreaName(\patest\StructType\GlobalString $targetAreaName = null)
    {
        if (is_null($targetAreaName) || (is_array($targetAreaName) && empty($targetAreaName))) {
            unset($this->TargetAreaName);
        } else {
            $this->TargetAreaName = $targetAreaName;
        }
        return $this;
    }
    /**
     * Get TargetEventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetEventDate()
    {
        return isset($this->TargetEventDate) ? $this->TargetEventDate : null;
    }
    /**
     * Set TargetEventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetEventDate
     * @return \patest\StructType\Ticketing_MoveAudienceAudit
     */
    public function setTargetEventDate($targetEventDate = null)
    {
        // validation for constraint: string
        if (!is_null($targetEventDate) && !is_string($targetEventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetEventDate, true), gettype($targetEventDate)), __LINE__);
        }
        if (is_null($targetEventDate) || (is_array($targetEventDate) && empty($targetEventDate))) {
            unset($this->TargetEventDate);
        } else {
            $this->TargetEventDate = $targetEventDate;
        }
        return $this;
    }
    /**
     * Get TargetEventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetEventId()
    {
        return isset($this->TargetEventId) ? $this->TargetEventId : null;
    }
    /**
     * Set TargetEventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetEventId
     * @return \patest\StructType\Ticketing_MoveAudienceAudit
     */
    public function setTargetEventId($targetEventId = null)
    {
        // validation for constraint: string
        if (!is_null($targetEventId) && !is_string($targetEventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetEventId, true), gettype($targetEventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetEventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetEventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetEventId, true)), __LINE__);
        }
        if (is_null($targetEventId) || (is_array($targetEventId) && empty($targetEventId))) {
            unset($this->TargetEventId);
        } else {
            $this->TargetEventId = $targetEventId;
        }
        return $this;
    }
    /**
     * Get TargetEventName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getTargetEventName()
    {
        return isset($this->TargetEventName) ? $this->TargetEventName : null;
    }
    /**
     * Set TargetEventName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $targetEventName
     * @return \patest\StructType\Ticketing_MoveAudienceAudit
     */
    public function setTargetEventName(\patest\StructType\GlobalString $targetEventName = null)
    {
        if (is_null($targetEventName) || (is_array($targetEventName) && empty($targetEventName))) {
            unset($this->TargetEventName);
        } else {
            $this->TargetEventName = $targetEventName;
        }
        return $this;
    }
    /**
     * Get TargetEventNameAndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetEventNameAndDate()
    {
        return isset($this->TargetEventNameAndDate) ? $this->TargetEventNameAndDate : null;
    }
    /**
     * Set TargetEventNameAndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetEventNameAndDate
     * @return \patest\StructType\Ticketing_MoveAudienceAudit
     */
    public function setTargetEventNameAndDate($targetEventNameAndDate = null)
    {
        // validation for constraint: string
        if (!is_null($targetEventNameAndDate) && !is_string($targetEventNameAndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetEventNameAndDate, true), gettype($targetEventNameAndDate)), __LINE__);
        }
        if (is_null($targetEventNameAndDate) || (is_array($targetEventNameAndDate) && empty($targetEventNameAndDate))) {
            unset($this->TargetEventNameAndDate);
        } else {
            $this->TargetEventNameAndDate = $targetEventNameAndDate;
        }
        return $this;
    }
    /**
     * Get TargetHallName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getTargetHallName()
    {
        return isset($this->TargetHallName) ? $this->TargetHallName : null;
    }
    /**
     * Set TargetHallName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $targetHallName
     * @return \patest\StructType\Ticketing_MoveAudienceAudit
     */
    public function setTargetHallName(\patest\StructType\GlobalString $targetHallName = null)
    {
        if (is_null($targetHallName) || (is_array($targetHallName) && empty($targetHallName))) {
            unset($this->TargetHallName);
        } else {
            $this->TargetHallName = $targetHallName;
        }
        return $this;
    }
    /**
     * Get TargetLockId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetLockId()
    {
        return isset($this->TargetLockId) ? $this->TargetLockId : null;
    }
    /**
     * Set TargetLockId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetLockId
     * @return \patest\StructType\Ticketing_MoveAudienceAudit
     */
    public function setTargetLockId($targetLockId = null)
    {
        // validation for constraint: string
        if (!is_null($targetLockId) && !is_string($targetLockId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetLockId, true), gettype($targetLockId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetLockId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetLockId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetLockId, true)), __LINE__);
        }
        if (is_null($targetLockId) || (is_array($targetLockId) && empty($targetLockId))) {
            unset($this->TargetLockId);
        } else {
            $this->TargetLockId = $targetLockId;
        }
        return $this;
    }
    /**
     * Get TargetPriceLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetPriceLevelId()
    {
        return isset($this->TargetPriceLevelId) ? $this->TargetPriceLevelId : null;
    }
    /**
     * Set TargetPriceLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetPriceLevelId
     * @return \patest\StructType\Ticketing_MoveAudienceAudit
     */
    public function setTargetPriceLevelId($targetPriceLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($targetPriceLevelId) && !is_string($targetPriceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetPriceLevelId, true), gettype($targetPriceLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetPriceLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetPriceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetPriceLevelId, true)), __LINE__);
        }
        if (is_null($targetPriceLevelId) || (is_array($targetPriceLevelId) && empty($targetPriceLevelId))) {
            unset($this->TargetPriceLevelId);
        } else {
            $this->TargetPriceLevelId = $targetPriceLevelId;
        }
        return $this;
    }
    /**
     * Get TargetSeatId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTargetSeatId()
    {
        return isset($this->TargetSeatId) ? $this->TargetSeatId : null;
    }
    /**
     * Set TargetSeatId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $targetSeatId
     * @return \patest\StructType\Ticketing_MoveAudienceAudit
     */
    public function setTargetSeatId($targetSeatId = null)
    {
        // validation for constraint: int
        if (!is_null($targetSeatId) && !(is_int($targetSeatId) || ctype_digit($targetSeatId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($targetSeatId, true), gettype($targetSeatId)), __LINE__);
        }
        if (is_null($targetSeatId) || (is_array($targetSeatId) && empty($targetSeatId))) {
            unset($this->TargetSeatId);
        } else {
            $this->TargetSeatId = $targetSeatId;
        }
        return $this;
    }
    /**
     * Get TargetSeatNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetSeatNumber()
    {
        return isset($this->TargetSeatNumber) ? $this->TargetSeatNumber : null;
    }
    /**
     * Set TargetSeatNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetSeatNumber
     * @return \patest\StructType\Ticketing_MoveAudienceAudit
     */
    public function setTargetSeatNumber($targetSeatNumber = null)
    {
        // validation for constraint: string
        if (!is_null($targetSeatNumber) && !is_string($targetSeatNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetSeatNumber, true), gettype($targetSeatNumber)), __LINE__);
        }
        if (is_null($targetSeatNumber) || (is_array($targetSeatNumber) && empty($targetSeatNumber))) {
            unset($this->TargetSeatNumber);
        } else {
            $this->TargetSeatNumber = $targetSeatNumber;
        }
        return $this;
    }
    /**
     * Get TargetSeatRow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetSeatRow()
    {
        return isset($this->TargetSeatRow) ? $this->TargetSeatRow : null;
    }
    /**
     * Set TargetSeatRow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetSeatRow
     * @return \patest\StructType\Ticketing_MoveAudienceAudit
     */
    public function setTargetSeatRow($targetSeatRow = null)
    {
        // validation for constraint: string
        if (!is_null($targetSeatRow) && !is_string($targetSeatRow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetSeatRow, true), gettype($targetSeatRow)), __LINE__);
        }
        if (is_null($targetSeatRow) || (is_array($targetSeatRow) && empty($targetSeatRow))) {
            unset($this->TargetSeatRow);
        } else {
            $this->TargetSeatRow = $targetSeatRow;
        }
        return $this;
    }
    /**
     * Get TicketId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketId()
    {
        return isset($this->TicketId) ? $this->TicketId : null;
    }
    /**
     * Set TicketId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketId
     * @return \patest\StructType\Ticketing_MoveAudienceAudit
     */
    public function setTicketId($ticketId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketId) && !is_string($ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketId, true), gettype($ticketId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketId, true)), __LINE__);
        }
        if (is_null($ticketId) || (is_array($ticketId) && empty($ticketId))) {
            unset($this->TicketId);
        } else {
            $this->TicketId = $ticketId;
        }
        return $this;
    }
    /**
     * Get TransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionId()
    {
        return isset($this->TransactionId) ? $this->TransactionId : null;
    }
    /**
     * Set TransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionId
     * @return \patest\StructType\Ticketing_MoveAudienceAudit
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionId, true)), __LINE__);
        }
        if (is_null($transactionId) || (is_array($transactionId) && empty($transactionId))) {
            unset($this->TransactionId);
        } else {
            $this->TransactionId = $transactionId;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Ticketing_MoveAudienceAudit
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
    /**
     * Get UserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserName()
    {
        return isset($this->UserName) ? $this->UserName : null;
    }
    /**
     * Set UserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userName
     * @return \patest\StructType\Ticketing_MoveAudienceAudit
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        if (is_null($userName) || (is_array($userName) && empty($userName))) {
            unset($this->UserName);
        } else {
            $this->UserName = $userName;
        }
        return $this;
    }
}
