<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.MobiliseTicketAvailability StructType
 * @subpackage Structs
 */
class Ticketing_MobiliseTicketAvailability extends AnyEntity
{
    /**
     * The AreaName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AreaName;
    /**
     * The DeviceType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeviceType;
    /**
     * The EventName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventName;
    /**
     * The FanId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FanId;
    /**
     * The IsTicketDownloaded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IsTicketDownloaded;
    /**
     * The IsTicketSold
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IsTicketSold;
    /**
     * The NumberOfTimesDownloaded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfTimesDownloaded;
    /**
     * The PriceList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceList;
    /**
     * The PurchaserId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PurchaserId;
    /**
     * The RowName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RowName;
    /**
     * The SeatName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatName;
    /**
     * The SectorName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SectorName;
    /**
     * The TicketBarcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketBarcode;
    /**
     * The TicketDownloadDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketDownloadDateTime;
    /**
     * The TicketDownloadStatus
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketDownloadStatus;
    /**
     * The TicketNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TicketNumber;
    /**
     * The TicketOwnerId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TicketOwnerId;
    /**
     * Constructor method for Ticketing.MobiliseTicketAvailability
     * @uses Ticketing_MobiliseTicketAvailability::setAreaName()
     * @uses Ticketing_MobiliseTicketAvailability::setDeviceType()
     * @uses Ticketing_MobiliseTicketAvailability::setEventName()
     * @uses Ticketing_MobiliseTicketAvailability::setFanId()
     * @uses Ticketing_MobiliseTicketAvailability::setIsTicketDownloaded()
     * @uses Ticketing_MobiliseTicketAvailability::setIsTicketSold()
     * @uses Ticketing_MobiliseTicketAvailability::setNumberOfTimesDownloaded()
     * @uses Ticketing_MobiliseTicketAvailability::setPriceList()
     * @uses Ticketing_MobiliseTicketAvailability::setPurchaserId()
     * @uses Ticketing_MobiliseTicketAvailability::setRowName()
     * @uses Ticketing_MobiliseTicketAvailability::setSeatName()
     * @uses Ticketing_MobiliseTicketAvailability::setSectorName()
     * @uses Ticketing_MobiliseTicketAvailability::setTicketBarcode()
     * @uses Ticketing_MobiliseTicketAvailability::setTicketDownloadDateTime()
     * @uses Ticketing_MobiliseTicketAvailability::setTicketDownloadStatus()
     * @uses Ticketing_MobiliseTicketAvailability::setTicketNumber()
     * @uses Ticketing_MobiliseTicketAvailability::setTicketOwnerId()
     * @param string $areaName
     * @param string $deviceType
     * @param string $eventName
     * @param int $fanId
     * @param string $isTicketDownloaded
     * @param string $isTicketSold
     * @param int $numberOfTimesDownloaded
     * @param string $priceList
     * @param int $purchaserId
     * @param string $rowName
     * @param string $seatName
     * @param string $sectorName
     * @param string $ticketBarcode
     * @param string $ticketDownloadDateTime
     * @param string $ticketDownloadStatus
     * @param int $ticketNumber
     * @param int $ticketOwnerId
     */
    public function __construct($areaName = null, $deviceType = null, $eventName = null, $fanId = null, $isTicketDownloaded = null, $isTicketSold = null, $numberOfTimesDownloaded = null, $priceList = null, $purchaserId = null, $rowName = null, $seatName = null, $sectorName = null, $ticketBarcode = null, $ticketDownloadDateTime = null, $ticketDownloadStatus = null, $ticketNumber = null, $ticketOwnerId = null)
    {
        $this
            ->setAreaName($areaName)
            ->setDeviceType($deviceType)
            ->setEventName($eventName)
            ->setFanId($fanId)
            ->setIsTicketDownloaded($isTicketDownloaded)
            ->setIsTicketSold($isTicketSold)
            ->setNumberOfTimesDownloaded($numberOfTimesDownloaded)
            ->setPriceList($priceList)
            ->setPurchaserId($purchaserId)
            ->setRowName($rowName)
            ->setSeatName($seatName)
            ->setSectorName($sectorName)
            ->setTicketBarcode($ticketBarcode)
            ->setTicketDownloadDateTime($ticketDownloadDateTime)
            ->setTicketDownloadStatus($ticketDownloadStatus)
            ->setTicketNumber($ticketNumber)
            ->setTicketOwnerId($ticketOwnerId);
    }
    /**
     * Get AreaName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaName()
    {
        return isset($this->AreaName) ? $this->AreaName : null;
    }
    /**
     * Set AreaName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaName
     * @return \patest\StructType\Ticketing_MobiliseTicketAvailability
     */
    public function setAreaName($areaName = null)
    {
        // validation for constraint: string
        if (!is_null($areaName) && !is_string($areaName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaName, true), gettype($areaName)), __LINE__);
        }
        if (is_null($areaName) || (is_array($areaName) && empty($areaName))) {
            unset($this->AreaName);
        } else {
            $this->AreaName = $areaName;
        }
        return $this;
    }
    /**
     * Get DeviceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeviceType()
    {
        return isset($this->DeviceType) ? $this->DeviceType : null;
    }
    /**
     * Set DeviceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deviceType
     * @return \patest\StructType\Ticketing_MobiliseTicketAvailability
     */
    public function setDeviceType($deviceType = null)
    {
        // validation for constraint: string
        if (!is_null($deviceType) && !is_string($deviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceType, true), gettype($deviceType)), __LINE__);
        }
        if (is_null($deviceType) || (is_array($deviceType) && empty($deviceType))) {
            unset($this->DeviceType);
        } else {
            $this->DeviceType = $deviceType;
        }
        return $this;
    }
    /**
     * Get EventName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventName()
    {
        return isset($this->EventName) ? $this->EventName : null;
    }
    /**
     * Set EventName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventName
     * @return \patest\StructType\Ticketing_MobiliseTicketAvailability
     */
    public function setEventName($eventName = null)
    {
        // validation for constraint: string
        if (!is_null($eventName) && !is_string($eventName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventName, true), gettype($eventName)), __LINE__);
        }
        if (is_null($eventName) || (is_array($eventName) && empty($eventName))) {
            unset($this->EventName);
        } else {
            $this->EventName = $eventName;
        }
        return $this;
    }
    /**
     * Get FanId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFanId()
    {
        return isset($this->FanId) ? $this->FanId : null;
    }
    /**
     * Set FanId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $fanId
     * @return \patest\StructType\Ticketing_MobiliseTicketAvailability
     */
    public function setFanId($fanId = null)
    {
        // validation for constraint: int
        if (!is_null($fanId) && !(is_int($fanId) || ctype_digit($fanId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fanId, true), gettype($fanId)), __LINE__);
        }
        if (is_null($fanId) || (is_array($fanId) && empty($fanId))) {
            unset($this->FanId);
        } else {
            $this->FanId = $fanId;
        }
        return $this;
    }
    /**
     * Get IsTicketDownloaded value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIsTicketDownloaded()
    {
        return isset($this->IsTicketDownloaded) ? $this->IsTicketDownloaded : null;
    }
    /**
     * Set IsTicketDownloaded value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $isTicketDownloaded
     * @return \patest\StructType\Ticketing_MobiliseTicketAvailability
     */
    public function setIsTicketDownloaded($isTicketDownloaded = null)
    {
        // validation for constraint: string
        if (!is_null($isTicketDownloaded) && !is_string($isTicketDownloaded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isTicketDownloaded, true), gettype($isTicketDownloaded)), __LINE__);
        }
        if (is_null($isTicketDownloaded) || (is_array($isTicketDownloaded) && empty($isTicketDownloaded))) {
            unset($this->IsTicketDownloaded);
        } else {
            $this->IsTicketDownloaded = $isTicketDownloaded;
        }
        return $this;
    }
    /**
     * Get IsTicketSold value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIsTicketSold()
    {
        return isset($this->IsTicketSold) ? $this->IsTicketSold : null;
    }
    /**
     * Set IsTicketSold value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $isTicketSold
     * @return \patest\StructType\Ticketing_MobiliseTicketAvailability
     */
    public function setIsTicketSold($isTicketSold = null)
    {
        // validation for constraint: string
        if (!is_null($isTicketSold) && !is_string($isTicketSold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isTicketSold, true), gettype($isTicketSold)), __LINE__);
        }
        if (is_null($isTicketSold) || (is_array($isTicketSold) && empty($isTicketSold))) {
            unset($this->IsTicketSold);
        } else {
            $this->IsTicketSold = $isTicketSold;
        }
        return $this;
    }
    /**
     * Get NumberOfTimesDownloaded value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfTimesDownloaded()
    {
        return isset($this->NumberOfTimesDownloaded) ? $this->NumberOfTimesDownloaded : null;
    }
    /**
     * Set NumberOfTimesDownloaded value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfTimesDownloaded
     * @return \patest\StructType\Ticketing_MobiliseTicketAvailability
     */
    public function setNumberOfTimesDownloaded($numberOfTimesDownloaded = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfTimesDownloaded) && !(is_int($numberOfTimesDownloaded) || ctype_digit($numberOfTimesDownloaded))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfTimesDownloaded, true), gettype($numberOfTimesDownloaded)), __LINE__);
        }
        if (is_null($numberOfTimesDownloaded) || (is_array($numberOfTimesDownloaded) && empty($numberOfTimesDownloaded))) {
            unset($this->NumberOfTimesDownloaded);
        } else {
            $this->NumberOfTimesDownloaded = $numberOfTimesDownloaded;
        }
        return $this;
    }
    /**
     * Get PriceList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceList()
    {
        return isset($this->PriceList) ? $this->PriceList : null;
    }
    /**
     * Set PriceList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceList
     * @return \patest\StructType\Ticketing_MobiliseTicketAvailability
     */
    public function setPriceList($priceList = null)
    {
        // validation for constraint: string
        if (!is_null($priceList) && !is_string($priceList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceList, true), gettype($priceList)), __LINE__);
        }
        if (is_null($priceList) || (is_array($priceList) && empty($priceList))) {
            unset($this->PriceList);
        } else {
            $this->PriceList = $priceList;
        }
        return $this;
    }
    /**
     * Get PurchaserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPurchaserId()
    {
        return isset($this->PurchaserId) ? $this->PurchaserId : null;
    }
    /**
     * Set PurchaserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $purchaserId
     * @return \patest\StructType\Ticketing_MobiliseTicketAvailability
     */
    public function setPurchaserId($purchaserId = null)
    {
        // validation for constraint: int
        if (!is_null($purchaserId) && !(is_int($purchaserId) || ctype_digit($purchaserId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($purchaserId, true), gettype($purchaserId)), __LINE__);
        }
        if (is_null($purchaserId) || (is_array($purchaserId) && empty($purchaserId))) {
            unset($this->PurchaserId);
        } else {
            $this->PurchaserId = $purchaserId;
        }
        return $this;
    }
    /**
     * Get RowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRowName()
    {
        return isset($this->RowName) ? $this->RowName : null;
    }
    /**
     * Set RowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rowName
     * @return \patest\StructType\Ticketing_MobiliseTicketAvailability
     */
    public function setRowName($rowName = null)
    {
        // validation for constraint: string
        if (!is_null($rowName) && !is_string($rowName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rowName, true), gettype($rowName)), __LINE__);
        }
        if (is_null($rowName) || (is_array($rowName) && empty($rowName))) {
            unset($this->RowName);
        } else {
            $this->RowName = $rowName;
        }
        return $this;
    }
    /**
     * Get SeatName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatName()
    {
        return isset($this->SeatName) ? $this->SeatName : null;
    }
    /**
     * Set SeatName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatName
     * @return \patest\StructType\Ticketing_MobiliseTicketAvailability
     */
    public function setSeatName($seatName = null)
    {
        // validation for constraint: string
        if (!is_null($seatName) && !is_string($seatName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatName, true), gettype($seatName)), __LINE__);
        }
        if (is_null($seatName) || (is_array($seatName) && empty($seatName))) {
            unset($this->SeatName);
        } else {
            $this->SeatName = $seatName;
        }
        return $this;
    }
    /**
     * Get SectorName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSectorName()
    {
        return isset($this->SectorName) ? $this->SectorName : null;
    }
    /**
     * Set SectorName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sectorName
     * @return \patest\StructType\Ticketing_MobiliseTicketAvailability
     */
    public function setSectorName($sectorName = null)
    {
        // validation for constraint: string
        if (!is_null($sectorName) && !is_string($sectorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectorName, true), gettype($sectorName)), __LINE__);
        }
        if (is_null($sectorName) || (is_array($sectorName) && empty($sectorName))) {
            unset($this->SectorName);
        } else {
            $this->SectorName = $sectorName;
        }
        return $this;
    }
    /**
     * Get TicketBarcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketBarcode()
    {
        return isset($this->TicketBarcode) ? $this->TicketBarcode : null;
    }
    /**
     * Set TicketBarcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketBarcode
     * @return \patest\StructType\Ticketing_MobiliseTicketAvailability
     */
    public function setTicketBarcode($ticketBarcode = null)
    {
        // validation for constraint: string
        if (!is_null($ticketBarcode) && !is_string($ticketBarcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketBarcode, true), gettype($ticketBarcode)), __LINE__);
        }
        if (is_null($ticketBarcode) || (is_array($ticketBarcode) && empty($ticketBarcode))) {
            unset($this->TicketBarcode);
        } else {
            $this->TicketBarcode = $ticketBarcode;
        }
        return $this;
    }
    /**
     * Get TicketDownloadDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketDownloadDateTime()
    {
        return isset($this->TicketDownloadDateTime) ? $this->TicketDownloadDateTime : null;
    }
    /**
     * Set TicketDownloadDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketDownloadDateTime
     * @return \patest\StructType\Ticketing_MobiliseTicketAvailability
     */
    public function setTicketDownloadDateTime($ticketDownloadDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($ticketDownloadDateTime) && !is_string($ticketDownloadDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketDownloadDateTime, true), gettype($ticketDownloadDateTime)), __LINE__);
        }
        if (is_null($ticketDownloadDateTime) || (is_array($ticketDownloadDateTime) && empty($ticketDownloadDateTime))) {
            unset($this->TicketDownloadDateTime);
        } else {
            $this->TicketDownloadDateTime = $ticketDownloadDateTime;
        }
        return $this;
    }
    /**
     * Get TicketDownloadStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketDownloadStatus()
    {
        return isset($this->TicketDownloadStatus) ? $this->TicketDownloadStatus : null;
    }
    /**
     * Set TicketDownloadStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketDownloadStatus::valueIsValid()
     * @uses \patest\EnumType\TicketDownloadStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ticketDownloadStatus
     * @return \patest\StructType\Ticketing_MobiliseTicketAvailability
     */
    public function setTicketDownloadStatus($ticketDownloadStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketDownloadStatus::valueIsValid($ticketDownloadStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketDownloadStatus', is_array($ticketDownloadStatus) ? implode(', ', $ticketDownloadStatus) : var_export($ticketDownloadStatus, true), implode(', ', \patest\EnumType\TicketDownloadStatus::getValidValues())), __LINE__);
        }
        if (is_null($ticketDownloadStatus) || (is_array($ticketDownloadStatus) && empty($ticketDownloadStatus))) {
            unset($this->TicketDownloadStatus);
        } else {
            $this->TicketDownloadStatus = $ticketDownloadStatus;
        }
        return $this;
    }
    /**
     * Get TicketNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTicketNumber()
    {
        return isset($this->TicketNumber) ? $this->TicketNumber : null;
    }
    /**
     * Set TicketNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ticketNumber
     * @return \patest\StructType\Ticketing_MobiliseTicketAvailability
     */
    public function setTicketNumber($ticketNumber = null)
    {
        // validation for constraint: int
        if (!is_null($ticketNumber) && !(is_int($ticketNumber) || ctype_digit($ticketNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ticketNumber, true), gettype($ticketNumber)), __LINE__);
        }
        if (is_null($ticketNumber) || (is_array($ticketNumber) && empty($ticketNumber))) {
            unset($this->TicketNumber);
        } else {
            $this->TicketNumber = $ticketNumber;
        }
        return $this;
    }
    /**
     * Get TicketOwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTicketOwnerId()
    {
        return isset($this->TicketOwnerId) ? $this->TicketOwnerId : null;
    }
    /**
     * Set TicketOwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ticketOwnerId
     * @return \patest\StructType\Ticketing_MobiliseTicketAvailability
     */
    public function setTicketOwnerId($ticketOwnerId = null)
    {
        // validation for constraint: int
        if (!is_null($ticketOwnerId) && !(is_int($ticketOwnerId) || ctype_digit($ticketOwnerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ticketOwnerId, true), gettype($ticketOwnerId)), __LINE__);
        }
        if (is_null($ticketOwnerId) || (is_array($ticketOwnerId) && empty($ticketOwnerId))) {
            unset($this->TicketOwnerId);
        } else {
            $this->TicketOwnerId = $ticketOwnerId;
        }
        return $this;
    }
}
