<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.HandoverAudit StructType
 * @subpackage Structs
 */
class Ticketing_HandoverAudit extends PersistableEntity
{
    /**
     * The AmountMoved
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $AmountMoved;
    /**
     * The DateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateTime;
    /**
     * The NewBarcodeCreated
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NewBarcodeCreated;
    /**
     * The NewClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewClientId;
    /**
     * The NewHandoverTransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewHandoverTransactionId;
    /**
     * The NewProductId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewProductId;
    /**
     * The OriginalClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OriginalClientId;
    /**
     * The OriginalHandoverTransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OriginalHandoverTransactionId;
    /**
     * The OriginalProductId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OriginalProductId;
    /**
     * The PrintedNewTicket
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PrintedNewTicket;
    /**
     * The ProductType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProductType;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserName;
    /**
     * Constructor method for Ticketing.HandoverAudit
     * @uses Ticketing_HandoverAudit::setAmountMoved()
     * @uses Ticketing_HandoverAudit::setDateTime()
     * @uses Ticketing_HandoverAudit::setNewBarcodeCreated()
     * @uses Ticketing_HandoverAudit::setNewClientId()
     * @uses Ticketing_HandoverAudit::setNewHandoverTransactionId()
     * @uses Ticketing_HandoverAudit::setNewProductId()
     * @uses Ticketing_HandoverAudit::setOriginalClientId()
     * @uses Ticketing_HandoverAudit::setOriginalHandoverTransactionId()
     * @uses Ticketing_HandoverAudit::setOriginalProductId()
     * @uses Ticketing_HandoverAudit::setPrintedNewTicket()
     * @uses Ticketing_HandoverAudit::setProductType()
     * @uses Ticketing_HandoverAudit::setUserName()
     * @param \patest\StructType\Money $amountMoved
     * @param string $dateTime
     * @param bool $newBarcodeCreated
     * @param string $newClientId
     * @param string $newHandoverTransactionId
     * @param string $newProductId
     * @param string $originalClientId
     * @param string $originalHandoverTransactionId
     * @param string $originalProductId
     * @param bool $printedNewTicket
     * @param string $productType
     * @param string $userName
     */
    public function __construct(\patest\StructType\Money $amountMoved = null, $dateTime = null, $newBarcodeCreated = null, $newClientId = null, $newHandoverTransactionId = null, $newProductId = null, $originalClientId = null, $originalHandoverTransactionId = null, $originalProductId = null, $printedNewTicket = null, $productType = null, $userName = null)
    {
        $this
            ->setAmountMoved($amountMoved)
            ->setDateTime($dateTime)
            ->setNewBarcodeCreated($newBarcodeCreated)
            ->setNewClientId($newClientId)
            ->setNewHandoverTransactionId($newHandoverTransactionId)
            ->setNewProductId($newProductId)
            ->setOriginalClientId($originalClientId)
            ->setOriginalHandoverTransactionId($originalHandoverTransactionId)
            ->setOriginalProductId($originalProductId)
            ->setPrintedNewTicket($printedNewTicket)
            ->setProductType($productType)
            ->setUserName($userName);
    }
    /**
     * Get AmountMoved value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getAmountMoved()
    {
        return isset($this->AmountMoved) ? $this->AmountMoved : null;
    }
    /**
     * Set AmountMoved value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $amountMoved
     * @return \patest\StructType\Ticketing_HandoverAudit
     */
    public function setAmountMoved(\patest\StructType\Money $amountMoved = null)
    {
        if (is_null($amountMoved) || (is_array($amountMoved) && empty($amountMoved))) {
            unset($this->AmountMoved);
        } else {
            $this->AmountMoved = $amountMoved;
        }
        return $this;
    }
    /**
     * Get DateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateTime()
    {
        return isset($this->DateTime) ? $this->DateTime : null;
    }
    /**
     * Set DateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateTime
     * @return \patest\StructType\Ticketing_HandoverAudit
     */
    public function setDateTime($dateTime = null)
    {
        // validation for constraint: string
        if (!is_null($dateTime) && !is_string($dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTime, true), gettype($dateTime)), __LINE__);
        }
        if (is_null($dateTime) || (is_array($dateTime) && empty($dateTime))) {
            unset($this->DateTime);
        } else {
            $this->DateTime = $dateTime;
        }
        return $this;
    }
    /**
     * Get NewBarcodeCreated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNewBarcodeCreated()
    {
        return isset($this->NewBarcodeCreated) ? $this->NewBarcodeCreated : null;
    }
    /**
     * Set NewBarcodeCreated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $newBarcodeCreated
     * @return \patest\StructType\Ticketing_HandoverAudit
     */
    public function setNewBarcodeCreated($newBarcodeCreated = null)
    {
        // validation for constraint: boolean
        if (!is_null($newBarcodeCreated) && !is_bool($newBarcodeCreated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($newBarcodeCreated, true), gettype($newBarcodeCreated)), __LINE__);
        }
        if (is_null($newBarcodeCreated) || (is_array($newBarcodeCreated) && empty($newBarcodeCreated))) {
            unset($this->NewBarcodeCreated);
        } else {
            $this->NewBarcodeCreated = $newBarcodeCreated;
        }
        return $this;
    }
    /**
     * Get NewClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewClientId()
    {
        return isset($this->NewClientId) ? $this->NewClientId : null;
    }
    /**
     * Set NewClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newClientId
     * @return \patest\StructType\Ticketing_HandoverAudit
     */
    public function setNewClientId($newClientId = null)
    {
        // validation for constraint: string
        if (!is_null($newClientId) && !is_string($newClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newClientId, true), gettype($newClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newClientId, true)), __LINE__);
        }
        if (is_null($newClientId) || (is_array($newClientId) && empty($newClientId))) {
            unset($this->NewClientId);
        } else {
            $this->NewClientId = $newClientId;
        }
        return $this;
    }
    /**
     * Get NewHandoverTransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewHandoverTransactionId()
    {
        return isset($this->NewHandoverTransactionId) ? $this->NewHandoverTransactionId : null;
    }
    /**
     * Set NewHandoverTransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newHandoverTransactionId
     * @return \patest\StructType\Ticketing_HandoverAudit
     */
    public function setNewHandoverTransactionId($newHandoverTransactionId = null)
    {
        // validation for constraint: string
        if (!is_null($newHandoverTransactionId) && !is_string($newHandoverTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newHandoverTransactionId, true), gettype($newHandoverTransactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newHandoverTransactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newHandoverTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newHandoverTransactionId, true)), __LINE__);
        }
        if (is_null($newHandoverTransactionId) || (is_array($newHandoverTransactionId) && empty($newHandoverTransactionId))) {
            unset($this->NewHandoverTransactionId);
        } else {
            $this->NewHandoverTransactionId = $newHandoverTransactionId;
        }
        return $this;
    }
    /**
     * Get NewProductId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewProductId()
    {
        return isset($this->NewProductId) ? $this->NewProductId : null;
    }
    /**
     * Set NewProductId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newProductId
     * @return \patest\StructType\Ticketing_HandoverAudit
     */
    public function setNewProductId($newProductId = null)
    {
        // validation for constraint: string
        if (!is_null($newProductId) && !is_string($newProductId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newProductId, true), gettype($newProductId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newProductId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newProductId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newProductId, true)), __LINE__);
        }
        if (is_null($newProductId) || (is_array($newProductId) && empty($newProductId))) {
            unset($this->NewProductId);
        } else {
            $this->NewProductId = $newProductId;
        }
        return $this;
    }
    /**
     * Get OriginalClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalClientId()
    {
        return isset($this->OriginalClientId) ? $this->OriginalClientId : null;
    }
    /**
     * Set OriginalClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalClientId
     * @return \patest\StructType\Ticketing_HandoverAudit
     */
    public function setOriginalClientId($originalClientId = null)
    {
        // validation for constraint: string
        if (!is_null($originalClientId) && !is_string($originalClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalClientId, true), gettype($originalClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($originalClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $originalClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($originalClientId, true)), __LINE__);
        }
        if (is_null($originalClientId) || (is_array($originalClientId) && empty($originalClientId))) {
            unset($this->OriginalClientId);
        } else {
            $this->OriginalClientId = $originalClientId;
        }
        return $this;
    }
    /**
     * Get OriginalHandoverTransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalHandoverTransactionId()
    {
        return isset($this->OriginalHandoverTransactionId) ? $this->OriginalHandoverTransactionId : null;
    }
    /**
     * Set OriginalHandoverTransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalHandoverTransactionId
     * @return \patest\StructType\Ticketing_HandoverAudit
     */
    public function setOriginalHandoverTransactionId($originalHandoverTransactionId = null)
    {
        // validation for constraint: string
        if (!is_null($originalHandoverTransactionId) && !is_string($originalHandoverTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalHandoverTransactionId, true), gettype($originalHandoverTransactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($originalHandoverTransactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $originalHandoverTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($originalHandoverTransactionId, true)), __LINE__);
        }
        if (is_null($originalHandoverTransactionId) || (is_array($originalHandoverTransactionId) && empty($originalHandoverTransactionId))) {
            unset($this->OriginalHandoverTransactionId);
        } else {
            $this->OriginalHandoverTransactionId = $originalHandoverTransactionId;
        }
        return $this;
    }
    /**
     * Get OriginalProductId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalProductId()
    {
        return isset($this->OriginalProductId) ? $this->OriginalProductId : null;
    }
    /**
     * Set OriginalProductId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalProductId
     * @return \patest\StructType\Ticketing_HandoverAudit
     */
    public function setOriginalProductId($originalProductId = null)
    {
        // validation for constraint: string
        if (!is_null($originalProductId) && !is_string($originalProductId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalProductId, true), gettype($originalProductId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($originalProductId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $originalProductId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($originalProductId, true)), __LINE__);
        }
        if (is_null($originalProductId) || (is_array($originalProductId) && empty($originalProductId))) {
            unset($this->OriginalProductId);
        } else {
            $this->OriginalProductId = $originalProductId;
        }
        return $this;
    }
    /**
     * Get PrintedNewTicket value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPrintedNewTicket()
    {
        return isset($this->PrintedNewTicket) ? $this->PrintedNewTicket : null;
    }
    /**
     * Set PrintedNewTicket value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $printedNewTicket
     * @return \patest\StructType\Ticketing_HandoverAudit
     */
    public function setPrintedNewTicket($printedNewTicket = null)
    {
        // validation for constraint: boolean
        if (!is_null($printedNewTicket) && !is_bool($printedNewTicket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($printedNewTicket, true), gettype($printedNewTicket)), __LINE__);
        }
        if (is_null($printedNewTicket) || (is_array($printedNewTicket) && empty($printedNewTicket))) {
            unset($this->PrintedNewTicket);
        } else {
            $this->PrintedNewTicket = $printedNewTicket;
        }
        return $this;
    }
    /**
     * Get ProductType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductType()
    {
        return isset($this->ProductType) ? $this->ProductType : null;
    }
    /**
     * Set ProductType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\HandoverProductType::valueIsValid()
     * @uses \patest\EnumType\HandoverProductType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $productType
     * @return \patest\StructType\Ticketing_HandoverAudit
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\HandoverProductType::valueIsValid($productType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\HandoverProductType', is_array($productType) ? implode(', ', $productType) : var_export($productType, true), implode(', ', \patest\EnumType\HandoverProductType::getValidValues())), __LINE__);
        }
        if (is_null($productType) || (is_array($productType) && empty($productType))) {
            unset($this->ProductType);
        } else {
            $this->ProductType = $productType;
        }
        return $this;
    }
    /**
     * Get UserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserName()
    {
        return isset($this->UserName) ? $this->UserName : null;
    }
    /**
     * Set UserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userName
     * @return \patest\StructType\Ticketing_HandoverAudit
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        if (is_null($userName) || (is_array($userName) && empty($userName))) {
            unset($this->UserName);
        } else {
            $this->UserName = $userName;
        }
        return $this;
    }
}
