<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.Gate StructType
 * @subpackage Structs
 */
class Ticketing_Gate extends Ticketing_Base
{
    /**
     * The AccessControlData
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AccessControl_EntityAccessControlData
     */
    public $AccessControlData;
    /**
     * The AreaIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AreaIds
     */
    public $AreaIds;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The HallId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallId;
    /**
     * The HallVersionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallVersionId;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The ParentRecordId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ParentRecordId;
    /**
     * The PrintedName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PrintedName;
    /**
     * The ScannerIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ScannerIds
     */
    public $ScannerIds;
    /**
     * Constructor method for Ticketing.Gate
     * @uses Ticketing_Gate::setAccessControlData()
     * @uses Ticketing_Gate::setAreaIds()
     * @uses Ticketing_Gate::setDescription()
     * @uses Ticketing_Gate::setHallId()
     * @uses Ticketing_Gate::setHallVersionId()
     * @uses Ticketing_Gate::setIsActive()
     * @uses Ticketing_Gate::setName()
     * @uses Ticketing_Gate::setParentRecordId()
     * @uses Ticketing_Gate::setPrintedName()
     * @uses Ticketing_Gate::setScannerIds()
     * @param \patest\StructType\AccessControl_EntityAccessControlData $accessControlData
     * @param \patest\StructType\AreaIds $areaIds
     * @param \patest\StructType\GlobalString $description
     * @param string $hallId
     * @param string $hallVersionId
     * @param bool $isActive
     * @param \patest\StructType\GlobalString $name
     * @param string $parentRecordId
     * @param \patest\StructType\GlobalString $printedName
     * @param \patest\StructType\ScannerIds $scannerIds
     */
    public function __construct(\patest\StructType\AccessControl_EntityAccessControlData $accessControlData = null, \patest\StructType\AreaIds $areaIds = null, \patest\StructType\GlobalString $description = null, $hallId = null, $hallVersionId = null, $isActive = null, \patest\StructType\GlobalString $name = null, $parentRecordId = null, \patest\StructType\GlobalString $printedName = null, \patest\StructType\ScannerIds $scannerIds = null)
    {
        $this
            ->setAccessControlData($accessControlData)
            ->setAreaIds($areaIds)
            ->setDescription($description)
            ->setHallId($hallId)
            ->setHallVersionId($hallVersionId)
            ->setIsActive($isActive)
            ->setName($name)
            ->setParentRecordId($parentRecordId)
            ->setPrintedName($printedName)
            ->setScannerIds($scannerIds);
    }
    /**
     * Get AccessControlData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AccessControl_EntityAccessControlData|null
     */
    public function getAccessControlData()
    {
        return isset($this->AccessControlData) ? $this->AccessControlData : null;
    }
    /**
     * Set AccessControlData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AccessControl_EntityAccessControlData $accessControlData
     * @return \patest\StructType\Ticketing_Gate
     */
    public function setAccessControlData(\patest\StructType\AccessControl_EntityAccessControlData $accessControlData = null)
    {
        if (is_null($accessControlData) || (is_array($accessControlData) && empty($accessControlData))) {
            unset($this->AccessControlData);
        } else {
            $this->AccessControlData = $accessControlData;
        }
        return $this;
    }
    /**
     * Get AreaIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AreaIds|null
     */
    public function getAreaIds()
    {
        return isset($this->AreaIds) ? $this->AreaIds : null;
    }
    /**
     * Set AreaIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AreaIds $areaIds
     * @return \patest\StructType\Ticketing_Gate
     */
    public function setAreaIds(\patest\StructType\AreaIds $areaIds = null)
    {
        if (is_null($areaIds) || (is_array($areaIds) && empty($areaIds))) {
            unset($this->AreaIds);
        } else {
            $this->AreaIds = $areaIds;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\Ticketing_Gate
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get HallId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallId()
    {
        return isset($this->HallId) ? $this->HallId : null;
    }
    /**
     * Set HallId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallId
     * @return \patest\StructType\Ticketing_Gate
     */
    public function setHallId($hallId = null)
    {
        // validation for constraint: string
        if (!is_null($hallId) && !is_string($hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallId, true), gettype($hallId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallId, true)), __LINE__);
        }
        if (is_null($hallId) || (is_array($hallId) && empty($hallId))) {
            unset($this->HallId);
        } else {
            $this->HallId = $hallId;
        }
        return $this;
    }
    /**
     * Get HallVersionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallVersionId()
    {
        return isset($this->HallVersionId) ? $this->HallVersionId : null;
    }
    /**
     * Set HallVersionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallVersionId
     * @return \patest\StructType\Ticketing_Gate
     */
    public function setHallVersionId($hallVersionId = null)
    {
        // validation for constraint: string
        if (!is_null($hallVersionId) && !is_string($hallVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallVersionId, true), gettype($hallVersionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallVersionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallVersionId, true)), __LINE__);
        }
        if (is_null($hallVersionId) || (is_array($hallVersionId) && empty($hallVersionId))) {
            unset($this->HallVersionId);
        } else {
            $this->HallVersionId = $hallVersionId;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Ticketing_Gate
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Ticketing_Gate
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get ParentRecordId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParentRecordId()
    {
        return isset($this->ParentRecordId) ? $this->ParentRecordId : null;
    }
    /**
     * Set ParentRecordId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parentRecordId
     * @return \patest\StructType\Ticketing_Gate
     */
    public function setParentRecordId($parentRecordId = null)
    {
        // validation for constraint: string
        if (!is_null($parentRecordId) && !is_string($parentRecordId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentRecordId, true), gettype($parentRecordId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($parentRecordId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $parentRecordId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($parentRecordId, true)), __LINE__);
        }
        if (is_null($parentRecordId) || (is_array($parentRecordId) && empty($parentRecordId))) {
            unset($this->ParentRecordId);
        } else {
            $this->ParentRecordId = $parentRecordId;
        }
        return $this;
    }
    /**
     * Get PrintedName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPrintedName()
    {
        return isset($this->PrintedName) ? $this->PrintedName : null;
    }
    /**
     * Set PrintedName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $printedName
     * @return \patest\StructType\Ticketing_Gate
     */
    public function setPrintedName(\patest\StructType\GlobalString $printedName = null)
    {
        if (is_null($printedName) || (is_array($printedName) && empty($printedName))) {
            unset($this->PrintedName);
        } else {
            $this->PrintedName = $printedName;
        }
        return $this;
    }
    /**
     * Get ScannerIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ScannerIds|null
     */
    public function getScannerIds()
    {
        return isset($this->ScannerIds) ? $this->ScannerIds : null;
    }
    /**
     * Set ScannerIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ScannerIds $scannerIds
     * @return \patest\StructType\Ticketing_Gate
     */
    public function setScannerIds(\patest\StructType\ScannerIds $scannerIds = null)
    {
        if (is_null($scannerIds) || (is_array($scannerIds) && empty($scannerIds))) {
            unset($this->ScannerIds);
        } else {
            $this->ScannerIds = $scannerIds;
        }
        return $this;
    }
}
