<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.FirstEvent StructType
 * @subpackage Structs
 */
class Ticketing_FirstEvent extends AnyEntity
{
    /**
     * The EventDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDate;
    /**
     * The FormattedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FormattedDate;
    /**
     * The HallId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallId;
    /**
     * The HallName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $HallName;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The IsAvailableForSale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAvailableForSale;
    /**
     * The IsRequiredOnSeries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsRequiredOnSeries;
    /**
     * The OccupancyStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OccupancyStatus;
    /**
     * The SoldOut
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SoldOut;
    /**
     * Constructor method for Ticketing.FirstEvent
     * @uses Ticketing_FirstEvent::setEventDate()
     * @uses Ticketing_FirstEvent::setFormattedDate()
     * @uses Ticketing_FirstEvent::setHallId()
     * @uses Ticketing_FirstEvent::setHallName()
     * @uses Ticketing_FirstEvent::setId()
     * @uses Ticketing_FirstEvent::setIsAvailableForSale()
     * @uses Ticketing_FirstEvent::setIsRequiredOnSeries()
     * @uses Ticketing_FirstEvent::setOccupancyStatus()
     * @uses Ticketing_FirstEvent::setSoldOut()
     * @param string $eventDate
     * @param string $formattedDate
     * @param string $hallId
     * @param \patest\StructType\GlobalString $hallName
     * @param string $id
     * @param bool $isAvailableForSale
     * @param bool $isRequiredOnSeries
     * @param string $occupancyStatus
     * @param bool $soldOut
     */
    public function __construct($eventDate = null, $formattedDate = null, $hallId = null, \patest\StructType\GlobalString $hallName = null, $id = null, $isAvailableForSale = null, $isRequiredOnSeries = null, $occupancyStatus = null, $soldOut = null)
    {
        $this
            ->setEventDate($eventDate)
            ->setFormattedDate($formattedDate)
            ->setHallId($hallId)
            ->setHallName($hallName)
            ->setId($id)
            ->setIsAvailableForSale($isAvailableForSale)
            ->setIsRequiredOnSeries($isRequiredOnSeries)
            ->setOccupancyStatus($occupancyStatus)
            ->setSoldOut($soldOut);
    }
    /**
     * Get EventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDate()
    {
        return isset($this->EventDate) ? $this->EventDate : null;
    }
    /**
     * Set EventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDate
     * @return \patest\StructType\Ticketing_FirstEvent
     */
    public function setEventDate($eventDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventDate) && !is_string($eventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDate, true), gettype($eventDate)), __LINE__);
        }
        if (is_null($eventDate) || (is_array($eventDate) && empty($eventDate))) {
            unset($this->EventDate);
        } else {
            $this->EventDate = $eventDate;
        }
        return $this;
    }
    /**
     * Get FormattedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormattedDate()
    {
        return isset($this->FormattedDate) ? $this->FormattedDate : null;
    }
    /**
     * Set FormattedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $formattedDate
     * @return \patest\StructType\Ticketing_FirstEvent
     */
    public function setFormattedDate($formattedDate = null)
    {
        // validation for constraint: string
        if (!is_null($formattedDate) && !is_string($formattedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formattedDate, true), gettype($formattedDate)), __LINE__);
        }
        if (is_null($formattedDate) || (is_array($formattedDate) && empty($formattedDate))) {
            unset($this->FormattedDate);
        } else {
            $this->FormattedDate = $formattedDate;
        }
        return $this;
    }
    /**
     * Get HallId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallId()
    {
        return isset($this->HallId) ? $this->HallId : null;
    }
    /**
     * Set HallId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallId
     * @return \patest\StructType\Ticketing_FirstEvent
     */
    public function setHallId($hallId = null)
    {
        // validation for constraint: string
        if (!is_null($hallId) && !is_string($hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallId, true), gettype($hallId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallId, true)), __LINE__);
        }
        if (is_null($hallId) || (is_array($hallId) && empty($hallId))) {
            unset($this->HallId);
        } else {
            $this->HallId = $hallId;
        }
        return $this;
    }
    /**
     * Get HallName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getHallName()
    {
        return isset($this->HallName) ? $this->HallName : null;
    }
    /**
     * Set HallName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $hallName
     * @return \patest\StructType\Ticketing_FirstEvent
     */
    public function setHallName(\patest\StructType\GlobalString $hallName = null)
    {
        if (is_null($hallName) || (is_array($hallName) && empty($hallName))) {
            unset($this->HallName);
        } else {
            $this->HallName = $hallName;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\Ticketing_FirstEvent
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get IsAvailableForSale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAvailableForSale()
    {
        return isset($this->IsAvailableForSale) ? $this->IsAvailableForSale : null;
    }
    /**
     * Set IsAvailableForSale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAvailableForSale
     * @return \patest\StructType\Ticketing_FirstEvent
     */
    public function setIsAvailableForSale($isAvailableForSale = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAvailableForSale) && !is_bool($isAvailableForSale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAvailableForSale, true), gettype($isAvailableForSale)), __LINE__);
        }
        if (is_null($isAvailableForSale) || (is_array($isAvailableForSale) && empty($isAvailableForSale))) {
            unset($this->IsAvailableForSale);
        } else {
            $this->IsAvailableForSale = $isAvailableForSale;
        }
        return $this;
    }
    /**
     * Get IsRequiredOnSeries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsRequiredOnSeries()
    {
        return isset($this->IsRequiredOnSeries) ? $this->IsRequiredOnSeries : null;
    }
    /**
     * Set IsRequiredOnSeries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isRequiredOnSeries
     * @return \patest\StructType\Ticketing_FirstEvent
     */
    public function setIsRequiredOnSeries($isRequiredOnSeries = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRequiredOnSeries) && !is_bool($isRequiredOnSeries)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRequiredOnSeries, true), gettype($isRequiredOnSeries)), __LINE__);
        }
        if (is_null($isRequiredOnSeries) || (is_array($isRequiredOnSeries) && empty($isRequiredOnSeries))) {
            unset($this->IsRequiredOnSeries);
        } else {
            $this->IsRequiredOnSeries = $isRequiredOnSeries;
        }
        return $this;
    }
    /**
     * Get OccupancyStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOccupancyStatus()
    {
        return isset($this->OccupancyStatus) ? $this->OccupancyStatus : null;
    }
    /**
     * Set OccupancyStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\EventOccupancyStatus::valueIsValid()
     * @uses \patest\EnumType\EventOccupancyStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $occupancyStatus
     * @return \patest\StructType\Ticketing_FirstEvent
     */
    public function setOccupancyStatus($occupancyStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\EventOccupancyStatus::valueIsValid($occupancyStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EventOccupancyStatus', is_array($occupancyStatus) ? implode(', ', $occupancyStatus) : var_export($occupancyStatus, true), implode(', ', \patest\EnumType\EventOccupancyStatus::getValidValues())), __LINE__);
        }
        if (is_null($occupancyStatus) || (is_array($occupancyStatus) && empty($occupancyStatus))) {
            unset($this->OccupancyStatus);
        } else {
            $this->OccupancyStatus = $occupancyStatus;
        }
        return $this;
    }
    /**
     * Get SoldOut value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSoldOut()
    {
        return isset($this->SoldOut) ? $this->SoldOut : null;
    }
    /**
     * Set SoldOut value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $soldOut
     * @return \patest\StructType\Ticketing_FirstEvent
     */
    public function setSoldOut($soldOut = null)
    {
        // validation for constraint: boolean
        if (!is_null($soldOut) && !is_bool($soldOut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($soldOut, true), gettype($soldOut)), __LINE__);
        }
        if (is_null($soldOut) || (is_array($soldOut) && empty($soldOut))) {
            unset($this->SoldOut);
        } else {
            $this->SoldOut = $soldOut;
        }
        return $this;
    }
}
