<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.EventWithSalesMonitoringInfo StructType
 * @subpackage Structs
 */
class Ticketing_EventWithSalesMonitoringInfo extends Ticketing_Event
{
    /**
     * The AppServerNodeName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AppServerNodeName;
    /**
     * The CapacityCounters
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_SeatingPlanCapacityCounters
     */
    public $CapacityCounters;
    /**
     * The HallVersionName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $HallVersionName;
    /**
     * The IncludeComps
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IncludeComps;
    /**
     * The IncludeReserved
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IncludeReserved;
    /**
     * The IncludeZeroPrice
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IncludeZeroPrice;
    /**
     * The ManagerLoadedAt
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ManagerLoadedAt;
    /**
     * The ManagerStatus
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ManagerStatus;
    /**
     * The NewTicketCountLast15min
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NewTicketCountLast15min;
    /**
     * The NewTicketCountLast1Day
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NewTicketCountLast1Day;
    /**
     * The NewTicketCountLast1hr
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NewTicketCountLast1hr;
    /**
     * The NewTicketCountLast3hr
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NewTicketCountLast3hr;
    /**
     * The NewTicketCountToday
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NewTicketCountToday;
    /**
     * The NewTicketCountYesterday
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NewTicketCountYesterday;
    /**
     * The ScannedTicketCount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ScannedTicketCount;
    /**
     * The SessionCount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SessionCount;
    /**
     * Constructor method for Ticketing.EventWithSalesMonitoringInfo
     * @uses Ticketing_EventWithSalesMonitoringInfo::setAppServerNodeName()
     * @uses Ticketing_EventWithSalesMonitoringInfo::setCapacityCounters()
     * @uses Ticketing_EventWithSalesMonitoringInfo::setHallVersionName()
     * @uses Ticketing_EventWithSalesMonitoringInfo::setIncludeComps()
     * @uses Ticketing_EventWithSalesMonitoringInfo::setIncludeReserved()
     * @uses Ticketing_EventWithSalesMonitoringInfo::setIncludeZeroPrice()
     * @uses Ticketing_EventWithSalesMonitoringInfo::setManagerLoadedAt()
     * @uses Ticketing_EventWithSalesMonitoringInfo::setManagerStatus()
     * @uses Ticketing_EventWithSalesMonitoringInfo::setNewTicketCountLast15min()
     * @uses Ticketing_EventWithSalesMonitoringInfo::setNewTicketCountLast1Day()
     * @uses Ticketing_EventWithSalesMonitoringInfo::setNewTicketCountLast1hr()
     * @uses Ticketing_EventWithSalesMonitoringInfo::setNewTicketCountLast3hr()
     * @uses Ticketing_EventWithSalesMonitoringInfo::setNewTicketCountToday()
     * @uses Ticketing_EventWithSalesMonitoringInfo::setNewTicketCountYesterday()
     * @uses Ticketing_EventWithSalesMonitoringInfo::setScannedTicketCount()
     * @uses Ticketing_EventWithSalesMonitoringInfo::setSessionCount()
     * @param string $appServerNodeName
     * @param \patest\StructType\Ticketing_SeatingPlanCapacityCounters $capacityCounters
     * @param \patest\StructType\GlobalString $hallVersionName
     * @param bool $includeComps
     * @param bool $includeReserved
     * @param bool $includeZeroPrice
     * @param string $managerLoadedAt
     * @param string $managerStatus
     * @param int $newTicketCountLast15min
     * @param int $newTicketCountLast1Day
     * @param int $newTicketCountLast1hr
     * @param int $newTicketCountLast3hr
     * @param int $newTicketCountToday
     * @param int $newTicketCountYesterday
     * @param int $scannedTicketCount
     * @param int $sessionCount
     */
    public function __construct($appServerNodeName = null, \patest\StructType\Ticketing_SeatingPlanCapacityCounters $capacityCounters = null, \patest\StructType\GlobalString $hallVersionName = null, $includeComps = null, $includeReserved = null, $includeZeroPrice = null, $managerLoadedAt = null, $managerStatus = null, $newTicketCountLast15min = null, $newTicketCountLast1Day = null, $newTicketCountLast1hr = null, $newTicketCountLast3hr = null, $newTicketCountToday = null, $newTicketCountYesterday = null, $scannedTicketCount = null, $sessionCount = null)
    {
        $this
            ->setAppServerNodeName($appServerNodeName)
            ->setCapacityCounters($capacityCounters)
            ->setHallVersionName($hallVersionName)
            ->setIncludeComps($includeComps)
            ->setIncludeReserved($includeReserved)
            ->setIncludeZeroPrice($includeZeroPrice)
            ->setManagerLoadedAt($managerLoadedAt)
            ->setManagerStatus($managerStatus)
            ->setNewTicketCountLast15min($newTicketCountLast15min)
            ->setNewTicketCountLast1Day($newTicketCountLast1Day)
            ->setNewTicketCountLast1hr($newTicketCountLast1hr)
            ->setNewTicketCountLast3hr($newTicketCountLast3hr)
            ->setNewTicketCountToday($newTicketCountToday)
            ->setNewTicketCountYesterday($newTicketCountYesterday)
            ->setScannedTicketCount($scannedTicketCount)
            ->setSessionCount($sessionCount);
    }
    /**
     * Get AppServerNodeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAppServerNodeName()
    {
        return isset($this->AppServerNodeName) ? $this->AppServerNodeName : null;
    }
    /**
     * Set AppServerNodeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $appServerNodeName
     * @return \patest\StructType\Ticketing_EventWithSalesMonitoringInfo
     */
    public function setAppServerNodeName($appServerNodeName = null)
    {
        // validation for constraint: string
        if (!is_null($appServerNodeName) && !is_string($appServerNodeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appServerNodeName, true), gettype($appServerNodeName)), __LINE__);
        }
        if (is_null($appServerNodeName) || (is_array($appServerNodeName) && empty($appServerNodeName))) {
            unset($this->AppServerNodeName);
        } else {
            $this->AppServerNodeName = $appServerNodeName;
        }
        return $this;
    }
    /**
     * Get CapacityCounters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_SeatingPlanCapacityCounters|null
     */
    public function getCapacityCounters()
    {
        return isset($this->CapacityCounters) ? $this->CapacityCounters : null;
    }
    /**
     * Set CapacityCounters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_SeatingPlanCapacityCounters $capacityCounters
     * @return \patest\StructType\Ticketing_EventWithSalesMonitoringInfo
     */
    public function setCapacityCounters(\patest\StructType\Ticketing_SeatingPlanCapacityCounters $capacityCounters = null)
    {
        if (is_null($capacityCounters) || (is_array($capacityCounters) && empty($capacityCounters))) {
            unset($this->CapacityCounters);
        } else {
            $this->CapacityCounters = $capacityCounters;
        }
        return $this;
    }
    /**
     * Get HallVersionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getHallVersionName()
    {
        return isset($this->HallVersionName) ? $this->HallVersionName : null;
    }
    /**
     * Set HallVersionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $hallVersionName
     * @return \patest\StructType\Ticketing_EventWithSalesMonitoringInfo
     */
    public function setHallVersionName(\patest\StructType\GlobalString $hallVersionName = null)
    {
        if (is_null($hallVersionName) || (is_array($hallVersionName) && empty($hallVersionName))) {
            unset($this->HallVersionName);
        } else {
            $this->HallVersionName = $hallVersionName;
        }
        return $this;
    }
    /**
     * Get IncludeComps value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeComps()
    {
        return isset($this->IncludeComps) ? $this->IncludeComps : null;
    }
    /**
     * Set IncludeComps value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeComps
     * @return \patest\StructType\Ticketing_EventWithSalesMonitoringInfo
     */
    public function setIncludeComps($includeComps = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeComps) && !is_bool($includeComps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeComps, true), gettype($includeComps)), __LINE__);
        }
        if (is_null($includeComps) || (is_array($includeComps) && empty($includeComps))) {
            unset($this->IncludeComps);
        } else {
            $this->IncludeComps = $includeComps;
        }
        return $this;
    }
    /**
     * Get IncludeReserved value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeReserved()
    {
        return isset($this->IncludeReserved) ? $this->IncludeReserved : null;
    }
    /**
     * Set IncludeReserved value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeReserved
     * @return \patest\StructType\Ticketing_EventWithSalesMonitoringInfo
     */
    public function setIncludeReserved($includeReserved = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeReserved) && !is_bool($includeReserved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeReserved, true), gettype($includeReserved)), __LINE__);
        }
        if (is_null($includeReserved) || (is_array($includeReserved) && empty($includeReserved))) {
            unset($this->IncludeReserved);
        } else {
            $this->IncludeReserved = $includeReserved;
        }
        return $this;
    }
    /**
     * Get IncludeZeroPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeZeroPrice()
    {
        return isset($this->IncludeZeroPrice) ? $this->IncludeZeroPrice : null;
    }
    /**
     * Set IncludeZeroPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeZeroPrice
     * @return \patest\StructType\Ticketing_EventWithSalesMonitoringInfo
     */
    public function setIncludeZeroPrice($includeZeroPrice = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeZeroPrice) && !is_bool($includeZeroPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeZeroPrice, true), gettype($includeZeroPrice)), __LINE__);
        }
        if (is_null($includeZeroPrice) || (is_array($includeZeroPrice) && empty($includeZeroPrice))) {
            unset($this->IncludeZeroPrice);
        } else {
            $this->IncludeZeroPrice = $includeZeroPrice;
        }
        return $this;
    }
    /**
     * Get ManagerLoadedAt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getManagerLoadedAt()
    {
        return isset($this->ManagerLoadedAt) ? $this->ManagerLoadedAt : null;
    }
    /**
     * Set ManagerLoadedAt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $managerLoadedAt
     * @return \patest\StructType\Ticketing_EventWithSalesMonitoringInfo
     */
    public function setManagerLoadedAt($managerLoadedAt = null)
    {
        // validation for constraint: string
        if (!is_null($managerLoadedAt) && !is_string($managerLoadedAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($managerLoadedAt, true), gettype($managerLoadedAt)), __LINE__);
        }
        if (is_null($managerLoadedAt) || (is_array($managerLoadedAt) && empty($managerLoadedAt))) {
            unset($this->ManagerLoadedAt);
        } else {
            $this->ManagerLoadedAt = $managerLoadedAt;
        }
        return $this;
    }
    /**
     * Get ManagerStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getManagerStatus()
    {
        return isset($this->ManagerStatus) ? $this->ManagerStatus : null;
    }
    /**
     * Set ManagerStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SeatingPlanManagerStatus::valueIsValid()
     * @uses \patest\EnumType\SeatingPlanManagerStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $managerStatus
     * @return \patest\StructType\Ticketing_EventWithSalesMonitoringInfo
     */
    public function setManagerStatus($managerStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SeatingPlanManagerStatus::valueIsValid($managerStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SeatingPlanManagerStatus', is_array($managerStatus) ? implode(', ', $managerStatus) : var_export($managerStatus, true), implode(', ', \patest\EnumType\SeatingPlanManagerStatus::getValidValues())), __LINE__);
        }
        if (is_null($managerStatus) || (is_array($managerStatus) && empty($managerStatus))) {
            unset($this->ManagerStatus);
        } else {
            $this->ManagerStatus = $managerStatus;
        }
        return $this;
    }
    /**
     * Get NewTicketCountLast15min value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNewTicketCountLast15min()
    {
        return isset($this->NewTicketCountLast15min) ? $this->NewTicketCountLast15min : null;
    }
    /**
     * Set NewTicketCountLast15min value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $newTicketCountLast15min
     * @return \patest\StructType\Ticketing_EventWithSalesMonitoringInfo
     */
    public function setNewTicketCountLast15min($newTicketCountLast15min = null)
    {
        // validation for constraint: int
        if (!is_null($newTicketCountLast15min) && !(is_int($newTicketCountLast15min) || ctype_digit($newTicketCountLast15min))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($newTicketCountLast15min, true), gettype($newTicketCountLast15min)), __LINE__);
        }
        if (is_null($newTicketCountLast15min) || (is_array($newTicketCountLast15min) && empty($newTicketCountLast15min))) {
            unset($this->NewTicketCountLast15min);
        } else {
            $this->NewTicketCountLast15min = $newTicketCountLast15min;
        }
        return $this;
    }
    /**
     * Get NewTicketCountLast1Day value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNewTicketCountLast1Day()
    {
        return isset($this->NewTicketCountLast1Day) ? $this->NewTicketCountLast1Day : null;
    }
    /**
     * Set NewTicketCountLast1Day value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $newTicketCountLast1Day
     * @return \patest\StructType\Ticketing_EventWithSalesMonitoringInfo
     */
    public function setNewTicketCountLast1Day($newTicketCountLast1Day = null)
    {
        // validation for constraint: int
        if (!is_null($newTicketCountLast1Day) && !(is_int($newTicketCountLast1Day) || ctype_digit($newTicketCountLast1Day))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($newTicketCountLast1Day, true), gettype($newTicketCountLast1Day)), __LINE__);
        }
        if (is_null($newTicketCountLast1Day) || (is_array($newTicketCountLast1Day) && empty($newTicketCountLast1Day))) {
            unset($this->NewTicketCountLast1Day);
        } else {
            $this->NewTicketCountLast1Day = $newTicketCountLast1Day;
        }
        return $this;
    }
    /**
     * Get NewTicketCountLast1hr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNewTicketCountLast1hr()
    {
        return isset($this->NewTicketCountLast1hr) ? $this->NewTicketCountLast1hr : null;
    }
    /**
     * Set NewTicketCountLast1hr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $newTicketCountLast1hr
     * @return \patest\StructType\Ticketing_EventWithSalesMonitoringInfo
     */
    public function setNewTicketCountLast1hr($newTicketCountLast1hr = null)
    {
        // validation for constraint: int
        if (!is_null($newTicketCountLast1hr) && !(is_int($newTicketCountLast1hr) || ctype_digit($newTicketCountLast1hr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($newTicketCountLast1hr, true), gettype($newTicketCountLast1hr)), __LINE__);
        }
        if (is_null($newTicketCountLast1hr) || (is_array($newTicketCountLast1hr) && empty($newTicketCountLast1hr))) {
            unset($this->NewTicketCountLast1hr);
        } else {
            $this->NewTicketCountLast1hr = $newTicketCountLast1hr;
        }
        return $this;
    }
    /**
     * Get NewTicketCountLast3hr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNewTicketCountLast3hr()
    {
        return isset($this->NewTicketCountLast3hr) ? $this->NewTicketCountLast3hr : null;
    }
    /**
     * Set NewTicketCountLast3hr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $newTicketCountLast3hr
     * @return \patest\StructType\Ticketing_EventWithSalesMonitoringInfo
     */
    public function setNewTicketCountLast3hr($newTicketCountLast3hr = null)
    {
        // validation for constraint: int
        if (!is_null($newTicketCountLast3hr) && !(is_int($newTicketCountLast3hr) || ctype_digit($newTicketCountLast3hr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($newTicketCountLast3hr, true), gettype($newTicketCountLast3hr)), __LINE__);
        }
        if (is_null($newTicketCountLast3hr) || (is_array($newTicketCountLast3hr) && empty($newTicketCountLast3hr))) {
            unset($this->NewTicketCountLast3hr);
        } else {
            $this->NewTicketCountLast3hr = $newTicketCountLast3hr;
        }
        return $this;
    }
    /**
     * Get NewTicketCountToday value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNewTicketCountToday()
    {
        return isset($this->NewTicketCountToday) ? $this->NewTicketCountToday : null;
    }
    /**
     * Set NewTicketCountToday value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $newTicketCountToday
     * @return \patest\StructType\Ticketing_EventWithSalesMonitoringInfo
     */
    public function setNewTicketCountToday($newTicketCountToday = null)
    {
        // validation for constraint: int
        if (!is_null($newTicketCountToday) && !(is_int($newTicketCountToday) || ctype_digit($newTicketCountToday))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($newTicketCountToday, true), gettype($newTicketCountToday)), __LINE__);
        }
        if (is_null($newTicketCountToday) || (is_array($newTicketCountToday) && empty($newTicketCountToday))) {
            unset($this->NewTicketCountToday);
        } else {
            $this->NewTicketCountToday = $newTicketCountToday;
        }
        return $this;
    }
    /**
     * Get NewTicketCountYesterday value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNewTicketCountYesterday()
    {
        return isset($this->NewTicketCountYesterday) ? $this->NewTicketCountYesterday : null;
    }
    /**
     * Set NewTicketCountYesterday value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $newTicketCountYesterday
     * @return \patest\StructType\Ticketing_EventWithSalesMonitoringInfo
     */
    public function setNewTicketCountYesterday($newTicketCountYesterday = null)
    {
        // validation for constraint: int
        if (!is_null($newTicketCountYesterday) && !(is_int($newTicketCountYesterday) || ctype_digit($newTicketCountYesterday))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($newTicketCountYesterday, true), gettype($newTicketCountYesterday)), __LINE__);
        }
        if (is_null($newTicketCountYesterday) || (is_array($newTicketCountYesterday) && empty($newTicketCountYesterday))) {
            unset($this->NewTicketCountYesterday);
        } else {
            $this->NewTicketCountYesterday = $newTicketCountYesterday;
        }
        return $this;
    }
    /**
     * Get ScannedTicketCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getScannedTicketCount()
    {
        return isset($this->ScannedTicketCount) ? $this->ScannedTicketCount : null;
    }
    /**
     * Set ScannedTicketCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $scannedTicketCount
     * @return \patest\StructType\Ticketing_EventWithSalesMonitoringInfo
     */
    public function setScannedTicketCount($scannedTicketCount = null)
    {
        // validation for constraint: int
        if (!is_null($scannedTicketCount) && !(is_int($scannedTicketCount) || ctype_digit($scannedTicketCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($scannedTicketCount, true), gettype($scannedTicketCount)), __LINE__);
        }
        if (is_null($scannedTicketCount) || (is_array($scannedTicketCount) && empty($scannedTicketCount))) {
            unset($this->ScannedTicketCount);
        } else {
            $this->ScannedTicketCount = $scannedTicketCount;
        }
        return $this;
    }
    /**
     * Get SessionCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSessionCount()
    {
        return isset($this->SessionCount) ? $this->SessionCount : null;
    }
    /**
     * Set SessionCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $sessionCount
     * @return \patest\StructType\Ticketing_EventWithSalesMonitoringInfo
     */
    public function setSessionCount($sessionCount = null)
    {
        // validation for constraint: int
        if (!is_null($sessionCount) && !(is_int($sessionCount) || ctype_digit($sessionCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sessionCount, true), gettype($sessionCount)), __LINE__);
        }
        if (is_null($sessionCount) || (is_array($sessionCount) && empty($sessionCount))) {
            unset($this->SessionCount);
        } else {
            $this->SessionCount = $sessionCount;
        }
        return $this;
    }
}
