<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.EventTicketSchemeRelation StructType
 * @subpackage Structs
 */
class Ticketing_EventTicketSchemeRelation extends PersistableEntity
{
    /**
     * The AllReservedCount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AllReservedCount;
    /**
     * The CanBeReservedCount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CanBeReservedCount;
    /**
     * The CanceledCount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CanceledCount;
    /**
     * The CanRunVerify
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanRunVerify;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - base: xs:duration
     * - maxInclusive: P10675199DT2H48M5.4775807S
     * - minInclusive: -P10675199DT2H48M5.4775808S
     * - minOccurs: 0
     * - nillable: true
     * - pattern: \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?
     * - type: tns:duration
     * @var string
     */
    public $Duration;
    /**
     * The EligibleClientTypesForPayOnEnroll
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EligibleClientTypesForPayOnEnroll
     */
    public $EligibleClientTypesForPayOnEnroll;
    /**
     * The EnrollmentsCount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $EnrollmentsCount;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The FailedConfigurationIssueCount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FailedConfigurationIssueCount;
    /**
     * The FailedOtherCount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FailedOtherCount;
    /**
     * The FailedPaymentCount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FailedPaymentCount;
    /**
     * The FailedSeatingCount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FailedSeatingCount;
    /**
     * The FulffilledCount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FulffilledCount;
    /**
     * The FulffilledUnpaidCount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FulffilledUnpaidCount;
    /**
     * The HandledByOtherCount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HandledByOtherCount;
    /**
     * The HasErrors
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasErrors;
    /**
     * The HasReservations
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasReservations;
    /**
     * The InProcess
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $InProcess;
    /**
     * The LastFulfillmentDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastFulfillmentDate;
    /**
     * The PayOnEnroll
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PayOnEnroll;
    /**
     * The PendingCount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PendingCount;
    /**
     * The ProcessedByUserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProcessedByUserId;
    /**
     * The ReservedCount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ReservedCount;
    /**
     * The ReservedWithNoPaymentDetailsCount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ReservedWithNoPaymentDetailsCount;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * The TicketSchemeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketSchemeId;
    /**
     * The TotalProcessedCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TotalProcessedCount;
    /**
     * The WorkItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $WorkItemId;
    /**
     * Constructor method for Ticketing.EventTicketSchemeRelation
     * @uses Ticketing_EventTicketSchemeRelation::setAllReservedCount()
     * @uses Ticketing_EventTicketSchemeRelation::setCanBeReservedCount()
     * @uses Ticketing_EventTicketSchemeRelation::setCanceledCount()
     * @uses Ticketing_EventTicketSchemeRelation::setCanRunVerify()
     * @uses Ticketing_EventTicketSchemeRelation::setDuration()
     * @uses Ticketing_EventTicketSchemeRelation::setEligibleClientTypesForPayOnEnroll()
     * @uses Ticketing_EventTicketSchemeRelation::setEnrollmentsCount()
     * @uses Ticketing_EventTicketSchemeRelation::setEventId()
     * @uses Ticketing_EventTicketSchemeRelation::setFailedConfigurationIssueCount()
     * @uses Ticketing_EventTicketSchemeRelation::setFailedOtherCount()
     * @uses Ticketing_EventTicketSchemeRelation::setFailedPaymentCount()
     * @uses Ticketing_EventTicketSchemeRelation::setFailedSeatingCount()
     * @uses Ticketing_EventTicketSchemeRelation::setFulffilledCount()
     * @uses Ticketing_EventTicketSchemeRelation::setFulffilledUnpaidCount()
     * @uses Ticketing_EventTicketSchemeRelation::setHandledByOtherCount()
     * @uses Ticketing_EventTicketSchemeRelation::setHasErrors()
     * @uses Ticketing_EventTicketSchemeRelation::setHasReservations()
     * @uses Ticketing_EventTicketSchemeRelation::setInProcess()
     * @uses Ticketing_EventTicketSchemeRelation::setLastFulfillmentDate()
     * @uses Ticketing_EventTicketSchemeRelation::setPayOnEnroll()
     * @uses Ticketing_EventTicketSchemeRelation::setPendingCount()
     * @uses Ticketing_EventTicketSchemeRelation::setProcessedByUserId()
     * @uses Ticketing_EventTicketSchemeRelation::setReservedCount()
     * @uses Ticketing_EventTicketSchemeRelation::setReservedWithNoPaymentDetailsCount()
     * @uses Ticketing_EventTicketSchemeRelation::setState()
     * @uses Ticketing_EventTicketSchemeRelation::setTicketSchemeId()
     * @uses Ticketing_EventTicketSchemeRelation::setTotalProcessedCount()
     * @uses Ticketing_EventTicketSchemeRelation::setWorkItemId()
     * @param int $allReservedCount
     * @param int $canBeReservedCount
     * @param int $canceledCount
     * @param bool $canRunVerify
     * @param string $duration
     * @param \patest\StructType\EligibleClientTypesForPayOnEnroll $eligibleClientTypesForPayOnEnroll
     * @param int $enrollmentsCount
     * @param string $eventId
     * @param int $failedConfigurationIssueCount
     * @param int $failedOtherCount
     * @param int $failedPaymentCount
     * @param int $failedSeatingCount
     * @param int $fulffilledCount
     * @param int $fulffilledUnpaidCount
     * @param int $handledByOtherCount
     * @param bool $hasErrors
     * @param bool $hasReservations
     * @param bool $inProcess
     * @param string $lastFulfillmentDate
     * @param bool $payOnEnroll
     * @param int $pendingCount
     * @param string $processedByUserId
     * @param int $reservedCount
     * @param int $reservedWithNoPaymentDetailsCount
     * @param string $state
     * @param string $ticketSchemeId
     * @param int $totalProcessedCount
     * @param string $workItemId
     */
    public function __construct($allReservedCount = null, $canBeReservedCount = null, $canceledCount = null, $canRunVerify = null, $duration = null, \patest\StructType\EligibleClientTypesForPayOnEnroll $eligibleClientTypesForPayOnEnroll = null, $enrollmentsCount = null, $eventId = null, $failedConfigurationIssueCount = null, $failedOtherCount = null, $failedPaymentCount = null, $failedSeatingCount = null, $fulffilledCount = null, $fulffilledUnpaidCount = null, $handledByOtherCount = null, $hasErrors = null, $hasReservations = null, $inProcess = null, $lastFulfillmentDate = null, $payOnEnroll = null, $pendingCount = null, $processedByUserId = null, $reservedCount = null, $reservedWithNoPaymentDetailsCount = null, $state = null, $ticketSchemeId = null, $totalProcessedCount = null, $workItemId = null)
    {
        $this
            ->setAllReservedCount($allReservedCount)
            ->setCanBeReservedCount($canBeReservedCount)
            ->setCanceledCount($canceledCount)
            ->setCanRunVerify($canRunVerify)
            ->setDuration($duration)
            ->setEligibleClientTypesForPayOnEnroll($eligibleClientTypesForPayOnEnroll)
            ->setEnrollmentsCount($enrollmentsCount)
            ->setEventId($eventId)
            ->setFailedConfigurationIssueCount($failedConfigurationIssueCount)
            ->setFailedOtherCount($failedOtherCount)
            ->setFailedPaymentCount($failedPaymentCount)
            ->setFailedSeatingCount($failedSeatingCount)
            ->setFulffilledCount($fulffilledCount)
            ->setFulffilledUnpaidCount($fulffilledUnpaidCount)
            ->setHandledByOtherCount($handledByOtherCount)
            ->setHasErrors($hasErrors)
            ->setHasReservations($hasReservations)
            ->setInProcess($inProcess)
            ->setLastFulfillmentDate($lastFulfillmentDate)
            ->setPayOnEnroll($payOnEnroll)
            ->setPendingCount($pendingCount)
            ->setProcessedByUserId($processedByUserId)
            ->setReservedCount($reservedCount)
            ->setReservedWithNoPaymentDetailsCount($reservedWithNoPaymentDetailsCount)
            ->setState($state)
            ->setTicketSchemeId($ticketSchemeId)
            ->setTotalProcessedCount($totalProcessedCount)
            ->setWorkItemId($workItemId);
    }
    /**
     * Get AllReservedCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAllReservedCount()
    {
        return isset($this->AllReservedCount) ? $this->AllReservedCount : null;
    }
    /**
     * Set AllReservedCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $allReservedCount
     * @return \patest\StructType\Ticketing_EventTicketSchemeRelation
     */
    public function setAllReservedCount($allReservedCount = null)
    {
        // validation for constraint: int
        if (!is_null($allReservedCount) && !(is_int($allReservedCount) || ctype_digit($allReservedCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($allReservedCount, true), gettype($allReservedCount)), __LINE__);
        }
        if (is_null($allReservedCount) || (is_array($allReservedCount) && empty($allReservedCount))) {
            unset($this->AllReservedCount);
        } else {
            $this->AllReservedCount = $allReservedCount;
        }
        return $this;
    }
    /**
     * Get CanBeReservedCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCanBeReservedCount()
    {
        return isset($this->CanBeReservedCount) ? $this->CanBeReservedCount : null;
    }
    /**
     * Set CanBeReservedCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $canBeReservedCount
     * @return \patest\StructType\Ticketing_EventTicketSchemeRelation
     */
    public function setCanBeReservedCount($canBeReservedCount = null)
    {
        // validation for constraint: int
        if (!is_null($canBeReservedCount) && !(is_int($canBeReservedCount) || ctype_digit($canBeReservedCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($canBeReservedCount, true), gettype($canBeReservedCount)), __LINE__);
        }
        if (is_null($canBeReservedCount) || (is_array($canBeReservedCount) && empty($canBeReservedCount))) {
            unset($this->CanBeReservedCount);
        } else {
            $this->CanBeReservedCount = $canBeReservedCount;
        }
        return $this;
    }
    /**
     * Get CanceledCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCanceledCount()
    {
        return isset($this->CanceledCount) ? $this->CanceledCount : null;
    }
    /**
     * Set CanceledCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $canceledCount
     * @return \patest\StructType\Ticketing_EventTicketSchemeRelation
     */
    public function setCanceledCount($canceledCount = null)
    {
        // validation for constraint: int
        if (!is_null($canceledCount) && !(is_int($canceledCount) || ctype_digit($canceledCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($canceledCount, true), gettype($canceledCount)), __LINE__);
        }
        if (is_null($canceledCount) || (is_array($canceledCount) && empty($canceledCount))) {
            unset($this->CanceledCount);
        } else {
            $this->CanceledCount = $canceledCount;
        }
        return $this;
    }
    /**
     * Get CanRunVerify value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanRunVerify()
    {
        return isset($this->CanRunVerify) ? $this->CanRunVerify : null;
    }
    /**
     * Set CanRunVerify value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canRunVerify
     * @return \patest\StructType\Ticketing_EventTicketSchemeRelation
     */
    public function setCanRunVerify($canRunVerify = null)
    {
        // validation for constraint: boolean
        if (!is_null($canRunVerify) && !is_bool($canRunVerify)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canRunVerify, true), gettype($canRunVerify)), __LINE__);
        }
        if (is_null($canRunVerify) || (is_array($canRunVerify) && empty($canRunVerify))) {
            unset($this->CanRunVerify);
        } else {
            $this->CanRunVerify = $canRunVerify;
        }
        return $this;
    }
    /**
     * Get Duration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDuration()
    {
        return isset($this->Duration) ? $this->Duration : null;
    }
    /**
     * Set Duration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $duration
     * @return \patest\StructType\Ticketing_EventTicketSchemeRelation
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        // validation for constraint: maxInclusive(P10675199DT2H48M5.4775807S)
        if (!is_null($duration) && false === mb_strpos($duration, '-') && ($time = (string) time()) && \DateTime::createFromFormat('U', $time)->add(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', str_replace('-', '', $duration)))) > \DateTime::createFromFormat('U', $time)->add(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', 'P10675199DT2H48M5.4775807S')))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be chronologically less than or equal to P10675199DT2H48M5.4775807S', var_export($duration, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-P10675199DT2H48M5.4775808S)
        if (!is_null($duration) && false !== mb_strpos($duration, '-') && ($time = (string) time()) && \DateTime::createFromFormat('U', $time)->sub(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', str_replace('-', '', $duration)))) < \DateTime::createFromFormat('U', $time)->sub(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', 'P10675199DT2H48M5.4775808S')))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be chronologically greater than or equal to -P10675199DT2H48M5.4775808S', var_export($duration, true)), __LINE__);
        }
        // validation for constraint: pattern(\-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?)
        if (!is_null($duration) && !preg_match('/\\-?P(\\d*D)?(T(\\d*H)?(\\d*M)?(\\d*(\\.\\d*)?S)?)?/', $duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?', var_export($duration, true)), __LINE__);
        }
        if (is_null($duration) || (is_array($duration) && empty($duration))) {
            unset($this->Duration);
        } else {
            $this->Duration = $duration;
        }
        return $this;
    }
    /**
     * Get EligibleClientTypesForPayOnEnroll value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EligibleClientTypesForPayOnEnroll|null
     */
    public function getEligibleClientTypesForPayOnEnroll()
    {
        return isset($this->EligibleClientTypesForPayOnEnroll) ? $this->EligibleClientTypesForPayOnEnroll : null;
    }
    /**
     * Set EligibleClientTypesForPayOnEnroll value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EligibleClientTypesForPayOnEnroll $eligibleClientTypesForPayOnEnroll
     * @return \patest\StructType\Ticketing_EventTicketSchemeRelation
     */
    public function setEligibleClientTypesForPayOnEnroll(\patest\StructType\EligibleClientTypesForPayOnEnroll $eligibleClientTypesForPayOnEnroll = null)
    {
        if (is_null($eligibleClientTypesForPayOnEnroll) || (is_array($eligibleClientTypesForPayOnEnroll) && empty($eligibleClientTypesForPayOnEnroll))) {
            unset($this->EligibleClientTypesForPayOnEnroll);
        } else {
            $this->EligibleClientTypesForPayOnEnroll = $eligibleClientTypesForPayOnEnroll;
        }
        return $this;
    }
    /**
     * Get EnrollmentsCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEnrollmentsCount()
    {
        return isset($this->EnrollmentsCount) ? $this->EnrollmentsCount : null;
    }
    /**
     * Set EnrollmentsCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $enrollmentsCount
     * @return \patest\StructType\Ticketing_EventTicketSchemeRelation
     */
    public function setEnrollmentsCount($enrollmentsCount = null)
    {
        // validation for constraint: int
        if (!is_null($enrollmentsCount) && !(is_int($enrollmentsCount) || ctype_digit($enrollmentsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($enrollmentsCount, true), gettype($enrollmentsCount)), __LINE__);
        }
        if (is_null($enrollmentsCount) || (is_array($enrollmentsCount) && empty($enrollmentsCount))) {
            unset($this->EnrollmentsCount);
        } else {
            $this->EnrollmentsCount = $enrollmentsCount;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\Ticketing_EventTicketSchemeRelation
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get FailedConfigurationIssueCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFailedConfigurationIssueCount()
    {
        return isset($this->FailedConfigurationIssueCount) ? $this->FailedConfigurationIssueCount : null;
    }
    /**
     * Set FailedConfigurationIssueCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $failedConfigurationIssueCount
     * @return \patest\StructType\Ticketing_EventTicketSchemeRelation
     */
    public function setFailedConfigurationIssueCount($failedConfigurationIssueCount = null)
    {
        // validation for constraint: int
        if (!is_null($failedConfigurationIssueCount) && !(is_int($failedConfigurationIssueCount) || ctype_digit($failedConfigurationIssueCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($failedConfigurationIssueCount, true), gettype($failedConfigurationIssueCount)), __LINE__);
        }
        if (is_null($failedConfigurationIssueCount) || (is_array($failedConfigurationIssueCount) && empty($failedConfigurationIssueCount))) {
            unset($this->FailedConfigurationIssueCount);
        } else {
            $this->FailedConfigurationIssueCount = $failedConfigurationIssueCount;
        }
        return $this;
    }
    /**
     * Get FailedOtherCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFailedOtherCount()
    {
        return isset($this->FailedOtherCount) ? $this->FailedOtherCount : null;
    }
    /**
     * Set FailedOtherCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $failedOtherCount
     * @return \patest\StructType\Ticketing_EventTicketSchemeRelation
     */
    public function setFailedOtherCount($failedOtherCount = null)
    {
        // validation for constraint: int
        if (!is_null($failedOtherCount) && !(is_int($failedOtherCount) || ctype_digit($failedOtherCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($failedOtherCount, true), gettype($failedOtherCount)), __LINE__);
        }
        if (is_null($failedOtherCount) || (is_array($failedOtherCount) && empty($failedOtherCount))) {
            unset($this->FailedOtherCount);
        } else {
            $this->FailedOtherCount = $failedOtherCount;
        }
        return $this;
    }
    /**
     * Get FailedPaymentCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFailedPaymentCount()
    {
        return isset($this->FailedPaymentCount) ? $this->FailedPaymentCount : null;
    }
    /**
     * Set FailedPaymentCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $failedPaymentCount
     * @return \patest\StructType\Ticketing_EventTicketSchemeRelation
     */
    public function setFailedPaymentCount($failedPaymentCount = null)
    {
        // validation for constraint: int
        if (!is_null($failedPaymentCount) && !(is_int($failedPaymentCount) || ctype_digit($failedPaymentCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($failedPaymentCount, true), gettype($failedPaymentCount)), __LINE__);
        }
        if (is_null($failedPaymentCount) || (is_array($failedPaymentCount) && empty($failedPaymentCount))) {
            unset($this->FailedPaymentCount);
        } else {
            $this->FailedPaymentCount = $failedPaymentCount;
        }
        return $this;
    }
    /**
     * Get FailedSeatingCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFailedSeatingCount()
    {
        return isset($this->FailedSeatingCount) ? $this->FailedSeatingCount : null;
    }
    /**
     * Set FailedSeatingCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $failedSeatingCount
     * @return \patest\StructType\Ticketing_EventTicketSchemeRelation
     */
    public function setFailedSeatingCount($failedSeatingCount = null)
    {
        // validation for constraint: int
        if (!is_null($failedSeatingCount) && !(is_int($failedSeatingCount) || ctype_digit($failedSeatingCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($failedSeatingCount, true), gettype($failedSeatingCount)), __LINE__);
        }
        if (is_null($failedSeatingCount) || (is_array($failedSeatingCount) && empty($failedSeatingCount))) {
            unset($this->FailedSeatingCount);
        } else {
            $this->FailedSeatingCount = $failedSeatingCount;
        }
        return $this;
    }
    /**
     * Get FulffilledCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFulffilledCount()
    {
        return isset($this->FulffilledCount) ? $this->FulffilledCount : null;
    }
    /**
     * Set FulffilledCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $fulffilledCount
     * @return \patest\StructType\Ticketing_EventTicketSchemeRelation
     */
    public function setFulffilledCount($fulffilledCount = null)
    {
        // validation for constraint: int
        if (!is_null($fulffilledCount) && !(is_int($fulffilledCount) || ctype_digit($fulffilledCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fulffilledCount, true), gettype($fulffilledCount)), __LINE__);
        }
        if (is_null($fulffilledCount) || (is_array($fulffilledCount) && empty($fulffilledCount))) {
            unset($this->FulffilledCount);
        } else {
            $this->FulffilledCount = $fulffilledCount;
        }
        return $this;
    }
    /**
     * Get FulffilledUnpaidCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFulffilledUnpaidCount()
    {
        return isset($this->FulffilledUnpaidCount) ? $this->FulffilledUnpaidCount : null;
    }
    /**
     * Set FulffilledUnpaidCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $fulffilledUnpaidCount
     * @return \patest\StructType\Ticketing_EventTicketSchemeRelation
     */
    public function setFulffilledUnpaidCount($fulffilledUnpaidCount = null)
    {
        // validation for constraint: int
        if (!is_null($fulffilledUnpaidCount) && !(is_int($fulffilledUnpaidCount) || ctype_digit($fulffilledUnpaidCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fulffilledUnpaidCount, true), gettype($fulffilledUnpaidCount)), __LINE__);
        }
        if (is_null($fulffilledUnpaidCount) || (is_array($fulffilledUnpaidCount) && empty($fulffilledUnpaidCount))) {
            unset($this->FulffilledUnpaidCount);
        } else {
            $this->FulffilledUnpaidCount = $fulffilledUnpaidCount;
        }
        return $this;
    }
    /**
     * Get HandledByOtherCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHandledByOtherCount()
    {
        return isset($this->HandledByOtherCount) ? $this->HandledByOtherCount : null;
    }
    /**
     * Set HandledByOtherCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $handledByOtherCount
     * @return \patest\StructType\Ticketing_EventTicketSchemeRelation
     */
    public function setHandledByOtherCount($handledByOtherCount = null)
    {
        // validation for constraint: int
        if (!is_null($handledByOtherCount) && !(is_int($handledByOtherCount) || ctype_digit($handledByOtherCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($handledByOtherCount, true), gettype($handledByOtherCount)), __LINE__);
        }
        if (is_null($handledByOtherCount) || (is_array($handledByOtherCount) && empty($handledByOtherCount))) {
            unset($this->HandledByOtherCount);
        } else {
            $this->HandledByOtherCount = $handledByOtherCount;
        }
        return $this;
    }
    /**
     * Get HasErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasErrors()
    {
        return isset($this->HasErrors) ? $this->HasErrors : null;
    }
    /**
     * Set HasErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasErrors
     * @return \patest\StructType\Ticketing_EventTicketSchemeRelation
     */
    public function setHasErrors($hasErrors = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasErrors) && !is_bool($hasErrors)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasErrors, true), gettype($hasErrors)), __LINE__);
        }
        if (is_null($hasErrors) || (is_array($hasErrors) && empty($hasErrors))) {
            unset($this->HasErrors);
        } else {
            $this->HasErrors = $hasErrors;
        }
        return $this;
    }
    /**
     * Get HasReservations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasReservations()
    {
        return isset($this->HasReservations) ? $this->HasReservations : null;
    }
    /**
     * Set HasReservations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasReservations
     * @return \patest\StructType\Ticketing_EventTicketSchemeRelation
     */
    public function setHasReservations($hasReservations = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasReservations) && !is_bool($hasReservations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasReservations, true), gettype($hasReservations)), __LINE__);
        }
        if (is_null($hasReservations) || (is_array($hasReservations) && empty($hasReservations))) {
            unset($this->HasReservations);
        } else {
            $this->HasReservations = $hasReservations;
        }
        return $this;
    }
    /**
     * Get InProcess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getInProcess()
    {
        return isset($this->InProcess) ? $this->InProcess : null;
    }
    /**
     * Set InProcess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $inProcess
     * @return \patest\StructType\Ticketing_EventTicketSchemeRelation
     */
    public function setInProcess($inProcess = null)
    {
        // validation for constraint: boolean
        if (!is_null($inProcess) && !is_bool($inProcess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inProcess, true), gettype($inProcess)), __LINE__);
        }
        if (is_null($inProcess) || (is_array($inProcess) && empty($inProcess))) {
            unset($this->InProcess);
        } else {
            $this->InProcess = $inProcess;
        }
        return $this;
    }
    /**
     * Get LastFulfillmentDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastFulfillmentDate()
    {
        return isset($this->LastFulfillmentDate) ? $this->LastFulfillmentDate : null;
    }
    /**
     * Set LastFulfillmentDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastFulfillmentDate
     * @return \patest\StructType\Ticketing_EventTicketSchemeRelation
     */
    public function setLastFulfillmentDate($lastFulfillmentDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastFulfillmentDate) && !is_string($lastFulfillmentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastFulfillmentDate, true), gettype($lastFulfillmentDate)), __LINE__);
        }
        if (is_null($lastFulfillmentDate) || (is_array($lastFulfillmentDate) && empty($lastFulfillmentDate))) {
            unset($this->LastFulfillmentDate);
        } else {
            $this->LastFulfillmentDate = $lastFulfillmentDate;
        }
        return $this;
    }
    /**
     * Get PayOnEnroll value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPayOnEnroll()
    {
        return isset($this->PayOnEnroll) ? $this->PayOnEnroll : null;
    }
    /**
     * Set PayOnEnroll value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $payOnEnroll
     * @return \patest\StructType\Ticketing_EventTicketSchemeRelation
     */
    public function setPayOnEnroll($payOnEnroll = null)
    {
        // validation for constraint: boolean
        if (!is_null($payOnEnroll) && !is_bool($payOnEnroll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($payOnEnroll, true), gettype($payOnEnroll)), __LINE__);
        }
        if (is_null($payOnEnroll) || (is_array($payOnEnroll) && empty($payOnEnroll))) {
            unset($this->PayOnEnroll);
        } else {
            $this->PayOnEnroll = $payOnEnroll;
        }
        return $this;
    }
    /**
     * Get PendingCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPendingCount()
    {
        return isset($this->PendingCount) ? $this->PendingCount : null;
    }
    /**
     * Set PendingCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $pendingCount
     * @return \patest\StructType\Ticketing_EventTicketSchemeRelation
     */
    public function setPendingCount($pendingCount = null)
    {
        // validation for constraint: int
        if (!is_null($pendingCount) && !(is_int($pendingCount) || ctype_digit($pendingCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pendingCount, true), gettype($pendingCount)), __LINE__);
        }
        if (is_null($pendingCount) || (is_array($pendingCount) && empty($pendingCount))) {
            unset($this->PendingCount);
        } else {
            $this->PendingCount = $pendingCount;
        }
        return $this;
    }
    /**
     * Get ProcessedByUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProcessedByUserId()
    {
        return isset($this->ProcessedByUserId) ? $this->ProcessedByUserId : null;
    }
    /**
     * Set ProcessedByUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $processedByUserId
     * @return \patest\StructType\Ticketing_EventTicketSchemeRelation
     */
    public function setProcessedByUserId($processedByUserId = null)
    {
        // validation for constraint: string
        if (!is_null($processedByUserId) && !is_string($processedByUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processedByUserId, true), gettype($processedByUserId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($processedByUserId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $processedByUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($processedByUserId, true)), __LINE__);
        }
        if (is_null($processedByUserId) || (is_array($processedByUserId) && empty($processedByUserId))) {
            unset($this->ProcessedByUserId);
        } else {
            $this->ProcessedByUserId = $processedByUserId;
        }
        return $this;
    }
    /**
     * Get ReservedCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getReservedCount()
    {
        return isset($this->ReservedCount) ? $this->ReservedCount : null;
    }
    /**
     * Set ReservedCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $reservedCount
     * @return \patest\StructType\Ticketing_EventTicketSchemeRelation
     */
    public function setReservedCount($reservedCount = null)
    {
        // validation for constraint: int
        if (!is_null($reservedCount) && !(is_int($reservedCount) || ctype_digit($reservedCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reservedCount, true), gettype($reservedCount)), __LINE__);
        }
        if (is_null($reservedCount) || (is_array($reservedCount) && empty($reservedCount))) {
            unset($this->ReservedCount);
        } else {
            $this->ReservedCount = $reservedCount;
        }
        return $this;
    }
    /**
     * Get ReservedWithNoPaymentDetailsCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getReservedWithNoPaymentDetailsCount()
    {
        return isset($this->ReservedWithNoPaymentDetailsCount) ? $this->ReservedWithNoPaymentDetailsCount : null;
    }
    /**
     * Set ReservedWithNoPaymentDetailsCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $reservedWithNoPaymentDetailsCount
     * @return \patest\StructType\Ticketing_EventTicketSchemeRelation
     */
    public function setReservedWithNoPaymentDetailsCount($reservedWithNoPaymentDetailsCount = null)
    {
        // validation for constraint: int
        if (!is_null($reservedWithNoPaymentDetailsCount) && !(is_int($reservedWithNoPaymentDetailsCount) || ctype_digit($reservedWithNoPaymentDetailsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reservedWithNoPaymentDetailsCount, true), gettype($reservedWithNoPaymentDetailsCount)), __LINE__);
        }
        if (is_null($reservedWithNoPaymentDetailsCount) || (is_array($reservedWithNoPaymentDetailsCount) && empty($reservedWithNoPaymentDetailsCount))) {
            unset($this->ReservedWithNoPaymentDetailsCount);
        } else {
            $this->ReservedWithNoPaymentDetailsCount = $reservedWithNoPaymentDetailsCount;
        }
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\FulfillmentExecutionState::valueIsValid()
     * @uses \patest\EnumType\FulfillmentExecutionState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \patest\StructType\Ticketing_EventTicketSchemeRelation
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\FulfillmentExecutionState::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\FulfillmentExecutionState', is_array($state) ? implode(', ', $state) : var_export($state, true), implode(', ', \patest\EnumType\FulfillmentExecutionState::getValidValues())), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
    /**
     * Get TicketSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketSchemeId()
    {
        return isset($this->TicketSchemeId) ? $this->TicketSchemeId : null;
    }
    /**
     * Set TicketSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketSchemeId
     * @return \patest\StructType\Ticketing_EventTicketSchemeRelation
     */
    public function setTicketSchemeId($ticketSchemeId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketSchemeId) && !is_string($ticketSchemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketSchemeId, true), gettype($ticketSchemeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketSchemeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketSchemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketSchemeId, true)), __LINE__);
        }
        if (is_null($ticketSchemeId) || (is_array($ticketSchemeId) && empty($ticketSchemeId))) {
            unset($this->TicketSchemeId);
        } else {
            $this->TicketSchemeId = $ticketSchemeId;
        }
        return $this;
    }
    /**
     * Get TotalProcessedCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTotalProcessedCount()
    {
        return isset($this->TotalProcessedCount) ? $this->TotalProcessedCount : null;
    }
    /**
     * Set TotalProcessedCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $totalProcessedCount
     * @return \patest\StructType\Ticketing_EventTicketSchemeRelation
     */
    public function setTotalProcessedCount($totalProcessedCount = null)
    {
        // validation for constraint: int
        if (!is_null($totalProcessedCount) && !(is_int($totalProcessedCount) || ctype_digit($totalProcessedCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalProcessedCount, true), gettype($totalProcessedCount)), __LINE__);
        }
        if (is_null($totalProcessedCount) || (is_array($totalProcessedCount) && empty($totalProcessedCount))) {
            unset($this->TotalProcessedCount);
        } else {
            $this->TotalProcessedCount = $totalProcessedCount;
        }
        return $this;
    }
    /**
     * Get WorkItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWorkItemId()
    {
        return isset($this->WorkItemId) ? $this->WorkItemId : null;
    }
    /**
     * Set WorkItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $workItemId
     * @return \patest\StructType\Ticketing_EventTicketSchemeRelation
     */
    public function setWorkItemId($workItemId = null)
    {
        // validation for constraint: string
        if (!is_null($workItemId) && !is_string($workItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workItemId, true), gettype($workItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($workItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $workItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($workItemId, true)), __LINE__);
        }
        if (is_null($workItemId) || (is_array($workItemId) && empty($workItemId))) {
            unset($this->WorkItemId);
        } else {
            $this->WorkItemId = $workItemId;
        }
        return $this;
    }
}
