<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.EventDates StructType
 * @subpackage Structs
 */
class Ticketing_EventDates extends AnyEntity
{
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Date;
    /**
     * The Qty
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Qty;
    /**
     * The SingleEventRepresentation
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SingleEventRepresentation;
    /**
     * Constructor method for Ticketing.EventDates
     * @uses Ticketing_EventDates::setDate()
     * @uses Ticketing_EventDates::setQty()
     * @uses Ticketing_EventDates::setSingleEventRepresentation()
     * @param string $date
     * @param int $qty
     * @param string $singleEventRepresentation
     */
    public function __construct($date = null, $qty = null, $singleEventRepresentation = null)
    {
        $this
            ->setDate($date)
            ->setQty($qty)
            ->setSingleEventRepresentation($singleEventRepresentation);
    }
    /**
     * Get Date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDate()
    {
        return isset($this->Date) ? $this->Date : null;
    }
    /**
     * Set Date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $date
     * @return \patest\StructType\Ticketing_EventDates
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        if (is_null($date) || (is_array($date) && empty($date))) {
            unset($this->Date);
        } else {
            $this->Date = $date;
        }
        return $this;
    }
    /**
     * Get Qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQty()
    {
        return isset($this->Qty) ? $this->Qty : null;
    }
    /**
     * Set Qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $qty
     * @return \patest\StructType\Ticketing_EventDates
     */
    public function setQty($qty = null)
    {
        // validation for constraint: int
        if (!is_null($qty) && !(is_int($qty) || ctype_digit($qty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($qty, true), gettype($qty)), __LINE__);
        }
        if (is_null($qty) || (is_array($qty) && empty($qty))) {
            unset($this->Qty);
        } else {
            $this->Qty = $qty;
        }
        return $this;
    }
    /**
     * Get SingleEventRepresentation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSingleEventRepresentation()
    {
        return isset($this->SingleEventRepresentation) ? $this->SingleEventRepresentation : null;
    }
    /**
     * Set SingleEventRepresentation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $singleEventRepresentation
     * @return \patest\StructType\Ticketing_EventDates
     */
    public function setSingleEventRepresentation($singleEventRepresentation = null)
    {
        // validation for constraint: string
        if (!is_null($singleEventRepresentation) && !is_string($singleEventRepresentation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($singleEventRepresentation, true), gettype($singleEventRepresentation)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($singleEventRepresentation) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $singleEventRepresentation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($singleEventRepresentation, true)), __LINE__);
        }
        if (is_null($singleEventRepresentation) || (is_array($singleEventRepresentation) && empty($singleEventRepresentation))) {
            unset($this->SingleEventRepresentation);
        } else {
            $this->SingleEventRepresentation = $singleEventRepresentation;
        }
        return $this;
    }
}
