<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.EventAvailableContinuousSeatsPerRow StructType
 * @subpackage Structs
 */
class Ticketing_EventAvailableContinuousSeatsPerRow extends DistributableEntity
{
    /**
     * The All
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $All;
    /**
     * The AllocationToolTip
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AllocationToolTip;
    /**
     * The AllocationType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AllocationType;
    /**
     * The AllocationTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AllocationTypeIds;
    /**
     * The Area
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Area;
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The Avail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Avail;
    /**
     * The AvailableInAllSubscriptionEvents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AvailableInAllSubscriptionEvents;
    /**
     * The DateOfEvent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateOfEvent;
    /**
     * The EnableAll
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $EnableAll;
    /**
     * The EventDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDate;
    /**
     * The EventHallName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventHallName;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The EventShowName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventShowName;
    /**
     * The EventShowType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventShowType;
    /**
     * The EventTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventTime;
    /**
     * The EventType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventType;
    /**
     * The EventWeekday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventWeekday;
    /**
     * The FirstSeat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstSeat;
    /**
     * The GARestrictionsUsage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GARestrictionsUsage;
    /**
     * The IsPrivateProperty
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPrivateProperty;
    /**
     * The IsSubscription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSubscription;
    /**
     * The LastSeat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastSeat;
    /**
     * The Lock
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Lock;
    /**
     * The LockTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LockTypeId;
    /**
     * The MaxUnavailbleEvents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxUnavailbleEvents;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Price;
    /**
     * The PriceLevelColor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceLevelColor;
    /**
     * The PriceLevelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceLevelId;
    /**
     * The PriceLevelName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceLevelName;
    /**
     * The PriceOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $PriceOverride;
    /**
     * The ResaleRequestDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResaleRequestDate;
    /**
     * The Row
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Row;
    /**
     * The SeatIndexes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatIndexes;
    /**
     * The SeatQTY
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SeatQTY;
    /**
     * The Seats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Seats;
    /**
     * The SeatType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatType;
    /**
     * The SeatTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeatTypeId;
    /**
     * The SectorId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SectorId;
    /**
     * The SectorName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SectorName;
    /**
     * The ShowId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowId;
    /**
     * The UnAvailableEventsToolTip
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UnAvailableEventsToolTip;
    /**
     * Constructor method for Ticketing.EventAvailableContinuousSeatsPerRow
     * @uses Ticketing_EventAvailableContinuousSeatsPerRow::setAll()
     * @uses Ticketing_EventAvailableContinuousSeatsPerRow::setAllocationToolTip()
     * @uses Ticketing_EventAvailableContinuousSeatsPerRow::setAllocationType()
     * @uses Ticketing_EventAvailableContinuousSeatsPerRow::setAllocationTypeIds()
     * @uses Ticketing_EventAvailableContinuousSeatsPerRow::setArea()
     * @uses Ticketing_EventAvailableContinuousSeatsPerRow::setAreaId()
     * @uses Ticketing_EventAvailableContinuousSeatsPerRow::setAvail()
     * @uses Ticketing_EventAvailableContinuousSeatsPerRow::setAvailableInAllSubscriptionEvents()
     * @uses Ticketing_EventAvailableContinuousSeatsPerRow::setDateOfEvent()
     * @uses Ticketing_EventAvailableContinuousSeatsPerRow::setEnableAll()
     * @uses Ticketing_EventAvailableContinuousSeatsPerRow::setEventDate()
     * @uses Ticketing_EventAvailableContinuousSeatsPerRow::setEventHallName()
     * @uses Ticketing_EventAvailableContinuousSeatsPerRow::setEventId()
     * @uses Ticketing_EventAvailableContinuousSeatsPerRow::setEventShowName()
     * @uses Ticketing_EventAvailableContinuousSeatsPerRow::setEventShowType()
     * @uses Ticketing_EventAvailableContinuousSeatsPerRow::setEventTime()
     * @uses Ticketing_EventAvailableContinuousSeatsPerRow::setEventType()
     * @uses Ticketing_EventAvailableContinuousSeatsPerRow::setEventWeekday()
     * @uses Ticketing_EventAvailableContinuousSeatsPerRow::setFirstSeat()
     * @uses Ticketing_EventAvailableContinuousSeatsPerRow::setGARestrictionsUsage()
     * @uses Ticketing_EventAvailableContinuousSeatsPerRow::setIsPrivateProperty()
     * @uses Ticketing_EventAvailableContinuousSeatsPerRow::setIsSubscription()
     * @uses Ticketing_EventAvailableContinuousSeatsPerRow::setLastSeat()
     * @uses Ticketing_EventAvailableContinuousSeatsPerRow::setLock()
     * @uses Ticketing_EventAvailableContinuousSeatsPerRow::setLockTypeId()
     * @uses Ticketing_EventAvailableContinuousSeatsPerRow::setMaxUnavailbleEvents()
     * @uses Ticketing_EventAvailableContinuousSeatsPerRow::setPrice()
     * @uses Ticketing_EventAvailableContinuousSeatsPerRow::setPriceLevelColor()
     * @uses Ticketing_EventAvailableContinuousSeatsPerRow::setPriceLevelId()
     * @uses Ticketing_EventAvailableContinuousSeatsPerRow::setPriceLevelName()
     * @uses Ticketing_EventAvailableContinuousSeatsPerRow::setPriceOverride()
     * @uses Ticketing_EventAvailableContinuousSeatsPerRow::setResaleRequestDate()
     * @uses Ticketing_EventAvailableContinuousSeatsPerRow::setRow()
     * @uses Ticketing_EventAvailableContinuousSeatsPerRow::setSeatIndexes()
     * @uses Ticketing_EventAvailableContinuousSeatsPerRow::setSeatQTY()
     * @uses Ticketing_EventAvailableContinuousSeatsPerRow::setSeats()
     * @uses Ticketing_EventAvailableContinuousSeatsPerRow::setSeatType()
     * @uses Ticketing_EventAvailableContinuousSeatsPerRow::setSeatTypeId()
     * @uses Ticketing_EventAvailableContinuousSeatsPerRow::setSectorId()
     * @uses Ticketing_EventAvailableContinuousSeatsPerRow::setSectorName()
     * @uses Ticketing_EventAvailableContinuousSeatsPerRow::setShowId()
     * @uses Ticketing_EventAvailableContinuousSeatsPerRow::setUnAvailableEventsToolTip()
     * @param bool $all
     * @param string $allocationToolTip
     * @param string $allocationType
     * @param string $allocationTypeIds
     * @param string $area
     * @param string $areaId
     * @param int $avail
     * @param bool $availableInAllSubscriptionEvents
     * @param string $dateOfEvent
     * @param bool $enableAll
     * @param string $eventDate
     * @param string $eventHallName
     * @param string $eventId
     * @param string $eventShowName
     * @param string $eventShowType
     * @param string $eventTime
     * @param string $eventType
     * @param string $eventWeekday
     * @param string $firstSeat
     * @param string $gARestrictionsUsage
     * @param bool $isPrivateProperty
     * @param bool $isSubscription
     * @param string $lastSeat
     * @param string $lock
     * @param string $lockTypeId
     * @param int $maxUnavailbleEvents
     * @param string $price
     * @param string $priceLevelColor
     * @param string $priceLevelId
     * @param string $priceLevelName
     * @param \patest\StructType\Money $priceOverride
     * @param string $resaleRequestDate
     * @param string $row
     * @param string $seatIndexes
     * @param int $seatQTY
     * @param string $seats
     * @param string $seatType
     * @param string $seatTypeId
     * @param string $sectorId
     * @param string $sectorName
     * @param string $showId
     * @param string $unAvailableEventsToolTip
     */
    public function __construct($all = null, $allocationToolTip = null, $allocationType = null, $allocationTypeIds = null, $area = null, $areaId = null, $avail = null, $availableInAllSubscriptionEvents = null, $dateOfEvent = null, $enableAll = null, $eventDate = null, $eventHallName = null, $eventId = null, $eventShowName = null, $eventShowType = null, $eventTime = null, $eventType = null, $eventWeekday = null, $firstSeat = null, $gARestrictionsUsage = null, $isPrivateProperty = null, $isSubscription = null, $lastSeat = null, $lock = null, $lockTypeId = null, $maxUnavailbleEvents = null, $price = null, $priceLevelColor = null, $priceLevelId = null, $priceLevelName = null, \patest\StructType\Money $priceOverride = null, $resaleRequestDate = null, $row = null, $seatIndexes = null, $seatQTY = null, $seats = null, $seatType = null, $seatTypeId = null, $sectorId = null, $sectorName = null, $showId = null, $unAvailableEventsToolTip = null)
    {
        $this
            ->setAll($all)
            ->setAllocationToolTip($allocationToolTip)
            ->setAllocationType($allocationType)
            ->setAllocationTypeIds($allocationTypeIds)
            ->setArea($area)
            ->setAreaId($areaId)
            ->setAvail($avail)
            ->setAvailableInAllSubscriptionEvents($availableInAllSubscriptionEvents)
            ->setDateOfEvent($dateOfEvent)
            ->setEnableAll($enableAll)
            ->setEventDate($eventDate)
            ->setEventHallName($eventHallName)
            ->setEventId($eventId)
            ->setEventShowName($eventShowName)
            ->setEventShowType($eventShowType)
            ->setEventTime($eventTime)
            ->setEventType($eventType)
            ->setEventWeekday($eventWeekday)
            ->setFirstSeat($firstSeat)
            ->setGARestrictionsUsage($gARestrictionsUsage)
            ->setIsPrivateProperty($isPrivateProperty)
            ->setIsSubscription($isSubscription)
            ->setLastSeat($lastSeat)
            ->setLock($lock)
            ->setLockTypeId($lockTypeId)
            ->setMaxUnavailbleEvents($maxUnavailbleEvents)
            ->setPrice($price)
            ->setPriceLevelColor($priceLevelColor)
            ->setPriceLevelId($priceLevelId)
            ->setPriceLevelName($priceLevelName)
            ->setPriceOverride($priceOverride)
            ->setResaleRequestDate($resaleRequestDate)
            ->setRow($row)
            ->setSeatIndexes($seatIndexes)
            ->setSeatQTY($seatQTY)
            ->setSeats($seats)
            ->setSeatType($seatType)
            ->setSeatTypeId($seatTypeId)
            ->setSectorId($sectorId)
            ->setSectorName($sectorName)
            ->setShowId($showId)
            ->setUnAvailableEventsToolTip($unAvailableEventsToolTip);
    }
    /**
     * Get All value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAll()
    {
        return isset($this->All) ? $this->All : null;
    }
    /**
     * Set All value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $all
     * @return \patest\StructType\Ticketing_EventAvailableContinuousSeatsPerRow
     */
    public function setAll($all = null)
    {
        // validation for constraint: boolean
        if (!is_null($all) && !is_bool($all)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($all, true), gettype($all)), __LINE__);
        }
        if (is_null($all) || (is_array($all) && empty($all))) {
            unset($this->All);
        } else {
            $this->All = $all;
        }
        return $this;
    }
    /**
     * Get AllocationToolTip value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAllocationToolTip()
    {
        return isset($this->AllocationToolTip) ? $this->AllocationToolTip : null;
    }
    /**
     * Set AllocationToolTip value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $allocationToolTip
     * @return \patest\StructType\Ticketing_EventAvailableContinuousSeatsPerRow
     */
    public function setAllocationToolTip($allocationToolTip = null)
    {
        // validation for constraint: string
        if (!is_null($allocationToolTip) && !is_string($allocationToolTip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allocationToolTip, true), gettype($allocationToolTip)), __LINE__);
        }
        if (is_null($allocationToolTip) || (is_array($allocationToolTip) && empty($allocationToolTip))) {
            unset($this->AllocationToolTip);
        } else {
            $this->AllocationToolTip = $allocationToolTip;
        }
        return $this;
    }
    /**
     * Get AllocationType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAllocationType()
    {
        return isset($this->AllocationType) ? $this->AllocationType : null;
    }
    /**
     * Set AllocationType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $allocationType
     * @return \patest\StructType\Ticketing_EventAvailableContinuousSeatsPerRow
     */
    public function setAllocationType($allocationType = null)
    {
        // validation for constraint: string
        if (!is_null($allocationType) && !is_string($allocationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allocationType, true), gettype($allocationType)), __LINE__);
        }
        if (is_null($allocationType) || (is_array($allocationType) && empty($allocationType))) {
            unset($this->AllocationType);
        } else {
            $this->AllocationType = $allocationType;
        }
        return $this;
    }
    /**
     * Get AllocationTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAllocationTypeIds()
    {
        return isset($this->AllocationTypeIds) ? $this->AllocationTypeIds : null;
    }
    /**
     * Set AllocationTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $allocationTypeIds
     * @return \patest\StructType\Ticketing_EventAvailableContinuousSeatsPerRow
     */
    public function setAllocationTypeIds($allocationTypeIds = null)
    {
        // validation for constraint: string
        if (!is_null($allocationTypeIds) && !is_string($allocationTypeIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allocationTypeIds, true), gettype($allocationTypeIds)), __LINE__);
        }
        if (is_null($allocationTypeIds) || (is_array($allocationTypeIds) && empty($allocationTypeIds))) {
            unset($this->AllocationTypeIds);
        } else {
            $this->AllocationTypeIds = $allocationTypeIds;
        }
        return $this;
    }
    /**
     * Get Area value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArea()
    {
        return isset($this->Area) ? $this->Area : null;
    }
    /**
     * Set Area value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $area
     * @return \patest\StructType\Ticketing_EventAvailableContinuousSeatsPerRow
     */
    public function setArea($area = null)
    {
        // validation for constraint: string
        if (!is_null($area) && !is_string($area)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($area, true), gettype($area)), __LINE__);
        }
        if (is_null($area) || (is_array($area) && empty($area))) {
            unset($this->Area);
        } else {
            $this->Area = $area;
        }
        return $this;
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\Ticketing_EventAvailableContinuousSeatsPerRow
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get Avail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAvail()
    {
        return isset($this->Avail) ? $this->Avail : null;
    }
    /**
     * Set Avail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $avail
     * @return \patest\StructType\Ticketing_EventAvailableContinuousSeatsPerRow
     */
    public function setAvail($avail = null)
    {
        // validation for constraint: int
        if (!is_null($avail) && !(is_int($avail) || ctype_digit($avail))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($avail, true), gettype($avail)), __LINE__);
        }
        if (is_null($avail) || (is_array($avail) && empty($avail))) {
            unset($this->Avail);
        } else {
            $this->Avail = $avail;
        }
        return $this;
    }
    /**
     * Get AvailableInAllSubscriptionEvents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAvailableInAllSubscriptionEvents()
    {
        return isset($this->AvailableInAllSubscriptionEvents) ? $this->AvailableInAllSubscriptionEvents : null;
    }
    /**
     * Set AvailableInAllSubscriptionEvents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $availableInAllSubscriptionEvents
     * @return \patest\StructType\Ticketing_EventAvailableContinuousSeatsPerRow
     */
    public function setAvailableInAllSubscriptionEvents($availableInAllSubscriptionEvents = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableInAllSubscriptionEvents) && !is_bool($availableInAllSubscriptionEvents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($availableInAllSubscriptionEvents, true), gettype($availableInAllSubscriptionEvents)), __LINE__);
        }
        if (is_null($availableInAllSubscriptionEvents) || (is_array($availableInAllSubscriptionEvents) && empty($availableInAllSubscriptionEvents))) {
            unset($this->AvailableInAllSubscriptionEvents);
        } else {
            $this->AvailableInAllSubscriptionEvents = $availableInAllSubscriptionEvents;
        }
        return $this;
    }
    /**
     * Get DateOfEvent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateOfEvent()
    {
        return isset($this->DateOfEvent) ? $this->DateOfEvent : null;
    }
    /**
     * Set DateOfEvent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateOfEvent
     * @return \patest\StructType\Ticketing_EventAvailableContinuousSeatsPerRow
     */
    public function setDateOfEvent($dateOfEvent = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfEvent) && !is_string($dateOfEvent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateOfEvent, true), gettype($dateOfEvent)), __LINE__);
        }
        if (is_null($dateOfEvent) || (is_array($dateOfEvent) && empty($dateOfEvent))) {
            unset($this->DateOfEvent);
        } else {
            $this->DateOfEvent = $dateOfEvent;
        }
        return $this;
    }
    /**
     * Get EnableAll value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getEnableAll()
    {
        return isset($this->EnableAll) ? $this->EnableAll : null;
    }
    /**
     * Set EnableAll value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $enableAll
     * @return \patest\StructType\Ticketing_EventAvailableContinuousSeatsPerRow
     */
    public function setEnableAll($enableAll = null)
    {
        // validation for constraint: boolean
        if (!is_null($enableAll) && !is_bool($enableAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enableAll, true), gettype($enableAll)), __LINE__);
        }
        if (is_null($enableAll) || (is_array($enableAll) && empty($enableAll))) {
            unset($this->EnableAll);
        } else {
            $this->EnableAll = $enableAll;
        }
        return $this;
    }
    /**
     * Get EventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDate()
    {
        return isset($this->EventDate) ? $this->EventDate : null;
    }
    /**
     * Set EventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDate
     * @return \patest\StructType\Ticketing_EventAvailableContinuousSeatsPerRow
     */
    public function setEventDate($eventDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventDate) && !is_string($eventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDate, true), gettype($eventDate)), __LINE__);
        }
        if (is_null($eventDate) || (is_array($eventDate) && empty($eventDate))) {
            unset($this->EventDate);
        } else {
            $this->EventDate = $eventDate;
        }
        return $this;
    }
    /**
     * Get EventHallName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventHallName()
    {
        return isset($this->EventHallName) ? $this->EventHallName : null;
    }
    /**
     * Set EventHallName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventHallName
     * @return \patest\StructType\Ticketing_EventAvailableContinuousSeatsPerRow
     */
    public function setEventHallName($eventHallName = null)
    {
        // validation for constraint: string
        if (!is_null($eventHallName) && !is_string($eventHallName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventHallName, true), gettype($eventHallName)), __LINE__);
        }
        if (is_null($eventHallName) || (is_array($eventHallName) && empty($eventHallName))) {
            unset($this->EventHallName);
        } else {
            $this->EventHallName = $eventHallName;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\Ticketing_EventAvailableContinuousSeatsPerRow
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get EventShowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventShowName()
    {
        return isset($this->EventShowName) ? $this->EventShowName : null;
    }
    /**
     * Set EventShowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventShowName
     * @return \patest\StructType\Ticketing_EventAvailableContinuousSeatsPerRow
     */
    public function setEventShowName($eventShowName = null)
    {
        // validation for constraint: string
        if (!is_null($eventShowName) && !is_string($eventShowName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventShowName, true), gettype($eventShowName)), __LINE__);
        }
        if (is_null($eventShowName) || (is_array($eventShowName) && empty($eventShowName))) {
            unset($this->EventShowName);
        } else {
            $this->EventShowName = $eventShowName;
        }
        return $this;
    }
    /**
     * Get EventShowType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventShowType()
    {
        return isset($this->EventShowType) ? $this->EventShowType : null;
    }
    /**
     * Set EventShowType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventShowType
     * @return \patest\StructType\Ticketing_EventAvailableContinuousSeatsPerRow
     */
    public function setEventShowType($eventShowType = null)
    {
        // validation for constraint: string
        if (!is_null($eventShowType) && !is_string($eventShowType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventShowType, true), gettype($eventShowType)), __LINE__);
        }
        if (is_null($eventShowType) || (is_array($eventShowType) && empty($eventShowType))) {
            unset($this->EventShowType);
        } else {
            $this->EventShowType = $eventShowType;
        }
        return $this;
    }
    /**
     * Get EventTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventTime()
    {
        return isset($this->EventTime) ? $this->EventTime : null;
    }
    /**
     * Set EventTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventTime
     * @return \patest\StructType\Ticketing_EventAvailableContinuousSeatsPerRow
     */
    public function setEventTime($eventTime = null)
    {
        // validation for constraint: string
        if (!is_null($eventTime) && !is_string($eventTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventTime, true), gettype($eventTime)), __LINE__);
        }
        if (is_null($eventTime) || (is_array($eventTime) && empty($eventTime))) {
            unset($this->EventTime);
        } else {
            $this->EventTime = $eventTime;
        }
        return $this;
    }
    /**
     * Get EventType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventType()
    {
        return isset($this->EventType) ? $this->EventType : null;
    }
    /**
     * Set EventType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventType
     * @return \patest\StructType\Ticketing_EventAvailableContinuousSeatsPerRow
     */
    public function setEventType($eventType = null)
    {
        // validation for constraint: string
        if (!is_null($eventType) && !is_string($eventType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventType, true), gettype($eventType)), __LINE__);
        }
        if (is_null($eventType) || (is_array($eventType) && empty($eventType))) {
            unset($this->EventType);
        } else {
            $this->EventType = $eventType;
        }
        return $this;
    }
    /**
     * Get EventWeekday value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventWeekday()
    {
        return isset($this->EventWeekday) ? $this->EventWeekday : null;
    }
    /**
     * Set EventWeekday value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\DayOfWeek::valueIsValid()
     * @uses \patest\EnumType\DayOfWeek::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $eventWeekday
     * @return \patest\StructType\Ticketing_EventAvailableContinuousSeatsPerRow
     */
    public function setEventWeekday($eventWeekday = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DayOfWeek::valueIsValid($eventWeekday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DayOfWeek', is_array($eventWeekday) ? implode(', ', $eventWeekday) : var_export($eventWeekday, true), implode(', ', \patest\EnumType\DayOfWeek::getValidValues())), __LINE__);
        }
        if (is_null($eventWeekday) || (is_array($eventWeekday) && empty($eventWeekday))) {
            unset($this->EventWeekday);
        } else {
            $this->EventWeekday = $eventWeekday;
        }
        return $this;
    }
    /**
     * Get FirstSeat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstSeat()
    {
        return isset($this->FirstSeat) ? $this->FirstSeat : null;
    }
    /**
     * Set FirstSeat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstSeat
     * @return \patest\StructType\Ticketing_EventAvailableContinuousSeatsPerRow
     */
    public function setFirstSeat($firstSeat = null)
    {
        // validation for constraint: string
        if (!is_null($firstSeat) && !is_string($firstSeat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstSeat, true), gettype($firstSeat)), __LINE__);
        }
        if (is_null($firstSeat) || (is_array($firstSeat) && empty($firstSeat))) {
            unset($this->FirstSeat);
        } else {
            $this->FirstSeat = $firstSeat;
        }
        return $this;
    }
    /**
     * Get GARestrictionsUsage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGARestrictionsUsage()
    {
        return isset($this->GARestrictionsUsage) ? $this->GARestrictionsUsage : null;
    }
    /**
     * Set GARestrictionsUsage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gARestrictionsUsage
     * @return \patest\StructType\Ticketing_EventAvailableContinuousSeatsPerRow
     */
    public function setGARestrictionsUsage($gARestrictionsUsage = null)
    {
        // validation for constraint: string
        if (!is_null($gARestrictionsUsage) && !is_string($gARestrictionsUsage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gARestrictionsUsage, true), gettype($gARestrictionsUsage)), __LINE__);
        }
        if (is_null($gARestrictionsUsage) || (is_array($gARestrictionsUsage) && empty($gARestrictionsUsage))) {
            unset($this->GARestrictionsUsage);
        } else {
            $this->GARestrictionsUsage = $gARestrictionsUsage;
        }
        return $this;
    }
    /**
     * Get IsPrivateProperty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPrivateProperty()
    {
        return isset($this->IsPrivateProperty) ? $this->IsPrivateProperty : null;
    }
    /**
     * Set IsPrivateProperty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPrivateProperty
     * @return \patest\StructType\Ticketing_EventAvailableContinuousSeatsPerRow
     */
    public function setIsPrivateProperty($isPrivateProperty = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrivateProperty) && !is_bool($isPrivateProperty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrivateProperty, true), gettype($isPrivateProperty)), __LINE__);
        }
        if (is_null($isPrivateProperty) || (is_array($isPrivateProperty) && empty($isPrivateProperty))) {
            unset($this->IsPrivateProperty);
        } else {
            $this->IsPrivateProperty = $isPrivateProperty;
        }
        return $this;
    }
    /**
     * Get IsSubscription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSubscription()
    {
        return isset($this->IsSubscription) ? $this->IsSubscription : null;
    }
    /**
     * Set IsSubscription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSubscription
     * @return \patest\StructType\Ticketing_EventAvailableContinuousSeatsPerRow
     */
    public function setIsSubscription($isSubscription = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSubscription) && !is_bool($isSubscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSubscription, true), gettype($isSubscription)), __LINE__);
        }
        if (is_null($isSubscription) || (is_array($isSubscription) && empty($isSubscription))) {
            unset($this->IsSubscription);
        } else {
            $this->IsSubscription = $isSubscription;
        }
        return $this;
    }
    /**
     * Get LastSeat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastSeat()
    {
        return isset($this->LastSeat) ? $this->LastSeat : null;
    }
    /**
     * Set LastSeat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastSeat
     * @return \patest\StructType\Ticketing_EventAvailableContinuousSeatsPerRow
     */
    public function setLastSeat($lastSeat = null)
    {
        // validation for constraint: string
        if (!is_null($lastSeat) && !is_string($lastSeat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastSeat, true), gettype($lastSeat)), __LINE__);
        }
        if (is_null($lastSeat) || (is_array($lastSeat) && empty($lastSeat))) {
            unset($this->LastSeat);
        } else {
            $this->LastSeat = $lastSeat;
        }
        return $this;
    }
    /**
     * Get Lock value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLock()
    {
        return isset($this->Lock) ? $this->Lock : null;
    }
    /**
     * Set Lock value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lock
     * @return \patest\StructType\Ticketing_EventAvailableContinuousSeatsPerRow
     */
    public function setLock($lock = null)
    {
        // validation for constraint: string
        if (!is_null($lock) && !is_string($lock)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lock, true), gettype($lock)), __LINE__);
        }
        if (is_null($lock) || (is_array($lock) && empty($lock))) {
            unset($this->Lock);
        } else {
            $this->Lock = $lock;
        }
        return $this;
    }
    /**
     * Get LockTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLockTypeId()
    {
        return isset($this->LockTypeId) ? $this->LockTypeId : null;
    }
    /**
     * Set LockTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lockTypeId
     * @return \patest\StructType\Ticketing_EventAvailableContinuousSeatsPerRow
     */
    public function setLockTypeId($lockTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($lockTypeId) && !is_string($lockTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lockTypeId, true), gettype($lockTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($lockTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $lockTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($lockTypeId, true)), __LINE__);
        }
        if (is_null($lockTypeId) || (is_array($lockTypeId) && empty($lockTypeId))) {
            unset($this->LockTypeId);
        } else {
            $this->LockTypeId = $lockTypeId;
        }
        return $this;
    }
    /**
     * Get MaxUnavailbleEvents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxUnavailbleEvents()
    {
        return isset($this->MaxUnavailbleEvents) ? $this->MaxUnavailbleEvents : null;
    }
    /**
     * Set MaxUnavailbleEvents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxUnavailbleEvents
     * @return \patest\StructType\Ticketing_EventAvailableContinuousSeatsPerRow
     */
    public function setMaxUnavailbleEvents($maxUnavailbleEvents = null)
    {
        // validation for constraint: int
        if (!is_null($maxUnavailbleEvents) && !(is_int($maxUnavailbleEvents) || ctype_digit($maxUnavailbleEvents))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxUnavailbleEvents, true), gettype($maxUnavailbleEvents)), __LINE__);
        }
        if (is_null($maxUnavailbleEvents) || (is_array($maxUnavailbleEvents) && empty($maxUnavailbleEvents))) {
            unset($this->MaxUnavailbleEvents);
        } else {
            $this->MaxUnavailbleEvents = $maxUnavailbleEvents;
        }
        return $this;
    }
    /**
     * Get Price value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrice()
    {
        return isset($this->Price) ? $this->Price : null;
    }
    /**
     * Set Price value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $price
     * @return \patest\StructType\Ticketing_EventAvailableContinuousSeatsPerRow
     */
    public function setPrice($price = null)
    {
        // validation for constraint: string
        if (!is_null($price) && !is_string($price)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        if (is_null($price) || (is_array($price) && empty($price))) {
            unset($this->Price);
        } else {
            $this->Price = $price;
        }
        return $this;
    }
    /**
     * Get PriceLevelColor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelColor()
    {
        return isset($this->PriceLevelColor) ? $this->PriceLevelColor : null;
    }
    /**
     * Set PriceLevelColor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelColor
     * @return \patest\StructType\Ticketing_EventAvailableContinuousSeatsPerRow
     */
    public function setPriceLevelColor($priceLevelColor = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelColor) && !is_string($priceLevelColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelColor, true), gettype($priceLevelColor)), __LINE__);
        }
        if (is_null($priceLevelColor) || (is_array($priceLevelColor) && empty($priceLevelColor))) {
            unset($this->PriceLevelColor);
        } else {
            $this->PriceLevelColor = $priceLevelColor;
        }
        return $this;
    }
    /**
     * Get PriceLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelId()
    {
        return isset($this->PriceLevelId) ? $this->PriceLevelId : null;
    }
    /**
     * Set PriceLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelId
     * @return \patest\StructType\Ticketing_EventAvailableContinuousSeatsPerRow
     */
    public function setPriceLevelId($priceLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelId) && !is_string($priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelId, true), gettype($priceLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceLevelId, true)), __LINE__);
        }
        if (is_null($priceLevelId) || (is_array($priceLevelId) && empty($priceLevelId))) {
            unset($this->PriceLevelId);
        } else {
            $this->PriceLevelId = $priceLevelId;
        }
        return $this;
    }
    /**
     * Get PriceLevelName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelName()
    {
        return isset($this->PriceLevelName) ? $this->PriceLevelName : null;
    }
    /**
     * Set PriceLevelName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelName
     * @return \patest\StructType\Ticketing_EventAvailableContinuousSeatsPerRow
     */
    public function setPriceLevelName($priceLevelName = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelName) && !is_string($priceLevelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelName, true), gettype($priceLevelName)), __LINE__);
        }
        if (is_null($priceLevelName) || (is_array($priceLevelName) && empty($priceLevelName))) {
            unset($this->PriceLevelName);
        } else {
            $this->PriceLevelName = $priceLevelName;
        }
        return $this;
    }
    /**
     * Get PriceOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getPriceOverride()
    {
        return isset($this->PriceOverride) ? $this->PriceOverride : null;
    }
    /**
     * Set PriceOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $priceOverride
     * @return \patest\StructType\Ticketing_EventAvailableContinuousSeatsPerRow
     */
    public function setPriceOverride(\patest\StructType\Money $priceOverride = null)
    {
        if (is_null($priceOverride) || (is_array($priceOverride) && empty($priceOverride))) {
            unset($this->PriceOverride);
        } else {
            $this->PriceOverride = $priceOverride;
        }
        return $this;
    }
    /**
     * Get ResaleRequestDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResaleRequestDate()
    {
        return isset($this->ResaleRequestDate) ? $this->ResaleRequestDate : null;
    }
    /**
     * Set ResaleRequestDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resaleRequestDate
     * @return \patest\StructType\Ticketing_EventAvailableContinuousSeatsPerRow
     */
    public function setResaleRequestDate($resaleRequestDate = null)
    {
        // validation for constraint: string
        if (!is_null($resaleRequestDate) && !is_string($resaleRequestDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resaleRequestDate, true), gettype($resaleRequestDate)), __LINE__);
        }
        if (is_null($resaleRequestDate) || (is_array($resaleRequestDate) && empty($resaleRequestDate))) {
            unset($this->ResaleRequestDate);
        } else {
            $this->ResaleRequestDate = $resaleRequestDate;
        }
        return $this;
    }
    /**
     * Get Row value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRow()
    {
        return isset($this->Row) ? $this->Row : null;
    }
    /**
     * Set Row value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $row
     * @return \patest\StructType\Ticketing_EventAvailableContinuousSeatsPerRow
     */
    public function setRow($row = null)
    {
        // validation for constraint: string
        if (!is_null($row) && !is_string($row)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($row, true), gettype($row)), __LINE__);
        }
        if (is_null($row) || (is_array($row) && empty($row))) {
            unset($this->Row);
        } else {
            $this->Row = $row;
        }
        return $this;
    }
    /**
     * Get SeatIndexes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatIndexes()
    {
        return isset($this->SeatIndexes) ? $this->SeatIndexes : null;
    }
    /**
     * Set SeatIndexes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatIndexes
     * @return \patest\StructType\Ticketing_EventAvailableContinuousSeatsPerRow
     */
    public function setSeatIndexes($seatIndexes = null)
    {
        // validation for constraint: string
        if (!is_null($seatIndexes) && !is_string($seatIndexes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatIndexes, true), gettype($seatIndexes)), __LINE__);
        }
        if (is_null($seatIndexes) || (is_array($seatIndexes) && empty($seatIndexes))) {
            unset($this->SeatIndexes);
        } else {
            $this->SeatIndexes = $seatIndexes;
        }
        return $this;
    }
    /**
     * Get SeatQTY value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSeatQTY()
    {
        return isset($this->SeatQTY) ? $this->SeatQTY : null;
    }
    /**
     * Set SeatQTY value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $seatQTY
     * @return \patest\StructType\Ticketing_EventAvailableContinuousSeatsPerRow
     */
    public function setSeatQTY($seatQTY = null)
    {
        // validation for constraint: int
        if (!is_null($seatQTY) && !(is_int($seatQTY) || ctype_digit($seatQTY))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatQTY, true), gettype($seatQTY)), __LINE__);
        }
        if (is_null($seatQTY) || (is_array($seatQTY) && empty($seatQTY))) {
            unset($this->SeatQTY);
        } else {
            $this->SeatQTY = $seatQTY;
        }
        return $this;
    }
    /**
     * Get Seats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeats()
    {
        return isset($this->Seats) ? $this->Seats : null;
    }
    /**
     * Set Seats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seats
     * @return \patest\StructType\Ticketing_EventAvailableContinuousSeatsPerRow
     */
    public function setSeats($seats = null)
    {
        // validation for constraint: string
        if (!is_null($seats) && !is_string($seats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seats, true), gettype($seats)), __LINE__);
        }
        if (is_null($seats) || (is_array($seats) && empty($seats))) {
            unset($this->Seats);
        } else {
            $this->Seats = $seats;
        }
        return $this;
    }
    /**
     * Get SeatType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatType()
    {
        return isset($this->SeatType) ? $this->SeatType : null;
    }
    /**
     * Set SeatType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatType
     * @return \patest\StructType\Ticketing_EventAvailableContinuousSeatsPerRow
     */
    public function setSeatType($seatType = null)
    {
        // validation for constraint: string
        if (!is_null($seatType) && !is_string($seatType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatType, true), gettype($seatType)), __LINE__);
        }
        if (is_null($seatType) || (is_array($seatType) && empty($seatType))) {
            unset($this->SeatType);
        } else {
            $this->SeatType = $seatType;
        }
        return $this;
    }
    /**
     * Get SeatTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatTypeId()
    {
        return isset($this->SeatTypeId) ? $this->SeatTypeId : null;
    }
    /**
     * Set SeatTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatTypeId
     * @return \patest\StructType\Ticketing_EventAvailableContinuousSeatsPerRow
     */
    public function setSeatTypeId($seatTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($seatTypeId) && !is_string($seatTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatTypeId, true), gettype($seatTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seatTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seatTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seatTypeId, true)), __LINE__);
        }
        if (is_null($seatTypeId) || (is_array($seatTypeId) && empty($seatTypeId))) {
            unset($this->SeatTypeId);
        } else {
            $this->SeatTypeId = $seatTypeId;
        }
        return $this;
    }
    /**
     * Get SectorId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSectorId()
    {
        return isset($this->SectorId) ? $this->SectorId : null;
    }
    /**
     * Set SectorId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sectorId
     * @return \patest\StructType\Ticketing_EventAvailableContinuousSeatsPerRow
     */
    public function setSectorId($sectorId = null)
    {
        // validation for constraint: string
        if (!is_null($sectorId) && !is_string($sectorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectorId, true), gettype($sectorId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sectorId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sectorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sectorId, true)), __LINE__);
        }
        if (is_null($sectorId) || (is_array($sectorId) && empty($sectorId))) {
            unset($this->SectorId);
        } else {
            $this->SectorId = $sectorId;
        }
        return $this;
    }
    /**
     * Get SectorName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSectorName()
    {
        return isset($this->SectorName) ? $this->SectorName : null;
    }
    /**
     * Set SectorName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sectorName
     * @return \patest\StructType\Ticketing_EventAvailableContinuousSeatsPerRow
     */
    public function setSectorName($sectorName = null)
    {
        // validation for constraint: string
        if (!is_null($sectorName) && !is_string($sectorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectorName, true), gettype($sectorName)), __LINE__);
        }
        if (is_null($sectorName) || (is_array($sectorName) && empty($sectorName))) {
            unset($this->SectorName);
        } else {
            $this->SectorName = $sectorName;
        }
        return $this;
    }
    /**
     * Get ShowId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowId()
    {
        return isset($this->ShowId) ? $this->ShowId : null;
    }
    /**
     * Set ShowId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showId
     * @return \patest\StructType\Ticketing_EventAvailableContinuousSeatsPerRow
     */
    public function setShowId($showId = null)
    {
        // validation for constraint: string
        if (!is_null($showId) && !is_string($showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showId, true), gettype($showId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showId, true)), __LINE__);
        }
        if (is_null($showId) || (is_array($showId) && empty($showId))) {
            unset($this->ShowId);
        } else {
            $this->ShowId = $showId;
        }
        return $this;
    }
    /**
     * Get UnAvailableEventsToolTip value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUnAvailableEventsToolTip()
    {
        return isset($this->UnAvailableEventsToolTip) ? $this->UnAvailableEventsToolTip : null;
    }
    /**
     * Set UnAvailableEventsToolTip value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $unAvailableEventsToolTip
     * @return \patest\StructType\Ticketing_EventAvailableContinuousSeatsPerRow
     */
    public function setUnAvailableEventsToolTip($unAvailableEventsToolTip = null)
    {
        // validation for constraint: string
        if (!is_null($unAvailableEventsToolTip) && !is_string($unAvailableEventsToolTip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unAvailableEventsToolTip, true), gettype($unAvailableEventsToolTip)), __LINE__);
        }
        if (is_null($unAvailableEventsToolTip) || (is_array($unAvailableEventsToolTip) && empty($unAvailableEventsToolTip))) {
            unset($this->UnAvailableEventsToolTip);
        } else {
            $this->UnAvailableEventsToolTip = $unAvailableEventsToolTip;
        }
        return $this;
    }
}
