<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.EffectiveAvailabilityFilterIdentification
 * StructType
 * @subpackage Structs
 */
class Ticketing_EffectiveAvailabilityFilterIdentification extends AnyEntity
{
    /**
     * The AreaIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AreaIds
     */
    public $AreaIds;
    /**
     * The AreasFilterType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AreasFilterType;
    /**
     * The CouponDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CouponDefinitionId;
    /**
     * The PresaleCodeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PresaleCodeId;
    /**
     * The PriceLevelIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PriceLevelIds
     */
    public $PriceLevelIds;
    /**
     * The PriceLevelsFilterType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceLevelsFilterType;
    /**
     * The RestrictionIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RestrictionIds
     */
    public $RestrictionIds;
    /**
     * The RestrictionsFilterType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RestrictionsFilterType;
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Token;
    /**
     * Constructor method for Ticketing.EffectiveAvailabilityFilterIdentification
     * @uses Ticketing_EffectiveAvailabilityFilterIdentification::setAreaIds()
     * @uses Ticketing_EffectiveAvailabilityFilterIdentification::setAreasFilterType()
     * @uses Ticketing_EffectiveAvailabilityFilterIdentification::setCouponDefinitionId()
     * @uses Ticketing_EffectiveAvailabilityFilterIdentification::setPresaleCodeId()
     * @uses Ticketing_EffectiveAvailabilityFilterIdentification::setPriceLevelIds()
     * @uses Ticketing_EffectiveAvailabilityFilterIdentification::setPriceLevelsFilterType()
     * @uses Ticketing_EffectiveAvailabilityFilterIdentification::setRestrictionIds()
     * @uses Ticketing_EffectiveAvailabilityFilterIdentification::setRestrictionsFilterType()
     * @uses Ticketing_EffectiveAvailabilityFilterIdentification::setToken()
     * @param \patest\StructType\AreaIds $areaIds
     * @param string $areasFilterType
     * @param string $couponDefinitionId
     * @param string $presaleCodeId
     * @param \patest\StructType\PriceLevelIds $priceLevelIds
     * @param string $priceLevelsFilterType
     * @param \patest\StructType\RestrictionIds $restrictionIds
     * @param string $restrictionsFilterType
     * @param string $token
     */
    public function __construct(\patest\StructType\AreaIds $areaIds = null, $areasFilterType = null, $couponDefinitionId = null, $presaleCodeId = null, \patest\StructType\PriceLevelIds $priceLevelIds = null, $priceLevelsFilterType = null, \patest\StructType\RestrictionIds $restrictionIds = null, $restrictionsFilterType = null, $token = null)
    {
        $this
            ->setAreaIds($areaIds)
            ->setAreasFilterType($areasFilterType)
            ->setCouponDefinitionId($couponDefinitionId)
            ->setPresaleCodeId($presaleCodeId)
            ->setPriceLevelIds($priceLevelIds)
            ->setPriceLevelsFilterType($priceLevelsFilterType)
            ->setRestrictionIds($restrictionIds)
            ->setRestrictionsFilterType($restrictionsFilterType)
            ->setToken($token);
    }
    /**
     * Get AreaIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AreaIds|null
     */
    public function getAreaIds()
    {
        return isset($this->AreaIds) ? $this->AreaIds : null;
    }
    /**
     * Set AreaIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AreaIds $areaIds
     * @return \patest\StructType\Ticketing_EffectiveAvailabilityFilterIdentification
     */
    public function setAreaIds(\patest\StructType\AreaIds $areaIds = null)
    {
        if (is_null($areaIds) || (is_array($areaIds) && empty($areaIds))) {
            unset($this->AreaIds);
        } else {
            $this->AreaIds = $areaIds;
        }
        return $this;
    }
    /**
     * Get AreasFilterType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreasFilterType()
    {
        return isset($this->AreasFilterType) ? $this->AreasFilterType : null;
    }
    /**
     * Set AreasFilterType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\EffectiveAvailabilityFilterType::valueIsValid()
     * @uses \patest\EnumType\EffectiveAvailabilityFilterType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $areasFilterType
     * @return \patest\StructType\Ticketing_EffectiveAvailabilityFilterIdentification
     */
    public function setAreasFilterType($areasFilterType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\EffectiveAvailabilityFilterType::valueIsValid($areasFilterType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EffectiveAvailabilityFilterType', is_array($areasFilterType) ? implode(', ', $areasFilterType) : var_export($areasFilterType, true), implode(', ', \patest\EnumType\EffectiveAvailabilityFilterType::getValidValues())), __LINE__);
        }
        if (is_null($areasFilterType) || (is_array($areasFilterType) && empty($areasFilterType))) {
            unset($this->AreasFilterType);
        } else {
            $this->AreasFilterType = $areasFilterType;
        }
        return $this;
    }
    /**
     * Get CouponDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCouponDefinitionId()
    {
        return isset($this->CouponDefinitionId) ? $this->CouponDefinitionId : null;
    }
    /**
     * Set CouponDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $couponDefinitionId
     * @return \patest\StructType\Ticketing_EffectiveAvailabilityFilterIdentification
     */
    public function setCouponDefinitionId($couponDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($couponDefinitionId) && !is_string($couponDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($couponDefinitionId, true), gettype($couponDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($couponDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $couponDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($couponDefinitionId, true)), __LINE__);
        }
        if (is_null($couponDefinitionId) || (is_array($couponDefinitionId) && empty($couponDefinitionId))) {
            unset($this->CouponDefinitionId);
        } else {
            $this->CouponDefinitionId = $couponDefinitionId;
        }
        return $this;
    }
    /**
     * Get PresaleCodeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPresaleCodeId()
    {
        return isset($this->PresaleCodeId) ? $this->PresaleCodeId : null;
    }
    /**
     * Set PresaleCodeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $presaleCodeId
     * @return \patest\StructType\Ticketing_EffectiveAvailabilityFilterIdentification
     */
    public function setPresaleCodeId($presaleCodeId = null)
    {
        // validation for constraint: string
        if (!is_null($presaleCodeId) && !is_string($presaleCodeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($presaleCodeId, true), gettype($presaleCodeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($presaleCodeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $presaleCodeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($presaleCodeId, true)), __LINE__);
        }
        if (is_null($presaleCodeId) || (is_array($presaleCodeId) && empty($presaleCodeId))) {
            unset($this->PresaleCodeId);
        } else {
            $this->PresaleCodeId = $presaleCodeId;
        }
        return $this;
    }
    /**
     * Get PriceLevelIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PriceLevelIds|null
     */
    public function getPriceLevelIds()
    {
        return isset($this->PriceLevelIds) ? $this->PriceLevelIds : null;
    }
    /**
     * Set PriceLevelIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PriceLevelIds $priceLevelIds
     * @return \patest\StructType\Ticketing_EffectiveAvailabilityFilterIdentification
     */
    public function setPriceLevelIds(\patest\StructType\PriceLevelIds $priceLevelIds = null)
    {
        if (is_null($priceLevelIds) || (is_array($priceLevelIds) && empty($priceLevelIds))) {
            unset($this->PriceLevelIds);
        } else {
            $this->PriceLevelIds = $priceLevelIds;
        }
        return $this;
    }
    /**
     * Get PriceLevelsFilterType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelsFilterType()
    {
        return isset($this->PriceLevelsFilterType) ? $this->PriceLevelsFilterType : null;
    }
    /**
     * Set PriceLevelsFilterType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\EffectiveAvailabilityFilterType::valueIsValid()
     * @uses \patest\EnumType\EffectiveAvailabilityFilterType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priceLevelsFilterType
     * @return \patest\StructType\Ticketing_EffectiveAvailabilityFilterIdentification
     */
    public function setPriceLevelsFilterType($priceLevelsFilterType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\EffectiveAvailabilityFilterType::valueIsValid($priceLevelsFilterType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EffectiveAvailabilityFilterType', is_array($priceLevelsFilterType) ? implode(', ', $priceLevelsFilterType) : var_export($priceLevelsFilterType, true), implode(', ', \patest\EnumType\EffectiveAvailabilityFilterType::getValidValues())), __LINE__);
        }
        if (is_null($priceLevelsFilterType) || (is_array($priceLevelsFilterType) && empty($priceLevelsFilterType))) {
            unset($this->PriceLevelsFilterType);
        } else {
            $this->PriceLevelsFilterType = $priceLevelsFilterType;
        }
        return $this;
    }
    /**
     * Get RestrictionIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RestrictionIds|null
     */
    public function getRestrictionIds()
    {
        return isset($this->RestrictionIds) ? $this->RestrictionIds : null;
    }
    /**
     * Set RestrictionIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RestrictionIds $restrictionIds
     * @return \patest\StructType\Ticketing_EffectiveAvailabilityFilterIdentification
     */
    public function setRestrictionIds(\patest\StructType\RestrictionIds $restrictionIds = null)
    {
        if (is_null($restrictionIds) || (is_array($restrictionIds) && empty($restrictionIds))) {
            unset($this->RestrictionIds);
        } else {
            $this->RestrictionIds = $restrictionIds;
        }
        return $this;
    }
    /**
     * Get RestrictionsFilterType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRestrictionsFilterType()
    {
        return isset($this->RestrictionsFilterType) ? $this->RestrictionsFilterType : null;
    }
    /**
     * Set RestrictionsFilterType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\EffectiveAvailabilityFilterType::valueIsValid()
     * @uses \patest\EnumType\EffectiveAvailabilityFilterType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $restrictionsFilterType
     * @return \patest\StructType\Ticketing_EffectiveAvailabilityFilterIdentification
     */
    public function setRestrictionsFilterType($restrictionsFilterType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\EffectiveAvailabilityFilterType::valueIsValid($restrictionsFilterType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EffectiveAvailabilityFilterType', is_array($restrictionsFilterType) ? implode(', ', $restrictionsFilterType) : var_export($restrictionsFilterType, true), implode(', ', \patest\EnumType\EffectiveAvailabilityFilterType::getValidValues())), __LINE__);
        }
        if (is_null($restrictionsFilterType) || (is_array($restrictionsFilterType) && empty($restrictionsFilterType))) {
            unset($this->RestrictionsFilterType);
        } else {
            $this->RestrictionsFilterType = $restrictionsFilterType;
        }
        return $this;
    }
    /**
     * Get Token value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToken()
    {
        return isset($this->Token) ? $this->Token : null;
    }
    /**
     * Set Token value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $token
     * @return \patest\StructType\Ticketing_EffectiveAvailabilityFilterIdentification
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($token) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($token, true)), __LINE__);
        }
        if (is_null($token) || (is_array($token) && empty($token))) {
            unset($this->Token);
        } else {
            $this->Token = $token;
        }
        return $this;
    }
}
