<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.DeepLink StructType
 * @subpackage Structs
 */
class Ticketing_DeepLink extends PersistableEntity
{
    /**
     * The Body
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Body;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The Extra1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Extra1;
    /**
     * The Extra2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Extra2;
    /**
     * The Header
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Header;
    /**
     * The Image
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Image;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The OBOAccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OBOAccountId;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The ShowLandingPage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ShowLandingPage;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Token;
    /**
     * The URL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $URL;
    /**
     * Constructor method for Ticketing.DeepLink
     * @uses Ticketing_DeepLink::setBody()
     * @uses Ticketing_DeepLink::setEndDate()
     * @uses Ticketing_DeepLink::setEventId()
     * @uses Ticketing_DeepLink::setExtra1()
     * @uses Ticketing_DeepLink::setExtra2()
     * @uses Ticketing_DeepLink::setHeader()
     * @uses Ticketing_DeepLink::setImage()
     * @uses Ticketing_DeepLink::setIsActive()
     * @uses Ticketing_DeepLink::setOBOAccountId()
     * @uses Ticketing_DeepLink::setOrganizationUnitId()
     * @uses Ticketing_DeepLink::setShowLandingPage()
     * @uses Ticketing_DeepLink::setStartDate()
     * @uses Ticketing_DeepLink::setToken()
     * @uses Ticketing_DeepLink::setURL()
     * @param \patest\StructType\GlobalString $body
     * @param string $endDate
     * @param string $eventId
     * @param \patest\StructType\GlobalString $extra1
     * @param \patest\StructType\GlobalString $extra2
     * @param \patest\StructType\GlobalString $header
     * @param int $image
     * @param bool $isActive
     * @param string $oBOAccountId
     * @param string $organizationUnitId
     * @param int $showLandingPage
     * @param string $startDate
     * @param string $token
     * @param \patest\StructType\GlobalString $uRL
     */
    public function __construct(\patest\StructType\GlobalString $body = null, $endDate = null, $eventId = null, \patest\StructType\GlobalString $extra1 = null, \patest\StructType\GlobalString $extra2 = null, \patest\StructType\GlobalString $header = null, $image = null, $isActive = null, $oBOAccountId = null, $organizationUnitId = null, $showLandingPage = null, $startDate = null, $token = null, \patest\StructType\GlobalString $uRL = null)
    {
        $this
            ->setBody($body)
            ->setEndDate($endDate)
            ->setEventId($eventId)
            ->setExtra1($extra1)
            ->setExtra2($extra2)
            ->setHeader($header)
            ->setImage($image)
            ->setIsActive($isActive)
            ->setOBOAccountId($oBOAccountId)
            ->setOrganizationUnitId($organizationUnitId)
            ->setShowLandingPage($showLandingPage)
            ->setStartDate($startDate)
            ->setToken($token)
            ->setURL($uRL);
    }
    /**
     * Get Body value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getBody()
    {
        return isset($this->Body) ? $this->Body : null;
    }
    /**
     * Set Body value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $body
     * @return \patest\StructType\Ticketing_DeepLink
     */
    public function setBody(\patest\StructType\GlobalString $body = null)
    {
        if (is_null($body) || (is_array($body) && empty($body))) {
            unset($this->Body);
        } else {
            $this->Body = $body;
        }
        return $this;
    }
    /**
     * Get EndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndDate()
    {
        return isset($this->EndDate) ? $this->EndDate : null;
    }
    /**
     * Set EndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endDate
     * @return \patest\StructType\Ticketing_DeepLink
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        if (is_null($endDate) || (is_array($endDate) && empty($endDate))) {
            unset($this->EndDate);
        } else {
            $this->EndDate = $endDate;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\Ticketing_DeepLink
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get Extra1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getExtra1()
    {
        return isset($this->Extra1) ? $this->Extra1 : null;
    }
    /**
     * Set Extra1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $extra1
     * @return \patest\StructType\Ticketing_DeepLink
     */
    public function setExtra1(\patest\StructType\GlobalString $extra1 = null)
    {
        if (is_null($extra1) || (is_array($extra1) && empty($extra1))) {
            unset($this->Extra1);
        } else {
            $this->Extra1 = $extra1;
        }
        return $this;
    }
    /**
     * Get Extra2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getExtra2()
    {
        return isset($this->Extra2) ? $this->Extra2 : null;
    }
    /**
     * Set Extra2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $extra2
     * @return \patest\StructType\Ticketing_DeepLink
     */
    public function setExtra2(\patest\StructType\GlobalString $extra2 = null)
    {
        if (is_null($extra2) || (is_array($extra2) && empty($extra2))) {
            unset($this->Extra2);
        } else {
            $this->Extra2 = $extra2;
        }
        return $this;
    }
    /**
     * Get Header value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getHeader()
    {
        return isset($this->Header) ? $this->Header : null;
    }
    /**
     * Set Header value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $header
     * @return \patest\StructType\Ticketing_DeepLink
     */
    public function setHeader(\patest\StructType\GlobalString $header = null)
    {
        if (is_null($header) || (is_array($header) && empty($header))) {
            unset($this->Header);
        } else {
            $this->Header = $header;
        }
        return $this;
    }
    /**
     * Get Image value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getImage()
    {
        return isset($this->Image) ? $this->Image : null;
    }
    /**
     * Set Image value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $image
     * @return \patest\StructType\Ticketing_DeepLink
     */
    public function setImage($image = null)
    {
        // validation for constraint: int
        if (!is_null($image) && !(is_int($image) || ctype_digit($image))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($image, true), gettype($image)), __LINE__);
        }
        if (is_null($image) || (is_array($image) && empty($image))) {
            unset($this->Image);
        } else {
            $this->Image = $image;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Ticketing_DeepLink
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get OBOAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOBOAccountId()
    {
        return isset($this->OBOAccountId) ? $this->OBOAccountId : null;
    }
    /**
     * Set OBOAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oBOAccountId
     * @return \patest\StructType\Ticketing_DeepLink
     */
    public function setOBOAccountId($oBOAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($oBOAccountId) && !is_string($oBOAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oBOAccountId, true), gettype($oBOAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($oBOAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $oBOAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($oBOAccountId, true)), __LINE__);
        }
        if (is_null($oBOAccountId) || (is_array($oBOAccountId) && empty($oBOAccountId))) {
            unset($this->OBOAccountId);
        } else {
            $this->OBOAccountId = $oBOAccountId;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Ticketing_DeepLink
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get ShowLandingPage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getShowLandingPage()
    {
        return isset($this->ShowLandingPage) ? $this->ShowLandingPage : null;
    }
    /**
     * Set ShowLandingPage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $showLandingPage
     * @return \patest\StructType\Ticketing_DeepLink
     */
    public function setShowLandingPage($showLandingPage = null)
    {
        // validation for constraint: int
        if (!is_null($showLandingPage) && !(is_int($showLandingPage) || ctype_digit($showLandingPage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($showLandingPage, true), gettype($showLandingPage)), __LINE__);
        }
        if (is_null($showLandingPage) || (is_array($showLandingPage) && empty($showLandingPage))) {
            unset($this->ShowLandingPage);
        } else {
            $this->ShowLandingPage = $showLandingPage;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDate()
    {
        return isset($this->StartDate) ? $this->StartDate : null;
    }
    /**
     * Set StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDate
     * @return \patest\StructType\Ticketing_DeepLink
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->StartDate);
        } else {
            $this->StartDate = $startDate;
        }
        return $this;
    }
    /**
     * Get Token value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToken()
    {
        return isset($this->Token) ? $this->Token : null;
    }
    /**
     * Set Token value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $token
     * @return \patest\StructType\Ticketing_DeepLink
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        if (is_null($token) || (is_array($token) && empty($token))) {
            unset($this->Token);
        } else {
            $this->Token = $token;
        }
        return $this;
    }
    /**
     * Get URL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getURL()
    {
        return isset($this->URL) ? $this->URL : null;
    }
    /**
     * Set URL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $uRL
     * @return \patest\StructType\Ticketing_DeepLink
     */
    public function setURL(\patest\StructType\GlobalString $uRL = null)
    {
        if (is_null($uRL) || (is_array($uRL) && empty($uRL))) {
            unset($this->URL);
        } else {
            $this->URL = $uRL;
        }
        return $this;
    }
}
