<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.DatesToExclude StructType
 * @subpackage Structs
 */
class Ticketing_DatesToExclude extends AnyEntity
{
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Date;
    /**
     * The UntilDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UntilDate;
    /**
     * Constructor method for Ticketing.DatesToExclude
     * @uses Ticketing_DatesToExclude::setDate()
     * @uses Ticketing_DatesToExclude::setUntilDate()
     * @param string $date
     * @param string $untilDate
     */
    public function __construct($date = null, $untilDate = null)
    {
        $this
            ->setDate($date)
            ->setUntilDate($untilDate);
    }
    /**
     * Get Date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDate()
    {
        return isset($this->Date) ? $this->Date : null;
    }
    /**
     * Set Date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $date
     * @return \patest\StructType\Ticketing_DatesToExclude
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        if (is_null($date) || (is_array($date) && empty($date))) {
            unset($this->Date);
        } else {
            $this->Date = $date;
        }
        return $this;
    }
    /**
     * Get UntilDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUntilDate()
    {
        return isset($this->UntilDate) ? $this->UntilDate : null;
    }
    /**
     * Set UntilDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $untilDate
     * @return \patest\StructType\Ticketing_DatesToExclude
     */
    public function setUntilDate($untilDate = null)
    {
        // validation for constraint: string
        if (!is_null($untilDate) && !is_string($untilDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($untilDate, true), gettype($untilDate)), __LINE__);
        }
        if (is_null($untilDate) || (is_array($untilDate) && empty($untilDate))) {
            unset($this->UntilDate);
        } else {
            $this->UntilDate = $untilDate;
        }
        return $this;
    }
}
