<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.CustomSeatPrice StructType
 * @subpackage Structs
 */
class Ticketing_CustomSeatPrice extends PersistableEntity
{
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The SeatIdInAreaMap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SeatIdInAreaMap;
    /**
     * The SeatPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $SeatPrice;
    /**
     * Constructor method for Ticketing.CustomSeatPrice
     * @uses Ticketing_CustomSeatPrice::setAreaId()
     * @uses Ticketing_CustomSeatPrice::setEventId()
     * @uses Ticketing_CustomSeatPrice::setSeatIdInAreaMap()
     * @uses Ticketing_CustomSeatPrice::setSeatPrice()
     * @param string $areaId
     * @param string $eventId
     * @param int $seatIdInAreaMap
     * @param \patest\StructType\Money $seatPrice
     */
    public function __construct($areaId = null, $eventId = null, $seatIdInAreaMap = null, \patest\StructType\Money $seatPrice = null)
    {
        $this
            ->setAreaId($areaId)
            ->setEventId($eventId)
            ->setSeatIdInAreaMap($seatIdInAreaMap)
            ->setSeatPrice($seatPrice);
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\Ticketing_CustomSeatPrice
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\Ticketing_CustomSeatPrice
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get SeatIdInAreaMap value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSeatIdInAreaMap()
    {
        return isset($this->SeatIdInAreaMap) ? $this->SeatIdInAreaMap : null;
    }
    /**
     * Set SeatIdInAreaMap value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $seatIdInAreaMap
     * @return \patest\StructType\Ticketing_CustomSeatPrice
     */
    public function setSeatIdInAreaMap($seatIdInAreaMap = null)
    {
        // validation for constraint: int
        if (!is_null($seatIdInAreaMap) && !(is_int($seatIdInAreaMap) || ctype_digit($seatIdInAreaMap))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatIdInAreaMap, true), gettype($seatIdInAreaMap)), __LINE__);
        }
        if (is_null($seatIdInAreaMap) || (is_array($seatIdInAreaMap) && empty($seatIdInAreaMap))) {
            unset($this->SeatIdInAreaMap);
        } else {
            $this->SeatIdInAreaMap = $seatIdInAreaMap;
        }
        return $this;
    }
    /**
     * Get SeatPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getSeatPrice()
    {
        return isset($this->SeatPrice) ? $this->SeatPrice : null;
    }
    /**
     * Set SeatPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $seatPrice
     * @return \patest\StructType\Ticketing_CustomSeatPrice
     */
    public function setSeatPrice(\patest\StructType\Money $seatPrice = null)
    {
        if (is_null($seatPrice) || (is_array($seatPrice) && empty($seatPrice))) {
            unset($this->SeatPrice);
        } else {
            $this->SeatPrice = $seatPrice;
        }
        return $this;
    }
}
