<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.ClientTicketsEnhanced StructType
 * @subpackage Structs
 */
class Ticketing_ClientTicketsEnhanced extends PersistableEntity
{
    /**
     * The AccessControlProviderId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccessControlProviderId;
    /**
     * The AclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AclSchemeId;
    /**
     * The AllocationGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AllocationGuid;
    /**
     * The ApplicationChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationChannel;
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The AreaName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $AreaName;
    /**
     * The AssociatedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AssociatedDate;
    /**
     * The AttachedToBenefitInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AttachedToBenefitInstanceId;
    /**
     * The BucketName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $BucketName;
    /**
     * The ContinuedByAction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContinuedByAction;
    /**
     * The CreatedByResaleMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedByResaleMethod;
    /**
     * The CustodyStatus
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustodyStatus;
    /**
     * The EventDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDate;
    /**
     * The EventDateUtc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDateUtc;
    /**
     * The EventDayOfWeek
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDayOfWeek;
    /**
     * The EventGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventGuid;
    /**
     * The EventSaleStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $EventSaleStatus;
    /**
     * The EventType1Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventType1Id;
    /**
     * The EventType2Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventType2Id;
    /**
     * The EventType3Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventType3Id;
    /**
     * The EventType4Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventType4Id;
    /**
     * The EventType5Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventType5Id;
    /**
     * The EventTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventTypeId;
    /**
     * The ExternalTicketNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalTicketNumber;
    /**
     * The ExtraFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtraFields;
    /**
     * The FirstEntryScanDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstEntryScanDate;
    /**
     * The HallId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallId;
    /**
     * The HasTicketHolder
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasTicketHolder;
    /**
     * The HolderCompanyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HolderCompanyId;
    /**
     * The IdInTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IdInTransaction;
    /**
     * The IsAvailableForChangeOfOwnership
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAvailableForChangeOfOwnership;
    /**
     * The IsAvailableForResaleRequest
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAvailableForResaleRequest;
    /**
     * The IsAvailableForTicketDistribution
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAvailableForTicketDistribution;
    /**
     * The IsComplimentary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsComplimentary;
    /**
     * The IsDistributed
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDistributed;
    /**
     * The IsForResale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsForResale;
    /**
     * The IsHospitality
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsHospitality;
    /**
     * The IsMoved
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsMoved;
    /**
     * The IsObsolete
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsObsolete;
    /**
     * The IsOnlineForwarded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsOnlineForwarded;
    /**
     * The IsOriginal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsOriginal;
    /**
     * The IsPrinted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPrinted;
    /**
     * The IsPrinting
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPrinting;
    /**
     * The IsResale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsResale;
    /**
     * The IsReserved
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsReserved;
    /**
     * The IsReturned
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsReturned;
    /**
     * The IsScanned
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsScanned;
    /**
     * The IsSubsTicket
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSubsTicket;
    /**
     * The IssuerCompanyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IssuerCompanyId;
    /**
     * The IsTurnback
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsTurnback;
    /**
     * The IsUpdated
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUpdated;
    /**
     * The IsValid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsValid;
    /**
     * The ItemAction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemAction;
    /**
     * The ItemType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemType;
    /**
     * The LockGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LockGuid;
    /**
     * The NameAndDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NameAndDate;
    /**
     * The NormalizedRowName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NormalizedRowName;
    /**
     * The NormalizedSeatName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NormalizedSeatName;
    /**
     * The NumberOfOwnershipChanges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfOwnershipChanges;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The OriginalOwnerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OriginalOwnerId;
    /**
     * The OriginalTicketId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OriginalTicketId;
    /**
     * The OwnerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OwnerId;
    /**
     * The PackageId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PackageId;
    /**
     * The PaidAmount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $PaidAmount;
    /**
     * The PaymentStatus
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentStatus;
    /**
     * The PendingOwnerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PendingOwnerId;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $Price;
    /**
     * The PriceLevelGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceLevelGuid;
    /**
     * The PriceTypeChangePolicy
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_TicketPriceTypeChangePolicy
     */
    public $PriceTypeChangePolicy;
    /**
     * The PriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceTypeId;
    /**
     * The PrintCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PrintCount;
    /**
     * The PrintedAs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrintedAs;
    /**
     * The PrintMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrintMethod;
    /**
     * The PrintMethodData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrintMethodData;
    /**
     * The PurchaserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PurchaserId;
    /**
     * The ResaleDestinationClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ResaleDestinationClientId;
    /**
     * The ResaleMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResaleMethod;
    /**
     * The ResaleStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResaleStatus;
    /**
     * The RoleInSubscription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RoleInSubscription;
    /**
     * The RowName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RowName;
    /**
     * The SalesRepClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalesRepClientId;
    /**
     * The SaleStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SaleStatus;
    /**
     * The SeasonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeasonId;
    /**
     * The SeatIdInAreaMap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SeatIdInAreaMap;
    /**
     * The SeatInfo
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_SeatInfo
     */
    public $SeatInfo;
    /**
     * The SeatName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatName;
    /**
     * The SectorName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SectorName;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * The SGOrderId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SGOrderId;
    /**
     * The ShowGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowGuid;
    /**
     * The ShowMinutes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ShowMinutes;
    /**
     * The StandId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $StandId;
    /**
     * The StandName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $StandName;
    /**
     * The StatusIcons
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StatusIcons;
    /**
     * The SubscriberTicketType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriberTicketType;
    /**
     * The SubscriptionInstance
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubscriptionInstance;
    /**
     * The SubscriptionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriptionNumber;
    /**
     * The TicketBarcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketBarcode;
    /**
     * The TicketHolder
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_TicketDistributionJournal
     */
    public $TicketHolder;
    /**
     * The TicketNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TicketNumber;
    /**
     * The TicketSaleItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketSaleItemId;
    /**
     * The TicketTurnbackFundName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketTurnbackFundName;
    /**
     * The TotalPrice
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalPrice;
    /**
     * The TransactionDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionDate;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionNotes
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionNotes;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * The TransactionReferenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionReferenceNumber;
    /**
     * The UnpaidAmount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $UnpaidAmount;
    /**
     * The UnpaidInstallmentsAmount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $UnpaidInstallmentsAmount;
    /**
     * Constructor method for Ticketing.ClientTicketsEnhanced
     * @uses Ticketing_ClientTicketsEnhanced::setAccessControlProviderId()
     * @uses Ticketing_ClientTicketsEnhanced::setAclSchemeId()
     * @uses Ticketing_ClientTicketsEnhanced::setAllocationGuid()
     * @uses Ticketing_ClientTicketsEnhanced::setApplicationChannel()
     * @uses Ticketing_ClientTicketsEnhanced::setAreaId()
     * @uses Ticketing_ClientTicketsEnhanced::setAreaName()
     * @uses Ticketing_ClientTicketsEnhanced::setAssociatedDate()
     * @uses Ticketing_ClientTicketsEnhanced::setAttachedToBenefitInstanceId()
     * @uses Ticketing_ClientTicketsEnhanced::setBucketName()
     * @uses Ticketing_ClientTicketsEnhanced::setContinuedByAction()
     * @uses Ticketing_ClientTicketsEnhanced::setCreatedByResaleMethod()
     * @uses Ticketing_ClientTicketsEnhanced::setCustodyStatus()
     * @uses Ticketing_ClientTicketsEnhanced::setEventDate()
     * @uses Ticketing_ClientTicketsEnhanced::setEventDateUtc()
     * @uses Ticketing_ClientTicketsEnhanced::setEventDayOfWeek()
     * @uses Ticketing_ClientTicketsEnhanced::setEventGuid()
     * @uses Ticketing_ClientTicketsEnhanced::setEventSaleStatus()
     * @uses Ticketing_ClientTicketsEnhanced::setEventType1Id()
     * @uses Ticketing_ClientTicketsEnhanced::setEventType2Id()
     * @uses Ticketing_ClientTicketsEnhanced::setEventType3Id()
     * @uses Ticketing_ClientTicketsEnhanced::setEventType4Id()
     * @uses Ticketing_ClientTicketsEnhanced::setEventType5Id()
     * @uses Ticketing_ClientTicketsEnhanced::setEventTypeId()
     * @uses Ticketing_ClientTicketsEnhanced::setExternalTicketNumber()
     * @uses Ticketing_ClientTicketsEnhanced::setExtraFields()
     * @uses Ticketing_ClientTicketsEnhanced::setFirstEntryScanDate()
     * @uses Ticketing_ClientTicketsEnhanced::setHallId()
     * @uses Ticketing_ClientTicketsEnhanced::setHasTicketHolder()
     * @uses Ticketing_ClientTicketsEnhanced::setHolderCompanyId()
     * @uses Ticketing_ClientTicketsEnhanced::setIdInTransaction()
     * @uses Ticketing_ClientTicketsEnhanced::setIsAvailableForChangeOfOwnership()
     * @uses Ticketing_ClientTicketsEnhanced::setIsAvailableForResaleRequest()
     * @uses Ticketing_ClientTicketsEnhanced::setIsAvailableForTicketDistribution()
     * @uses Ticketing_ClientTicketsEnhanced::setIsComplimentary()
     * @uses Ticketing_ClientTicketsEnhanced::setIsDistributed()
     * @uses Ticketing_ClientTicketsEnhanced::setIsForResale()
     * @uses Ticketing_ClientTicketsEnhanced::setIsHospitality()
     * @uses Ticketing_ClientTicketsEnhanced::setIsMoved()
     * @uses Ticketing_ClientTicketsEnhanced::setIsObsolete()
     * @uses Ticketing_ClientTicketsEnhanced::setIsOnlineForwarded()
     * @uses Ticketing_ClientTicketsEnhanced::setIsOriginal()
     * @uses Ticketing_ClientTicketsEnhanced::setIsPrinted()
     * @uses Ticketing_ClientTicketsEnhanced::setIsPrinting()
     * @uses Ticketing_ClientTicketsEnhanced::setIsResale()
     * @uses Ticketing_ClientTicketsEnhanced::setIsReserved()
     * @uses Ticketing_ClientTicketsEnhanced::setIsReturned()
     * @uses Ticketing_ClientTicketsEnhanced::setIsScanned()
     * @uses Ticketing_ClientTicketsEnhanced::setIsSubsTicket()
     * @uses Ticketing_ClientTicketsEnhanced::setIssuerCompanyId()
     * @uses Ticketing_ClientTicketsEnhanced::setIsTurnback()
     * @uses Ticketing_ClientTicketsEnhanced::setIsUpdated()
     * @uses Ticketing_ClientTicketsEnhanced::setIsValid()
     * @uses Ticketing_ClientTicketsEnhanced::setItemAction()
     * @uses Ticketing_ClientTicketsEnhanced::setItemType()
     * @uses Ticketing_ClientTicketsEnhanced::setLockGuid()
     * @uses Ticketing_ClientTicketsEnhanced::setNameAndDate()
     * @uses Ticketing_ClientTicketsEnhanced::setNormalizedRowName()
     * @uses Ticketing_ClientTicketsEnhanced::setNormalizedSeatName()
     * @uses Ticketing_ClientTicketsEnhanced::setNumberOfOwnershipChanges()
     * @uses Ticketing_ClientTicketsEnhanced::setOrganizationUnitId()
     * @uses Ticketing_ClientTicketsEnhanced::setOriginalOwnerId()
     * @uses Ticketing_ClientTicketsEnhanced::setOriginalTicketId()
     * @uses Ticketing_ClientTicketsEnhanced::setOwnerId()
     * @uses Ticketing_ClientTicketsEnhanced::setPackageId()
     * @uses Ticketing_ClientTicketsEnhanced::setPaidAmount()
     * @uses Ticketing_ClientTicketsEnhanced::setPaymentStatus()
     * @uses Ticketing_ClientTicketsEnhanced::setPendingOwnerId()
     * @uses Ticketing_ClientTicketsEnhanced::setPrice()
     * @uses Ticketing_ClientTicketsEnhanced::setPriceLevelGuid()
     * @uses Ticketing_ClientTicketsEnhanced::setPriceTypeChangePolicy()
     * @uses Ticketing_ClientTicketsEnhanced::setPriceTypeId()
     * @uses Ticketing_ClientTicketsEnhanced::setPrintCount()
     * @uses Ticketing_ClientTicketsEnhanced::setPrintedAs()
     * @uses Ticketing_ClientTicketsEnhanced::setPrintMethod()
     * @uses Ticketing_ClientTicketsEnhanced::setPrintMethodData()
     * @uses Ticketing_ClientTicketsEnhanced::setPurchaserId()
     * @uses Ticketing_ClientTicketsEnhanced::setResaleDestinationClientId()
     * @uses Ticketing_ClientTicketsEnhanced::setResaleMethod()
     * @uses Ticketing_ClientTicketsEnhanced::setResaleStatus()
     * @uses Ticketing_ClientTicketsEnhanced::setRoleInSubscription()
     * @uses Ticketing_ClientTicketsEnhanced::setRowName()
     * @uses Ticketing_ClientTicketsEnhanced::setSalesRepClientId()
     * @uses Ticketing_ClientTicketsEnhanced::setSaleStatus()
     * @uses Ticketing_ClientTicketsEnhanced::setSeasonId()
     * @uses Ticketing_ClientTicketsEnhanced::setSeatIdInAreaMap()
     * @uses Ticketing_ClientTicketsEnhanced::setSeatInfo()
     * @uses Ticketing_ClientTicketsEnhanced::setSeatName()
     * @uses Ticketing_ClientTicketsEnhanced::setSectorName()
     * @uses Ticketing_ClientTicketsEnhanced::setSeriesId()
     * @uses Ticketing_ClientTicketsEnhanced::setSGOrderId()
     * @uses Ticketing_ClientTicketsEnhanced::setShowGuid()
     * @uses Ticketing_ClientTicketsEnhanced::setShowMinutes()
     * @uses Ticketing_ClientTicketsEnhanced::setStandId()
     * @uses Ticketing_ClientTicketsEnhanced::setStandName()
     * @uses Ticketing_ClientTicketsEnhanced::setStatusIcons()
     * @uses Ticketing_ClientTicketsEnhanced::setSubscriberTicketType()
     * @uses Ticketing_ClientTicketsEnhanced::setSubscriptionInstance()
     * @uses Ticketing_ClientTicketsEnhanced::setSubscriptionNumber()
     * @uses Ticketing_ClientTicketsEnhanced::setTicketBarcode()
     * @uses Ticketing_ClientTicketsEnhanced::setTicketHolder()
     * @uses Ticketing_ClientTicketsEnhanced::setTicketNumber()
     * @uses Ticketing_ClientTicketsEnhanced::setTicketSaleItemId()
     * @uses Ticketing_ClientTicketsEnhanced::setTicketTurnbackFundName()
     * @uses Ticketing_ClientTicketsEnhanced::setTotalPrice()
     * @uses Ticketing_ClientTicketsEnhanced::setTransactionDate()
     * @uses Ticketing_ClientTicketsEnhanced::setTransactionGuid()
     * @uses Ticketing_ClientTicketsEnhanced::setTransactionNotes()
     * @uses Ticketing_ClientTicketsEnhanced::setTransactionNumber()
     * @uses Ticketing_ClientTicketsEnhanced::setTransactionReferenceNumber()
     * @uses Ticketing_ClientTicketsEnhanced::setUnpaidAmount()
     * @uses Ticketing_ClientTicketsEnhanced::setUnpaidInstallmentsAmount()
     * @param string $accessControlProviderId
     * @param int $aclSchemeId
     * @param string $allocationGuid
     * @param string $applicationChannel
     * @param string $areaId
     * @param \patest\StructType\GlobalString $areaName
     * @param string $associatedDate
     * @param string $attachedToBenefitInstanceId
     * @param \patest\StructType\GlobalString $bucketName
     * @param string $continuedByAction
     * @param string $createdByResaleMethod
     * @param string $custodyStatus
     * @param string $eventDate
     * @param string $eventDateUtc
     * @param string $eventDayOfWeek
     * @param string $eventGuid
     * @param string[] $eventSaleStatus
     * @param string $eventType1Id
     * @param string $eventType2Id
     * @param string $eventType3Id
     * @param string $eventType4Id
     * @param string $eventType5Id
     * @param string $eventTypeId
     * @param string $externalTicketNumber
     * @param string $extraFields
     * @param string $firstEntryScanDate
     * @param string $hallId
     * @param bool $hasTicketHolder
     * @param int $holderCompanyId
     * @param int $idInTransaction
     * @param bool $isAvailableForChangeOfOwnership
     * @param bool $isAvailableForResaleRequest
     * @param bool $isAvailableForTicketDistribution
     * @param bool $isComplimentary
     * @param bool $isDistributed
     * @param bool $isForResale
     * @param bool $isHospitality
     * @param bool $isMoved
     * @param bool $isObsolete
     * @param bool $isOnlineForwarded
     * @param bool $isOriginal
     * @param bool $isPrinted
     * @param bool $isPrinting
     * @param bool $isResale
     * @param bool $isReserved
     * @param bool $isReturned
     * @param bool $isScanned
     * @param bool $isSubsTicket
     * @param int $issuerCompanyId
     * @param bool $isTurnback
     * @param bool $isUpdated
     * @param bool $isValid
     * @param int $itemAction
     * @param int $itemType
     * @param string $lockGuid
     * @param string $nameAndDate
     * @param string $normalizedRowName
     * @param string $normalizedSeatName
     * @param int $numberOfOwnershipChanges
     * @param string $organizationUnitId
     * @param string $originalOwnerId
     * @param string $originalTicketId
     * @param string $ownerId
     * @param string $packageId
     * @param \patest\StructType\Money $paidAmount
     * @param string $paymentStatus
     * @param string $pendingOwnerId
     * @param \patest\StructType\Money $price
     * @param string $priceLevelGuid
     * @param \patest\StructType\Ticketing_TicketPriceTypeChangePolicy $priceTypeChangePolicy
     * @param string $priceTypeId
     * @param int $printCount
     * @param string $printedAs
     * @param string $printMethod
     * @param string $printMethodData
     * @param string $purchaserId
     * @param string $resaleDestinationClientId
     * @param string $resaleMethod
     * @param string $resaleStatus
     * @param string $roleInSubscription
     * @param string $rowName
     * @param string $salesRepClientId
     * @param string $saleStatus
     * @param string $seasonId
     * @param int $seatIdInAreaMap
     * @param \patest\StructType\Ticketing_SeatInfo $seatInfo
     * @param string $seatName
     * @param \patest\StructType\GlobalString $sectorName
     * @param string $seriesId
     * @param string $sGOrderId
     * @param string $showGuid
     * @param int $showMinutes
     * @param string $standId
     * @param \patest\StructType\GlobalString $standName
     * @param string $statusIcons
     * @param string $subscriberTicketType
     * @param string $subscriptionInstance
     * @param string $subscriptionNumber
     * @param string $ticketBarcode
     * @param \patest\StructType\Ticketing_TicketDistributionJournal $ticketHolder
     * @param int $ticketNumber
     * @param string $ticketSaleItemId
     * @param string $ticketTurnbackFundName
     * @param \patest\StructType\Money $totalPrice
     * @param string $transactionDate
     * @param string $transactionGuid
     * @param string $transactionNotes
     * @param int $transactionNumber
     * @param int $transactionReferenceNumber
     * @param \patest\StructType\Money $unpaidAmount
     * @param \patest\StructType\Money $unpaidInstallmentsAmount
     */
    public function __construct($accessControlProviderId = null, $aclSchemeId = null, $allocationGuid = null, $applicationChannel = null, $areaId = null, \patest\StructType\GlobalString $areaName = null, $associatedDate = null, $attachedToBenefitInstanceId = null, \patest\StructType\GlobalString $bucketName = null, $continuedByAction = null, $createdByResaleMethod = null, $custodyStatus = null, $eventDate = null, $eventDateUtc = null, $eventDayOfWeek = null, $eventGuid = null, array $eventSaleStatus = array(), $eventType1Id = null, $eventType2Id = null, $eventType3Id = null, $eventType4Id = null, $eventType5Id = null, $eventTypeId = null, $externalTicketNumber = null, $extraFields = null, $firstEntryScanDate = null, $hallId = null, $hasTicketHolder = null, $holderCompanyId = null, $idInTransaction = null, $isAvailableForChangeOfOwnership = null, $isAvailableForResaleRequest = null, $isAvailableForTicketDistribution = null, $isComplimentary = null, $isDistributed = null, $isForResale = null, $isHospitality = null, $isMoved = null, $isObsolete = null, $isOnlineForwarded = null, $isOriginal = null, $isPrinted = null, $isPrinting = null, $isResale = null, $isReserved = null, $isReturned = null, $isScanned = null, $isSubsTicket = null, $issuerCompanyId = null, $isTurnback = null, $isUpdated = null, $isValid = null, $itemAction = null, $itemType = null, $lockGuid = null, $nameAndDate = null, $normalizedRowName = null, $normalizedSeatName = null, $numberOfOwnershipChanges = null, $organizationUnitId = null, $originalOwnerId = null, $originalTicketId = null, $ownerId = null, $packageId = null, \patest\StructType\Money $paidAmount = null, $paymentStatus = null, $pendingOwnerId = null, \patest\StructType\Money $price = null, $priceLevelGuid = null, \patest\StructType\Ticketing_TicketPriceTypeChangePolicy $priceTypeChangePolicy = null, $priceTypeId = null, $printCount = null, $printedAs = null, $printMethod = null, $printMethodData = null, $purchaserId = null, $resaleDestinationClientId = null, $resaleMethod = null, $resaleStatus = null, $roleInSubscription = null, $rowName = null, $salesRepClientId = null, $saleStatus = null, $seasonId = null, $seatIdInAreaMap = null, \patest\StructType\Ticketing_SeatInfo $seatInfo = null, $seatName = null, \patest\StructType\GlobalString $sectorName = null, $seriesId = null, $sGOrderId = null, $showGuid = null, $showMinutes = null, $standId = null, \patest\StructType\GlobalString $standName = null, $statusIcons = null, $subscriberTicketType = null, $subscriptionInstance = null, $subscriptionNumber = null, $ticketBarcode = null, \patest\StructType\Ticketing_TicketDistributionJournal $ticketHolder = null, $ticketNumber = null, $ticketSaleItemId = null, $ticketTurnbackFundName = null, \patest\StructType\Money $totalPrice = null, $transactionDate = null, $transactionGuid = null, $transactionNotes = null, $transactionNumber = null, $transactionReferenceNumber = null, \patest\StructType\Money $unpaidAmount = null, \patest\StructType\Money $unpaidInstallmentsAmount = null)
    {
        $this
            ->setAccessControlProviderId($accessControlProviderId)
            ->setAclSchemeId($aclSchemeId)
            ->setAllocationGuid($allocationGuid)
            ->setApplicationChannel($applicationChannel)
            ->setAreaId($areaId)
            ->setAreaName($areaName)
            ->setAssociatedDate($associatedDate)
            ->setAttachedToBenefitInstanceId($attachedToBenefitInstanceId)
            ->setBucketName($bucketName)
            ->setContinuedByAction($continuedByAction)
            ->setCreatedByResaleMethod($createdByResaleMethod)
            ->setCustodyStatus($custodyStatus)
            ->setEventDate($eventDate)
            ->setEventDateUtc($eventDateUtc)
            ->setEventDayOfWeek($eventDayOfWeek)
            ->setEventGuid($eventGuid)
            ->setEventSaleStatus($eventSaleStatus)
            ->setEventType1Id($eventType1Id)
            ->setEventType2Id($eventType2Id)
            ->setEventType3Id($eventType3Id)
            ->setEventType4Id($eventType4Id)
            ->setEventType5Id($eventType5Id)
            ->setEventTypeId($eventTypeId)
            ->setExternalTicketNumber($externalTicketNumber)
            ->setExtraFields($extraFields)
            ->setFirstEntryScanDate($firstEntryScanDate)
            ->setHallId($hallId)
            ->setHasTicketHolder($hasTicketHolder)
            ->setHolderCompanyId($holderCompanyId)
            ->setIdInTransaction($idInTransaction)
            ->setIsAvailableForChangeOfOwnership($isAvailableForChangeOfOwnership)
            ->setIsAvailableForResaleRequest($isAvailableForResaleRequest)
            ->setIsAvailableForTicketDistribution($isAvailableForTicketDistribution)
            ->setIsComplimentary($isComplimentary)
            ->setIsDistributed($isDistributed)
            ->setIsForResale($isForResale)
            ->setIsHospitality($isHospitality)
            ->setIsMoved($isMoved)
            ->setIsObsolete($isObsolete)
            ->setIsOnlineForwarded($isOnlineForwarded)
            ->setIsOriginal($isOriginal)
            ->setIsPrinted($isPrinted)
            ->setIsPrinting($isPrinting)
            ->setIsResale($isResale)
            ->setIsReserved($isReserved)
            ->setIsReturned($isReturned)
            ->setIsScanned($isScanned)
            ->setIsSubsTicket($isSubsTicket)
            ->setIssuerCompanyId($issuerCompanyId)
            ->setIsTurnback($isTurnback)
            ->setIsUpdated($isUpdated)
            ->setIsValid($isValid)
            ->setItemAction($itemAction)
            ->setItemType($itemType)
            ->setLockGuid($lockGuid)
            ->setNameAndDate($nameAndDate)
            ->setNormalizedRowName($normalizedRowName)
            ->setNormalizedSeatName($normalizedSeatName)
            ->setNumberOfOwnershipChanges($numberOfOwnershipChanges)
            ->setOrganizationUnitId($organizationUnitId)
            ->setOriginalOwnerId($originalOwnerId)
            ->setOriginalTicketId($originalTicketId)
            ->setOwnerId($ownerId)
            ->setPackageId($packageId)
            ->setPaidAmount($paidAmount)
            ->setPaymentStatus($paymentStatus)
            ->setPendingOwnerId($pendingOwnerId)
            ->setPrice($price)
            ->setPriceLevelGuid($priceLevelGuid)
            ->setPriceTypeChangePolicy($priceTypeChangePolicy)
            ->setPriceTypeId($priceTypeId)
            ->setPrintCount($printCount)
            ->setPrintedAs($printedAs)
            ->setPrintMethod($printMethod)
            ->setPrintMethodData($printMethodData)
            ->setPurchaserId($purchaserId)
            ->setResaleDestinationClientId($resaleDestinationClientId)
            ->setResaleMethod($resaleMethod)
            ->setResaleStatus($resaleStatus)
            ->setRoleInSubscription($roleInSubscription)
            ->setRowName($rowName)
            ->setSalesRepClientId($salesRepClientId)
            ->setSaleStatus($saleStatus)
            ->setSeasonId($seasonId)
            ->setSeatIdInAreaMap($seatIdInAreaMap)
            ->setSeatInfo($seatInfo)
            ->setSeatName($seatName)
            ->setSectorName($sectorName)
            ->setSeriesId($seriesId)
            ->setSGOrderId($sGOrderId)
            ->setShowGuid($showGuid)
            ->setShowMinutes($showMinutes)
            ->setStandId($standId)
            ->setStandName($standName)
            ->setStatusIcons($statusIcons)
            ->setSubscriberTicketType($subscriberTicketType)
            ->setSubscriptionInstance($subscriptionInstance)
            ->setSubscriptionNumber($subscriptionNumber)
            ->setTicketBarcode($ticketBarcode)
            ->setTicketHolder($ticketHolder)
            ->setTicketNumber($ticketNumber)
            ->setTicketSaleItemId($ticketSaleItemId)
            ->setTicketTurnbackFundName($ticketTurnbackFundName)
            ->setTotalPrice($totalPrice)
            ->setTransactionDate($transactionDate)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionNotes($transactionNotes)
            ->setTransactionNumber($transactionNumber)
            ->setTransactionReferenceNumber($transactionReferenceNumber)
            ->setUnpaidAmount($unpaidAmount)
            ->setUnpaidInstallmentsAmount($unpaidInstallmentsAmount);
    }
    /**
     * Get AccessControlProviderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlProviderId()
    {
        return isset($this->AccessControlProviderId) ? $this->AccessControlProviderId : null;
    }
    /**
     * Set AccessControlProviderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlProviderId
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setAccessControlProviderId($accessControlProviderId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlProviderId) && !is_string($accessControlProviderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlProviderId, true), gettype($accessControlProviderId)), __LINE__);
        }
        if (is_null($accessControlProviderId) || (is_array($accessControlProviderId) && empty($accessControlProviderId))) {
            unset($this->AccessControlProviderId);
        } else {
            $this->AccessControlProviderId = $accessControlProviderId;
        }
        return $this;
    }
    /**
     * Get AclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAclSchemeId()
    {
        return isset($this->AclSchemeId) ? $this->AclSchemeId : null;
    }
    /**
     * Set AclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aclSchemeId
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setAclSchemeId($aclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($aclSchemeId) && !(is_int($aclSchemeId) || ctype_digit($aclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aclSchemeId, true), gettype($aclSchemeId)), __LINE__);
        }
        if (is_null($aclSchemeId) || (is_array($aclSchemeId) && empty($aclSchemeId))) {
            unset($this->AclSchemeId);
        } else {
            $this->AclSchemeId = $aclSchemeId;
        }
        return $this;
    }
    /**
     * Get AllocationGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAllocationGuid()
    {
        return isset($this->AllocationGuid) ? $this->AllocationGuid : null;
    }
    /**
     * Set AllocationGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $allocationGuid
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setAllocationGuid($allocationGuid = null)
    {
        // validation for constraint: string
        if (!is_null($allocationGuid) && !is_string($allocationGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allocationGuid, true), gettype($allocationGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($allocationGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $allocationGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($allocationGuid, true)), __LINE__);
        }
        if (is_null($allocationGuid) || (is_array($allocationGuid) && empty($allocationGuid))) {
            unset($this->AllocationGuid);
        } else {
            $this->AllocationGuid = $allocationGuid;
        }
        return $this;
    }
    /**
     * Get ApplicationChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationChannel()
    {
        return isset($this->ApplicationChannel) ? $this->ApplicationChannel : null;
    }
    /**
     * Set ApplicationChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationChannel
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setApplicationChannel($applicationChannel = null)
    {
        // validation for constraint: string
        if (!is_null($applicationChannel) && !is_string($applicationChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationChannel, true), gettype($applicationChannel)), __LINE__);
        }
        if (is_null($applicationChannel) || (is_array($applicationChannel) && empty($applicationChannel))) {
            unset($this->ApplicationChannel);
        } else {
            $this->ApplicationChannel = $applicationChannel;
        }
        return $this;
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get AreaName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getAreaName()
    {
        return isset($this->AreaName) ? $this->AreaName : null;
    }
    /**
     * Set AreaName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $areaName
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setAreaName(\patest\StructType\GlobalString $areaName = null)
    {
        if (is_null($areaName) || (is_array($areaName) && empty($areaName))) {
            unset($this->AreaName);
        } else {
            $this->AreaName = $areaName;
        }
        return $this;
    }
    /**
     * Get AssociatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssociatedDate()
    {
        return isset($this->AssociatedDate) ? $this->AssociatedDate : null;
    }
    /**
     * Set AssociatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $associatedDate
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setAssociatedDate($associatedDate = null)
    {
        // validation for constraint: string
        if (!is_null($associatedDate) && !is_string($associatedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($associatedDate, true), gettype($associatedDate)), __LINE__);
        }
        if (is_null($associatedDate) || (is_array($associatedDate) && empty($associatedDate))) {
            unset($this->AssociatedDate);
        } else {
            $this->AssociatedDate = $associatedDate;
        }
        return $this;
    }
    /**
     * Get AttachedToBenefitInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAttachedToBenefitInstanceId()
    {
        return isset($this->AttachedToBenefitInstanceId) ? $this->AttachedToBenefitInstanceId : null;
    }
    /**
     * Set AttachedToBenefitInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $attachedToBenefitInstanceId
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setAttachedToBenefitInstanceId($attachedToBenefitInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($attachedToBenefitInstanceId) && !is_string($attachedToBenefitInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attachedToBenefitInstanceId, true), gettype($attachedToBenefitInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($attachedToBenefitInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $attachedToBenefitInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($attachedToBenefitInstanceId, true)), __LINE__);
        }
        if (is_null($attachedToBenefitInstanceId) || (is_array($attachedToBenefitInstanceId) && empty($attachedToBenefitInstanceId))) {
            unset($this->AttachedToBenefitInstanceId);
        } else {
            $this->AttachedToBenefitInstanceId = $attachedToBenefitInstanceId;
        }
        return $this;
    }
    /**
     * Get BucketName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getBucketName()
    {
        return isset($this->BucketName) ? $this->BucketName : null;
    }
    /**
     * Set BucketName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $bucketName
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setBucketName(\patest\StructType\GlobalString $bucketName = null)
    {
        if (is_null($bucketName) || (is_array($bucketName) && empty($bucketName))) {
            unset($this->BucketName);
        } else {
            $this->BucketName = $bucketName;
        }
        return $this;
    }
    /**
     * Get ContinuedByAction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContinuedByAction()
    {
        return isset($this->ContinuedByAction) ? $this->ContinuedByAction : null;
    }
    /**
     * Set ContinuedByAction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketContinuationAction::valueIsValid()
     * @uses \patest\EnumType\TicketContinuationAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $continuedByAction
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setContinuedByAction($continuedByAction = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketContinuationAction::valueIsValid($continuedByAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketContinuationAction', is_array($continuedByAction) ? implode(', ', $continuedByAction) : var_export($continuedByAction, true), implode(', ', \patest\EnumType\TicketContinuationAction::getValidValues())), __LINE__);
        }
        if (is_null($continuedByAction) || (is_array($continuedByAction) && empty($continuedByAction))) {
            unset($this->ContinuedByAction);
        } else {
            $this->ContinuedByAction = $continuedByAction;
        }
        return $this;
    }
    /**
     * Get CreatedByResaleMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedByResaleMethod()
    {
        return isset($this->CreatedByResaleMethod) ? $this->CreatedByResaleMethod : null;
    }
    /**
     * Set CreatedByResaleMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketResaleMethod::valueIsValid()
     * @uses \patest\EnumType\TicketResaleMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $createdByResaleMethod
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setCreatedByResaleMethod($createdByResaleMethod = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketResaleMethod::valueIsValid($createdByResaleMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketResaleMethod', is_array($createdByResaleMethod) ? implode(', ', $createdByResaleMethod) : var_export($createdByResaleMethod, true), implode(', ', \patest\EnumType\TicketResaleMethod::getValidValues())), __LINE__);
        }
        if (is_null($createdByResaleMethod) || (is_array($createdByResaleMethod) && empty($createdByResaleMethod))) {
            unset($this->CreatedByResaleMethod);
        } else {
            $this->CreatedByResaleMethod = $createdByResaleMethod;
        }
        return $this;
    }
    /**
     * Get CustodyStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustodyStatus()
    {
        return isset($this->CustodyStatus) ? $this->CustodyStatus : null;
    }
    /**
     * Set CustodyStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CustodyStatus::valueIsValid()
     * @uses \patest\EnumType\CustodyStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $custodyStatus
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setCustodyStatus($custodyStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\CustodyStatus::valueIsValid($custodyStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CustodyStatus', is_array($custodyStatus) ? implode(', ', $custodyStatus) : var_export($custodyStatus, true), implode(', ', \patest\EnumType\CustodyStatus::getValidValues())), __LINE__);
        }
        if (is_null($custodyStatus) || (is_array($custodyStatus) && empty($custodyStatus))) {
            unset($this->CustodyStatus);
        } else {
            $this->CustodyStatus = $custodyStatus;
        }
        return $this;
    }
    /**
     * Get EventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDate()
    {
        return isset($this->EventDate) ? $this->EventDate : null;
    }
    /**
     * Set EventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDate
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setEventDate($eventDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventDate) && !is_string($eventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDate, true), gettype($eventDate)), __LINE__);
        }
        if (is_null($eventDate) || (is_array($eventDate) && empty($eventDate))) {
            unset($this->EventDate);
        } else {
            $this->EventDate = $eventDate;
        }
        return $this;
    }
    /**
     * Get EventDateUtc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDateUtc()
    {
        return isset($this->EventDateUtc) ? $this->EventDateUtc : null;
    }
    /**
     * Set EventDateUtc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDateUtc
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setEventDateUtc($eventDateUtc = null)
    {
        // validation for constraint: string
        if (!is_null($eventDateUtc) && !is_string($eventDateUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDateUtc, true), gettype($eventDateUtc)), __LINE__);
        }
        if (is_null($eventDateUtc) || (is_array($eventDateUtc) && empty($eventDateUtc))) {
            unset($this->EventDateUtc);
        } else {
            $this->EventDateUtc = $eventDateUtc;
        }
        return $this;
    }
    /**
     * Get EventDayOfWeek value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDayOfWeek()
    {
        return isset($this->EventDayOfWeek) ? $this->EventDayOfWeek : null;
    }
    /**
     * Set EventDayOfWeek value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDayOfWeek
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setEventDayOfWeek($eventDayOfWeek = null)
    {
        // validation for constraint: string
        if (!is_null($eventDayOfWeek) && !is_string($eventDayOfWeek)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDayOfWeek, true), gettype($eventDayOfWeek)), __LINE__);
        }
        if (is_null($eventDayOfWeek) || (is_array($eventDayOfWeek) && empty($eventDayOfWeek))) {
            unset($this->EventDayOfWeek);
        } else {
            $this->EventDayOfWeek = $eventDayOfWeek;
        }
        return $this;
    }
    /**
     * Get EventGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventGuid()
    {
        return isset($this->EventGuid) ? $this->EventGuid : null;
    }
    /**
     * Set EventGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventGuid
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setEventGuid($eventGuid = null)
    {
        // validation for constraint: string
        if (!is_null($eventGuid) && !is_string($eventGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventGuid, true), gettype($eventGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventGuid, true)), __LINE__);
        }
        if (is_null($eventGuid) || (is_array($eventGuid) && empty($eventGuid))) {
            unset($this->EventGuid);
        } else {
            $this->EventGuid = $eventGuid;
        }
        return $this;
    }
    /**
     * Get EventSaleStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getEventSaleStatus()
    {
        return isset($this->EventSaleStatus) ? $this->EventSaleStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setEventSaleStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEventSaleStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEventSaleStatusForArrayConstraintsFromSetEventSaleStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ticketing_ClientTicketsEnhancedEventSaleStatusItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\EventSaleStatus::valueIsValid($ticketing_ClientTicketsEnhancedEventSaleStatusItem)) {
                $invalidValues[] = is_object($ticketing_ClientTicketsEnhancedEventSaleStatusItem) ? get_class($ticketing_ClientTicketsEnhancedEventSaleStatusItem) : sprintf('%s(%s)', gettype($ticketing_ClientTicketsEnhancedEventSaleStatusItem), var_export($ticketing_ClientTicketsEnhancedEventSaleStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EventSaleStatus', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\EventSaleStatus::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EventSaleStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\EventSaleStatus::valueIsValid()
     * @uses \patest\EnumType\EventSaleStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $eventSaleStatus
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setEventSaleStatus(array $eventSaleStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($eventSaleStatusArrayErrorMessage = self::validateEventSaleStatusForArrayConstraintsFromSetEventSaleStatus($eventSaleStatus))) {
            throw new \InvalidArgumentException($eventSaleStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($eventSaleStatus) || (is_array($eventSaleStatus) && empty($eventSaleStatus))) {
            unset($this->EventSaleStatus);
        } else {
            $this->EventSaleStatus = is_array($eventSaleStatus) ? implode(' ', $eventSaleStatus) : null;
        }
        return $this;
    }
    /**
     * Get EventType1Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventType1Id()
    {
        return isset($this->EventType1Id) ? $this->EventType1Id : null;
    }
    /**
     * Set EventType1Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventType1Id
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setEventType1Id($eventType1Id = null)
    {
        // validation for constraint: string
        if (!is_null($eventType1Id) && !is_string($eventType1Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventType1Id, true), gettype($eventType1Id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventType1Id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventType1Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventType1Id, true)), __LINE__);
        }
        if (is_null($eventType1Id) || (is_array($eventType1Id) && empty($eventType1Id))) {
            unset($this->EventType1Id);
        } else {
            $this->EventType1Id = $eventType1Id;
        }
        return $this;
    }
    /**
     * Get EventType2Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventType2Id()
    {
        return isset($this->EventType2Id) ? $this->EventType2Id : null;
    }
    /**
     * Set EventType2Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventType2Id
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setEventType2Id($eventType2Id = null)
    {
        // validation for constraint: string
        if (!is_null($eventType2Id) && !is_string($eventType2Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventType2Id, true), gettype($eventType2Id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventType2Id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventType2Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventType2Id, true)), __LINE__);
        }
        if (is_null($eventType2Id) || (is_array($eventType2Id) && empty($eventType2Id))) {
            unset($this->EventType2Id);
        } else {
            $this->EventType2Id = $eventType2Id;
        }
        return $this;
    }
    /**
     * Get EventType3Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventType3Id()
    {
        return isset($this->EventType3Id) ? $this->EventType3Id : null;
    }
    /**
     * Set EventType3Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventType3Id
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setEventType3Id($eventType3Id = null)
    {
        // validation for constraint: string
        if (!is_null($eventType3Id) && !is_string($eventType3Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventType3Id, true), gettype($eventType3Id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventType3Id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventType3Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventType3Id, true)), __LINE__);
        }
        if (is_null($eventType3Id) || (is_array($eventType3Id) && empty($eventType3Id))) {
            unset($this->EventType3Id);
        } else {
            $this->EventType3Id = $eventType3Id;
        }
        return $this;
    }
    /**
     * Get EventType4Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventType4Id()
    {
        return isset($this->EventType4Id) ? $this->EventType4Id : null;
    }
    /**
     * Set EventType4Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventType4Id
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setEventType4Id($eventType4Id = null)
    {
        // validation for constraint: string
        if (!is_null($eventType4Id) && !is_string($eventType4Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventType4Id, true), gettype($eventType4Id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventType4Id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventType4Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventType4Id, true)), __LINE__);
        }
        if (is_null($eventType4Id) || (is_array($eventType4Id) && empty($eventType4Id))) {
            unset($this->EventType4Id);
        } else {
            $this->EventType4Id = $eventType4Id;
        }
        return $this;
    }
    /**
     * Get EventType5Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventType5Id()
    {
        return isset($this->EventType5Id) ? $this->EventType5Id : null;
    }
    /**
     * Set EventType5Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventType5Id
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setEventType5Id($eventType5Id = null)
    {
        // validation for constraint: string
        if (!is_null($eventType5Id) && !is_string($eventType5Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventType5Id, true), gettype($eventType5Id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventType5Id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventType5Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventType5Id, true)), __LINE__);
        }
        if (is_null($eventType5Id) || (is_array($eventType5Id) && empty($eventType5Id))) {
            unset($this->EventType5Id);
        } else {
            $this->EventType5Id = $eventType5Id;
        }
        return $this;
    }
    /**
     * Get EventTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventTypeId()
    {
        return isset($this->EventTypeId) ? $this->EventTypeId : null;
    }
    /**
     * Set EventTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventTypeId
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setEventTypeId($eventTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($eventTypeId) && !is_string($eventTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventTypeId, true), gettype($eventTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventTypeId, true)), __LINE__);
        }
        if (is_null($eventTypeId) || (is_array($eventTypeId) && empty($eventTypeId))) {
            unset($this->EventTypeId);
        } else {
            $this->EventTypeId = $eventTypeId;
        }
        return $this;
    }
    /**
     * Get ExternalTicketNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalTicketNumber()
    {
        return isset($this->ExternalTicketNumber) ? $this->ExternalTicketNumber : null;
    }
    /**
     * Set ExternalTicketNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalTicketNumber
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setExternalTicketNumber($externalTicketNumber = null)
    {
        // validation for constraint: string
        if (!is_null($externalTicketNumber) && !is_string($externalTicketNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalTicketNumber, true), gettype($externalTicketNumber)), __LINE__);
        }
        if (is_null($externalTicketNumber) || (is_array($externalTicketNumber) && empty($externalTicketNumber))) {
            unset($this->ExternalTicketNumber);
        } else {
            $this->ExternalTicketNumber = $externalTicketNumber;
        }
        return $this;
    }
    /**
     * Get ExtraFields value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtraFields()
    {
        return isset($this->ExtraFields) ? $this->ExtraFields : null;
    }
    /**
     * Set ExtraFields value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extraFields
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setExtraFields($extraFields = null)
    {
        // validation for constraint: string
        if (!is_null($extraFields) && !is_string($extraFields)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraFields, true), gettype($extraFields)), __LINE__);
        }
        if (is_null($extraFields) || (is_array($extraFields) && empty($extraFields))) {
            unset($this->ExtraFields);
        } else {
            $this->ExtraFields = $extraFields;
        }
        return $this;
    }
    /**
     * Get FirstEntryScanDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstEntryScanDate()
    {
        return isset($this->FirstEntryScanDate) ? $this->FirstEntryScanDate : null;
    }
    /**
     * Set FirstEntryScanDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstEntryScanDate
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setFirstEntryScanDate($firstEntryScanDate = null)
    {
        // validation for constraint: string
        if (!is_null($firstEntryScanDate) && !is_string($firstEntryScanDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstEntryScanDate, true), gettype($firstEntryScanDate)), __LINE__);
        }
        if (is_null($firstEntryScanDate) || (is_array($firstEntryScanDate) && empty($firstEntryScanDate))) {
            unset($this->FirstEntryScanDate);
        } else {
            $this->FirstEntryScanDate = $firstEntryScanDate;
        }
        return $this;
    }
    /**
     * Get HallId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallId()
    {
        return isset($this->HallId) ? $this->HallId : null;
    }
    /**
     * Set HallId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallId
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setHallId($hallId = null)
    {
        // validation for constraint: string
        if (!is_null($hallId) && !is_string($hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallId, true), gettype($hallId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallId, true)), __LINE__);
        }
        if (is_null($hallId) || (is_array($hallId) && empty($hallId))) {
            unset($this->HallId);
        } else {
            $this->HallId = $hallId;
        }
        return $this;
    }
    /**
     * Get HasTicketHolder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasTicketHolder()
    {
        return isset($this->HasTicketHolder) ? $this->HasTicketHolder : null;
    }
    /**
     * Set HasTicketHolder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasTicketHolder
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setHasTicketHolder($hasTicketHolder = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasTicketHolder) && !is_bool($hasTicketHolder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasTicketHolder, true), gettype($hasTicketHolder)), __LINE__);
        }
        if (is_null($hasTicketHolder) || (is_array($hasTicketHolder) && empty($hasTicketHolder))) {
            unset($this->HasTicketHolder);
        } else {
            $this->HasTicketHolder = $hasTicketHolder;
        }
        return $this;
    }
    /**
     * Get HolderCompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHolderCompanyId()
    {
        return isset($this->HolderCompanyId) ? $this->HolderCompanyId : null;
    }
    /**
     * Set HolderCompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $holderCompanyId
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setHolderCompanyId($holderCompanyId = null)
    {
        // validation for constraint: int
        if (!is_null($holderCompanyId) && !(is_int($holderCompanyId) || ctype_digit($holderCompanyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($holderCompanyId, true), gettype($holderCompanyId)), __LINE__);
        }
        if (is_null($holderCompanyId) || (is_array($holderCompanyId) && empty($holderCompanyId))) {
            unset($this->HolderCompanyId);
        } else {
            $this->HolderCompanyId = $holderCompanyId;
        }
        return $this;
    }
    /**
     * Get IdInTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIdInTransaction()
    {
        return isset($this->IdInTransaction) ? $this->IdInTransaction : null;
    }
    /**
     * Set IdInTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $idInTransaction
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setIdInTransaction($idInTransaction = null)
    {
        // validation for constraint: int
        if (!is_null($idInTransaction) && !(is_int($idInTransaction) || ctype_digit($idInTransaction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idInTransaction, true), gettype($idInTransaction)), __LINE__);
        }
        if (is_null($idInTransaction) || (is_array($idInTransaction) && empty($idInTransaction))) {
            unset($this->IdInTransaction);
        } else {
            $this->IdInTransaction = $idInTransaction;
        }
        return $this;
    }
    /**
     * Get IsAvailableForChangeOfOwnership value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAvailableForChangeOfOwnership()
    {
        return isset($this->IsAvailableForChangeOfOwnership) ? $this->IsAvailableForChangeOfOwnership : null;
    }
    /**
     * Set IsAvailableForChangeOfOwnership value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAvailableForChangeOfOwnership
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setIsAvailableForChangeOfOwnership($isAvailableForChangeOfOwnership = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAvailableForChangeOfOwnership) && !is_bool($isAvailableForChangeOfOwnership)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAvailableForChangeOfOwnership, true), gettype($isAvailableForChangeOfOwnership)), __LINE__);
        }
        if (is_null($isAvailableForChangeOfOwnership) || (is_array($isAvailableForChangeOfOwnership) && empty($isAvailableForChangeOfOwnership))) {
            unset($this->IsAvailableForChangeOfOwnership);
        } else {
            $this->IsAvailableForChangeOfOwnership = $isAvailableForChangeOfOwnership;
        }
        return $this;
    }
    /**
     * Get IsAvailableForResaleRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAvailableForResaleRequest()
    {
        return isset($this->IsAvailableForResaleRequest) ? $this->IsAvailableForResaleRequest : null;
    }
    /**
     * Set IsAvailableForResaleRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAvailableForResaleRequest
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setIsAvailableForResaleRequest($isAvailableForResaleRequest = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAvailableForResaleRequest) && !is_bool($isAvailableForResaleRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAvailableForResaleRequest, true), gettype($isAvailableForResaleRequest)), __LINE__);
        }
        if (is_null($isAvailableForResaleRequest) || (is_array($isAvailableForResaleRequest) && empty($isAvailableForResaleRequest))) {
            unset($this->IsAvailableForResaleRequest);
        } else {
            $this->IsAvailableForResaleRequest = $isAvailableForResaleRequest;
        }
        return $this;
    }
    /**
     * Get IsAvailableForTicketDistribution value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAvailableForTicketDistribution()
    {
        return isset($this->IsAvailableForTicketDistribution) ? $this->IsAvailableForTicketDistribution : null;
    }
    /**
     * Set IsAvailableForTicketDistribution value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAvailableForTicketDistribution
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setIsAvailableForTicketDistribution($isAvailableForTicketDistribution = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAvailableForTicketDistribution) && !is_bool($isAvailableForTicketDistribution)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAvailableForTicketDistribution, true), gettype($isAvailableForTicketDistribution)), __LINE__);
        }
        if (is_null($isAvailableForTicketDistribution) || (is_array($isAvailableForTicketDistribution) && empty($isAvailableForTicketDistribution))) {
            unset($this->IsAvailableForTicketDistribution);
        } else {
            $this->IsAvailableForTicketDistribution = $isAvailableForTicketDistribution;
        }
        return $this;
    }
    /**
     * Get IsComplimentary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsComplimentary()
    {
        return isset($this->IsComplimentary) ? $this->IsComplimentary : null;
    }
    /**
     * Set IsComplimentary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isComplimentary
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setIsComplimentary($isComplimentary = null)
    {
        // validation for constraint: boolean
        if (!is_null($isComplimentary) && !is_bool($isComplimentary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isComplimentary, true), gettype($isComplimentary)), __LINE__);
        }
        if (is_null($isComplimentary) || (is_array($isComplimentary) && empty($isComplimentary))) {
            unset($this->IsComplimentary);
        } else {
            $this->IsComplimentary = $isComplimentary;
        }
        return $this;
    }
    /**
     * Get IsDistributed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDistributed()
    {
        return isset($this->IsDistributed) ? $this->IsDistributed : null;
    }
    /**
     * Set IsDistributed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDistributed
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setIsDistributed($isDistributed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDistributed) && !is_bool($isDistributed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDistributed, true), gettype($isDistributed)), __LINE__);
        }
        if (is_null($isDistributed) || (is_array($isDistributed) && empty($isDistributed))) {
            unset($this->IsDistributed);
        } else {
            $this->IsDistributed = $isDistributed;
        }
        return $this;
    }
    /**
     * Get IsForResale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsForResale()
    {
        return isset($this->IsForResale) ? $this->IsForResale : null;
    }
    /**
     * Set IsForResale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isForResale
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setIsForResale($isForResale = null)
    {
        // validation for constraint: boolean
        if (!is_null($isForResale) && !is_bool($isForResale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isForResale, true), gettype($isForResale)), __LINE__);
        }
        if (is_null($isForResale) || (is_array($isForResale) && empty($isForResale))) {
            unset($this->IsForResale);
        } else {
            $this->IsForResale = $isForResale;
        }
        return $this;
    }
    /**
     * Get IsHospitality value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsHospitality()
    {
        return isset($this->IsHospitality) ? $this->IsHospitality : null;
    }
    /**
     * Set IsHospitality value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isHospitality
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setIsHospitality($isHospitality = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHospitality) && !is_bool($isHospitality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isHospitality, true), gettype($isHospitality)), __LINE__);
        }
        if (is_null($isHospitality) || (is_array($isHospitality) && empty($isHospitality))) {
            unset($this->IsHospitality);
        } else {
            $this->IsHospitality = $isHospitality;
        }
        return $this;
    }
    /**
     * Get IsMoved value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsMoved()
    {
        return isset($this->IsMoved) ? $this->IsMoved : null;
    }
    /**
     * Set IsMoved value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isMoved
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setIsMoved($isMoved = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMoved) && !is_bool($isMoved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMoved, true), gettype($isMoved)), __LINE__);
        }
        if (is_null($isMoved) || (is_array($isMoved) && empty($isMoved))) {
            unset($this->IsMoved);
        } else {
            $this->IsMoved = $isMoved;
        }
        return $this;
    }
    /**
     * Get IsObsolete value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsObsolete()
    {
        return isset($this->IsObsolete) ? $this->IsObsolete : null;
    }
    /**
     * Set IsObsolete value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isObsolete
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setIsObsolete($isObsolete = null)
    {
        // validation for constraint: boolean
        if (!is_null($isObsolete) && !is_bool($isObsolete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isObsolete, true), gettype($isObsolete)), __LINE__);
        }
        if (is_null($isObsolete) || (is_array($isObsolete) && empty($isObsolete))) {
            unset($this->IsObsolete);
        } else {
            $this->IsObsolete = $isObsolete;
        }
        return $this;
    }
    /**
     * Get IsOnlineForwarded value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsOnlineForwarded()
    {
        return isset($this->IsOnlineForwarded) ? $this->IsOnlineForwarded : null;
    }
    /**
     * Set IsOnlineForwarded value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isOnlineForwarded
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setIsOnlineForwarded($isOnlineForwarded = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOnlineForwarded) && !is_bool($isOnlineForwarded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOnlineForwarded, true), gettype($isOnlineForwarded)), __LINE__);
        }
        if (is_null($isOnlineForwarded) || (is_array($isOnlineForwarded) && empty($isOnlineForwarded))) {
            unset($this->IsOnlineForwarded);
        } else {
            $this->IsOnlineForwarded = $isOnlineForwarded;
        }
        return $this;
    }
    /**
     * Get IsOriginal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsOriginal()
    {
        return isset($this->IsOriginal) ? $this->IsOriginal : null;
    }
    /**
     * Set IsOriginal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isOriginal
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setIsOriginal($isOriginal = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOriginal) && !is_bool($isOriginal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOriginal, true), gettype($isOriginal)), __LINE__);
        }
        if (is_null($isOriginal) || (is_array($isOriginal) && empty($isOriginal))) {
            unset($this->IsOriginal);
        } else {
            $this->IsOriginal = $isOriginal;
        }
        return $this;
    }
    /**
     * Get IsPrinted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPrinted()
    {
        return isset($this->IsPrinted) ? $this->IsPrinted : null;
    }
    /**
     * Set IsPrinted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPrinted
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setIsPrinted($isPrinted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrinted) && !is_bool($isPrinted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrinted, true), gettype($isPrinted)), __LINE__);
        }
        if (is_null($isPrinted) || (is_array($isPrinted) && empty($isPrinted))) {
            unset($this->IsPrinted);
        } else {
            $this->IsPrinted = $isPrinted;
        }
        return $this;
    }
    /**
     * Get IsPrinting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPrinting()
    {
        return isset($this->IsPrinting) ? $this->IsPrinting : null;
    }
    /**
     * Set IsPrinting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPrinting
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setIsPrinting($isPrinting = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrinting) && !is_bool($isPrinting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrinting, true), gettype($isPrinting)), __LINE__);
        }
        if (is_null($isPrinting) || (is_array($isPrinting) && empty($isPrinting))) {
            unset($this->IsPrinting);
        } else {
            $this->IsPrinting = $isPrinting;
        }
        return $this;
    }
    /**
     * Get IsResale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsResale()
    {
        return isset($this->IsResale) ? $this->IsResale : null;
    }
    /**
     * Set IsResale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isResale
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setIsResale($isResale = null)
    {
        // validation for constraint: boolean
        if (!is_null($isResale) && !is_bool($isResale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isResale, true), gettype($isResale)), __LINE__);
        }
        if (is_null($isResale) || (is_array($isResale) && empty($isResale))) {
            unset($this->IsResale);
        } else {
            $this->IsResale = $isResale;
        }
        return $this;
    }
    /**
     * Get IsReserved value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsReserved()
    {
        return isset($this->IsReserved) ? $this->IsReserved : null;
    }
    /**
     * Set IsReserved value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isReserved
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setIsReserved($isReserved = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReserved) && !is_bool($isReserved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReserved, true), gettype($isReserved)), __LINE__);
        }
        if (is_null($isReserved) || (is_array($isReserved) && empty($isReserved))) {
            unset($this->IsReserved);
        } else {
            $this->IsReserved = $isReserved;
        }
        return $this;
    }
    /**
     * Get IsReturned value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsReturned()
    {
        return isset($this->IsReturned) ? $this->IsReturned : null;
    }
    /**
     * Set IsReturned value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isReturned
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setIsReturned($isReturned = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReturned) && !is_bool($isReturned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReturned, true), gettype($isReturned)), __LINE__);
        }
        if (is_null($isReturned) || (is_array($isReturned) && empty($isReturned))) {
            unset($this->IsReturned);
        } else {
            $this->IsReturned = $isReturned;
        }
        return $this;
    }
    /**
     * Get IsScanned value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsScanned()
    {
        return isset($this->IsScanned) ? $this->IsScanned : null;
    }
    /**
     * Set IsScanned value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isScanned
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setIsScanned($isScanned = null)
    {
        // validation for constraint: boolean
        if (!is_null($isScanned) && !is_bool($isScanned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isScanned, true), gettype($isScanned)), __LINE__);
        }
        if (is_null($isScanned) || (is_array($isScanned) && empty($isScanned))) {
            unset($this->IsScanned);
        } else {
            $this->IsScanned = $isScanned;
        }
        return $this;
    }
    /**
     * Get IsSubsTicket value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSubsTicket()
    {
        return isset($this->IsSubsTicket) ? $this->IsSubsTicket : null;
    }
    /**
     * Set IsSubsTicket value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSubsTicket
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setIsSubsTicket($isSubsTicket = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSubsTicket) && !is_bool($isSubsTicket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSubsTicket, true), gettype($isSubsTicket)), __LINE__);
        }
        if (is_null($isSubsTicket) || (is_array($isSubsTicket) && empty($isSubsTicket))) {
            unset($this->IsSubsTicket);
        } else {
            $this->IsSubsTicket = $isSubsTicket;
        }
        return $this;
    }
    /**
     * Get IssuerCompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIssuerCompanyId()
    {
        return isset($this->IssuerCompanyId) ? $this->IssuerCompanyId : null;
    }
    /**
     * Set IssuerCompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $issuerCompanyId
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setIssuerCompanyId($issuerCompanyId = null)
    {
        // validation for constraint: int
        if (!is_null($issuerCompanyId) && !(is_int($issuerCompanyId) || ctype_digit($issuerCompanyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($issuerCompanyId, true), gettype($issuerCompanyId)), __LINE__);
        }
        if (is_null($issuerCompanyId) || (is_array($issuerCompanyId) && empty($issuerCompanyId))) {
            unset($this->IssuerCompanyId);
        } else {
            $this->IssuerCompanyId = $issuerCompanyId;
        }
        return $this;
    }
    /**
     * Get IsTurnback value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsTurnback()
    {
        return isset($this->IsTurnback) ? $this->IsTurnback : null;
    }
    /**
     * Set IsTurnback value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isTurnback
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setIsTurnback($isTurnback = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTurnback) && !is_bool($isTurnback)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTurnback, true), gettype($isTurnback)), __LINE__);
        }
        if (is_null($isTurnback) || (is_array($isTurnback) && empty($isTurnback))) {
            unset($this->IsTurnback);
        } else {
            $this->IsTurnback = $isTurnback;
        }
        return $this;
    }
    /**
     * Get IsUpdated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUpdated()
    {
        return isset($this->IsUpdated) ? $this->IsUpdated : null;
    }
    /**
     * Set IsUpdated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUpdated
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setIsUpdated($isUpdated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdated) && !is_bool($isUpdated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpdated, true), gettype($isUpdated)), __LINE__);
        }
        if (is_null($isUpdated) || (is_array($isUpdated) && empty($isUpdated))) {
            unset($this->IsUpdated);
        } else {
            $this->IsUpdated = $isUpdated;
        }
        return $this;
    }
    /**
     * Get IsValid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsValid()
    {
        return isset($this->IsValid) ? $this->IsValid : null;
    }
    /**
     * Set IsValid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isValid
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setIsValid($isValid = null)
    {
        // validation for constraint: boolean
        if (!is_null($isValid) && !is_bool($isValid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isValid, true), gettype($isValid)), __LINE__);
        }
        if (is_null($isValid) || (is_array($isValid) && empty($isValid))) {
            unset($this->IsValid);
        } else {
            $this->IsValid = $isValid;
        }
        return $this;
    }
    /**
     * Get ItemAction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemAction()
    {
        return isset($this->ItemAction) ? $this->ItemAction : null;
    }
    /**
     * Set ItemAction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemAction
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setItemAction($itemAction = null)
    {
        // validation for constraint: int
        if (!is_null($itemAction) && !(is_int($itemAction) || ctype_digit($itemAction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemAction, true), gettype($itemAction)), __LINE__);
        }
        if (is_null($itemAction) || (is_array($itemAction) && empty($itemAction))) {
            unset($this->ItemAction);
        } else {
            $this->ItemAction = $itemAction;
        }
        return $this;
    }
    /**
     * Get ItemType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemType()
    {
        return isset($this->ItemType) ? $this->ItemType : null;
    }
    /**
     * Set ItemType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemType
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setItemType($itemType = null)
    {
        // validation for constraint: int
        if (!is_null($itemType) && !(is_int($itemType) || ctype_digit($itemType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemType, true), gettype($itemType)), __LINE__);
        }
        if (is_null($itemType) || (is_array($itemType) && empty($itemType))) {
            unset($this->ItemType);
        } else {
            $this->ItemType = $itemType;
        }
        return $this;
    }
    /**
     * Get LockGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLockGuid()
    {
        return isset($this->LockGuid) ? $this->LockGuid : null;
    }
    /**
     * Set LockGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lockGuid
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setLockGuid($lockGuid = null)
    {
        // validation for constraint: string
        if (!is_null($lockGuid) && !is_string($lockGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lockGuid, true), gettype($lockGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($lockGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $lockGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($lockGuid, true)), __LINE__);
        }
        if (is_null($lockGuid) || (is_array($lockGuid) && empty($lockGuid))) {
            unset($this->LockGuid);
        } else {
            $this->LockGuid = $lockGuid;
        }
        return $this;
    }
    /**
     * Get NameAndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNameAndDate()
    {
        return isset($this->NameAndDate) ? $this->NameAndDate : null;
    }
    /**
     * Set NameAndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nameAndDate
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setNameAndDate($nameAndDate = null)
    {
        // validation for constraint: string
        if (!is_null($nameAndDate) && !is_string($nameAndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameAndDate, true), gettype($nameAndDate)), __LINE__);
        }
        if (is_null($nameAndDate) || (is_array($nameAndDate) && empty($nameAndDate))) {
            unset($this->NameAndDate);
        } else {
            $this->NameAndDate = $nameAndDate;
        }
        return $this;
    }
    /**
     * Get NormalizedRowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNormalizedRowName()
    {
        return isset($this->NormalizedRowName) ? $this->NormalizedRowName : null;
    }
    /**
     * Set NormalizedRowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $normalizedRowName
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setNormalizedRowName($normalizedRowName = null)
    {
        // validation for constraint: string
        if (!is_null($normalizedRowName) && !is_string($normalizedRowName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($normalizedRowName, true), gettype($normalizedRowName)), __LINE__);
        }
        if (is_null($normalizedRowName) || (is_array($normalizedRowName) && empty($normalizedRowName))) {
            unset($this->NormalizedRowName);
        } else {
            $this->NormalizedRowName = $normalizedRowName;
        }
        return $this;
    }
    /**
     * Get NormalizedSeatName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNormalizedSeatName()
    {
        return isset($this->NormalizedSeatName) ? $this->NormalizedSeatName : null;
    }
    /**
     * Set NormalizedSeatName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $normalizedSeatName
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setNormalizedSeatName($normalizedSeatName = null)
    {
        // validation for constraint: string
        if (!is_null($normalizedSeatName) && !is_string($normalizedSeatName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($normalizedSeatName, true), gettype($normalizedSeatName)), __LINE__);
        }
        if (is_null($normalizedSeatName) || (is_array($normalizedSeatName) && empty($normalizedSeatName))) {
            unset($this->NormalizedSeatName);
        } else {
            $this->NormalizedSeatName = $normalizedSeatName;
        }
        return $this;
    }
    /**
     * Get NumberOfOwnershipChanges value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfOwnershipChanges()
    {
        return isset($this->NumberOfOwnershipChanges) ? $this->NumberOfOwnershipChanges : null;
    }
    /**
     * Set NumberOfOwnershipChanges value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfOwnershipChanges
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setNumberOfOwnershipChanges($numberOfOwnershipChanges = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfOwnershipChanges) && !(is_int($numberOfOwnershipChanges) || ctype_digit($numberOfOwnershipChanges))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfOwnershipChanges, true), gettype($numberOfOwnershipChanges)), __LINE__);
        }
        if (is_null($numberOfOwnershipChanges) || (is_array($numberOfOwnershipChanges) && empty($numberOfOwnershipChanges))) {
            unset($this->NumberOfOwnershipChanges);
        } else {
            $this->NumberOfOwnershipChanges = $numberOfOwnershipChanges;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get OriginalOwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalOwnerId()
    {
        return isset($this->OriginalOwnerId) ? $this->OriginalOwnerId : null;
    }
    /**
     * Set OriginalOwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalOwnerId
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setOriginalOwnerId($originalOwnerId = null)
    {
        // validation for constraint: string
        if (!is_null($originalOwnerId) && !is_string($originalOwnerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalOwnerId, true), gettype($originalOwnerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($originalOwnerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $originalOwnerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($originalOwnerId, true)), __LINE__);
        }
        if (is_null($originalOwnerId) || (is_array($originalOwnerId) && empty($originalOwnerId))) {
            unset($this->OriginalOwnerId);
        } else {
            $this->OriginalOwnerId = $originalOwnerId;
        }
        return $this;
    }
    /**
     * Get OriginalTicketId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalTicketId()
    {
        return isset($this->OriginalTicketId) ? $this->OriginalTicketId : null;
    }
    /**
     * Set OriginalTicketId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalTicketId
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setOriginalTicketId($originalTicketId = null)
    {
        // validation for constraint: string
        if (!is_null($originalTicketId) && !is_string($originalTicketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalTicketId, true), gettype($originalTicketId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($originalTicketId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $originalTicketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($originalTicketId, true)), __LINE__);
        }
        if (is_null($originalTicketId) || (is_array($originalTicketId) && empty($originalTicketId))) {
            unset($this->OriginalTicketId);
        } else {
            $this->OriginalTicketId = $originalTicketId;
        }
        return $this;
    }
    /**
     * Get OwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerId()
    {
        return isset($this->OwnerId) ? $this->OwnerId : null;
    }
    /**
     * Set OwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerId
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setOwnerId($ownerId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerId) && !is_string($ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerId, true), gettype($ownerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ownerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ownerId, true)), __LINE__);
        }
        if (is_null($ownerId) || (is_array($ownerId) && empty($ownerId))) {
            unset($this->OwnerId);
        } else {
            $this->OwnerId = $ownerId;
        }
        return $this;
    }
    /**
     * Get PackageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPackageId()
    {
        return isset($this->PackageId) ? $this->PackageId : null;
    }
    /**
     * Set PackageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $packageId
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setPackageId($packageId = null)
    {
        // validation for constraint: string
        if (!is_null($packageId) && !is_string($packageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageId, true), gettype($packageId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($packageId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $packageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($packageId, true)), __LINE__);
        }
        if (is_null($packageId) || (is_array($packageId) && empty($packageId))) {
            unset($this->PackageId);
        } else {
            $this->PackageId = $packageId;
        }
        return $this;
    }
    /**
     * Get PaidAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getPaidAmount()
    {
        return isset($this->PaidAmount) ? $this->PaidAmount : null;
    }
    /**
     * Set PaidAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $paidAmount
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setPaidAmount(\patest\StructType\Money $paidAmount = null)
    {
        if (is_null($paidAmount) || (is_array($paidAmount) && empty($paidAmount))) {
            unset($this->PaidAmount);
        } else {
            $this->PaidAmount = $paidAmount;
        }
        return $this;
    }
    /**
     * Get PaymentStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentStatus()
    {
        return isset($this->PaymentStatus) ? $this->PaymentStatus : null;
    }
    /**
     * Set PaymentStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentPaidStatusType::valueIsValid()
     * @uses \patest\EnumType\PaymentPaidStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentStatus
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setPaymentStatus($paymentStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentPaidStatusType::valueIsValid($paymentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentPaidStatusType', is_array($paymentStatus) ? implode(', ', $paymentStatus) : var_export($paymentStatus, true), implode(', ', \patest\EnumType\PaymentPaidStatusType::getValidValues())), __LINE__);
        }
        if (is_null($paymentStatus) || (is_array($paymentStatus) && empty($paymentStatus))) {
            unset($this->PaymentStatus);
        } else {
            $this->PaymentStatus = $paymentStatus;
        }
        return $this;
    }
    /**
     * Get PendingOwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPendingOwnerId()
    {
        return isset($this->PendingOwnerId) ? $this->PendingOwnerId : null;
    }
    /**
     * Set PendingOwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pendingOwnerId
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setPendingOwnerId($pendingOwnerId = null)
    {
        // validation for constraint: string
        if (!is_null($pendingOwnerId) && !is_string($pendingOwnerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pendingOwnerId, true), gettype($pendingOwnerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($pendingOwnerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $pendingOwnerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($pendingOwnerId, true)), __LINE__);
        }
        if (is_null($pendingOwnerId) || (is_array($pendingOwnerId) && empty($pendingOwnerId))) {
            unset($this->PendingOwnerId);
        } else {
            $this->PendingOwnerId = $pendingOwnerId;
        }
        return $this;
    }
    /**
     * Get Price value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getPrice()
    {
        return isset($this->Price) ? $this->Price : null;
    }
    /**
     * Set Price value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $price
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setPrice(\patest\StructType\Money $price = null)
    {
        if (is_null($price) || (is_array($price) && empty($price))) {
            unset($this->Price);
        } else {
            $this->Price = $price;
        }
        return $this;
    }
    /**
     * Get PriceLevelGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelGuid()
    {
        return isset($this->PriceLevelGuid) ? $this->PriceLevelGuid : null;
    }
    /**
     * Set PriceLevelGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelGuid
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setPriceLevelGuid($priceLevelGuid = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelGuid) && !is_string($priceLevelGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelGuid, true), gettype($priceLevelGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceLevelGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceLevelGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceLevelGuid, true)), __LINE__);
        }
        if (is_null($priceLevelGuid) || (is_array($priceLevelGuid) && empty($priceLevelGuid))) {
            unset($this->PriceLevelGuid);
        } else {
            $this->PriceLevelGuid = $priceLevelGuid;
        }
        return $this;
    }
    /**
     * Get PriceTypeChangePolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_TicketPriceTypeChangePolicy|null
     */
    public function getPriceTypeChangePolicy()
    {
        return isset($this->PriceTypeChangePolicy) ? $this->PriceTypeChangePolicy : null;
    }
    /**
     * Set PriceTypeChangePolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_TicketPriceTypeChangePolicy $priceTypeChangePolicy
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setPriceTypeChangePolicy(\patest\StructType\Ticketing_TicketPriceTypeChangePolicy $priceTypeChangePolicy = null)
    {
        if (is_null($priceTypeChangePolicy) || (is_array($priceTypeChangePolicy) && empty($priceTypeChangePolicy))) {
            unset($this->PriceTypeChangePolicy);
        } else {
            $this->PriceTypeChangePolicy = $priceTypeChangePolicy;
        }
        return $this;
    }
    /**
     * Get PriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeId()
    {
        return isset($this->PriceTypeId) ? $this->PriceTypeId : null;
    }
    /**
     * Set PriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeId
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setPriceTypeId($priceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeId) && !is_string($priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeId, true), gettype($priceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceTypeId, true)), __LINE__);
        }
        if (is_null($priceTypeId) || (is_array($priceTypeId) && empty($priceTypeId))) {
            unset($this->PriceTypeId);
        } else {
            $this->PriceTypeId = $priceTypeId;
        }
        return $this;
    }
    /**
     * Get PrintCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrintCount()
    {
        return isset($this->PrintCount) ? $this->PrintCount : null;
    }
    /**
     * Set PrintCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $printCount
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setPrintCount($printCount = null)
    {
        // validation for constraint: int
        if (!is_null($printCount) && !(is_int($printCount) || ctype_digit($printCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($printCount, true), gettype($printCount)), __LINE__);
        }
        if (is_null($printCount) || (is_array($printCount) && empty($printCount))) {
            unset($this->PrintCount);
        } else {
            $this->PrintCount = $printCount;
        }
        return $this;
    }
    /**
     * Get PrintedAs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrintedAs()
    {
        return isset($this->PrintedAs) ? $this->PrintedAs : null;
    }
    /**
     * Set PrintedAs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $printedAs
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setPrintedAs($printedAs = null)
    {
        // validation for constraint: string
        if (!is_null($printedAs) && !is_string($printedAs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printedAs, true), gettype($printedAs)), __LINE__);
        }
        if (is_null($printedAs) || (is_array($printedAs) && empty($printedAs))) {
            unset($this->PrintedAs);
        } else {
            $this->PrintedAs = $printedAs;
        }
        return $this;
    }
    /**
     * Get PrintMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrintMethod()
    {
        return isset($this->PrintMethod) ? $this->PrintMethod : null;
    }
    /**
     * Set PrintMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $printMethod
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setPrintMethod($printMethod = null)
    {
        // validation for constraint: string
        if (!is_null($printMethod) && !is_string($printMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printMethod, true), gettype($printMethod)), __LINE__);
        }
        if (is_null($printMethod) || (is_array($printMethod) && empty($printMethod))) {
            unset($this->PrintMethod);
        } else {
            $this->PrintMethod = $printMethod;
        }
        return $this;
    }
    /**
     * Get PrintMethodData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrintMethodData()
    {
        return isset($this->PrintMethodData) ? $this->PrintMethodData : null;
    }
    /**
     * Set PrintMethodData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $printMethodData
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setPrintMethodData($printMethodData = null)
    {
        // validation for constraint: string
        if (!is_null($printMethodData) && !is_string($printMethodData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printMethodData, true), gettype($printMethodData)), __LINE__);
        }
        if (is_null($printMethodData) || (is_array($printMethodData) && empty($printMethodData))) {
            unset($this->PrintMethodData);
        } else {
            $this->PrintMethodData = $printMethodData;
        }
        return $this;
    }
    /**
     * Get PurchaserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPurchaserId()
    {
        return isset($this->PurchaserId) ? $this->PurchaserId : null;
    }
    /**
     * Set PurchaserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $purchaserId
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setPurchaserId($purchaserId = null)
    {
        // validation for constraint: string
        if (!is_null($purchaserId) && !is_string($purchaserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaserId, true), gettype($purchaserId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($purchaserId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $purchaserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($purchaserId, true)), __LINE__);
        }
        if (is_null($purchaserId) || (is_array($purchaserId) && empty($purchaserId))) {
            unset($this->PurchaserId);
        } else {
            $this->PurchaserId = $purchaserId;
        }
        return $this;
    }
    /**
     * Get ResaleDestinationClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResaleDestinationClientId()
    {
        return isset($this->ResaleDestinationClientId) ? $this->ResaleDestinationClientId : null;
    }
    /**
     * Set ResaleDestinationClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resaleDestinationClientId
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setResaleDestinationClientId($resaleDestinationClientId = null)
    {
        // validation for constraint: string
        if (!is_null($resaleDestinationClientId) && !is_string($resaleDestinationClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resaleDestinationClientId, true), gettype($resaleDestinationClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($resaleDestinationClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $resaleDestinationClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($resaleDestinationClientId, true)), __LINE__);
        }
        if (is_null($resaleDestinationClientId) || (is_array($resaleDestinationClientId) && empty($resaleDestinationClientId))) {
            unset($this->ResaleDestinationClientId);
        } else {
            $this->ResaleDestinationClientId = $resaleDestinationClientId;
        }
        return $this;
    }
    /**
     * Get ResaleMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResaleMethod()
    {
        return isset($this->ResaleMethod) ? $this->ResaleMethod : null;
    }
    /**
     * Set ResaleMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketResaleMethod::valueIsValid()
     * @uses \patest\EnumType\TicketResaleMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resaleMethod
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setResaleMethod($resaleMethod = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketResaleMethod::valueIsValid($resaleMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketResaleMethod', is_array($resaleMethod) ? implode(', ', $resaleMethod) : var_export($resaleMethod, true), implode(', ', \patest\EnumType\TicketResaleMethod::getValidValues())), __LINE__);
        }
        if (is_null($resaleMethod) || (is_array($resaleMethod) && empty($resaleMethod))) {
            unset($this->ResaleMethod);
        } else {
            $this->ResaleMethod = $resaleMethod;
        }
        return $this;
    }
    /**
     * Get ResaleStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResaleStatus()
    {
        return isset($this->ResaleStatus) ? $this->ResaleStatus : null;
    }
    /**
     * Set ResaleStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ResaleStatus::valueIsValid()
     * @uses \patest\EnumType\ResaleStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resaleStatus
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setResaleStatus($resaleStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ResaleStatus::valueIsValid($resaleStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ResaleStatus', is_array($resaleStatus) ? implode(', ', $resaleStatus) : var_export($resaleStatus, true), implode(', ', \patest\EnumType\ResaleStatus::getValidValues())), __LINE__);
        }
        if (is_null($resaleStatus) || (is_array($resaleStatus) && empty($resaleStatus))) {
            unset($this->ResaleStatus);
        } else {
            $this->ResaleStatus = $resaleStatus;
        }
        return $this;
    }
    /**
     * Get RoleInSubscription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoleInSubscription()
    {
        return isset($this->RoleInSubscription) ? $this->RoleInSubscription : null;
    }
    /**
     * Set RoleInSubscription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\RoleInSubscription::valueIsValid()
     * @uses \patest\EnumType\RoleInSubscription::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $roleInSubscription
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setRoleInSubscription($roleInSubscription = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RoleInSubscription::valueIsValid($roleInSubscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RoleInSubscription', is_array($roleInSubscription) ? implode(', ', $roleInSubscription) : var_export($roleInSubscription, true), implode(', ', \patest\EnumType\RoleInSubscription::getValidValues())), __LINE__);
        }
        if (is_null($roleInSubscription) || (is_array($roleInSubscription) && empty($roleInSubscription))) {
            unset($this->RoleInSubscription);
        } else {
            $this->RoleInSubscription = $roleInSubscription;
        }
        return $this;
    }
    /**
     * Get RowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRowName()
    {
        return isset($this->RowName) ? $this->RowName : null;
    }
    /**
     * Set RowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rowName
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setRowName($rowName = null)
    {
        // validation for constraint: string
        if (!is_null($rowName) && !is_string($rowName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rowName, true), gettype($rowName)), __LINE__);
        }
        if (is_null($rowName) || (is_array($rowName) && empty($rowName))) {
            unset($this->RowName);
        } else {
            $this->RowName = $rowName;
        }
        return $this;
    }
    /**
     * Get SalesRepClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesRepClientId()
    {
        return isset($this->SalesRepClientId) ? $this->SalesRepClientId : null;
    }
    /**
     * Set SalesRepClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salesRepClientId
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setSalesRepClientId($salesRepClientId = null)
    {
        // validation for constraint: string
        if (!is_null($salesRepClientId) && !is_string($salesRepClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesRepClientId, true), gettype($salesRepClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salesRepClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salesRepClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salesRepClientId, true)), __LINE__);
        }
        if (is_null($salesRepClientId) || (is_array($salesRepClientId) && empty($salesRepClientId))) {
            unset($this->SalesRepClientId);
        } else {
            $this->SalesRepClientId = $salesRepClientId;
        }
        return $this;
    }
    /**
     * Get SaleStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSaleStatus()
    {
        return isset($this->SaleStatus) ? $this->SaleStatus : null;
    }
    /**
     * Set SaleStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SaleStatusExtended::valueIsValid()
     * @uses \patest\EnumType\SaleStatusExtended::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $saleStatus
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setSaleStatus($saleStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SaleStatusExtended::valueIsValid($saleStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SaleStatusExtended', is_array($saleStatus) ? implode(', ', $saleStatus) : var_export($saleStatus, true), implode(', ', \patest\EnumType\SaleStatusExtended::getValidValues())), __LINE__);
        }
        if (is_null($saleStatus) || (is_array($saleStatus) && empty($saleStatus))) {
            unset($this->SaleStatus);
        } else {
            $this->SaleStatus = $saleStatus;
        }
        return $this;
    }
    /**
     * Get SeasonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeasonId()
    {
        return isset($this->SeasonId) ? $this->SeasonId : null;
    }
    /**
     * Set SeasonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seasonId
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setSeasonId($seasonId = null)
    {
        // validation for constraint: string
        if (!is_null($seasonId) && !is_string($seasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seasonId, true), gettype($seasonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seasonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seasonId, true)), __LINE__);
        }
        if (is_null($seasonId) || (is_array($seasonId) && empty($seasonId))) {
            unset($this->SeasonId);
        } else {
            $this->SeasonId = $seasonId;
        }
        return $this;
    }
    /**
     * Get SeatIdInAreaMap value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSeatIdInAreaMap()
    {
        return isset($this->SeatIdInAreaMap) ? $this->SeatIdInAreaMap : null;
    }
    /**
     * Set SeatIdInAreaMap value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $seatIdInAreaMap
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setSeatIdInAreaMap($seatIdInAreaMap = null)
    {
        // validation for constraint: int
        if (!is_null($seatIdInAreaMap) && !(is_int($seatIdInAreaMap) || ctype_digit($seatIdInAreaMap))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatIdInAreaMap, true), gettype($seatIdInAreaMap)), __LINE__);
        }
        if (is_null($seatIdInAreaMap) || (is_array($seatIdInAreaMap) && empty($seatIdInAreaMap))) {
            unset($this->SeatIdInAreaMap);
        } else {
            $this->SeatIdInAreaMap = $seatIdInAreaMap;
        }
        return $this;
    }
    /**
     * Get SeatInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_SeatInfo|null
     */
    public function getSeatInfo()
    {
        return isset($this->SeatInfo) ? $this->SeatInfo : null;
    }
    /**
     * Set SeatInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_SeatInfo $seatInfo
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setSeatInfo(\patest\StructType\Ticketing_SeatInfo $seatInfo = null)
    {
        if (is_null($seatInfo) || (is_array($seatInfo) && empty($seatInfo))) {
            unset($this->SeatInfo);
        } else {
            $this->SeatInfo = $seatInfo;
        }
        return $this;
    }
    /**
     * Get SeatName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatName()
    {
        return isset($this->SeatName) ? $this->SeatName : null;
    }
    /**
     * Set SeatName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatName
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setSeatName($seatName = null)
    {
        // validation for constraint: string
        if (!is_null($seatName) && !is_string($seatName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatName, true), gettype($seatName)), __LINE__);
        }
        if (is_null($seatName) || (is_array($seatName) && empty($seatName))) {
            unset($this->SeatName);
        } else {
            $this->SeatName = $seatName;
        }
        return $this;
    }
    /**
     * Get SectorName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSectorName()
    {
        return isset($this->SectorName) ? $this->SectorName : null;
    }
    /**
     * Set SectorName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $sectorName
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setSectorName(\patest\StructType\GlobalString $sectorName = null)
    {
        if (is_null($sectorName) || (is_array($sectorName) && empty($sectorName))) {
            unset($this->SectorName);
        } else {
            $this->SectorName = $sectorName;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
    /**
     * Get SGOrderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSGOrderId()
    {
        return isset($this->SGOrderId) ? $this->SGOrderId : null;
    }
    /**
     * Set SGOrderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sGOrderId
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setSGOrderId($sGOrderId = null)
    {
        // validation for constraint: string
        if (!is_null($sGOrderId) && !is_string($sGOrderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sGOrderId, true), gettype($sGOrderId)), __LINE__);
        }
        if (is_null($sGOrderId) || (is_array($sGOrderId) && empty($sGOrderId))) {
            unset($this->SGOrderId);
        } else {
            $this->SGOrderId = $sGOrderId;
        }
        return $this;
    }
    /**
     * Get ShowGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowGuid()
    {
        return isset($this->ShowGuid) ? $this->ShowGuid : null;
    }
    /**
     * Set ShowGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showGuid
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setShowGuid($showGuid = null)
    {
        // validation for constraint: string
        if (!is_null($showGuid) && !is_string($showGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showGuid, true), gettype($showGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showGuid, true)), __LINE__);
        }
        if (is_null($showGuid) || (is_array($showGuid) && empty($showGuid))) {
            unset($this->ShowGuid);
        } else {
            $this->ShowGuid = $showGuid;
        }
        return $this;
    }
    /**
     * Get ShowMinutes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getShowMinutes()
    {
        return isset($this->ShowMinutes) ? $this->ShowMinutes : null;
    }
    /**
     * Set ShowMinutes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $showMinutes
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setShowMinutes($showMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($showMinutes) && !(is_int($showMinutes) || ctype_digit($showMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($showMinutes, true), gettype($showMinutes)), __LINE__);
        }
        if (is_null($showMinutes) || (is_array($showMinutes) && empty($showMinutes))) {
            unset($this->ShowMinutes);
        } else {
            $this->ShowMinutes = $showMinutes;
        }
        return $this;
    }
    /**
     * Get StandId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStandId()
    {
        return isset($this->StandId) ? $this->StandId : null;
    }
    /**
     * Set StandId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $standId
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setStandId($standId = null)
    {
        // validation for constraint: string
        if (!is_null($standId) && !is_string($standId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($standId, true), gettype($standId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($standId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $standId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($standId, true)), __LINE__);
        }
        if (is_null($standId) || (is_array($standId) && empty($standId))) {
            unset($this->StandId);
        } else {
            $this->StandId = $standId;
        }
        return $this;
    }
    /**
     * Get StandName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getStandName()
    {
        return isset($this->StandName) ? $this->StandName : null;
    }
    /**
     * Set StandName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $standName
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setStandName(\patest\StructType\GlobalString $standName = null)
    {
        if (is_null($standName) || (is_array($standName) && empty($standName))) {
            unset($this->StandName);
        } else {
            $this->StandName = $standName;
        }
        return $this;
    }
    /**
     * Get StatusIcons value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatusIcons()
    {
        return isset($this->StatusIcons) ? $this->StatusIcons : null;
    }
    /**
     * Set StatusIcons value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $statusIcons
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setStatusIcons($statusIcons = null)
    {
        // validation for constraint: string
        if (!is_null($statusIcons) && !is_string($statusIcons)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusIcons, true), gettype($statusIcons)), __LINE__);
        }
        if (is_null($statusIcons) || (is_array($statusIcons) && empty($statusIcons))) {
            unset($this->StatusIcons);
        } else {
            $this->StatusIcons = $statusIcons;
        }
        return $this;
    }
    /**
     * Get SubscriberTicketType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriberTicketType()
    {
        return isset($this->SubscriberTicketType) ? $this->SubscriberTicketType : null;
    }
    /**
     * Set SubscriberTicketType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SubscriberTicketType::valueIsValid()
     * @uses \patest\EnumType\SubscriberTicketType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subscriberTicketType
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setSubscriberTicketType($subscriberTicketType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SubscriberTicketType::valueIsValid($subscriberTicketType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SubscriberTicketType', is_array($subscriberTicketType) ? implode(', ', $subscriberTicketType) : var_export($subscriberTicketType, true), implode(', ', \patest\EnumType\SubscriberTicketType::getValidValues())), __LINE__);
        }
        if (is_null($subscriberTicketType) || (is_array($subscriberTicketType) && empty($subscriberTicketType))) {
            unset($this->SubscriberTicketType);
        } else {
            $this->SubscriberTicketType = $subscriberTicketType;
        }
        return $this;
    }
    /**
     * Get SubscriptionInstance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionInstance()
    {
        return isset($this->SubscriptionInstance) ? $this->SubscriptionInstance : null;
    }
    /**
     * Set SubscriptionInstance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionInstance
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setSubscriptionInstance($subscriptionInstance = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionInstance) && !is_string($subscriptionInstance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionInstance, true), gettype($subscriptionInstance)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subscriptionInstance) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subscriptionInstance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subscriptionInstance, true)), __LINE__);
        }
        if (is_null($subscriptionInstance) || (is_array($subscriptionInstance) && empty($subscriptionInstance))) {
            unset($this->SubscriptionInstance);
        } else {
            $this->SubscriptionInstance = $subscriptionInstance;
        }
        return $this;
    }
    /**
     * Get SubscriptionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionNumber()
    {
        return isset($this->SubscriptionNumber) ? $this->SubscriptionNumber : null;
    }
    /**
     * Set SubscriptionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionNumber
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setSubscriptionNumber($subscriptionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionNumber) && !is_string($subscriptionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionNumber, true), gettype($subscriptionNumber)), __LINE__);
        }
        if (is_null($subscriptionNumber) || (is_array($subscriptionNumber) && empty($subscriptionNumber))) {
            unset($this->SubscriptionNumber);
        } else {
            $this->SubscriptionNumber = $subscriptionNumber;
        }
        return $this;
    }
    /**
     * Get TicketBarcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketBarcode()
    {
        return isset($this->TicketBarcode) ? $this->TicketBarcode : null;
    }
    /**
     * Set TicketBarcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketBarcode
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setTicketBarcode($ticketBarcode = null)
    {
        // validation for constraint: string
        if (!is_null($ticketBarcode) && !is_string($ticketBarcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketBarcode, true), gettype($ticketBarcode)), __LINE__);
        }
        if (is_null($ticketBarcode) || (is_array($ticketBarcode) && empty($ticketBarcode))) {
            unset($this->TicketBarcode);
        } else {
            $this->TicketBarcode = $ticketBarcode;
        }
        return $this;
    }
    /**
     * Get TicketHolder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_TicketDistributionJournal|null
     */
    public function getTicketHolder()
    {
        return isset($this->TicketHolder) ? $this->TicketHolder : null;
    }
    /**
     * Set TicketHolder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_TicketDistributionJournal $ticketHolder
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setTicketHolder(\patest\StructType\Ticketing_TicketDistributionJournal $ticketHolder = null)
    {
        if (is_null($ticketHolder) || (is_array($ticketHolder) && empty($ticketHolder))) {
            unset($this->TicketHolder);
        } else {
            $this->TicketHolder = $ticketHolder;
        }
        return $this;
    }
    /**
     * Get TicketNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTicketNumber()
    {
        return isset($this->TicketNumber) ? $this->TicketNumber : null;
    }
    /**
     * Set TicketNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ticketNumber
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setTicketNumber($ticketNumber = null)
    {
        // validation for constraint: int
        if (!is_null($ticketNumber) && !(is_int($ticketNumber) || ctype_digit($ticketNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ticketNumber, true), gettype($ticketNumber)), __LINE__);
        }
        if (is_null($ticketNumber) || (is_array($ticketNumber) && empty($ticketNumber))) {
            unset($this->TicketNumber);
        } else {
            $this->TicketNumber = $ticketNumber;
        }
        return $this;
    }
    /**
     * Get TicketSaleItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketSaleItemId()
    {
        return isset($this->TicketSaleItemId) ? $this->TicketSaleItemId : null;
    }
    /**
     * Set TicketSaleItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketSaleItemId
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setTicketSaleItemId($ticketSaleItemId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketSaleItemId) && !is_string($ticketSaleItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketSaleItemId, true), gettype($ticketSaleItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketSaleItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketSaleItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketSaleItemId, true)), __LINE__);
        }
        if (is_null($ticketSaleItemId) || (is_array($ticketSaleItemId) && empty($ticketSaleItemId))) {
            unset($this->TicketSaleItemId);
        } else {
            $this->TicketSaleItemId = $ticketSaleItemId;
        }
        return $this;
    }
    /**
     * Get TicketTurnbackFundName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketTurnbackFundName()
    {
        return isset($this->TicketTurnbackFundName) ? $this->TicketTurnbackFundName : null;
    }
    /**
     * Set TicketTurnbackFundName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketTurnbackFundName
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setTicketTurnbackFundName($ticketTurnbackFundName = null)
    {
        // validation for constraint: string
        if (!is_null($ticketTurnbackFundName) && !is_string($ticketTurnbackFundName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketTurnbackFundName, true), gettype($ticketTurnbackFundName)), __LINE__);
        }
        if (is_null($ticketTurnbackFundName) || (is_array($ticketTurnbackFundName) && empty($ticketTurnbackFundName))) {
            unset($this->TicketTurnbackFundName);
        } else {
            $this->TicketTurnbackFundName = $ticketTurnbackFundName;
        }
        return $this;
    }
    /**
     * Get TotalPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalPrice()
    {
        return isset($this->TotalPrice) ? $this->TotalPrice : null;
    }
    /**
     * Set TotalPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalPrice
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setTotalPrice(\patest\StructType\Money $totalPrice = null)
    {
        if (is_null($totalPrice) || (is_array($totalPrice) && empty($totalPrice))) {
            unset($this->TotalPrice);
        } else {
            $this->TotalPrice = $totalPrice;
        }
        return $this;
    }
    /**
     * Get TransactionDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionDate()
    {
        return isset($this->TransactionDate) ? $this->TransactionDate : null;
    }
    /**
     * Set TransactionDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionDate
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setTransactionDate($transactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDate) && !is_string($transactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionDate, true), gettype($transactionDate)), __LINE__);
        }
        if (is_null($transactionDate) || (is_array($transactionDate) && empty($transactionDate))) {
            unset($this->TransactionDate);
        } else {
            $this->TransactionDate = $transactionDate;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
    /**
     * Get TransactionNotes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionNotes()
    {
        return isset($this->TransactionNotes) ? $this->TransactionNotes : null;
    }
    /**
     * Set TransactionNotes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionNotes
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setTransactionNotes($transactionNotes = null)
    {
        // validation for constraint: string
        if (!is_null($transactionNotes) && !is_string($transactionNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionNotes, true), gettype($transactionNotes)), __LINE__);
        }
        if (is_null($transactionNotes) || (is_array($transactionNotes) && empty($transactionNotes))) {
            unset($this->TransactionNotes);
        } else {
            $this->TransactionNotes = $transactionNotes;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
    /**
     * Get TransactionReferenceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionReferenceNumber()
    {
        return isset($this->TransactionReferenceNumber) ? $this->TransactionReferenceNumber : null;
    }
    /**
     * Set TransactionReferenceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionReferenceNumber
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setTransactionReferenceNumber($transactionReferenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionReferenceNumber) && !(is_int($transactionReferenceNumber) || ctype_digit($transactionReferenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionReferenceNumber, true), gettype($transactionReferenceNumber)), __LINE__);
        }
        if (is_null($transactionReferenceNumber) || (is_array($transactionReferenceNumber) && empty($transactionReferenceNumber))) {
            unset($this->TransactionReferenceNumber);
        } else {
            $this->TransactionReferenceNumber = $transactionReferenceNumber;
        }
        return $this;
    }
    /**
     * Get UnpaidAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getUnpaidAmount()
    {
        return isset($this->UnpaidAmount) ? $this->UnpaidAmount : null;
    }
    /**
     * Set UnpaidAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $unpaidAmount
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setUnpaidAmount(\patest\StructType\Money $unpaidAmount = null)
    {
        if (is_null($unpaidAmount) || (is_array($unpaidAmount) && empty($unpaidAmount))) {
            unset($this->UnpaidAmount);
        } else {
            $this->UnpaidAmount = $unpaidAmount;
        }
        return $this;
    }
    /**
     * Get UnpaidInstallmentsAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getUnpaidInstallmentsAmount()
    {
        return isset($this->UnpaidInstallmentsAmount) ? $this->UnpaidInstallmentsAmount : null;
    }
    /**
     * Set UnpaidInstallmentsAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $unpaidInstallmentsAmount
     * @return \patest\StructType\Ticketing_ClientTicketsEnhanced
     */
    public function setUnpaidInstallmentsAmount(\patest\StructType\Money $unpaidInstallmentsAmount = null)
    {
        if (is_null($unpaidInstallmentsAmount) || (is_array($unpaidInstallmentsAmount) && empty($unpaidInstallmentsAmount))) {
            unset($this->UnpaidInstallmentsAmount);
        } else {
            $this->UnpaidInstallmentsAmount = $unpaidInstallmentsAmount;
        }
        return $this;
    }
}
