<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.ClientAvailableBallot StructType
 * @subpackage Structs
 */
class Ticketing_ClientAvailableBallot extends Ticketing_Ballot
{
    /**
     * The ExistingApplicationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ExistingApplicationId;
    /**
     * Constructor method for Ticketing.ClientAvailableBallot
     * @uses Ticketing_ClientAvailableBallot::setExistingApplicationId()
     * @param string $existingApplicationId
     */
    public function __construct($existingApplicationId = null)
    {
        $this
            ->setExistingApplicationId($existingApplicationId);
    }
    /**
     * Get ExistingApplicationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExistingApplicationId()
    {
        return isset($this->ExistingApplicationId) ? $this->ExistingApplicationId : null;
    }
    /**
     * Set ExistingApplicationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $existingApplicationId
     * @return \patest\StructType\Ticketing_ClientAvailableBallot
     */
    public function setExistingApplicationId($existingApplicationId = null)
    {
        // validation for constraint: string
        if (!is_null($existingApplicationId) && !is_string($existingApplicationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($existingApplicationId, true), gettype($existingApplicationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($existingApplicationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $existingApplicationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($existingApplicationId, true)), __LINE__);
        }
        if (is_null($existingApplicationId) || (is_array($existingApplicationId) && empty($existingApplicationId))) {
            unset($this->ExistingApplicationId);
        } else {
            $this->ExistingApplicationId = $existingApplicationId;
        }
        return $this;
    }
}
