<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.BallotSectionVirtualPriceType StructType
 * @subpackage Structs
 */
class Ticketing_BallotSectionVirtualPriceType extends PersistableEntity
{
    /**
     * The IsRequired
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsRequired;
    /**
     * The MaxSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxSeats;
    /**
     * The MinSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MinSeats;
    /**
     * The PriceLevelMapping
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_BallotSectionPriceLevelPriceTypeMapping
     */
    public $PriceLevelMapping;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Priority;
    /**
     * The SectionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SectionId;
    /**
     * The VirtualPriceType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VirtualPriceType;
    /**
     * Constructor method for Ticketing.BallotSectionVirtualPriceType
     * @uses Ticketing_BallotSectionVirtualPriceType::setIsRequired()
     * @uses Ticketing_BallotSectionVirtualPriceType::setMaxSeats()
     * @uses Ticketing_BallotSectionVirtualPriceType::setMinSeats()
     * @uses Ticketing_BallotSectionVirtualPriceType::setPriceLevelMapping()
     * @uses Ticketing_BallotSectionVirtualPriceType::setPriority()
     * @uses Ticketing_BallotSectionVirtualPriceType::setSectionId()
     * @uses Ticketing_BallotSectionVirtualPriceType::setVirtualPriceType()
     * @param bool $isRequired
     * @param int $maxSeats
     * @param int $minSeats
     * @param \patest\StructType\RecordSetOfTicketing_BallotSectionPriceLevelPriceTypeMapping $priceLevelMapping
     * @param int $priority
     * @param string $sectionId
     * @param string $virtualPriceType
     */
    public function __construct($isRequired = null, $maxSeats = null, $minSeats = null, \patest\StructType\RecordSetOfTicketing_BallotSectionPriceLevelPriceTypeMapping $priceLevelMapping = null, $priority = null, $sectionId = null, $virtualPriceType = null)
    {
        $this
            ->setIsRequired($isRequired)
            ->setMaxSeats($maxSeats)
            ->setMinSeats($minSeats)
            ->setPriceLevelMapping($priceLevelMapping)
            ->setPriority($priority)
            ->setSectionId($sectionId)
            ->setVirtualPriceType($virtualPriceType);
    }
    /**
     * Get IsRequired value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsRequired()
    {
        return isset($this->IsRequired) ? $this->IsRequired : null;
    }
    /**
     * Set IsRequired value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isRequired
     * @return \patest\StructType\Ticketing_BallotSectionVirtualPriceType
     */
    public function setIsRequired($isRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRequired) && !is_bool($isRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRequired, true), gettype($isRequired)), __LINE__);
        }
        if (is_null($isRequired) || (is_array($isRequired) && empty($isRequired))) {
            unset($this->IsRequired);
        } else {
            $this->IsRequired = $isRequired;
        }
        return $this;
    }
    /**
     * Get MaxSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxSeats()
    {
        return isset($this->MaxSeats) ? $this->MaxSeats : null;
    }
    /**
     * Set MaxSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxSeats
     * @return \patest\StructType\Ticketing_BallotSectionVirtualPriceType
     */
    public function setMaxSeats($maxSeats = null)
    {
        // validation for constraint: int
        if (!is_null($maxSeats) && !(is_int($maxSeats) || ctype_digit($maxSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxSeats, true), gettype($maxSeats)), __LINE__);
        }
        if (is_null($maxSeats) || (is_array($maxSeats) && empty($maxSeats))) {
            unset($this->MaxSeats);
        } else {
            $this->MaxSeats = $maxSeats;
        }
        return $this;
    }
    /**
     * Get MinSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinSeats()
    {
        return isset($this->MinSeats) ? $this->MinSeats : null;
    }
    /**
     * Set MinSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minSeats
     * @return \patest\StructType\Ticketing_BallotSectionVirtualPriceType
     */
    public function setMinSeats($minSeats = null)
    {
        // validation for constraint: int
        if (!is_null($minSeats) && !(is_int($minSeats) || ctype_digit($minSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minSeats, true), gettype($minSeats)), __LINE__);
        }
        if (is_null($minSeats) || (is_array($minSeats) && empty($minSeats))) {
            unset($this->MinSeats);
        } else {
            $this->MinSeats = $minSeats;
        }
        return $this;
    }
    /**
     * Get PriceLevelMapping value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_BallotSectionPriceLevelPriceTypeMapping|null
     */
    public function getPriceLevelMapping()
    {
        return isset($this->PriceLevelMapping) ? $this->PriceLevelMapping : null;
    }
    /**
     * Set PriceLevelMapping value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_BallotSectionPriceLevelPriceTypeMapping $priceLevelMapping
     * @return \patest\StructType\Ticketing_BallotSectionVirtualPriceType
     */
    public function setPriceLevelMapping(\patest\StructType\RecordSetOfTicketing_BallotSectionPriceLevelPriceTypeMapping $priceLevelMapping = null)
    {
        if (is_null($priceLevelMapping) || (is_array($priceLevelMapping) && empty($priceLevelMapping))) {
            unset($this->PriceLevelMapping);
        } else {
            $this->PriceLevelMapping = $priceLevelMapping;
        }
        return $this;
    }
    /**
     * Get Priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPriority()
    {
        return isset($this->Priority) ? $this->Priority : null;
    }
    /**
     * Set Priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $priority
     * @return \patest\StructType\Ticketing_BallotSectionVirtualPriceType
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        if (is_null($priority) || (is_array($priority) && empty($priority))) {
            unset($this->Priority);
        } else {
            $this->Priority = $priority;
        }
        return $this;
    }
    /**
     * Get SectionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSectionId()
    {
        return isset($this->SectionId) ? $this->SectionId : null;
    }
    /**
     * Set SectionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sectionId
     * @return \patest\StructType\Ticketing_BallotSectionVirtualPriceType
     */
    public function setSectionId($sectionId = null)
    {
        // validation for constraint: string
        if (!is_null($sectionId) && !is_string($sectionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectionId, true), gettype($sectionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sectionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sectionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sectionId, true)), __LINE__);
        }
        if (is_null($sectionId) || (is_array($sectionId) && empty($sectionId))) {
            unset($this->SectionId);
        } else {
            $this->SectionId = $sectionId;
        }
        return $this;
    }
    /**
     * Get VirtualPriceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVirtualPriceType()
    {
        return isset($this->VirtualPriceType) ? $this->VirtualPriceType : null;
    }
    /**
     * Set VirtualPriceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $virtualPriceType
     * @return \patest\StructType\Ticketing_BallotSectionVirtualPriceType
     */
    public function setVirtualPriceType($virtualPriceType = null)
    {
        // validation for constraint: string
        if (!is_null($virtualPriceType) && !is_string($virtualPriceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($virtualPriceType, true), gettype($virtualPriceType)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($virtualPriceType) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $virtualPriceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($virtualPriceType, true)), __LINE__);
        }
        if (is_null($virtualPriceType) || (is_array($virtualPriceType) && empty($virtualPriceType))) {
            unset($this->VirtualPriceType);
        } else {
            $this->VirtualPriceType = $virtualPriceType;
        }
        return $this;
    }
}
