<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.BallotSectionPriceLevelPriceTypeMapping
 * StructType
 * @subpackage Structs
 */
class Ticketing_BallotSectionPriceLevelPriceTypeMapping extends PersistableEntity
{
    /**
     * The Blocked
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Blocked;
    /**
     * The MappedPriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MappedPriceTypeId;
    /**
     * The PriceLevelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceLevelId;
    /**
     * The SectionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SectionId;
    /**
     * The SectionPricetypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SectionPricetypeId;
    /**
     * The VirtualPriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VirtualPriceTypeId;
    /**
     * Constructor method for Ticketing.BallotSectionPriceLevelPriceTypeMapping
     * @uses Ticketing_BallotSectionPriceLevelPriceTypeMapping::setBlocked()
     * @uses Ticketing_BallotSectionPriceLevelPriceTypeMapping::setMappedPriceTypeId()
     * @uses Ticketing_BallotSectionPriceLevelPriceTypeMapping::setPriceLevelId()
     * @uses Ticketing_BallotSectionPriceLevelPriceTypeMapping::setSectionId()
     * @uses Ticketing_BallotSectionPriceLevelPriceTypeMapping::setSectionPricetypeId()
     * @uses Ticketing_BallotSectionPriceLevelPriceTypeMapping::setVirtualPriceTypeId()
     * @param bool $blocked
     * @param string $mappedPriceTypeId
     * @param string $priceLevelId
     * @param string $sectionId
     * @param string $sectionPricetypeId
     * @param string $virtualPriceTypeId
     */
    public function __construct($blocked = null, $mappedPriceTypeId = null, $priceLevelId = null, $sectionId = null, $sectionPricetypeId = null, $virtualPriceTypeId = null)
    {
        $this
            ->setBlocked($blocked)
            ->setMappedPriceTypeId($mappedPriceTypeId)
            ->setPriceLevelId($priceLevelId)
            ->setSectionId($sectionId)
            ->setSectionPricetypeId($sectionPricetypeId)
            ->setVirtualPriceTypeId($virtualPriceTypeId);
    }
    /**
     * Get Blocked value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getBlocked()
    {
        return isset($this->Blocked) ? $this->Blocked : null;
    }
    /**
     * Set Blocked value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $blocked
     * @return \patest\StructType\Ticketing_BallotSectionPriceLevelPriceTypeMapping
     */
    public function setBlocked($blocked = null)
    {
        // validation for constraint: boolean
        if (!is_null($blocked) && !is_bool($blocked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($blocked, true), gettype($blocked)), __LINE__);
        }
        if (is_null($blocked) || (is_array($blocked) && empty($blocked))) {
            unset($this->Blocked);
        } else {
            $this->Blocked = $blocked;
        }
        return $this;
    }
    /**
     * Get MappedPriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMappedPriceTypeId()
    {
        return isset($this->MappedPriceTypeId) ? $this->MappedPriceTypeId : null;
    }
    /**
     * Set MappedPriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mappedPriceTypeId
     * @return \patest\StructType\Ticketing_BallotSectionPriceLevelPriceTypeMapping
     */
    public function setMappedPriceTypeId($mappedPriceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($mappedPriceTypeId) && !is_string($mappedPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mappedPriceTypeId, true), gettype($mappedPriceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($mappedPriceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $mappedPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($mappedPriceTypeId, true)), __LINE__);
        }
        if (is_null($mappedPriceTypeId) || (is_array($mappedPriceTypeId) && empty($mappedPriceTypeId))) {
            unset($this->MappedPriceTypeId);
        } else {
            $this->MappedPriceTypeId = $mappedPriceTypeId;
        }
        return $this;
    }
    /**
     * Get PriceLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelId()
    {
        return isset($this->PriceLevelId) ? $this->PriceLevelId : null;
    }
    /**
     * Set PriceLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelId
     * @return \patest\StructType\Ticketing_BallotSectionPriceLevelPriceTypeMapping
     */
    public function setPriceLevelId($priceLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelId) && !is_string($priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelId, true), gettype($priceLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceLevelId, true)), __LINE__);
        }
        if (is_null($priceLevelId) || (is_array($priceLevelId) && empty($priceLevelId))) {
            unset($this->PriceLevelId);
        } else {
            $this->PriceLevelId = $priceLevelId;
        }
        return $this;
    }
    /**
     * Get SectionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSectionId()
    {
        return isset($this->SectionId) ? $this->SectionId : null;
    }
    /**
     * Set SectionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sectionId
     * @return \patest\StructType\Ticketing_BallotSectionPriceLevelPriceTypeMapping
     */
    public function setSectionId($sectionId = null)
    {
        // validation for constraint: string
        if (!is_null($sectionId) && !is_string($sectionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectionId, true), gettype($sectionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sectionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sectionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sectionId, true)), __LINE__);
        }
        if (is_null($sectionId) || (is_array($sectionId) && empty($sectionId))) {
            unset($this->SectionId);
        } else {
            $this->SectionId = $sectionId;
        }
        return $this;
    }
    /**
     * Get SectionPricetypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSectionPricetypeId()
    {
        return isset($this->SectionPricetypeId) ? $this->SectionPricetypeId : null;
    }
    /**
     * Set SectionPricetypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sectionPricetypeId
     * @return \patest\StructType\Ticketing_BallotSectionPriceLevelPriceTypeMapping
     */
    public function setSectionPricetypeId($sectionPricetypeId = null)
    {
        // validation for constraint: string
        if (!is_null($sectionPricetypeId) && !is_string($sectionPricetypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectionPricetypeId, true), gettype($sectionPricetypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sectionPricetypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sectionPricetypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sectionPricetypeId, true)), __LINE__);
        }
        if (is_null($sectionPricetypeId) || (is_array($sectionPricetypeId) && empty($sectionPricetypeId))) {
            unset($this->SectionPricetypeId);
        } else {
            $this->SectionPricetypeId = $sectionPricetypeId;
        }
        return $this;
    }
    /**
     * Get VirtualPriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVirtualPriceTypeId()
    {
        return isset($this->VirtualPriceTypeId) ? $this->VirtualPriceTypeId : null;
    }
    /**
     * Set VirtualPriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $virtualPriceTypeId
     * @return \patest\StructType\Ticketing_BallotSectionPriceLevelPriceTypeMapping
     */
    public function setVirtualPriceTypeId($virtualPriceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($virtualPriceTypeId) && !is_string($virtualPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($virtualPriceTypeId, true), gettype($virtualPriceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($virtualPriceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $virtualPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($virtualPriceTypeId, true)), __LINE__);
        }
        if (is_null($virtualPriceTypeId) || (is_array($virtualPriceTypeId) && empty($virtualPriceTypeId))) {
            unset($this->VirtualPriceTypeId);
        } else {
            $this->VirtualPriceTypeId = $virtualPriceTypeId;
        }
        return $this;
    }
}
