<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.BallotConfirmationBatch StructType
 * @subpackage Structs
 */
class Ticketing_BallotConfirmationBatch extends PersistableEntity
{
    /**
     * The BallotConfirmations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_BallotConfirmation
     */
    public $BallotConfirmations;
    /**
     * The BallotId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BallotId;
    /**
     * The ExecutionAuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ExecutionAuditId;
    /**
     * The ExecutionDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExecutionDate;
    /**
     * The Failed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Failed;
    /**
     * The Succeeded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Succeeded;
    /**
     * Constructor method for Ticketing.BallotConfirmationBatch
     * @uses Ticketing_BallotConfirmationBatch::setBallotConfirmations()
     * @uses Ticketing_BallotConfirmationBatch::setBallotId()
     * @uses Ticketing_BallotConfirmationBatch::setExecutionAuditId()
     * @uses Ticketing_BallotConfirmationBatch::setExecutionDate()
     * @uses Ticketing_BallotConfirmationBatch::setFailed()
     * @uses Ticketing_BallotConfirmationBatch::setSucceeded()
     * @param \patest\StructType\RecordSetOfTicketing_BallotConfirmation $ballotConfirmations
     * @param string $ballotId
     * @param int $executionAuditId
     * @param string $executionDate
     * @param int $failed
     * @param int $succeeded
     */
    public function __construct(\patest\StructType\RecordSetOfTicketing_BallotConfirmation $ballotConfirmations = null, $ballotId = null, $executionAuditId = null, $executionDate = null, $failed = null, $succeeded = null)
    {
        $this
            ->setBallotConfirmations($ballotConfirmations)
            ->setBallotId($ballotId)
            ->setExecutionAuditId($executionAuditId)
            ->setExecutionDate($executionDate)
            ->setFailed($failed)
            ->setSucceeded($succeeded);
    }
    /**
     * Get BallotConfirmations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_BallotConfirmation|null
     */
    public function getBallotConfirmations()
    {
        return isset($this->BallotConfirmations) ? $this->BallotConfirmations : null;
    }
    /**
     * Set BallotConfirmations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_BallotConfirmation $ballotConfirmations
     * @return \patest\StructType\Ticketing_BallotConfirmationBatch
     */
    public function setBallotConfirmations(\patest\StructType\RecordSetOfTicketing_BallotConfirmation $ballotConfirmations = null)
    {
        if (is_null($ballotConfirmations) || (is_array($ballotConfirmations) && empty($ballotConfirmations))) {
            unset($this->BallotConfirmations);
        } else {
            $this->BallotConfirmations = $ballotConfirmations;
        }
        return $this;
    }
    /**
     * Get BallotId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBallotId()
    {
        return isset($this->BallotId) ? $this->BallotId : null;
    }
    /**
     * Set BallotId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ballotId
     * @return \patest\StructType\Ticketing_BallotConfirmationBatch
     */
    public function setBallotId($ballotId = null)
    {
        // validation for constraint: string
        if (!is_null($ballotId) && !is_string($ballotId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ballotId, true), gettype($ballotId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ballotId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ballotId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ballotId, true)), __LINE__);
        }
        if (is_null($ballotId) || (is_array($ballotId) && empty($ballotId))) {
            unset($this->BallotId);
        } else {
            $this->BallotId = $ballotId;
        }
        return $this;
    }
    /**
     * Get ExecutionAuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getExecutionAuditId()
    {
        return isset($this->ExecutionAuditId) ? $this->ExecutionAuditId : null;
    }
    /**
     * Set ExecutionAuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $executionAuditId
     * @return \patest\StructType\Ticketing_BallotConfirmationBatch
     */
    public function setExecutionAuditId($executionAuditId = null)
    {
        // validation for constraint: int
        if (!is_null($executionAuditId) && !(is_int($executionAuditId) || ctype_digit($executionAuditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($executionAuditId, true), gettype($executionAuditId)), __LINE__);
        }
        if (is_null($executionAuditId) || (is_array($executionAuditId) && empty($executionAuditId))) {
            unset($this->ExecutionAuditId);
        } else {
            $this->ExecutionAuditId = $executionAuditId;
        }
        return $this;
    }
    /**
     * Get ExecutionDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExecutionDate()
    {
        return isset($this->ExecutionDate) ? $this->ExecutionDate : null;
    }
    /**
     * Set ExecutionDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $executionDate
     * @return \patest\StructType\Ticketing_BallotConfirmationBatch
     */
    public function setExecutionDate($executionDate = null)
    {
        // validation for constraint: string
        if (!is_null($executionDate) && !is_string($executionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($executionDate, true), gettype($executionDate)), __LINE__);
        }
        if (is_null($executionDate) || (is_array($executionDate) && empty($executionDate))) {
            unset($this->ExecutionDate);
        } else {
            $this->ExecutionDate = $executionDate;
        }
        return $this;
    }
    /**
     * Get Failed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFailed()
    {
        return isset($this->Failed) ? $this->Failed : null;
    }
    /**
     * Set Failed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $failed
     * @return \patest\StructType\Ticketing_BallotConfirmationBatch
     */
    public function setFailed($failed = null)
    {
        // validation for constraint: int
        if (!is_null($failed) && !(is_int($failed) || ctype_digit($failed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($failed, true), gettype($failed)), __LINE__);
        }
        if (is_null($failed) || (is_array($failed) && empty($failed))) {
            unset($this->Failed);
        } else {
            $this->Failed = $failed;
        }
        return $this;
    }
    /**
     * Get Succeeded value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSucceeded()
    {
        return isset($this->Succeeded) ? $this->Succeeded : null;
    }
    /**
     * Set Succeeded value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $succeeded
     * @return \patest\StructType\Ticketing_BallotConfirmationBatch
     */
    public function setSucceeded($succeeded = null)
    {
        // validation for constraint: int
        if (!is_null($succeeded) && !(is_int($succeeded) || ctype_digit($succeeded))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($succeeded, true), gettype($succeeded)), __LINE__);
        }
        if (is_null($succeeded) || (is_array($succeeded) && empty($succeeded))) {
            unset($this->Succeeded);
        } else {
            $this->Succeeded = $succeeded;
        }
        return $this;
    }
}
