<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.BallotClientApplication StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Ticketing.BallotClientApplication
 * @subpackage Structs
 */
class Ticketing_BallotClientApplication extends PersistableEntity
{
    /**
     * The BallotId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BallotId;
    /**
     * The BallotNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BallotNumber;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The CreationAuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CreationAuditId;
    /**
     * The CreationDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDateTime;
    /**
     * The CrmId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CrmId;
    /**
     * The Events
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_BallotApplicationEvent
     */
    public $Events;
    /**
     * The IgnoreQtyValidation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IgnoreQtyValidation;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsPaymentConfirmed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPaymentConfirmed;
    /**
     * The LastModifiedAuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LastModifiedAuditId;
    /**
     * The LastModifiedDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDateTime;
    /**
     * The Lines
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_BallotApplicationLine
     */
    public $Lines;
    /**
     * The PaymentMethodDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethodDetails;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * Constructor method for Ticketing.BallotClientApplication
     * @uses Ticketing_BallotClientApplication::setBallotId()
     * @uses Ticketing_BallotClientApplication::setBallotNumber()
     * @uses Ticketing_BallotClientApplication::setClientId()
     * @uses Ticketing_BallotClientApplication::setCreationAuditId()
     * @uses Ticketing_BallotClientApplication::setCreationDateTime()
     * @uses Ticketing_BallotClientApplication::setCrmId()
     * @uses Ticketing_BallotClientApplication::setEvents()
     * @uses Ticketing_BallotClientApplication::setIgnoreQtyValidation()
     * @uses Ticketing_BallotClientApplication::setIsActive()
     * @uses Ticketing_BallotClientApplication::setIsPaymentConfirmed()
     * @uses Ticketing_BallotClientApplication::setLastModifiedAuditId()
     * @uses Ticketing_BallotClientApplication::setLastModifiedDateTime()
     * @uses Ticketing_BallotClientApplication::setLines()
     * @uses Ticketing_BallotClientApplication::setPaymentMethodDetails()
     * @uses Ticketing_BallotClientApplication::setPaymentMethodId()
     * @uses Ticketing_BallotClientApplication::setStatus()
     * @param string $ballotId
     * @param int $ballotNumber
     * @param string $clientId
     * @param int $creationAuditId
     * @param string $creationDateTime
     * @param string $crmId
     * @param \patest\StructType\RecordSetOfTicketing_BallotApplicationEvent $events
     * @param bool $ignoreQtyValidation
     * @param bool $isActive
     * @param bool $isPaymentConfirmed
     * @param int $lastModifiedAuditId
     * @param string $lastModifiedDateTime
     * @param \patest\StructType\RecordSetOfTicketing_BallotApplicationLine $lines
     * @param string $paymentMethodDetails
     * @param string $paymentMethodId
     * @param string $status
     */
    public function __construct($ballotId = null, $ballotNumber = null, $clientId = null, $creationAuditId = null, $creationDateTime = null, $crmId = null, \patest\StructType\RecordSetOfTicketing_BallotApplicationEvent $events = null, $ignoreQtyValidation = null, $isActive = null, $isPaymentConfirmed = null, $lastModifiedAuditId = null, $lastModifiedDateTime = null, \patest\StructType\RecordSetOfTicketing_BallotApplicationLine $lines = null, $paymentMethodDetails = null, $paymentMethodId = null, $status = null)
    {
        $this
            ->setBallotId($ballotId)
            ->setBallotNumber($ballotNumber)
            ->setClientId($clientId)
            ->setCreationAuditId($creationAuditId)
            ->setCreationDateTime($creationDateTime)
            ->setCrmId($crmId)
            ->setEvents($events)
            ->setIgnoreQtyValidation($ignoreQtyValidation)
            ->setIsActive($isActive)
            ->setIsPaymentConfirmed($isPaymentConfirmed)
            ->setLastModifiedAuditId($lastModifiedAuditId)
            ->setLastModifiedDateTime($lastModifiedDateTime)
            ->setLines($lines)
            ->setPaymentMethodDetails($paymentMethodDetails)
            ->setPaymentMethodId($paymentMethodId)
            ->setStatus($status);
    }
    /**
     * Get BallotId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBallotId()
    {
        return isset($this->BallotId) ? $this->BallotId : null;
    }
    /**
     * Set BallotId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ballotId
     * @return \patest\StructType\Ticketing_BallotClientApplication
     */
    public function setBallotId($ballotId = null)
    {
        // validation for constraint: string
        if (!is_null($ballotId) && !is_string($ballotId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ballotId, true), gettype($ballotId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ballotId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ballotId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ballotId, true)), __LINE__);
        }
        if (is_null($ballotId) || (is_array($ballotId) && empty($ballotId))) {
            unset($this->BallotId);
        } else {
            $this->BallotId = $ballotId;
        }
        return $this;
    }
    /**
     * Get BallotNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBallotNumber()
    {
        return isset($this->BallotNumber) ? $this->BallotNumber : null;
    }
    /**
     * Set BallotNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ballotNumber
     * @return \patest\StructType\Ticketing_BallotClientApplication
     */
    public function setBallotNumber($ballotNumber = null)
    {
        // validation for constraint: int
        if (!is_null($ballotNumber) && !(is_int($ballotNumber) || ctype_digit($ballotNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ballotNumber, true), gettype($ballotNumber)), __LINE__);
        }
        if (is_null($ballotNumber) || (is_array($ballotNumber) && empty($ballotNumber))) {
            unset($this->BallotNumber);
        } else {
            $this->BallotNumber = $ballotNumber;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Ticketing_BallotClientApplication
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get CreationAuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCreationAuditId()
    {
        return isset($this->CreationAuditId) ? $this->CreationAuditId : null;
    }
    /**
     * Set CreationAuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $creationAuditId
     * @return \patest\StructType\Ticketing_BallotClientApplication
     */
    public function setCreationAuditId($creationAuditId = null)
    {
        // validation for constraint: int
        if (!is_null($creationAuditId) && !(is_int($creationAuditId) || ctype_digit($creationAuditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($creationAuditId, true), gettype($creationAuditId)), __LINE__);
        }
        if (is_null($creationAuditId) || (is_array($creationAuditId) && empty($creationAuditId))) {
            unset($this->CreationAuditId);
        } else {
            $this->CreationAuditId = $creationAuditId;
        }
        return $this;
    }
    /**
     * Get CreationDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDateTime()
    {
        return isset($this->CreationDateTime) ? $this->CreationDateTime : null;
    }
    /**
     * Set CreationDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDateTime
     * @return \patest\StructType\Ticketing_BallotClientApplication
     */
    public function setCreationDateTime($creationDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($creationDateTime) && !is_string($creationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDateTime, true), gettype($creationDateTime)), __LINE__);
        }
        if (is_null($creationDateTime) || (is_array($creationDateTime) && empty($creationDateTime))) {
            unset($this->CreationDateTime);
        } else {
            $this->CreationDateTime = $creationDateTime;
        }
        return $this;
    }
    /**
     * Get CrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrmId()
    {
        return isset($this->CrmId) ? $this->CrmId : null;
    }
    /**
     * Set CrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crmId
     * @return \patest\StructType\Ticketing_BallotClientApplication
     */
    public function setCrmId($crmId = null)
    {
        // validation for constraint: string
        if (!is_null($crmId) && !is_string($crmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crmId, true), gettype($crmId)), __LINE__);
        }
        if (is_null($crmId) || (is_array($crmId) && empty($crmId))) {
            unset($this->CrmId);
        } else {
            $this->CrmId = $crmId;
        }
        return $this;
    }
    /**
     * Get Events value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_BallotApplicationEvent|null
     */
    public function getEvents()
    {
        return isset($this->Events) ? $this->Events : null;
    }
    /**
     * Set Events value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_BallotApplicationEvent $events
     * @return \patest\StructType\Ticketing_BallotClientApplication
     */
    public function setEvents(\patest\StructType\RecordSetOfTicketing_BallotApplicationEvent $events = null)
    {
        if (is_null($events) || (is_array($events) && empty($events))) {
            unset($this->Events);
        } else {
            $this->Events = $events;
        }
        return $this;
    }
    /**
     * Get IgnoreQtyValidation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIgnoreQtyValidation()
    {
        return isset($this->IgnoreQtyValidation) ? $this->IgnoreQtyValidation : null;
    }
    /**
     * Set IgnoreQtyValidation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $ignoreQtyValidation
     * @return \patest\StructType\Ticketing_BallotClientApplication
     */
    public function setIgnoreQtyValidation($ignoreQtyValidation = null)
    {
        // validation for constraint: boolean
        if (!is_null($ignoreQtyValidation) && !is_bool($ignoreQtyValidation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ignoreQtyValidation, true), gettype($ignoreQtyValidation)), __LINE__);
        }
        if (is_null($ignoreQtyValidation) || (is_array($ignoreQtyValidation) && empty($ignoreQtyValidation))) {
            unset($this->IgnoreQtyValidation);
        } else {
            $this->IgnoreQtyValidation = $ignoreQtyValidation;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Ticketing_BallotClientApplication
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsPaymentConfirmed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPaymentConfirmed()
    {
        return isset($this->IsPaymentConfirmed) ? $this->IsPaymentConfirmed : null;
    }
    /**
     * Set IsPaymentConfirmed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPaymentConfirmed
     * @return \patest\StructType\Ticketing_BallotClientApplication
     */
    public function setIsPaymentConfirmed($isPaymentConfirmed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPaymentConfirmed) && !is_bool($isPaymentConfirmed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPaymentConfirmed, true), gettype($isPaymentConfirmed)), __LINE__);
        }
        if (is_null($isPaymentConfirmed) || (is_array($isPaymentConfirmed) && empty($isPaymentConfirmed))) {
            unset($this->IsPaymentConfirmed);
        } else {
            $this->IsPaymentConfirmed = $isPaymentConfirmed;
        }
        return $this;
    }
    /**
     * Get LastModifiedAuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLastModifiedAuditId()
    {
        return isset($this->LastModifiedAuditId) ? $this->LastModifiedAuditId : null;
    }
    /**
     * Set LastModifiedAuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $lastModifiedAuditId
     * @return \patest\StructType\Ticketing_BallotClientApplication
     */
    public function setLastModifiedAuditId($lastModifiedAuditId = null)
    {
        // validation for constraint: int
        if (!is_null($lastModifiedAuditId) && !(is_int($lastModifiedAuditId) || ctype_digit($lastModifiedAuditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lastModifiedAuditId, true), gettype($lastModifiedAuditId)), __LINE__);
        }
        if (is_null($lastModifiedAuditId) || (is_array($lastModifiedAuditId) && empty($lastModifiedAuditId))) {
            unset($this->LastModifiedAuditId);
        } else {
            $this->LastModifiedAuditId = $lastModifiedAuditId;
        }
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDateTime()
    {
        return isset($this->LastModifiedDateTime) ? $this->LastModifiedDateTime : null;
    }
    /**
     * Set LastModifiedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDateTime
     * @return \patest\StructType\Ticketing_BallotClientApplication
     */
    public function setLastModifiedDateTime($lastModifiedDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDateTime) && !is_string($lastModifiedDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDateTime, true), gettype($lastModifiedDateTime)), __LINE__);
        }
        if (is_null($lastModifiedDateTime) || (is_array($lastModifiedDateTime) && empty($lastModifiedDateTime))) {
            unset($this->LastModifiedDateTime);
        } else {
            $this->LastModifiedDateTime = $lastModifiedDateTime;
        }
        return $this;
    }
    /**
     * Get Lines value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_BallotApplicationLine|null
     */
    public function getLines()
    {
        return isset($this->Lines) ? $this->Lines : null;
    }
    /**
     * Set Lines value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_BallotApplicationLine $lines
     * @return \patest\StructType\Ticketing_BallotClientApplication
     */
    public function setLines(\patest\StructType\RecordSetOfTicketing_BallotApplicationLine $lines = null)
    {
        if (is_null($lines) || (is_array($lines) && empty($lines))) {
            unset($this->Lines);
        } else {
            $this->Lines = $lines;
        }
        return $this;
    }
    /**
     * Get PaymentMethodDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodDetails()
    {
        return isset($this->PaymentMethodDetails) ? $this->PaymentMethodDetails : null;
    }
    /**
     * Set PaymentMethodDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodDetails
     * @return \patest\StructType\Ticketing_BallotClientApplication
     */
    public function setPaymentMethodDetails($paymentMethodDetails = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodDetails) && !is_string($paymentMethodDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodDetails, true), gettype($paymentMethodDetails)), __LINE__);
        }
        if (is_null($paymentMethodDetails) || (is_array($paymentMethodDetails) && empty($paymentMethodDetails))) {
            unset($this->PaymentMethodDetails);
        } else {
            $this->PaymentMethodDetails = $paymentMethodDetails;
        }
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return isset($this->PaymentMethodId) ? $this->PaymentMethodId : null;
    }
    /**
     * Set PaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodId
     * @return \patest\StructType\Ticketing_BallotClientApplication
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        if (is_null($paymentMethodId) || (is_array($paymentMethodId) && empty($paymentMethodId))) {
            unset($this->PaymentMethodId);
        } else {
            $this->PaymentMethodId = $paymentMethodId;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BallotApplicationStatus::valueIsValid()
     * @uses \patest\EnumType\BallotApplicationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\Ticketing_BallotClientApplication
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BallotApplicationStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BallotApplicationStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\BallotApplicationStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
}
