<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.AreaLayer StructType
 * @subpackage Structs
 */
class Ticketing_AreaLayer extends PersistableEntity
{
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The BinaryValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BinaryValue;
    /**
     * The EntityVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityVersion;
    /**
     * The GuidValue
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GuidValue;
    /**
     * The IntValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IntValue;
    /**
     * The LastUpdateDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastUpdateDateTime;
    /**
     * The LayerEntityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LayerEntityId;
    /**
     * The LayerLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LayerLevel;
    /**
     * The LayerType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LayerType;
    /**
     * The UpdateStartedAt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UpdateStartedAt;
    /**
     * The UpdateToken
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UpdateToken;
    /**
     * The XmlValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $XmlValue;
    /**
     * Constructor method for Ticketing.AreaLayer
     * @uses Ticketing_AreaLayer::setAreaId()
     * @uses Ticketing_AreaLayer::setBinaryValue()
     * @uses Ticketing_AreaLayer::setEntityVersion()
     * @uses Ticketing_AreaLayer::setGuidValue()
     * @uses Ticketing_AreaLayer::setIntValue()
     * @uses Ticketing_AreaLayer::setLastUpdateDateTime()
     * @uses Ticketing_AreaLayer::setLayerEntityId()
     * @uses Ticketing_AreaLayer::setLayerLevel()
     * @uses Ticketing_AreaLayer::setLayerType()
     * @uses Ticketing_AreaLayer::setUpdateStartedAt()
     * @uses Ticketing_AreaLayer::setUpdateToken()
     * @uses Ticketing_AreaLayer::setXmlValue()
     * @param string $areaId
     * @param string $binaryValue
     * @param string $entityVersion
     * @param string $guidValue
     * @param int $intValue
     * @param string $lastUpdateDateTime
     * @param string $layerEntityId
     * @param string $layerLevel
     * @param string $layerType
     * @param string $updateStartedAt
     * @param string $updateToken
     * @param string $xmlValue
     */
    public function __construct($areaId = null, $binaryValue = null, $entityVersion = null, $guidValue = null, $intValue = null, $lastUpdateDateTime = null, $layerEntityId = null, $layerLevel = null, $layerType = null, $updateStartedAt = null, $updateToken = null, $xmlValue = null)
    {
        $this
            ->setAreaId($areaId)
            ->setBinaryValue($binaryValue)
            ->setEntityVersion($entityVersion)
            ->setGuidValue($guidValue)
            ->setIntValue($intValue)
            ->setLastUpdateDateTime($lastUpdateDateTime)
            ->setLayerEntityId($layerEntityId)
            ->setLayerLevel($layerLevel)
            ->setLayerType($layerType)
            ->setUpdateStartedAt($updateStartedAt)
            ->setUpdateToken($updateToken)
            ->setXmlValue($xmlValue);
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\Ticketing_AreaLayer
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get BinaryValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBinaryValue()
    {
        return isset($this->BinaryValue) ? $this->BinaryValue : null;
    }
    /**
     * Set BinaryValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $binaryValue
     * @return \patest\StructType\Ticketing_AreaLayer
     */
    public function setBinaryValue($binaryValue = null)
    {
        // validation for constraint: string
        if (!is_null($binaryValue) && !is_string($binaryValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($binaryValue, true), gettype($binaryValue)), __LINE__);
        }
        if (is_null($binaryValue) || (is_array($binaryValue) && empty($binaryValue))) {
            unset($this->BinaryValue);
        } else {
            $this->BinaryValue = $binaryValue;
        }
        return $this;
    }
    /**
     * Get EntityVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityVersion()
    {
        return isset($this->EntityVersion) ? $this->EntityVersion : null;
    }
    /**
     * Set EntityVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityVersion
     * @return \patest\StructType\Ticketing_AreaLayer
     */
    public function setEntityVersion($entityVersion = null)
    {
        // validation for constraint: string
        if (!is_null($entityVersion) && !is_string($entityVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityVersion, true), gettype($entityVersion)), __LINE__);
        }
        if (is_null($entityVersion) || (is_array($entityVersion) && empty($entityVersion))) {
            unset($this->EntityVersion);
        } else {
            $this->EntityVersion = $entityVersion;
        }
        return $this;
    }
    /**
     * Get GuidValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGuidValue()
    {
        return isset($this->GuidValue) ? $this->GuidValue : null;
    }
    /**
     * Set GuidValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $guidValue
     * @return \patest\StructType\Ticketing_AreaLayer
     */
    public function setGuidValue($guidValue = null)
    {
        // validation for constraint: string
        if (!is_null($guidValue) && !is_string($guidValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guidValue, true), gettype($guidValue)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($guidValue) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $guidValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($guidValue, true)), __LINE__);
        }
        if (is_null($guidValue) || (is_array($guidValue) && empty($guidValue))) {
            unset($this->GuidValue);
        } else {
            $this->GuidValue = $guidValue;
        }
        return $this;
    }
    /**
     * Get IntValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIntValue()
    {
        return isset($this->IntValue) ? $this->IntValue : null;
    }
    /**
     * Set IntValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $intValue
     * @return \patest\StructType\Ticketing_AreaLayer
     */
    public function setIntValue($intValue = null)
    {
        // validation for constraint: int
        if (!is_null($intValue) && !(is_int($intValue) || ctype_digit($intValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($intValue, true), gettype($intValue)), __LINE__);
        }
        if (is_null($intValue) || (is_array($intValue) && empty($intValue))) {
            unset($this->IntValue);
        } else {
            $this->IntValue = $intValue;
        }
        return $this;
    }
    /**
     * Get LastUpdateDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastUpdateDateTime()
    {
        return isset($this->LastUpdateDateTime) ? $this->LastUpdateDateTime : null;
    }
    /**
     * Set LastUpdateDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastUpdateDateTime
     * @return \patest\StructType\Ticketing_AreaLayer
     */
    public function setLastUpdateDateTime($lastUpdateDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateDateTime) && !is_string($lastUpdateDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUpdateDateTime, true), gettype($lastUpdateDateTime)), __LINE__);
        }
        if (is_null($lastUpdateDateTime) || (is_array($lastUpdateDateTime) && empty($lastUpdateDateTime))) {
            unset($this->LastUpdateDateTime);
        } else {
            $this->LastUpdateDateTime = $lastUpdateDateTime;
        }
        return $this;
    }
    /**
     * Get LayerEntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLayerEntityId()
    {
        return isset($this->LayerEntityId) ? $this->LayerEntityId : null;
    }
    /**
     * Set LayerEntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $layerEntityId
     * @return \patest\StructType\Ticketing_AreaLayer
     */
    public function setLayerEntityId($layerEntityId = null)
    {
        // validation for constraint: string
        if (!is_null($layerEntityId) && !is_string($layerEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($layerEntityId, true), gettype($layerEntityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($layerEntityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $layerEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($layerEntityId, true)), __LINE__);
        }
        if (is_null($layerEntityId) || (is_array($layerEntityId) && empty($layerEntityId))) {
            unset($this->LayerEntityId);
        } else {
            $this->LayerEntityId = $layerEntityId;
        }
        return $this;
    }
    /**
     * Get LayerLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLayerLevel()
    {
        return isset($this->LayerLevel) ? $this->LayerLevel : null;
    }
    /**
     * Set LayerLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\LayerLevel::valueIsValid()
     * @uses \patest\EnumType\LayerLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $layerLevel
     * @return \patest\StructType\Ticketing_AreaLayer
     */
    public function setLayerLevel($layerLevel = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\LayerLevel::valueIsValid($layerLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\LayerLevel', is_array($layerLevel) ? implode(', ', $layerLevel) : var_export($layerLevel, true), implode(', ', \patest\EnumType\LayerLevel::getValidValues())), __LINE__);
        }
        if (is_null($layerLevel) || (is_array($layerLevel) && empty($layerLevel))) {
            unset($this->LayerLevel);
        } else {
            $this->LayerLevel = $layerLevel;
        }
        return $this;
    }
    /**
     * Get LayerType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLayerType()
    {
        return isset($this->LayerType) ? $this->LayerType : null;
    }
    /**
     * Set LayerType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\LayerTypes::valueIsValid()
     * @uses \patest\EnumType\LayerTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $layerType
     * @return \patest\StructType\Ticketing_AreaLayer
     */
    public function setLayerType($layerType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\LayerTypes::valueIsValid($layerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\LayerTypes', is_array($layerType) ? implode(', ', $layerType) : var_export($layerType, true), implode(', ', \patest\EnumType\LayerTypes::getValidValues())), __LINE__);
        }
        if (is_null($layerType) || (is_array($layerType) && empty($layerType))) {
            unset($this->LayerType);
        } else {
            $this->LayerType = $layerType;
        }
        return $this;
    }
    /**
     * Get UpdateStartedAt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUpdateStartedAt()
    {
        return isset($this->UpdateStartedAt) ? $this->UpdateStartedAt : null;
    }
    /**
     * Set UpdateStartedAt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $updateStartedAt
     * @return \patest\StructType\Ticketing_AreaLayer
     */
    public function setUpdateStartedAt($updateStartedAt = null)
    {
        // validation for constraint: string
        if (!is_null($updateStartedAt) && !is_string($updateStartedAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updateStartedAt, true), gettype($updateStartedAt)), __LINE__);
        }
        if (is_null($updateStartedAt) || (is_array($updateStartedAt) && empty($updateStartedAt))) {
            unset($this->UpdateStartedAt);
        } else {
            $this->UpdateStartedAt = $updateStartedAt;
        }
        return $this;
    }
    /**
     * Get UpdateToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUpdateToken()
    {
        return isset($this->UpdateToken) ? $this->UpdateToken : null;
    }
    /**
     * Set UpdateToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $updateToken
     * @return \patest\StructType\Ticketing_AreaLayer
     */
    public function setUpdateToken($updateToken = null)
    {
        // validation for constraint: string
        if (!is_null($updateToken) && !is_string($updateToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updateToken, true), gettype($updateToken)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($updateToken) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $updateToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($updateToken, true)), __LINE__);
        }
        if (is_null($updateToken) || (is_array($updateToken) && empty($updateToken))) {
            unset($this->UpdateToken);
        } else {
            $this->UpdateToken = $updateToken;
        }
        return $this;
    }
    /**
     * Get XmlValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getXmlValue()
    {
        return isset($this->XmlValue) ? $this->XmlValue : null;
    }
    /**
     * Set XmlValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $xmlValue
     * @return \patest\StructType\Ticketing_AreaLayer
     */
    public function setXmlValue($xmlValue = null)
    {
        // validation for constraint: string
        if (!is_null($xmlValue) && !is_string($xmlValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($xmlValue, true), gettype($xmlValue)), __LINE__);
        }
        if (is_null($xmlValue) || (is_array($xmlValue) && empty($xmlValue))) {
            unset($this->XmlValue);
        } else {
            $this->XmlValue = $xmlValue;
        }
        return $this;
    }
}
