<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.Area StructType
 * @subpackage Structs
 */
class Ticketing_Area extends Ticketing_Base
{
    /**
     * The AccessControlData
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AccessControl_EntityAccessControlData
     */
    public $AccessControlData;
    /**
     * The ClientTypeTurnstileIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ClientTypeTurnstileIds
     */
    public $ClientTypeTurnstileIds;
    /**
     * The DefaultGACapacity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DefaultGACapacity;
    /**
     * The DefaultOrdinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DefaultOrdinal;
    /**
     * The DefaultSeatingType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DefaultSeatingType;
    /**
     * The GAMaxCapacity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $GAMaxCapacity;
    /**
     * The GateIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GateIds
     */
    public $GateIds;
    /**
     * The MinQtyToSellTogether
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MinQtyToSellTogether;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The NameForReports
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $NameForReports;
    /**
     * The ParentHallId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ParentHallId;
    /**
     * The StandId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $StandId;
    /**
     * The StandName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $StandName;
    /**
     * The TaxonomyClass
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TaxonomyClass;
    /**
     * The TaxonomyFieldView
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TaxonomyFieldView;
    /**
     * The TaxonomyVenueLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TaxonomyVenueLevel;
    /**
     * The TaxonomyVenueSide
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TaxonomyVenueSide;
    /**
     * The TurnstileIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\TurnstileIds
     */
    public $TurnstileIds;
    /**
     * Constructor method for Ticketing.Area
     * @uses Ticketing_Area::setAccessControlData()
     * @uses Ticketing_Area::setClientTypeTurnstileIds()
     * @uses Ticketing_Area::setDefaultGACapacity()
     * @uses Ticketing_Area::setDefaultOrdinal()
     * @uses Ticketing_Area::setDefaultSeatingType()
     * @uses Ticketing_Area::setGAMaxCapacity()
     * @uses Ticketing_Area::setGateIds()
     * @uses Ticketing_Area::setMinQtyToSellTogether()
     * @uses Ticketing_Area::setName()
     * @uses Ticketing_Area::setNameForReports()
     * @uses Ticketing_Area::setParentHallId()
     * @uses Ticketing_Area::setStandId()
     * @uses Ticketing_Area::setStandName()
     * @uses Ticketing_Area::setTaxonomyClass()
     * @uses Ticketing_Area::setTaxonomyFieldView()
     * @uses Ticketing_Area::setTaxonomyVenueLevel()
     * @uses Ticketing_Area::setTaxonomyVenueSide()
     * @uses Ticketing_Area::setTurnstileIds()
     * @param \patest\StructType\AccessControl_EntityAccessControlData $accessControlData
     * @param \patest\StructType\ClientTypeTurnstileIds $clientTypeTurnstileIds
     * @param int $defaultGACapacity
     * @param int $defaultOrdinal
     * @param string $defaultSeatingType
     * @param int $gAMaxCapacity
     * @param \patest\StructType\GateIds $gateIds
     * @param int $minQtyToSellTogether
     * @param \patest\StructType\GlobalString $name
     * @param \patest\StructType\GlobalString $nameForReports
     * @param string $parentHallId
     * @param string $standId
     * @param \patest\StructType\GlobalString $standName
     * @param string $taxonomyClass
     * @param string $taxonomyFieldView
     * @param string $taxonomyVenueLevel
     * @param string $taxonomyVenueSide
     * @param \patest\StructType\TurnstileIds $turnstileIds
     */
    public function __construct(\patest\StructType\AccessControl_EntityAccessControlData $accessControlData = null, \patest\StructType\ClientTypeTurnstileIds $clientTypeTurnstileIds = null, $defaultGACapacity = null, $defaultOrdinal = null, $defaultSeatingType = null, $gAMaxCapacity = null, \patest\StructType\GateIds $gateIds = null, $minQtyToSellTogether = null, \patest\StructType\GlobalString $name = null, \patest\StructType\GlobalString $nameForReports = null, $parentHallId = null, $standId = null, \patest\StructType\GlobalString $standName = null, $taxonomyClass = null, $taxonomyFieldView = null, $taxonomyVenueLevel = null, $taxonomyVenueSide = null, \patest\StructType\TurnstileIds $turnstileIds = null)
    {
        $this
            ->setAccessControlData($accessControlData)
            ->setClientTypeTurnstileIds($clientTypeTurnstileIds)
            ->setDefaultGACapacity($defaultGACapacity)
            ->setDefaultOrdinal($defaultOrdinal)
            ->setDefaultSeatingType($defaultSeatingType)
            ->setGAMaxCapacity($gAMaxCapacity)
            ->setGateIds($gateIds)
            ->setMinQtyToSellTogether($minQtyToSellTogether)
            ->setName($name)
            ->setNameForReports($nameForReports)
            ->setParentHallId($parentHallId)
            ->setStandId($standId)
            ->setStandName($standName)
            ->setTaxonomyClass($taxonomyClass)
            ->setTaxonomyFieldView($taxonomyFieldView)
            ->setTaxonomyVenueLevel($taxonomyVenueLevel)
            ->setTaxonomyVenueSide($taxonomyVenueSide)
            ->setTurnstileIds($turnstileIds);
    }
    /**
     * Get AccessControlData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AccessControl_EntityAccessControlData|null
     */
    public function getAccessControlData()
    {
        return isset($this->AccessControlData) ? $this->AccessControlData : null;
    }
    /**
     * Set AccessControlData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AccessControl_EntityAccessControlData $accessControlData
     * @return \patest\StructType\Ticketing_Area
     */
    public function setAccessControlData(\patest\StructType\AccessControl_EntityAccessControlData $accessControlData = null)
    {
        if (is_null($accessControlData) || (is_array($accessControlData) && empty($accessControlData))) {
            unset($this->AccessControlData);
        } else {
            $this->AccessControlData = $accessControlData;
        }
        return $this;
    }
    /**
     * Get ClientTypeTurnstileIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ClientTypeTurnstileIds|null
     */
    public function getClientTypeTurnstileIds()
    {
        return isset($this->ClientTypeTurnstileIds) ? $this->ClientTypeTurnstileIds : null;
    }
    /**
     * Set ClientTypeTurnstileIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ClientTypeTurnstileIds $clientTypeTurnstileIds
     * @return \patest\StructType\Ticketing_Area
     */
    public function setClientTypeTurnstileIds(\patest\StructType\ClientTypeTurnstileIds $clientTypeTurnstileIds = null)
    {
        if (is_null($clientTypeTurnstileIds) || (is_array($clientTypeTurnstileIds) && empty($clientTypeTurnstileIds))) {
            unset($this->ClientTypeTurnstileIds);
        } else {
            $this->ClientTypeTurnstileIds = $clientTypeTurnstileIds;
        }
        return $this;
    }
    /**
     * Get DefaultGACapacity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDefaultGACapacity()
    {
        return isset($this->DefaultGACapacity) ? $this->DefaultGACapacity : null;
    }
    /**
     * Set DefaultGACapacity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $defaultGACapacity
     * @return \patest\StructType\Ticketing_Area
     */
    public function setDefaultGACapacity($defaultGACapacity = null)
    {
        // validation for constraint: int
        if (!is_null($defaultGACapacity) && !(is_int($defaultGACapacity) || ctype_digit($defaultGACapacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($defaultGACapacity, true), gettype($defaultGACapacity)), __LINE__);
        }
        if (is_null($defaultGACapacity) || (is_array($defaultGACapacity) && empty($defaultGACapacity))) {
            unset($this->DefaultGACapacity);
        } else {
            $this->DefaultGACapacity = $defaultGACapacity;
        }
        return $this;
    }
    /**
     * Get DefaultOrdinal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDefaultOrdinal()
    {
        return isset($this->DefaultOrdinal) ? $this->DefaultOrdinal : null;
    }
    /**
     * Set DefaultOrdinal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $defaultOrdinal
     * @return \patest\StructType\Ticketing_Area
     */
    public function setDefaultOrdinal($defaultOrdinal = null)
    {
        // validation for constraint: int
        if (!is_null($defaultOrdinal) && !(is_int($defaultOrdinal) || ctype_digit($defaultOrdinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($defaultOrdinal, true), gettype($defaultOrdinal)), __LINE__);
        }
        if (is_null($defaultOrdinal) || (is_array($defaultOrdinal) && empty($defaultOrdinal))) {
            unset($this->DefaultOrdinal);
        } else {
            $this->DefaultOrdinal = $defaultOrdinal;
        }
        return $this;
    }
    /**
     * Get DefaultSeatingType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultSeatingType()
    {
        return isset($this->DefaultSeatingType) ? $this->DefaultSeatingType : null;
    }
    /**
     * Set DefaultSeatingType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AreaSeatingType::valueIsValid()
     * @uses \patest\EnumType\AreaSeatingType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $defaultSeatingType
     * @return \patest\StructType\Ticketing_Area
     */
    public function setDefaultSeatingType($defaultSeatingType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AreaSeatingType::valueIsValid($defaultSeatingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AreaSeatingType', is_array($defaultSeatingType) ? implode(', ', $defaultSeatingType) : var_export($defaultSeatingType, true), implode(', ', \patest\EnumType\AreaSeatingType::getValidValues())), __LINE__);
        }
        if (is_null($defaultSeatingType) || (is_array($defaultSeatingType) && empty($defaultSeatingType))) {
            unset($this->DefaultSeatingType);
        } else {
            $this->DefaultSeatingType = $defaultSeatingType;
        }
        return $this;
    }
    /**
     * Get GAMaxCapacity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGAMaxCapacity()
    {
        return isset($this->GAMaxCapacity) ? $this->GAMaxCapacity : null;
    }
    /**
     * Set GAMaxCapacity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $gAMaxCapacity
     * @return \patest\StructType\Ticketing_Area
     */
    public function setGAMaxCapacity($gAMaxCapacity = null)
    {
        // validation for constraint: int
        if (!is_null($gAMaxCapacity) && !(is_int($gAMaxCapacity) || ctype_digit($gAMaxCapacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($gAMaxCapacity, true), gettype($gAMaxCapacity)), __LINE__);
        }
        if (is_null($gAMaxCapacity) || (is_array($gAMaxCapacity) && empty($gAMaxCapacity))) {
            unset($this->GAMaxCapacity);
        } else {
            $this->GAMaxCapacity = $gAMaxCapacity;
        }
        return $this;
    }
    /**
     * Get GateIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GateIds|null
     */
    public function getGateIds()
    {
        return isset($this->GateIds) ? $this->GateIds : null;
    }
    /**
     * Set GateIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GateIds $gateIds
     * @return \patest\StructType\Ticketing_Area
     */
    public function setGateIds(\patest\StructType\GateIds $gateIds = null)
    {
        if (is_null($gateIds) || (is_array($gateIds) && empty($gateIds))) {
            unset($this->GateIds);
        } else {
            $this->GateIds = $gateIds;
        }
        return $this;
    }
    /**
     * Get MinQtyToSellTogether value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinQtyToSellTogether()
    {
        return isset($this->MinQtyToSellTogether) ? $this->MinQtyToSellTogether : null;
    }
    /**
     * Set MinQtyToSellTogether value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minQtyToSellTogether
     * @return \patest\StructType\Ticketing_Area
     */
    public function setMinQtyToSellTogether($minQtyToSellTogether = null)
    {
        // validation for constraint: int
        if (!is_null($minQtyToSellTogether) && !(is_int($minQtyToSellTogether) || ctype_digit($minQtyToSellTogether))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minQtyToSellTogether, true), gettype($minQtyToSellTogether)), __LINE__);
        }
        if (is_null($minQtyToSellTogether) || (is_array($minQtyToSellTogether) && empty($minQtyToSellTogether))) {
            unset($this->MinQtyToSellTogether);
        } else {
            $this->MinQtyToSellTogether = $minQtyToSellTogether;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Ticketing_Area
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NameForReports value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getNameForReports()
    {
        return isset($this->NameForReports) ? $this->NameForReports : null;
    }
    /**
     * Set NameForReports value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $nameForReports
     * @return \patest\StructType\Ticketing_Area
     */
    public function setNameForReports(\patest\StructType\GlobalString $nameForReports = null)
    {
        if (is_null($nameForReports) || (is_array($nameForReports) && empty($nameForReports))) {
            unset($this->NameForReports);
        } else {
            $this->NameForReports = $nameForReports;
        }
        return $this;
    }
    /**
     * Get ParentHallId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParentHallId()
    {
        return isset($this->ParentHallId) ? $this->ParentHallId : null;
    }
    /**
     * Set ParentHallId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parentHallId
     * @return \patest\StructType\Ticketing_Area
     */
    public function setParentHallId($parentHallId = null)
    {
        // validation for constraint: string
        if (!is_null($parentHallId) && !is_string($parentHallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentHallId, true), gettype($parentHallId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($parentHallId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $parentHallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($parentHallId, true)), __LINE__);
        }
        if (is_null($parentHallId) || (is_array($parentHallId) && empty($parentHallId))) {
            unset($this->ParentHallId);
        } else {
            $this->ParentHallId = $parentHallId;
        }
        return $this;
    }
    /**
     * Get StandId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStandId()
    {
        return isset($this->StandId) ? $this->StandId : null;
    }
    /**
     * Set StandId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $standId
     * @return \patest\StructType\Ticketing_Area
     */
    public function setStandId($standId = null)
    {
        // validation for constraint: string
        if (!is_null($standId) && !is_string($standId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($standId, true), gettype($standId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($standId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $standId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($standId, true)), __LINE__);
        }
        if (is_null($standId) || (is_array($standId) && empty($standId))) {
            unset($this->StandId);
        } else {
            $this->StandId = $standId;
        }
        return $this;
    }
    /**
     * Get StandName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getStandName()
    {
        return isset($this->StandName) ? $this->StandName : null;
    }
    /**
     * Set StandName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $standName
     * @return \patest\StructType\Ticketing_Area
     */
    public function setStandName(\patest\StructType\GlobalString $standName = null)
    {
        if (is_null($standName) || (is_array($standName) && empty($standName))) {
            unset($this->StandName);
        } else {
            $this->StandName = $standName;
        }
        return $this;
    }
    /**
     * Get TaxonomyClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaxonomyClass()
    {
        return isset($this->TaxonomyClass) ? $this->TaxonomyClass : null;
    }
    /**
     * Set TaxonomyClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AreaTaxonomyClass::valueIsValid()
     * @uses \patest\EnumType\AreaTaxonomyClass::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $taxonomyClass
     * @return \patest\StructType\Ticketing_Area
     */
    public function setTaxonomyClass($taxonomyClass = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AreaTaxonomyClass::valueIsValid($taxonomyClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AreaTaxonomyClass', is_array($taxonomyClass) ? implode(', ', $taxonomyClass) : var_export($taxonomyClass, true), implode(', ', \patest\EnumType\AreaTaxonomyClass::getValidValues())), __LINE__);
        }
        if (is_null($taxonomyClass) || (is_array($taxonomyClass) && empty($taxonomyClass))) {
            unset($this->TaxonomyClass);
        } else {
            $this->TaxonomyClass = $taxonomyClass;
        }
        return $this;
    }
    /**
     * Get TaxonomyFieldView value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaxonomyFieldView()
    {
        return isset($this->TaxonomyFieldView) ? $this->TaxonomyFieldView : null;
    }
    /**
     * Set TaxonomyFieldView value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AreaTaxonomyFieldView::valueIsValid()
     * @uses \patest\EnumType\AreaTaxonomyFieldView::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $taxonomyFieldView
     * @return \patest\StructType\Ticketing_Area
     */
    public function setTaxonomyFieldView($taxonomyFieldView = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AreaTaxonomyFieldView::valueIsValid($taxonomyFieldView)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AreaTaxonomyFieldView', is_array($taxonomyFieldView) ? implode(', ', $taxonomyFieldView) : var_export($taxonomyFieldView, true), implode(', ', \patest\EnumType\AreaTaxonomyFieldView::getValidValues())), __LINE__);
        }
        if (is_null($taxonomyFieldView) || (is_array($taxonomyFieldView) && empty($taxonomyFieldView))) {
            unset($this->TaxonomyFieldView);
        } else {
            $this->TaxonomyFieldView = $taxonomyFieldView;
        }
        return $this;
    }
    /**
     * Get TaxonomyVenueLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaxonomyVenueLevel()
    {
        return isset($this->TaxonomyVenueLevel) ? $this->TaxonomyVenueLevel : null;
    }
    /**
     * Set TaxonomyVenueLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AreaTaxonomyVenueLevel::valueIsValid()
     * @uses \patest\EnumType\AreaTaxonomyVenueLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $taxonomyVenueLevel
     * @return \patest\StructType\Ticketing_Area
     */
    public function setTaxonomyVenueLevel($taxonomyVenueLevel = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AreaTaxonomyVenueLevel::valueIsValid($taxonomyVenueLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AreaTaxonomyVenueLevel', is_array($taxonomyVenueLevel) ? implode(', ', $taxonomyVenueLevel) : var_export($taxonomyVenueLevel, true), implode(', ', \patest\EnumType\AreaTaxonomyVenueLevel::getValidValues())), __LINE__);
        }
        if (is_null($taxonomyVenueLevel) || (is_array($taxonomyVenueLevel) && empty($taxonomyVenueLevel))) {
            unset($this->TaxonomyVenueLevel);
        } else {
            $this->TaxonomyVenueLevel = $taxonomyVenueLevel;
        }
        return $this;
    }
    /**
     * Get TaxonomyVenueSide value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaxonomyVenueSide()
    {
        return isset($this->TaxonomyVenueSide) ? $this->TaxonomyVenueSide : null;
    }
    /**
     * Set TaxonomyVenueSide value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AreaTaxonomyVenueSide::valueIsValid()
     * @uses \patest\EnumType\AreaTaxonomyVenueSide::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $taxonomyVenueSide
     * @return \patest\StructType\Ticketing_Area
     */
    public function setTaxonomyVenueSide($taxonomyVenueSide = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AreaTaxonomyVenueSide::valueIsValid($taxonomyVenueSide)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AreaTaxonomyVenueSide', is_array($taxonomyVenueSide) ? implode(', ', $taxonomyVenueSide) : var_export($taxonomyVenueSide, true), implode(', ', \patest\EnumType\AreaTaxonomyVenueSide::getValidValues())), __LINE__);
        }
        if (is_null($taxonomyVenueSide) || (is_array($taxonomyVenueSide) && empty($taxonomyVenueSide))) {
            unset($this->TaxonomyVenueSide);
        } else {
            $this->TaxonomyVenueSide = $taxonomyVenueSide;
        }
        return $this;
    }
    /**
     * Get TurnstileIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\TurnstileIds|null
     */
    public function getTurnstileIds()
    {
        return isset($this->TurnstileIds) ? $this->TurnstileIds : null;
    }
    /**
     * Set TurnstileIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\TurnstileIds $turnstileIds
     * @return \patest\StructType\Ticketing_Area
     */
    public function setTurnstileIds(\patest\StructType\TurnstileIds $turnstileIds = null)
    {
        if (is_null($turnstileIds) || (is_array($turnstileIds) && empty($turnstileIds))) {
            unset($this->TurnstileIds);
        } else {
            $this->TurnstileIds = $turnstileIds;
        }
        return $this;
    }
}
