<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.AgentRestricitionsLump StructType
 * @subpackage Structs
 */
class Ticketing_AgentRestricitionsLump extends AnyEntity
{
    /**
     * The AllocationTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AllocationTypes;
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The AreaName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AreaName;
    /**
     * The AreaOrdinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AreaOrdinal;
    /**
     * The BookCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BookCost;
    /**
     * The BuyPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BuyPrice;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The ClientName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientName;
    /**
     * The EventDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDate;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The EventName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventName;
    /**
     * The FaceValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FaceValue;
    /**
     * The FirstSeat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FirstSeat;
    /**
     * The FirstSeatSelected
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FirstSeatSelected;
    /**
     * The FromSeatIdInAreaMap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FromSeatIdInAreaMap;
    /**
     * The InCurrentSession
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $InCurrentSession;
    /**
     * The InsideCommission
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InsideCommission;
    /**
     * The InsideCommissionPercentage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $InsideCommissionPercentage;
    /**
     * The LastSeat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LastSeat;
    /**
     * The LastSeatSelected
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LastSeatSelected;
    /**
     * The LumpId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LumpId;
    /**
     * The PaymentReferenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentReferenceNumber;
    /**
     * The PriceLevelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceLevelId;
    /**
     * The ReservationExpiry
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReservationExpiry;
    /**
     * The RowName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RowName;
    /**
     * The SalesStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SalesStatus;
    /**
     * The SeatCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SeatCount;
    /**
     * The SeatRange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatRange;
    /**
     * The SeatRangeWithCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatRangeWithCount;
    /**
     * The Selected
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Selected;
    /**
     * The ToSeatIdInAreaMap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ToSeatIdInAreaMap;
    /**
     * The TransactionDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionDate;
    /**
     * The TransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionId;
    /**
     * The TransactionNote
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionNote;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * The TransactionSeller
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionSeller;
    /**
     * The User
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $User;
    /**
     * Constructor method for Ticketing.AgentRestricitionsLump
     * @uses Ticketing_AgentRestricitionsLump::setAllocationTypes()
     * @uses Ticketing_AgentRestricitionsLump::setAreaId()
     * @uses Ticketing_AgentRestricitionsLump::setAreaName()
     * @uses Ticketing_AgentRestricitionsLump::setAreaOrdinal()
     * @uses Ticketing_AgentRestricitionsLump::setBookCost()
     * @uses Ticketing_AgentRestricitionsLump::setBuyPrice()
     * @uses Ticketing_AgentRestricitionsLump::setClientId()
     * @uses Ticketing_AgentRestricitionsLump::setClientName()
     * @uses Ticketing_AgentRestricitionsLump::setEventDate()
     * @uses Ticketing_AgentRestricitionsLump::setEventId()
     * @uses Ticketing_AgentRestricitionsLump::setEventName()
     * @uses Ticketing_AgentRestricitionsLump::setFaceValue()
     * @uses Ticketing_AgentRestricitionsLump::setFirstSeat()
     * @uses Ticketing_AgentRestricitionsLump::setFirstSeatSelected()
     * @uses Ticketing_AgentRestricitionsLump::setFromSeatIdInAreaMap()
     * @uses Ticketing_AgentRestricitionsLump::setInCurrentSession()
     * @uses Ticketing_AgentRestricitionsLump::setInsideCommission()
     * @uses Ticketing_AgentRestricitionsLump::setInsideCommissionPercentage()
     * @uses Ticketing_AgentRestricitionsLump::setLastSeat()
     * @uses Ticketing_AgentRestricitionsLump::setLastSeatSelected()
     * @uses Ticketing_AgentRestricitionsLump::setLumpId()
     * @uses Ticketing_AgentRestricitionsLump::setPaymentReferenceNumber()
     * @uses Ticketing_AgentRestricitionsLump::setPriceLevelId()
     * @uses Ticketing_AgentRestricitionsLump::setReservationExpiry()
     * @uses Ticketing_AgentRestricitionsLump::setRowName()
     * @uses Ticketing_AgentRestricitionsLump::setSalesStatus()
     * @uses Ticketing_AgentRestricitionsLump::setSeatCount()
     * @uses Ticketing_AgentRestricitionsLump::setSeatRange()
     * @uses Ticketing_AgentRestricitionsLump::setSeatRangeWithCount()
     * @uses Ticketing_AgentRestricitionsLump::setSelected()
     * @uses Ticketing_AgentRestricitionsLump::setToSeatIdInAreaMap()
     * @uses Ticketing_AgentRestricitionsLump::setTransactionDate()
     * @uses Ticketing_AgentRestricitionsLump::setTransactionId()
     * @uses Ticketing_AgentRestricitionsLump::setTransactionNote()
     * @uses Ticketing_AgentRestricitionsLump::setTransactionNumber()
     * @uses Ticketing_AgentRestricitionsLump::setTransactionSeller()
     * @uses Ticketing_AgentRestricitionsLump::setUser()
     * @param string $allocationTypes
     * @param string $areaId
     * @param string $areaName
     * @param int $areaOrdinal
     * @param string $bookCost
     * @param string $buyPrice
     * @param string $clientId
     * @param string $clientName
     * @param string $eventDate
     * @param string $eventId
     * @param string $eventName
     * @param string $faceValue
     * @param int $firstSeat
     * @param int $firstSeatSelected
     * @param int $fromSeatIdInAreaMap
     * @param bool $inCurrentSession
     * @param string $insideCommission
     * @param float $insideCommissionPercentage
     * @param int $lastSeat
     * @param int $lastSeatSelected
     * @param string $lumpId
     * @param string $paymentReferenceNumber
     * @param string $priceLevelId
     * @param string $reservationExpiry
     * @param string $rowName
     * @param string $salesStatus
     * @param int $seatCount
     * @param string $seatRange
     * @param string $seatRangeWithCount
     * @param bool $selected
     * @param int $toSeatIdInAreaMap
     * @param string $transactionDate
     * @param string $transactionId
     * @param string $transactionNote
     * @param int $transactionNumber
     * @param string $transactionSeller
     * @param string $user
     */
    public function __construct($allocationTypes = null, $areaId = null, $areaName = null, $areaOrdinal = null, $bookCost = null, $buyPrice = null, $clientId = null, $clientName = null, $eventDate = null, $eventId = null, $eventName = null, $faceValue = null, $firstSeat = null, $firstSeatSelected = null, $fromSeatIdInAreaMap = null, $inCurrentSession = null, $insideCommission = null, $insideCommissionPercentage = null, $lastSeat = null, $lastSeatSelected = null, $lumpId = null, $paymentReferenceNumber = null, $priceLevelId = null, $reservationExpiry = null, $rowName = null, $salesStatus = null, $seatCount = null, $seatRange = null, $seatRangeWithCount = null, $selected = null, $toSeatIdInAreaMap = null, $transactionDate = null, $transactionId = null, $transactionNote = null, $transactionNumber = null, $transactionSeller = null, $user = null)
    {
        $this
            ->setAllocationTypes($allocationTypes)
            ->setAreaId($areaId)
            ->setAreaName($areaName)
            ->setAreaOrdinal($areaOrdinal)
            ->setBookCost($bookCost)
            ->setBuyPrice($buyPrice)
            ->setClientId($clientId)
            ->setClientName($clientName)
            ->setEventDate($eventDate)
            ->setEventId($eventId)
            ->setEventName($eventName)
            ->setFaceValue($faceValue)
            ->setFirstSeat($firstSeat)
            ->setFirstSeatSelected($firstSeatSelected)
            ->setFromSeatIdInAreaMap($fromSeatIdInAreaMap)
            ->setInCurrentSession($inCurrentSession)
            ->setInsideCommission($insideCommission)
            ->setInsideCommissionPercentage($insideCommissionPercentage)
            ->setLastSeat($lastSeat)
            ->setLastSeatSelected($lastSeatSelected)
            ->setLumpId($lumpId)
            ->setPaymentReferenceNumber($paymentReferenceNumber)
            ->setPriceLevelId($priceLevelId)
            ->setReservationExpiry($reservationExpiry)
            ->setRowName($rowName)
            ->setSalesStatus($salesStatus)
            ->setSeatCount($seatCount)
            ->setSeatRange($seatRange)
            ->setSeatRangeWithCount($seatRangeWithCount)
            ->setSelected($selected)
            ->setToSeatIdInAreaMap($toSeatIdInAreaMap)
            ->setTransactionDate($transactionDate)
            ->setTransactionId($transactionId)
            ->setTransactionNote($transactionNote)
            ->setTransactionNumber($transactionNumber)
            ->setTransactionSeller($transactionSeller)
            ->setUser($user);
    }
    /**
     * Get AllocationTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAllocationTypes()
    {
        return isset($this->AllocationTypes) ? $this->AllocationTypes : null;
    }
    /**
     * Set AllocationTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $allocationTypes
     * @return \patest\StructType\Ticketing_AgentRestricitionsLump
     */
    public function setAllocationTypes($allocationTypes = null)
    {
        // validation for constraint: string
        if (!is_null($allocationTypes) && !is_string($allocationTypes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allocationTypes, true), gettype($allocationTypes)), __LINE__);
        }
        if (is_null($allocationTypes) || (is_array($allocationTypes) && empty($allocationTypes))) {
            unset($this->AllocationTypes);
        } else {
            $this->AllocationTypes = $allocationTypes;
        }
        return $this;
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\Ticketing_AgentRestricitionsLump
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get AreaName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaName()
    {
        return isset($this->AreaName) ? $this->AreaName : null;
    }
    /**
     * Set AreaName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaName
     * @return \patest\StructType\Ticketing_AgentRestricitionsLump
     */
    public function setAreaName($areaName = null)
    {
        // validation for constraint: string
        if (!is_null($areaName) && !is_string($areaName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaName, true), gettype($areaName)), __LINE__);
        }
        if (is_null($areaName) || (is_array($areaName) && empty($areaName))) {
            unset($this->AreaName);
        } else {
            $this->AreaName = $areaName;
        }
        return $this;
    }
    /**
     * Get AreaOrdinal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAreaOrdinal()
    {
        return isset($this->AreaOrdinal) ? $this->AreaOrdinal : null;
    }
    /**
     * Set AreaOrdinal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $areaOrdinal
     * @return \patest\StructType\Ticketing_AgentRestricitionsLump
     */
    public function setAreaOrdinal($areaOrdinal = null)
    {
        // validation for constraint: int
        if (!is_null($areaOrdinal) && !(is_int($areaOrdinal) || ctype_digit($areaOrdinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($areaOrdinal, true), gettype($areaOrdinal)), __LINE__);
        }
        if (is_null($areaOrdinal) || (is_array($areaOrdinal) && empty($areaOrdinal))) {
            unset($this->AreaOrdinal);
        } else {
            $this->AreaOrdinal = $areaOrdinal;
        }
        return $this;
    }
    /**
     * Get BookCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBookCost()
    {
        return isset($this->BookCost) ? $this->BookCost : null;
    }
    /**
     * Set BookCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bookCost
     * @return \patest\StructType\Ticketing_AgentRestricitionsLump
     */
    public function setBookCost($bookCost = null)
    {
        // validation for constraint: string
        if (!is_null($bookCost) && !is_string($bookCost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookCost, true), gettype($bookCost)), __LINE__);
        }
        if (is_null($bookCost) || (is_array($bookCost) && empty($bookCost))) {
            unset($this->BookCost);
        } else {
            $this->BookCost = $bookCost;
        }
        return $this;
    }
    /**
     * Get BuyPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBuyPrice()
    {
        return isset($this->BuyPrice) ? $this->BuyPrice : null;
    }
    /**
     * Set BuyPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $buyPrice
     * @return \patest\StructType\Ticketing_AgentRestricitionsLump
     */
    public function setBuyPrice($buyPrice = null)
    {
        // validation for constraint: string
        if (!is_null($buyPrice) && !is_string($buyPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($buyPrice, true), gettype($buyPrice)), __LINE__);
        }
        if (is_null($buyPrice) || (is_array($buyPrice) && empty($buyPrice))) {
            unset($this->BuyPrice);
        } else {
            $this->BuyPrice = $buyPrice;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Ticketing_AgentRestricitionsLump
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get ClientName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientName()
    {
        return isset($this->ClientName) ? $this->ClientName : null;
    }
    /**
     * Set ClientName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientName
     * @return \patest\StructType\Ticketing_AgentRestricitionsLump
     */
    public function setClientName($clientName = null)
    {
        // validation for constraint: string
        if (!is_null($clientName) && !is_string($clientName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientName, true), gettype($clientName)), __LINE__);
        }
        if (is_null($clientName) || (is_array($clientName) && empty($clientName))) {
            unset($this->ClientName);
        } else {
            $this->ClientName = $clientName;
        }
        return $this;
    }
    /**
     * Get EventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDate()
    {
        return isset($this->EventDate) ? $this->EventDate : null;
    }
    /**
     * Set EventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDate
     * @return \patest\StructType\Ticketing_AgentRestricitionsLump
     */
    public function setEventDate($eventDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventDate) && !is_string($eventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDate, true), gettype($eventDate)), __LINE__);
        }
        if (is_null($eventDate) || (is_array($eventDate) && empty($eventDate))) {
            unset($this->EventDate);
        } else {
            $this->EventDate = $eventDate;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\Ticketing_AgentRestricitionsLump
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get EventName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventName()
    {
        return isset($this->EventName) ? $this->EventName : null;
    }
    /**
     * Set EventName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventName
     * @return \patest\StructType\Ticketing_AgentRestricitionsLump
     */
    public function setEventName($eventName = null)
    {
        // validation for constraint: string
        if (!is_null($eventName) && !is_string($eventName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventName, true), gettype($eventName)), __LINE__);
        }
        if (is_null($eventName) || (is_array($eventName) && empty($eventName))) {
            unset($this->EventName);
        } else {
            $this->EventName = $eventName;
        }
        return $this;
    }
    /**
     * Get FaceValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFaceValue()
    {
        return isset($this->FaceValue) ? $this->FaceValue : null;
    }
    /**
     * Set FaceValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $faceValue
     * @return \patest\StructType\Ticketing_AgentRestricitionsLump
     */
    public function setFaceValue($faceValue = null)
    {
        // validation for constraint: string
        if (!is_null($faceValue) && !is_string($faceValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faceValue, true), gettype($faceValue)), __LINE__);
        }
        if (is_null($faceValue) || (is_array($faceValue) && empty($faceValue))) {
            unset($this->FaceValue);
        } else {
            $this->FaceValue = $faceValue;
        }
        return $this;
    }
    /**
     * Get FirstSeat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFirstSeat()
    {
        return isset($this->FirstSeat) ? $this->FirstSeat : null;
    }
    /**
     * Set FirstSeat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $firstSeat
     * @return \patest\StructType\Ticketing_AgentRestricitionsLump
     */
    public function setFirstSeat($firstSeat = null)
    {
        // validation for constraint: int
        if (!is_null($firstSeat) && !(is_int($firstSeat) || ctype_digit($firstSeat))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($firstSeat, true), gettype($firstSeat)), __LINE__);
        }
        if (is_null($firstSeat) || (is_array($firstSeat) && empty($firstSeat))) {
            unset($this->FirstSeat);
        } else {
            $this->FirstSeat = $firstSeat;
        }
        return $this;
    }
    /**
     * Get FirstSeatSelected value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFirstSeatSelected()
    {
        return isset($this->FirstSeatSelected) ? $this->FirstSeatSelected : null;
    }
    /**
     * Set FirstSeatSelected value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $firstSeatSelected
     * @return \patest\StructType\Ticketing_AgentRestricitionsLump
     */
    public function setFirstSeatSelected($firstSeatSelected = null)
    {
        // validation for constraint: int
        if (!is_null($firstSeatSelected) && !(is_int($firstSeatSelected) || ctype_digit($firstSeatSelected))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($firstSeatSelected, true), gettype($firstSeatSelected)), __LINE__);
        }
        if (is_null($firstSeatSelected) || (is_array($firstSeatSelected) && empty($firstSeatSelected))) {
            unset($this->FirstSeatSelected);
        } else {
            $this->FirstSeatSelected = $firstSeatSelected;
        }
        return $this;
    }
    /**
     * Get FromSeatIdInAreaMap value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFromSeatIdInAreaMap()
    {
        return isset($this->FromSeatIdInAreaMap) ? $this->FromSeatIdInAreaMap : null;
    }
    /**
     * Set FromSeatIdInAreaMap value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $fromSeatIdInAreaMap
     * @return \patest\StructType\Ticketing_AgentRestricitionsLump
     */
    public function setFromSeatIdInAreaMap($fromSeatIdInAreaMap = null)
    {
        // validation for constraint: int
        if (!is_null($fromSeatIdInAreaMap) && !(is_int($fromSeatIdInAreaMap) || ctype_digit($fromSeatIdInAreaMap))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fromSeatIdInAreaMap, true), gettype($fromSeatIdInAreaMap)), __LINE__);
        }
        if (is_null($fromSeatIdInAreaMap) || (is_array($fromSeatIdInAreaMap) && empty($fromSeatIdInAreaMap))) {
            unset($this->FromSeatIdInAreaMap);
        } else {
            $this->FromSeatIdInAreaMap = $fromSeatIdInAreaMap;
        }
        return $this;
    }
    /**
     * Get InCurrentSession value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getInCurrentSession()
    {
        return isset($this->InCurrentSession) ? $this->InCurrentSession : null;
    }
    /**
     * Set InCurrentSession value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $inCurrentSession
     * @return \patest\StructType\Ticketing_AgentRestricitionsLump
     */
    public function setInCurrentSession($inCurrentSession = null)
    {
        // validation for constraint: boolean
        if (!is_null($inCurrentSession) && !is_bool($inCurrentSession)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inCurrentSession, true), gettype($inCurrentSession)), __LINE__);
        }
        if (is_null($inCurrentSession) || (is_array($inCurrentSession) && empty($inCurrentSession))) {
            unset($this->InCurrentSession);
        } else {
            $this->InCurrentSession = $inCurrentSession;
        }
        return $this;
    }
    /**
     * Get InsideCommission value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInsideCommission()
    {
        return isset($this->InsideCommission) ? $this->InsideCommission : null;
    }
    /**
     * Set InsideCommission value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $insideCommission
     * @return \patest\StructType\Ticketing_AgentRestricitionsLump
     */
    public function setInsideCommission($insideCommission = null)
    {
        // validation for constraint: string
        if (!is_null($insideCommission) && !is_string($insideCommission)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insideCommission, true), gettype($insideCommission)), __LINE__);
        }
        if (is_null($insideCommission) || (is_array($insideCommission) && empty($insideCommission))) {
            unset($this->InsideCommission);
        } else {
            $this->InsideCommission = $insideCommission;
        }
        return $this;
    }
    /**
     * Get InsideCommissionPercentage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getInsideCommissionPercentage()
    {
        return isset($this->InsideCommissionPercentage) ? $this->InsideCommissionPercentage : null;
    }
    /**
     * Set InsideCommissionPercentage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $insideCommissionPercentage
     * @return \patest\StructType\Ticketing_AgentRestricitionsLump
     */
    public function setInsideCommissionPercentage($insideCommissionPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($insideCommissionPercentage) && !(is_float($insideCommissionPercentage) || is_numeric($insideCommissionPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($insideCommissionPercentage, true), gettype($insideCommissionPercentage)), __LINE__);
        }
        if (is_null($insideCommissionPercentage) || (is_array($insideCommissionPercentage) && empty($insideCommissionPercentage))) {
            unset($this->InsideCommissionPercentage);
        } else {
            $this->InsideCommissionPercentage = $insideCommissionPercentage;
        }
        return $this;
    }
    /**
     * Get LastSeat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLastSeat()
    {
        return isset($this->LastSeat) ? $this->LastSeat : null;
    }
    /**
     * Set LastSeat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $lastSeat
     * @return \patest\StructType\Ticketing_AgentRestricitionsLump
     */
    public function setLastSeat($lastSeat = null)
    {
        // validation for constraint: int
        if (!is_null($lastSeat) && !(is_int($lastSeat) || ctype_digit($lastSeat))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lastSeat, true), gettype($lastSeat)), __LINE__);
        }
        if (is_null($lastSeat) || (is_array($lastSeat) && empty($lastSeat))) {
            unset($this->LastSeat);
        } else {
            $this->LastSeat = $lastSeat;
        }
        return $this;
    }
    /**
     * Get LastSeatSelected value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLastSeatSelected()
    {
        return isset($this->LastSeatSelected) ? $this->LastSeatSelected : null;
    }
    /**
     * Set LastSeatSelected value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $lastSeatSelected
     * @return \patest\StructType\Ticketing_AgentRestricitionsLump
     */
    public function setLastSeatSelected($lastSeatSelected = null)
    {
        // validation for constraint: int
        if (!is_null($lastSeatSelected) && !(is_int($lastSeatSelected) || ctype_digit($lastSeatSelected))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lastSeatSelected, true), gettype($lastSeatSelected)), __LINE__);
        }
        if (is_null($lastSeatSelected) || (is_array($lastSeatSelected) && empty($lastSeatSelected))) {
            unset($this->LastSeatSelected);
        } else {
            $this->LastSeatSelected = $lastSeatSelected;
        }
        return $this;
    }
    /**
     * Get LumpId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLumpId()
    {
        return isset($this->LumpId) ? $this->LumpId : null;
    }
    /**
     * Set LumpId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lumpId
     * @return \patest\StructType\Ticketing_AgentRestricitionsLump
     */
    public function setLumpId($lumpId = null)
    {
        // validation for constraint: string
        if (!is_null($lumpId) && !is_string($lumpId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lumpId, true), gettype($lumpId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($lumpId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $lumpId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($lumpId, true)), __LINE__);
        }
        if (is_null($lumpId) || (is_array($lumpId) && empty($lumpId))) {
            unset($this->LumpId);
        } else {
            $this->LumpId = $lumpId;
        }
        return $this;
    }
    /**
     * Get PaymentReferenceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentReferenceNumber()
    {
        return isset($this->PaymentReferenceNumber) ? $this->PaymentReferenceNumber : null;
    }
    /**
     * Set PaymentReferenceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentReferenceNumber
     * @return \patest\StructType\Ticketing_AgentRestricitionsLump
     */
    public function setPaymentReferenceNumber($paymentReferenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($paymentReferenceNumber) && !is_string($paymentReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentReferenceNumber, true), gettype($paymentReferenceNumber)), __LINE__);
        }
        if (is_null($paymentReferenceNumber) || (is_array($paymentReferenceNumber) && empty($paymentReferenceNumber))) {
            unset($this->PaymentReferenceNumber);
        } else {
            $this->PaymentReferenceNumber = $paymentReferenceNumber;
        }
        return $this;
    }
    /**
     * Get PriceLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelId()
    {
        return isset($this->PriceLevelId) ? $this->PriceLevelId : null;
    }
    /**
     * Set PriceLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelId
     * @return \patest\StructType\Ticketing_AgentRestricitionsLump
     */
    public function setPriceLevelId($priceLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelId) && !is_string($priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelId, true), gettype($priceLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceLevelId, true)), __LINE__);
        }
        if (is_null($priceLevelId) || (is_array($priceLevelId) && empty($priceLevelId))) {
            unset($this->PriceLevelId);
        } else {
            $this->PriceLevelId = $priceLevelId;
        }
        return $this;
    }
    /**
     * Get ReservationExpiry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReservationExpiry()
    {
        return isset($this->ReservationExpiry) ? $this->ReservationExpiry : null;
    }
    /**
     * Set ReservationExpiry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reservationExpiry
     * @return \patest\StructType\Ticketing_AgentRestricitionsLump
     */
    public function setReservationExpiry($reservationExpiry = null)
    {
        // validation for constraint: string
        if (!is_null($reservationExpiry) && !is_string($reservationExpiry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationExpiry, true), gettype($reservationExpiry)), __LINE__);
        }
        if (is_null($reservationExpiry) || (is_array($reservationExpiry) && empty($reservationExpiry))) {
            unset($this->ReservationExpiry);
        } else {
            $this->ReservationExpiry = $reservationExpiry;
        }
        return $this;
    }
    /**
     * Get RowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRowName()
    {
        return isset($this->RowName) ? $this->RowName : null;
    }
    /**
     * Set RowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rowName
     * @return \patest\StructType\Ticketing_AgentRestricitionsLump
     */
    public function setRowName($rowName = null)
    {
        // validation for constraint: string
        if (!is_null($rowName) && !is_string($rowName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rowName, true), gettype($rowName)), __LINE__);
        }
        if (is_null($rowName) || (is_array($rowName) && empty($rowName))) {
            unset($this->RowName);
        } else {
            $this->RowName = $rowName;
        }
        return $this;
    }
    /**
     * Get SalesStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesStatus()
    {
        return isset($this->SalesStatus) ? $this->SalesStatus : null;
    }
    /**
     * Set SalesStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CallOverSeatStatus::valueIsValid()
     * @uses \patest\EnumType\CallOverSeatStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $salesStatus
     * @return \patest\StructType\Ticketing_AgentRestricitionsLump
     */
    public function setSalesStatus($salesStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\CallOverSeatStatus::valueIsValid($salesStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CallOverSeatStatus', is_array($salesStatus) ? implode(', ', $salesStatus) : var_export($salesStatus, true), implode(', ', \patest\EnumType\CallOverSeatStatus::getValidValues())), __LINE__);
        }
        if (is_null($salesStatus) || (is_array($salesStatus) && empty($salesStatus))) {
            unset($this->SalesStatus);
        } else {
            $this->SalesStatus = $salesStatus;
        }
        return $this;
    }
    /**
     * Get SeatCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSeatCount()
    {
        return isset($this->SeatCount) ? $this->SeatCount : null;
    }
    /**
     * Set SeatCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $seatCount
     * @return \patest\StructType\Ticketing_AgentRestricitionsLump
     */
    public function setSeatCount($seatCount = null)
    {
        // validation for constraint: int
        if (!is_null($seatCount) && !(is_int($seatCount) || ctype_digit($seatCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatCount, true), gettype($seatCount)), __LINE__);
        }
        if (is_null($seatCount) || (is_array($seatCount) && empty($seatCount))) {
            unset($this->SeatCount);
        } else {
            $this->SeatCount = $seatCount;
        }
        return $this;
    }
    /**
     * Get SeatRange value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatRange()
    {
        return isset($this->SeatRange) ? $this->SeatRange : null;
    }
    /**
     * Set SeatRange value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatRange
     * @return \patest\StructType\Ticketing_AgentRestricitionsLump
     */
    public function setSeatRange($seatRange = null)
    {
        // validation for constraint: string
        if (!is_null($seatRange) && !is_string($seatRange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatRange, true), gettype($seatRange)), __LINE__);
        }
        if (is_null($seatRange) || (is_array($seatRange) && empty($seatRange))) {
            unset($this->SeatRange);
        } else {
            $this->SeatRange = $seatRange;
        }
        return $this;
    }
    /**
     * Get SeatRangeWithCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatRangeWithCount()
    {
        return isset($this->SeatRangeWithCount) ? $this->SeatRangeWithCount : null;
    }
    /**
     * Set SeatRangeWithCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatRangeWithCount
     * @return \patest\StructType\Ticketing_AgentRestricitionsLump
     */
    public function setSeatRangeWithCount($seatRangeWithCount = null)
    {
        // validation for constraint: string
        if (!is_null($seatRangeWithCount) && !is_string($seatRangeWithCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatRangeWithCount, true), gettype($seatRangeWithCount)), __LINE__);
        }
        if (is_null($seatRangeWithCount) || (is_array($seatRangeWithCount) && empty($seatRangeWithCount))) {
            unset($this->SeatRangeWithCount);
        } else {
            $this->SeatRangeWithCount = $seatRangeWithCount;
        }
        return $this;
    }
    /**
     * Get Selected value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSelected()
    {
        return isset($this->Selected) ? $this->Selected : null;
    }
    /**
     * Set Selected value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $selected
     * @return \patest\StructType\Ticketing_AgentRestricitionsLump
     */
    public function setSelected($selected = null)
    {
        // validation for constraint: boolean
        if (!is_null($selected) && !is_bool($selected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($selected, true), gettype($selected)), __LINE__);
        }
        if (is_null($selected) || (is_array($selected) && empty($selected))) {
            unset($this->Selected);
        } else {
            $this->Selected = $selected;
        }
        return $this;
    }
    /**
     * Get ToSeatIdInAreaMap value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getToSeatIdInAreaMap()
    {
        return isset($this->ToSeatIdInAreaMap) ? $this->ToSeatIdInAreaMap : null;
    }
    /**
     * Set ToSeatIdInAreaMap value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $toSeatIdInAreaMap
     * @return \patest\StructType\Ticketing_AgentRestricitionsLump
     */
    public function setToSeatIdInAreaMap($toSeatIdInAreaMap = null)
    {
        // validation for constraint: int
        if (!is_null($toSeatIdInAreaMap) && !(is_int($toSeatIdInAreaMap) || ctype_digit($toSeatIdInAreaMap))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($toSeatIdInAreaMap, true), gettype($toSeatIdInAreaMap)), __LINE__);
        }
        if (is_null($toSeatIdInAreaMap) || (is_array($toSeatIdInAreaMap) && empty($toSeatIdInAreaMap))) {
            unset($this->ToSeatIdInAreaMap);
        } else {
            $this->ToSeatIdInAreaMap = $toSeatIdInAreaMap;
        }
        return $this;
    }
    /**
     * Get TransactionDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionDate()
    {
        return isset($this->TransactionDate) ? $this->TransactionDate : null;
    }
    /**
     * Set TransactionDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionDate
     * @return \patest\StructType\Ticketing_AgentRestricitionsLump
     */
    public function setTransactionDate($transactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDate) && !is_string($transactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionDate, true), gettype($transactionDate)), __LINE__);
        }
        if (is_null($transactionDate) || (is_array($transactionDate) && empty($transactionDate))) {
            unset($this->TransactionDate);
        } else {
            $this->TransactionDate = $transactionDate;
        }
        return $this;
    }
    /**
     * Get TransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionId()
    {
        return isset($this->TransactionId) ? $this->TransactionId : null;
    }
    /**
     * Set TransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionId
     * @return \patest\StructType\Ticketing_AgentRestricitionsLump
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionId, true)), __LINE__);
        }
        if (is_null($transactionId) || (is_array($transactionId) && empty($transactionId))) {
            unset($this->TransactionId);
        } else {
            $this->TransactionId = $transactionId;
        }
        return $this;
    }
    /**
     * Get TransactionNote value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionNote()
    {
        return isset($this->TransactionNote) ? $this->TransactionNote : null;
    }
    /**
     * Set TransactionNote value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionNote
     * @return \patest\StructType\Ticketing_AgentRestricitionsLump
     */
    public function setTransactionNote($transactionNote = null)
    {
        // validation for constraint: string
        if (!is_null($transactionNote) && !is_string($transactionNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionNote, true), gettype($transactionNote)), __LINE__);
        }
        if (is_null($transactionNote) || (is_array($transactionNote) && empty($transactionNote))) {
            unset($this->TransactionNote);
        } else {
            $this->TransactionNote = $transactionNote;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Ticketing_AgentRestricitionsLump
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
    /**
     * Get TransactionSeller value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionSeller()
    {
        return isset($this->TransactionSeller) ? $this->TransactionSeller : null;
    }
    /**
     * Set TransactionSeller value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionSeller
     * @return \patest\StructType\Ticketing_AgentRestricitionsLump
     */
    public function setTransactionSeller($transactionSeller = null)
    {
        // validation for constraint: string
        if (!is_null($transactionSeller) && !is_string($transactionSeller)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionSeller, true), gettype($transactionSeller)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionSeller) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionSeller)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionSeller, true)), __LINE__);
        }
        if (is_null($transactionSeller) || (is_array($transactionSeller) && empty($transactionSeller))) {
            unset($this->TransactionSeller);
        } else {
            $this->TransactionSeller = $transactionSeller;
        }
        return $this;
    }
    /**
     * Get User value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUser()
    {
        return isset($this->User) ? $this->User : null;
    }
    /**
     * Set User value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $user
     * @return \patest\StructType\Ticketing_AgentRestricitionsLump
     */
    public function setUser($user = null)
    {
        // validation for constraint: string
        if (!is_null($user) && !is_string($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($user, true), gettype($user)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($user) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($user, true)), __LINE__);
        }
        if (is_null($user) || (is_array($user) && empty($user))) {
            unset($this->User);
        } else {
            $this->User = $user;
        }
        return $this;
    }
}
