<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketViewConfiguration StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TicketViewConfiguration
 * @subpackage Structs
 */
class TicketViewConfiguration extends ExtensibleDataContract
{
    /**
     * The BackgroundColor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BackgroundColor;
    /**
     * The BackgroundImageAdaDominantColor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BackgroundImageAdaDominantColor;
    /**
     * The BackgroundImageUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BackgroundImageUrl;
    /**
     * The ConfigurationEnabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ConfigurationEnabled;
    /**
     * The GateWithLabel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GateWithLabel;
    /**
     * The HideBackgroundImage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $HideBackgroundImage;
    /**
     * The IsGa
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsGa;
    /**
     * The LevelWithLabel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LevelWithLabel;
    /**
     * The PriceTypeNote
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceTypeNote;
    /**
     * The SponsorshipLogoUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SponsorshipLogoUrl;
    /**
     * The Subtitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfstring
     */
    public $Subtitle;
    /**
     * The TicketBackNotesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketBackNotesId;
    /**
     * The TicketFooterNotes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfTicketViewSeatNote
     */
    public $TicketFooterNotes;
    /**
     * The TicketViewSeatAttributes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfTicketViewSeatAttribute
     */
    public $TicketViewSeatAttributes;
    /**
     * The TicketViewSeatLocation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfTicketViewSeatLocation
     */
    public $TicketViewSeatLocation;
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Title;
    /**
     * Constructor method for TicketViewConfiguration
     * @uses TicketViewConfiguration::setBackgroundColor()
     * @uses TicketViewConfiguration::setBackgroundImageAdaDominantColor()
     * @uses TicketViewConfiguration::setBackgroundImageUrl()
     * @uses TicketViewConfiguration::setConfigurationEnabled()
     * @uses TicketViewConfiguration::setGateWithLabel()
     * @uses TicketViewConfiguration::setHideBackgroundImage()
     * @uses TicketViewConfiguration::setIsGa()
     * @uses TicketViewConfiguration::setLevelWithLabel()
     * @uses TicketViewConfiguration::setPriceTypeNote()
     * @uses TicketViewConfiguration::setSponsorshipLogoUrl()
     * @uses TicketViewConfiguration::setSubtitle()
     * @uses TicketViewConfiguration::setTicketBackNotesId()
     * @uses TicketViewConfiguration::setTicketFooterNotes()
     * @uses TicketViewConfiguration::setTicketViewSeatAttributes()
     * @uses TicketViewConfiguration::setTicketViewSeatLocation()
     * @uses TicketViewConfiguration::setTitle()
     * @param string $backgroundColor
     * @param string $backgroundImageAdaDominantColor
     * @param string $backgroundImageUrl
     * @param bool $configurationEnabled
     * @param string $gateWithLabel
     * @param bool $hideBackgroundImage
     * @param bool $isGa
     * @param string $levelWithLabel
     * @param string $priceTypeNote
     * @param string $sponsorshipLogoUrl
     * @param \patest\ArrayType\ArrayOfstring $subtitle
     * @param string $ticketBackNotesId
     * @param \patest\ArrayType\ArrayOfTicketViewSeatNote $ticketFooterNotes
     * @param \patest\ArrayType\ArrayOfTicketViewSeatAttribute $ticketViewSeatAttributes
     * @param \patest\ArrayType\ArrayOfTicketViewSeatLocation $ticketViewSeatLocation
     * @param string $title
     */
    public function __construct($backgroundColor = null, $backgroundImageAdaDominantColor = null, $backgroundImageUrl = null, $configurationEnabled = null, $gateWithLabel = null, $hideBackgroundImage = null, $isGa = null, $levelWithLabel = null, $priceTypeNote = null, $sponsorshipLogoUrl = null, \patest\ArrayType\ArrayOfstring $subtitle = null, $ticketBackNotesId = null, \patest\ArrayType\ArrayOfTicketViewSeatNote $ticketFooterNotes = null, \patest\ArrayType\ArrayOfTicketViewSeatAttribute $ticketViewSeatAttributes = null, \patest\ArrayType\ArrayOfTicketViewSeatLocation $ticketViewSeatLocation = null, $title = null)
    {
        $this
            ->setBackgroundColor($backgroundColor)
            ->setBackgroundImageAdaDominantColor($backgroundImageAdaDominantColor)
            ->setBackgroundImageUrl($backgroundImageUrl)
            ->setConfigurationEnabled($configurationEnabled)
            ->setGateWithLabel($gateWithLabel)
            ->setHideBackgroundImage($hideBackgroundImage)
            ->setIsGa($isGa)
            ->setLevelWithLabel($levelWithLabel)
            ->setPriceTypeNote($priceTypeNote)
            ->setSponsorshipLogoUrl($sponsorshipLogoUrl)
            ->setSubtitle($subtitle)
            ->setTicketBackNotesId($ticketBackNotesId)
            ->setTicketFooterNotes($ticketFooterNotes)
            ->setTicketViewSeatAttributes($ticketViewSeatAttributes)
            ->setTicketViewSeatLocation($ticketViewSeatLocation)
            ->setTitle($title);
    }
    /**
     * Get BackgroundColor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBackgroundColor()
    {
        return isset($this->BackgroundColor) ? $this->BackgroundColor : null;
    }
    /**
     * Set BackgroundColor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $backgroundColor
     * @return \patest\StructType\TicketViewConfiguration
     */
    public function setBackgroundColor($backgroundColor = null)
    {
        // validation for constraint: string
        if (!is_null($backgroundColor) && !is_string($backgroundColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($backgroundColor, true), gettype($backgroundColor)), __LINE__);
        }
        if (is_null($backgroundColor) || (is_array($backgroundColor) && empty($backgroundColor))) {
            unset($this->BackgroundColor);
        } else {
            $this->BackgroundColor = $backgroundColor;
        }
        return $this;
    }
    /**
     * Get BackgroundImageAdaDominantColor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBackgroundImageAdaDominantColor()
    {
        return isset($this->BackgroundImageAdaDominantColor) ? $this->BackgroundImageAdaDominantColor : null;
    }
    /**
     * Set BackgroundImageAdaDominantColor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $backgroundImageAdaDominantColor
     * @return \patest\StructType\TicketViewConfiguration
     */
    public function setBackgroundImageAdaDominantColor($backgroundImageAdaDominantColor = null)
    {
        // validation for constraint: string
        if (!is_null($backgroundImageAdaDominantColor) && !is_string($backgroundImageAdaDominantColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($backgroundImageAdaDominantColor, true), gettype($backgroundImageAdaDominantColor)), __LINE__);
        }
        if (is_null($backgroundImageAdaDominantColor) || (is_array($backgroundImageAdaDominantColor) && empty($backgroundImageAdaDominantColor))) {
            unset($this->BackgroundImageAdaDominantColor);
        } else {
            $this->BackgroundImageAdaDominantColor = $backgroundImageAdaDominantColor;
        }
        return $this;
    }
    /**
     * Get BackgroundImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBackgroundImageUrl()
    {
        return isset($this->BackgroundImageUrl) ? $this->BackgroundImageUrl : null;
    }
    /**
     * Set BackgroundImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $backgroundImageUrl
     * @return \patest\StructType\TicketViewConfiguration
     */
    public function setBackgroundImageUrl($backgroundImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($backgroundImageUrl) && !is_string($backgroundImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($backgroundImageUrl, true), gettype($backgroundImageUrl)), __LINE__);
        }
        if (is_null($backgroundImageUrl) || (is_array($backgroundImageUrl) && empty($backgroundImageUrl))) {
            unset($this->BackgroundImageUrl);
        } else {
            $this->BackgroundImageUrl = $backgroundImageUrl;
        }
        return $this;
    }
    /**
     * Get ConfigurationEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getConfigurationEnabled()
    {
        return isset($this->ConfigurationEnabled) ? $this->ConfigurationEnabled : null;
    }
    /**
     * Set ConfigurationEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $configurationEnabled
     * @return \patest\StructType\TicketViewConfiguration
     */
    public function setConfigurationEnabled($configurationEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($configurationEnabled) && !is_bool($configurationEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($configurationEnabled, true), gettype($configurationEnabled)), __LINE__);
        }
        if (is_null($configurationEnabled) || (is_array($configurationEnabled) && empty($configurationEnabled))) {
            unset($this->ConfigurationEnabled);
        } else {
            $this->ConfigurationEnabled = $configurationEnabled;
        }
        return $this;
    }
    /**
     * Get GateWithLabel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGateWithLabel()
    {
        return isset($this->GateWithLabel) ? $this->GateWithLabel : null;
    }
    /**
     * Set GateWithLabel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gateWithLabel
     * @return \patest\StructType\TicketViewConfiguration
     */
    public function setGateWithLabel($gateWithLabel = null)
    {
        // validation for constraint: string
        if (!is_null($gateWithLabel) && !is_string($gateWithLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gateWithLabel, true), gettype($gateWithLabel)), __LINE__);
        }
        if (is_null($gateWithLabel) || (is_array($gateWithLabel) && empty($gateWithLabel))) {
            unset($this->GateWithLabel);
        } else {
            $this->GateWithLabel = $gateWithLabel;
        }
        return $this;
    }
    /**
     * Get HideBackgroundImage value
     * @return bool|null
     */
    public function getHideBackgroundImage()
    {
        return $this->HideBackgroundImage;
    }
    /**
     * Set HideBackgroundImage value
     * @param bool $hideBackgroundImage
     * @return \patest\StructType\TicketViewConfiguration
     */
    public function setHideBackgroundImage($hideBackgroundImage = null)
    {
        // validation for constraint: boolean
        if (!is_null($hideBackgroundImage) && !is_bool($hideBackgroundImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hideBackgroundImage, true), gettype($hideBackgroundImage)), __LINE__);
        }
        $this->HideBackgroundImage = $hideBackgroundImage;
        return $this;
    }
    /**
     * Get IsGa value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsGa()
    {
        return isset($this->IsGa) ? $this->IsGa : null;
    }
    /**
     * Set IsGa value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isGa
     * @return \patest\StructType\TicketViewConfiguration
     */
    public function setIsGa($isGa = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGa) && !is_bool($isGa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isGa, true), gettype($isGa)), __LINE__);
        }
        if (is_null($isGa) || (is_array($isGa) && empty($isGa))) {
            unset($this->IsGa);
        } else {
            $this->IsGa = $isGa;
        }
        return $this;
    }
    /**
     * Get LevelWithLabel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLevelWithLabel()
    {
        return isset($this->LevelWithLabel) ? $this->LevelWithLabel : null;
    }
    /**
     * Set LevelWithLabel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $levelWithLabel
     * @return \patest\StructType\TicketViewConfiguration
     */
    public function setLevelWithLabel($levelWithLabel = null)
    {
        // validation for constraint: string
        if (!is_null($levelWithLabel) && !is_string($levelWithLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($levelWithLabel, true), gettype($levelWithLabel)), __LINE__);
        }
        if (is_null($levelWithLabel) || (is_array($levelWithLabel) && empty($levelWithLabel))) {
            unset($this->LevelWithLabel);
        } else {
            $this->LevelWithLabel = $levelWithLabel;
        }
        return $this;
    }
    /**
     * Get PriceTypeNote value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeNote()
    {
        return isset($this->PriceTypeNote) ? $this->PriceTypeNote : null;
    }
    /**
     * Set PriceTypeNote value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeNote
     * @return \patest\StructType\TicketViewConfiguration
     */
    public function setPriceTypeNote($priceTypeNote = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeNote) && !is_string($priceTypeNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeNote, true), gettype($priceTypeNote)), __LINE__);
        }
        if (is_null($priceTypeNote) || (is_array($priceTypeNote) && empty($priceTypeNote))) {
            unset($this->PriceTypeNote);
        } else {
            $this->PriceTypeNote = $priceTypeNote;
        }
        return $this;
    }
    /**
     * Get SponsorshipLogoUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSponsorshipLogoUrl()
    {
        return isset($this->SponsorshipLogoUrl) ? $this->SponsorshipLogoUrl : null;
    }
    /**
     * Set SponsorshipLogoUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sponsorshipLogoUrl
     * @return \patest\StructType\TicketViewConfiguration
     */
    public function setSponsorshipLogoUrl($sponsorshipLogoUrl = null)
    {
        // validation for constraint: string
        if (!is_null($sponsorshipLogoUrl) && !is_string($sponsorshipLogoUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sponsorshipLogoUrl, true), gettype($sponsorshipLogoUrl)), __LINE__);
        }
        if (is_null($sponsorshipLogoUrl) || (is_array($sponsorshipLogoUrl) && empty($sponsorshipLogoUrl))) {
            unset($this->SponsorshipLogoUrl);
        } else {
            $this->SponsorshipLogoUrl = $sponsorshipLogoUrl;
        }
        return $this;
    }
    /**
     * Get Subtitle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfstring|null
     */
    public function getSubtitle()
    {
        return isset($this->Subtitle) ? $this->Subtitle : null;
    }
    /**
     * Set Subtitle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfstring $subtitle
     * @return \patest\StructType\TicketViewConfiguration
     */
    public function setSubtitle(\patest\ArrayType\ArrayOfstring $subtitle = null)
    {
        if (is_null($subtitle) || (is_array($subtitle) && empty($subtitle))) {
            unset($this->Subtitle);
        } else {
            $this->Subtitle = $subtitle;
        }
        return $this;
    }
    /**
     * Get TicketBackNotesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketBackNotesId()
    {
        return isset($this->TicketBackNotesId) ? $this->TicketBackNotesId : null;
    }
    /**
     * Set TicketBackNotesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketBackNotesId
     * @return \patest\StructType\TicketViewConfiguration
     */
    public function setTicketBackNotesId($ticketBackNotesId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketBackNotesId) && !is_string($ticketBackNotesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketBackNotesId, true), gettype($ticketBackNotesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketBackNotesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketBackNotesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketBackNotesId, true)), __LINE__);
        }
        if (is_null($ticketBackNotesId) || (is_array($ticketBackNotesId) && empty($ticketBackNotesId))) {
            unset($this->TicketBackNotesId);
        } else {
            $this->TicketBackNotesId = $ticketBackNotesId;
        }
        return $this;
    }
    /**
     * Get TicketFooterNotes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfTicketViewSeatNote|null
     */
    public function getTicketFooterNotes()
    {
        return isset($this->TicketFooterNotes) ? $this->TicketFooterNotes : null;
    }
    /**
     * Set TicketFooterNotes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfTicketViewSeatNote $ticketFooterNotes
     * @return \patest\StructType\TicketViewConfiguration
     */
    public function setTicketFooterNotes(\patest\ArrayType\ArrayOfTicketViewSeatNote $ticketFooterNotes = null)
    {
        if (is_null($ticketFooterNotes) || (is_array($ticketFooterNotes) && empty($ticketFooterNotes))) {
            unset($this->TicketFooterNotes);
        } else {
            $this->TicketFooterNotes = $ticketFooterNotes;
        }
        return $this;
    }
    /**
     * Get TicketViewSeatAttributes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfTicketViewSeatAttribute|null
     */
    public function getTicketViewSeatAttributes()
    {
        return isset($this->TicketViewSeatAttributes) ? $this->TicketViewSeatAttributes : null;
    }
    /**
     * Set TicketViewSeatAttributes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfTicketViewSeatAttribute $ticketViewSeatAttributes
     * @return \patest\StructType\TicketViewConfiguration
     */
    public function setTicketViewSeatAttributes(\patest\ArrayType\ArrayOfTicketViewSeatAttribute $ticketViewSeatAttributes = null)
    {
        if (is_null($ticketViewSeatAttributes) || (is_array($ticketViewSeatAttributes) && empty($ticketViewSeatAttributes))) {
            unset($this->TicketViewSeatAttributes);
        } else {
            $this->TicketViewSeatAttributes = $ticketViewSeatAttributes;
        }
        return $this;
    }
    /**
     * Get TicketViewSeatLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfTicketViewSeatLocation|null
     */
    public function getTicketViewSeatLocation()
    {
        return isset($this->TicketViewSeatLocation) ? $this->TicketViewSeatLocation : null;
    }
    /**
     * Set TicketViewSeatLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfTicketViewSeatLocation $ticketViewSeatLocation
     * @return \patest\StructType\TicketViewConfiguration
     */
    public function setTicketViewSeatLocation(\patest\ArrayType\ArrayOfTicketViewSeatLocation $ticketViewSeatLocation = null)
    {
        if (is_null($ticketViewSeatLocation) || (is_array($ticketViewSeatLocation) && empty($ticketViewSeatLocation))) {
            unset($this->TicketViewSeatLocation);
        } else {
            $this->TicketViewSeatLocation = $ticketViewSeatLocation;
        }
        return $this;
    }
    /**
     * Get Title value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTitle()
    {
        return isset($this->Title) ? $this->Title : null;
    }
    /**
     * Set Title value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $title
     * @return \patest\StructType\TicketViewConfiguration
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        if (is_null($title) || (is_array($title) && empty($title))) {
            unset($this->Title);
        } else {
            $this->Title = $title;
        }
        return $this;
    }
}
