<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketViewComponentUpdate-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TicketViewComponentUpdate-Request
 * @subpackage Structs
 */
class TicketViewComponentUpdate_Request extends CreateOrUpdateTicketViewComponentRequestBase
{
    /**
     * The ComponentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ComponentId;
    /**
     * Constructor method for TicketViewComponentUpdate-Request
     * @uses TicketViewComponentUpdate_Request::setComponentId()
     * @param string $componentId
     */
    public function __construct($componentId = null)
    {
        $this
            ->setComponentId($componentId);
    }
    /**
     * Get ComponentId value
     * @return string|null
     */
    public function getComponentId()
    {
        return $this->ComponentId;
    }
    /**
     * Set ComponentId value
     * @param string $componentId
     * @return \patest\StructType\TicketViewComponentUpdate_Request
     */
    public function setComponentId($componentId = null)
    {
        // validation for constraint: string
        if (!is_null($componentId) && !is_string($componentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($componentId, true), gettype($componentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($componentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $componentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($componentId, true)), __LINE__);
        }
        $this->ComponentId = $componentId;
        return $this;
    }
}
