<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketViewComponentResponseBase StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TicketViewComponentResponseBase
 * @subpackage Structs
 */
class TicketViewComponentResponseBase extends ExtensibleDataContract
{
    /**
     * The AdditionalTicketBackNotes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AdditionalTicketBackNotes
     */
    public $AdditionalTicketBackNotes;
    /**
     * The AssociationReferences
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfTicketViewComponentAssociationReference
     */
    public $AssociationReferences;
    /**
     * The ComponentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ComponentId;
    /**
     * The ComponentType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ComponentType;
    /**
     * The CreationDateTimeUtc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CreationDateTimeUtc;
    /**
     * The EventHeader
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EventHeaderOverrideWithUrls
     */
    public $EventHeader;
    /**
     * The IsHidden
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsHidden;
    /**
     * The LastUpdateDateTimeUtc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LastUpdateDateTimeUtc;
    /**
     * The MyTicketsCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\MyTicketsCardWithUrls
     */
    public $MyTicketsCard;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The TicketDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\TicketDetailsOverride
     */
    public $TicketDetails;
    /**
     * The TicketFooterNotes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\TicketFooterNoteOverride
     */
    public $TicketFooterNotes;
    /**
     * The TicketStyle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\TicketStyleOverrideWithUrls
     */
    public $TicketStyle;
    /**
     * Constructor method for TicketViewComponentResponseBase
     * @uses TicketViewComponentResponseBase::setAdditionalTicketBackNotes()
     * @uses TicketViewComponentResponseBase::setAssociationReferences()
     * @uses TicketViewComponentResponseBase::setComponentId()
     * @uses TicketViewComponentResponseBase::setComponentType()
     * @uses TicketViewComponentResponseBase::setCreationDateTimeUtc()
     * @uses TicketViewComponentResponseBase::setEventHeader()
     * @uses TicketViewComponentResponseBase::setIsHidden()
     * @uses TicketViewComponentResponseBase::setLastUpdateDateTimeUtc()
     * @uses TicketViewComponentResponseBase::setMyTicketsCard()
     * @uses TicketViewComponentResponseBase::setName()
     * @uses TicketViewComponentResponseBase::setOrganizationUnitId()
     * @uses TicketViewComponentResponseBase::setTicketDetails()
     * @uses TicketViewComponentResponseBase::setTicketFooterNotes()
     * @uses TicketViewComponentResponseBase::setTicketStyle()
     * @param \patest\StructType\AdditionalTicketBackNotes $additionalTicketBackNotes
     * @param \patest\ArrayType\ArrayOfTicketViewComponentAssociationReference $associationReferences
     * @param string $componentId
     * @param string $componentType
     * @param string $creationDateTimeUtc
     * @param \patest\StructType\EventHeaderOverrideWithUrls $eventHeader
     * @param bool $isHidden
     * @param string $lastUpdateDateTimeUtc
     * @param \patest\StructType\MyTicketsCardWithUrls $myTicketsCard
     * @param string $name
     * @param string $organizationUnitId
     * @param \patest\StructType\TicketDetailsOverride $ticketDetails
     * @param \patest\StructType\TicketFooterNoteOverride $ticketFooterNotes
     * @param \patest\StructType\TicketStyleOverrideWithUrls $ticketStyle
     */
    public function __construct(\patest\StructType\AdditionalTicketBackNotes $additionalTicketBackNotes = null, \patest\ArrayType\ArrayOfTicketViewComponentAssociationReference $associationReferences = null, $componentId = null, $componentType = null, $creationDateTimeUtc = null, \patest\StructType\EventHeaderOverrideWithUrls $eventHeader = null, $isHidden = null, $lastUpdateDateTimeUtc = null, \patest\StructType\MyTicketsCardWithUrls $myTicketsCard = null, $name = null, $organizationUnitId = null, \patest\StructType\TicketDetailsOverride $ticketDetails = null, \patest\StructType\TicketFooterNoteOverride $ticketFooterNotes = null, \patest\StructType\TicketStyleOverrideWithUrls $ticketStyle = null)
    {
        $this
            ->setAdditionalTicketBackNotes($additionalTicketBackNotes)
            ->setAssociationReferences($associationReferences)
            ->setComponentId($componentId)
            ->setComponentType($componentType)
            ->setCreationDateTimeUtc($creationDateTimeUtc)
            ->setEventHeader($eventHeader)
            ->setIsHidden($isHidden)
            ->setLastUpdateDateTimeUtc($lastUpdateDateTimeUtc)
            ->setMyTicketsCard($myTicketsCard)
            ->setName($name)
            ->setOrganizationUnitId($organizationUnitId)
            ->setTicketDetails($ticketDetails)
            ->setTicketFooterNotes($ticketFooterNotes)
            ->setTicketStyle($ticketStyle);
    }
    /**
     * Get AdditionalTicketBackNotes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AdditionalTicketBackNotes|null
     */
    public function getAdditionalTicketBackNotes()
    {
        return isset($this->AdditionalTicketBackNotes) ? $this->AdditionalTicketBackNotes : null;
    }
    /**
     * Set AdditionalTicketBackNotes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AdditionalTicketBackNotes $additionalTicketBackNotes
     * @return \patest\StructType\TicketViewComponentResponseBase
     */
    public function setAdditionalTicketBackNotes(\patest\StructType\AdditionalTicketBackNotes $additionalTicketBackNotes = null)
    {
        if (is_null($additionalTicketBackNotes) || (is_array($additionalTicketBackNotes) && empty($additionalTicketBackNotes))) {
            unset($this->AdditionalTicketBackNotes);
        } else {
            $this->AdditionalTicketBackNotes = $additionalTicketBackNotes;
        }
        return $this;
    }
    /**
     * Get AssociationReferences value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfTicketViewComponentAssociationReference|null
     */
    public function getAssociationReferences()
    {
        return isset($this->AssociationReferences) ? $this->AssociationReferences : null;
    }
    /**
     * Set AssociationReferences value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfTicketViewComponentAssociationReference $associationReferences
     * @return \patest\StructType\TicketViewComponentResponseBase
     */
    public function setAssociationReferences(\patest\ArrayType\ArrayOfTicketViewComponentAssociationReference $associationReferences = null)
    {
        if (is_null($associationReferences) || (is_array($associationReferences) && empty($associationReferences))) {
            unset($this->AssociationReferences);
        } else {
            $this->AssociationReferences = $associationReferences;
        }
        return $this;
    }
    /**
     * Get ComponentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getComponentId()
    {
        return isset($this->ComponentId) ? $this->ComponentId : null;
    }
    /**
     * Set ComponentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $componentId
     * @return \patest\StructType\TicketViewComponentResponseBase
     */
    public function setComponentId($componentId = null)
    {
        // validation for constraint: string
        if (!is_null($componentId) && !is_string($componentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($componentId, true), gettype($componentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($componentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $componentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($componentId, true)), __LINE__);
        }
        if (is_null($componentId) || (is_array($componentId) && empty($componentId))) {
            unset($this->ComponentId);
        } else {
            $this->ComponentId = $componentId;
        }
        return $this;
    }
    /**
     * Get ComponentType value
     * @return string|null
     */
    public function getComponentType()
    {
        return $this->ComponentType;
    }
    /**
     * Set ComponentType value
     * @uses \patest\EnumType\TicketConfigurationComponentType::valueIsValid()
     * @uses \patest\EnumType\TicketConfigurationComponentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $componentType
     * @return \patest\StructType\TicketViewComponentResponseBase
     */
    public function setComponentType($componentType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketConfigurationComponentType::valueIsValid($componentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketConfigurationComponentType', is_array($componentType) ? implode(', ', $componentType) : var_export($componentType, true), implode(', ', \patest\EnumType\TicketConfigurationComponentType::getValidValues())), __LINE__);
        }
        $this->ComponentType = $componentType;
        return $this;
    }
    /**
     * Get CreationDateTimeUtc value
     * @return string|null
     */
    public function getCreationDateTimeUtc()
    {
        return $this->CreationDateTimeUtc;
    }
    /**
     * Set CreationDateTimeUtc value
     * @param string $creationDateTimeUtc
     * @return \patest\StructType\TicketViewComponentResponseBase
     */
    public function setCreationDateTimeUtc($creationDateTimeUtc = null)
    {
        // validation for constraint: string
        if (!is_null($creationDateTimeUtc) && !is_string($creationDateTimeUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDateTimeUtc, true), gettype($creationDateTimeUtc)), __LINE__);
        }
        $this->CreationDateTimeUtc = $creationDateTimeUtc;
        return $this;
    }
    /**
     * Get EventHeader value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EventHeaderOverrideWithUrls|null
     */
    public function getEventHeader()
    {
        return isset($this->EventHeader) ? $this->EventHeader : null;
    }
    /**
     * Set EventHeader value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EventHeaderOverrideWithUrls $eventHeader
     * @return \patest\StructType\TicketViewComponentResponseBase
     */
    public function setEventHeader(\patest\StructType\EventHeaderOverrideWithUrls $eventHeader = null)
    {
        if (is_null($eventHeader) || (is_array($eventHeader) && empty($eventHeader))) {
            unset($this->EventHeader);
        } else {
            $this->EventHeader = $eventHeader;
        }
        return $this;
    }
    /**
     * Get IsHidden value
     * @return bool|null
     */
    public function getIsHidden()
    {
        return $this->IsHidden;
    }
    /**
     * Set IsHidden value
     * @param bool $isHidden
     * @return \patest\StructType\TicketViewComponentResponseBase
     */
    public function setIsHidden($isHidden = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHidden) && !is_bool($isHidden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isHidden, true), gettype($isHidden)), __LINE__);
        }
        $this->IsHidden = $isHidden;
        return $this;
    }
    /**
     * Get LastUpdateDateTimeUtc value
     * @return string|null
     */
    public function getLastUpdateDateTimeUtc()
    {
        return $this->LastUpdateDateTimeUtc;
    }
    /**
     * Set LastUpdateDateTimeUtc value
     * @param string $lastUpdateDateTimeUtc
     * @return \patest\StructType\TicketViewComponentResponseBase
     */
    public function setLastUpdateDateTimeUtc($lastUpdateDateTimeUtc = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateDateTimeUtc) && !is_string($lastUpdateDateTimeUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUpdateDateTimeUtc, true), gettype($lastUpdateDateTimeUtc)), __LINE__);
        }
        $this->LastUpdateDateTimeUtc = $lastUpdateDateTimeUtc;
        return $this;
    }
    /**
     * Get MyTicketsCard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\MyTicketsCardWithUrls|null
     */
    public function getMyTicketsCard()
    {
        return isset($this->MyTicketsCard) ? $this->MyTicketsCard : null;
    }
    /**
     * Set MyTicketsCard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\MyTicketsCardWithUrls $myTicketsCard
     * @return \patest\StructType\TicketViewComponentResponseBase
     */
    public function setMyTicketsCard(\patest\StructType\MyTicketsCardWithUrls $myTicketsCard = null)
    {
        if (is_null($myTicketsCard) || (is_array($myTicketsCard) && empty($myTicketsCard))) {
            unset($this->MyTicketsCard);
        } else {
            $this->MyTicketsCard = $myTicketsCard;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\TicketViewComponentResponseBase
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\TicketViewComponentResponseBase
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get TicketDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\TicketDetailsOverride|null
     */
    public function getTicketDetails()
    {
        return isset($this->TicketDetails) ? $this->TicketDetails : null;
    }
    /**
     * Set TicketDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\TicketDetailsOverride $ticketDetails
     * @return \patest\StructType\TicketViewComponentResponseBase
     */
    public function setTicketDetails(\patest\StructType\TicketDetailsOverride $ticketDetails = null)
    {
        if (is_null($ticketDetails) || (is_array($ticketDetails) && empty($ticketDetails))) {
            unset($this->TicketDetails);
        } else {
            $this->TicketDetails = $ticketDetails;
        }
        return $this;
    }
    /**
     * Get TicketFooterNotes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\TicketFooterNoteOverride|null
     */
    public function getTicketFooterNotes()
    {
        return isset($this->TicketFooterNotes) ? $this->TicketFooterNotes : null;
    }
    /**
     * Set TicketFooterNotes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\TicketFooterNoteOverride $ticketFooterNotes
     * @return \patest\StructType\TicketViewComponentResponseBase
     */
    public function setTicketFooterNotes(\patest\StructType\TicketFooterNoteOverride $ticketFooterNotes = null)
    {
        if (is_null($ticketFooterNotes) || (is_array($ticketFooterNotes) && empty($ticketFooterNotes))) {
            unset($this->TicketFooterNotes);
        } else {
            $this->TicketFooterNotes = $ticketFooterNotes;
        }
        return $this;
    }
    /**
     * Get TicketStyle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\TicketStyleOverrideWithUrls|null
     */
    public function getTicketStyle()
    {
        return isset($this->TicketStyle) ? $this->TicketStyle : null;
    }
    /**
     * Set TicketStyle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\TicketStyleOverrideWithUrls $ticketStyle
     * @return \patest\StructType\TicketViewComponentResponseBase
     */
    public function setTicketStyle(\patest\StructType\TicketStyleOverrideWithUrls $ticketStyle = null)
    {
        if (is_null($ticketStyle) || (is_array($ticketStyle) && empty($ticketStyle))) {
            unset($this->TicketStyle);
        } else {
            $this->TicketStyle = $ticketStyle;
        }
        return $this;
    }
}
